/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.common;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.miniorange.usermanagement.confluence.common.CommonAuditLogDetails;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginCommonConstants;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class UserManagementPluginSettings {
    private static Logger LOGGER = LoggerFactory.getLogger(UserManagementPluginSettings.class);
    private ApplicationProperties applicationProperties;
    private PluginSettingsFactory pluginSettingsFactory;
    private PluginSettings pluginSettings;
    private CrowdService crowdService;

    public UserManagementPluginSettings(PluginSettingsFactory pluginSettingsFactory, CrowdService crowdService, ApplicationProperties applicationProperties) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.crowdService = crowdService;
        this.applicationProperties = applicationProperties;
    }

    public String getBaseURL() {
        String baseURL = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        LOGGER.debug("Returning application's base URL : " + baseURL);
        return baseURL;
    }

    public long getNumberOfDays() {
        String numberOfDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.NUMBER_OF_USER_INACTIVE_DAYS.getKey())), (CharSequence)"30");
        return NumberUtils.createInteger((String)numberOfDays).intValue();
    }

    public void setNumberOfDays(long numberOfDays) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.NUMBER_OF_USER_INACTIVE_DAYS.getKey(), (Object)String.valueOf(numberOfDays));
    }

    public long getNumberofDaysAfterUserCreation() {
        String daysAfterCreation = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.NUMBER_OF_DAYS_AFTER_USER_CREATION.getKey())), (CharSequence)"30");
        return NumberUtils.createInteger((String)daysAfterCreation).intValue();
    }

    public void setNumberofDaysAfterUserCreation(long daysAfterCreation) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.NUMBER_OF_DAYS_AFTER_USER_CREATION.getKey(), (Object)String.valueOf(daysAfterCreation));
    }

    public long getCustomSchedulerTimeHour() {
        String Custom_scheduler_time_hour = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.CUSTOM_SCHEDULER_TIME_HOUR.getKey())), (CharSequence)"01");
        return NumberUtils.createInteger((String)Custom_scheduler_time_hour).intValue();
    }

    public void setCustomSchedulerTimeHour(Long Custom_scheduler_time_hour) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.CUSTOM_SCHEDULER_TIME_HOUR.getKey(), (Object)String.valueOf(Custom_scheduler_time_hour));
    }

    public long getCustomSchedulerTimeMinute() {
        String Custom_scheduler_time_minute = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.CUSTOM_SCHEDULER_TIME_MINUTE.getKey())), (CharSequence)"01");
        return NumberUtils.createInteger((String)Custom_scheduler_time_minute).intValue();
    }

    public void setCustomSchedulerTimeMinute(long Custom_scheduler_time_minute) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.CUSTOM_SCHEDULER_TIME_MINUTE.getKey(), (Object)String.valueOf(Custom_scheduler_time_minute));
    }

    public Integer getExportUsersFlagEvalLicense() {
        String exportUsersFlagEvalLicense = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.EXPORT_USERS_FLAG_EVAL_LICENSE.getKey())), (CharSequence)"3");
        return NumberUtils.createInteger((String)exportUsersFlagEvalLicense);
    }

    public void setExportUsersFlagEvalLicense(Integer exportUsersFlagEvalLicense) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.EXPORT_USERS_FLAG_EVAL_LICENSE.getKey(), (Object)String.valueOf(exportUsersFlagEvalLicense));
    }

    public long getScheduler_days() {
        String Scheduler_days = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.SCHEDULER_DAYS.getKey())), (CharSequence)"1");
        return NumberUtils.createInteger((String)Scheduler_days).intValue();
    }

    public void setScheduler_days(long scheduler_days) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SCHEDULER_DAYS.getKey(), (Object)String.valueOf(scheduler_days));
    }

    public Date getPrevSchedulerDate() throws ParseException {
        Date prevDate = null;
        String date = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.PREVIOUS_SCHEDULER_DATE.getKey());
        if (date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            prevDate = formatter.parse(date);
        } else {
            prevDate = null;
        }
        return prevDate;
    }

    public Date getNextSchedulerDate() throws ParseException {
        Date nextDate = null;
        String date = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.NEXT_SCHEDULER_DATE.getKey());
        if (date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            nextDate = formatter.parse(date);
        } else {
            nextDate = null;
        }
        return nextDate;
    }

    public void setPrevSchedulerDate(String date) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.PREVIOUS_SCHEDULER_DATE.getKey(), (Object)date);
    }

    public void setNextSchedulerDate(String date) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.NEXT_SCHEDULER_DATE.getKey(), (Object)date);
    }

    public String getPreviousSchedulerDateString() {
        String date = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.PREVIOUS_SCHEDULER_DATE.getKey());
        if (date != null) {
            return date;
        }
        return null;
    }

    public String getNextSchedulerDateString() {
        String date = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.NEXT_SCHEDULER_DATE.getKey());
        if (date != null) {
            return date;
        }
        return null;
    }

    public String getUserManagementSelectedAction() {
        String groupManagementSelectedAction = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.GROUP_MANAGEMENT_SELECTION.getKey())), (CharSequence)"groupCreationAction");
        groupManagementSelectedAction = groupManagementSelectedAction.replaceAll(" ", "");
        return groupManagementSelectedAction;
    }

    public void setUserManagementSelectedAction(String groupManagementSelectedAction) {
        groupManagementSelectedAction = groupManagementSelectedAction.replaceAll(" ", "");
        this.pluginSettings.put(UserManagementPluginCommonConstants.GROUP_MANAGEMENT_SELECTION.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)groupManagementSelectedAction, (CharSequence)"groupCreationAction"))));
    }

    public String getCreationSelection() {
        String groupCreation = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.GROUP_CREATION_SELECTION.getKey())), (CharSequence)"manuallyAdding");
        return groupCreation;
    }

    public void setCreationSelection(String groupCreation) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.GROUP_CREATION_SELECTION.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)groupCreation, (CharSequence)"manuallyAdding"))));
    }

    public String getGroupsToCreate() {
        String groupToCreate = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.MANUALLY_GROUP_CREATION.getKey())), (CharSequence)"");
        return groupToCreate;
    }

    public void setGroupsToCreate(String groupToCreate) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MANUALLY_GROUP_CREATION.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)groupToCreate, (CharSequence)""))));
    }

    public Boolean getReActivateUser() {
        String reActivateUser = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_REACTIVATE_USER.getKey());
        if (StringUtils.isBlank((CharSequence)reActivateUser)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)reActivateUser);
    }

    public void setReActivateUser(Boolean reActivateUser) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_REACTIVATE_USER.getKey(), (Object)BooleanUtils.toString((Boolean)reActivateUser, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRestrictLoginUsersGroups() {
        String restrictLoginUsersGroups = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.RESTRICT_LOGIN_USERS_GROUPS.getKey());
        if (StringUtils.isBlank((CharSequence)restrictLoginUsersGroups)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)restrictLoginUsersGroups);
    }

    public void setRestrictLoginUsersGroups(Boolean restrictLoginUsersGroups) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.RESTRICT_LOGIN_USERS_GROUPS.getKey(), (Object)BooleanUtils.toString((Boolean)restrictLoginUsersGroups, (String)"true", (String)"false", (String)"false"));
    }

    public List<String> getRestrictLoginUsersGroupsList() {
        return (List)this.pluginSettings.get(UserManagementPluginCommonConstants.RESTRICT_LOGIN_USERS_GROUPS_LIST.getKey());
    }

    public void setRestrictLoginUsersGroupsList(List<String> restrictLoginUsersGroupsList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.RESTRICT_LOGIN_USERS_GROUPS_LIST.getKey(), restrictLoginUsersGroupsList);
    }

    public Boolean getEnableReadOnlyDirAutoActivate() {
        String enableReadOnlyDirAutoActivate = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.READ_ONLY_DIRECTORY_AUTO_ACTIVATE.getKey());
        if (StringUtils.isBlank((CharSequence)enableReadOnlyDirAutoActivate)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)enableReadOnlyDirAutoActivate);
    }

    public void setEnableReadOnlyDirAutoActivate(Boolean enableReadOnlyDirAutoActivate) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.READ_ONLY_DIRECTORY_AUTO_ACTIVATE.getKey(), (Object)BooleanUtils.toString((Boolean)enableReadOnlyDirAutoActivate, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableFloatingLicenseForRODir() {
        String enableFloatingLicenseForRODir = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.READ_ONLY_DIRECTORY_FLOATING_LICENSE.getKey());
        if (StringUtils.isBlank((CharSequence)enableFloatingLicenseForRODir)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)enableFloatingLicenseForRODir);
    }

    public void setEnableFloatingLicenseForRODir(Boolean enableFloatingLicenseForRODir) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.READ_ONLY_DIRECTORY_FLOATING_LICENSE.getKey(), (Object)BooleanUtils.toString((Boolean)enableFloatingLicenseForRODir, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAddGroupsToInactive() {
        String addGroupsToInactive = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ADD_GROUP_TO_INACTIVE_USER.getKey());
        if (StringUtils.isBlank((CharSequence)addGroupsToInactive)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)addGroupsToInactive);
    }

    public void setAddGroupsToInactive(Boolean addGroupsToInactive) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ADD_GROUP_TO_INACTIVE_USER.getKey(), (Object)BooleanUtils.toString((Boolean)addGroupsToInactive, (String)"true", (String)"false", (String)"false"));
    }

    public void setAddGroups(ArrayList<String> addGroupsList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ADD_GROUP_LIST.getKey(), addGroupsList);
    }

    public Object getAddGroups() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.ADD_GROUP_LIST.getKey());
    }

    public Boolean getRemoveGroupsFromInactive() {
        String removeGroupsFromInactive = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.REMOVE_GROUP_FROM_INACTIVE_USER.getKey());
        if (StringUtils.isBlank((CharSequence)removeGroupsFromInactive)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)removeGroupsFromInactive);
    }

    public void setRemoveGroupsFromInactive(Boolean removeGroupsFromInactive) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.REMOVE_GROUP_FROM_INACTIVE_USER.getKey(), (Object)BooleanUtils.toString((Boolean)removeGroupsFromInactive, (String)"true", (String)"false", (String)"false"));
    }

    public Object getRemoveGroups() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.REMOVE_GROUP_LIST.getKey());
    }

    public void setRemoveGroups(ArrayList<String> removeGroupsList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.REMOVE_GROUP_LIST.getKey(), removeGroupsList);
    }

    public void setAddGroupsToActiveUsers(Boolean addGroupsToActive) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ADD_GROUPS_TO_ACTIVE_USER.getKey(), (Object)BooleanUtils.toString((Boolean)addGroupsToActive, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAddGroupsToActiveUsers() {
        String addGroupsToInactive = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ADD_GROUPS_TO_ACTIVE_USER.getKey());
        if (StringUtils.isBlank((CharSequence)addGroupsToInactive)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)addGroupsToInactive);
    }

    public void setGroupsAssignToActiveUser(ArrayList<String> groupsListAssignToActiveUser) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.GROUP_ASSIGN_TO_ACTIVE_USER.getKey(), groupsListAssignToActiveUser);
    }

    public Object getGroupsAssignToActiveUser() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.GROUP_ASSIGN_TO_ACTIVE_USER.getKey());
    }

    public void setRuleBaseGroupMapping(Boolean ruleBaseGroupMapping) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.RULE_BASE_GROUP_MAPPING.getKey(), (Object)BooleanUtils.toString((Boolean)ruleBaseGroupMapping, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRuleBaseGroupMapping() {
        String ruleBaseGroupMapping = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.RULE_BASE_GROUP_MAPPING.getKey());
        if (StringUtils.isBlank((CharSequence)ruleBaseGroupMapping)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)ruleBaseGroupMapping);
    }

    public void setGroupCondition(ArrayList<String> groupCondition) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.GROUP_CONDITION.getKey(), groupCondition);
    }

    public Object getGroupCondition() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.GROUP_CONDITION.getKey());
    }

    public void setAddGroupBaseOnRule(ArrayList<String> addGroupBaseOnRule) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ADD_GROUP_BASE_ON_RULE.getKey(), addGroupBaseOnRule);
    }

    public Object getAddGroupBaseOnRule() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.ADD_GROUP_BASE_ON_RULE.getKey());
    }

    public Boolean getAutoDeActivateUsers() {
        String autodeactivatecheck = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_DEACTIVATE_USER.getKey());
        if (StringUtils.isBlank((CharSequence)autodeactivatecheck)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)autodeactivatecheck);
    }

    public void setAutoDeActivateUsers(Boolean autodeactivatecheck) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_DEACTIVATE_USER.getKey(), (Object)BooleanUtils.toString((Boolean)autodeactivatecheck, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAutoDeleteUsers() {
        String autodeletecheck = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_DELETE_USER.getKey());
        if (StringUtils.isBlank((CharSequence)autodeletecheck)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)autodeletecheck);
    }

    public void setAutoDeleteUsers(Boolean autodeletecheck) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_DELETE_USER.getKey(), (Object)BooleanUtils.toString((Boolean)autodeletecheck, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableAutoRemoveFromGroup() {
        String enableAutoRemoveFromGroup = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ENABLE_AUTO_REMOVE_GROUP.getKey());
        return BooleanUtils.toBoolean((String)((String)StringUtils.defaultIfBlank((CharSequence)enableAutoRemoveFromGroup, (CharSequence)"false")));
    }

    public void setEnableAutoRemoveFromGroup(Boolean enableAutoRemoveFromGroup) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ENABLE_AUTO_REMOVE_GROUP.getKey(), (Object)BooleanUtils.toString((Boolean)enableAutoRemoveFromGroup, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableAutoAddGroupToUser() {
        String enableAutoAddGroupToUser = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ENABLE_AUTO_Add_GROUP.getKey());
        return BooleanUtils.toBoolean((String)((String)StringUtils.defaultIfBlank((CharSequence)enableAutoAddGroupToUser, (CharSequence)"false")));
    }

    public void setEnableAutoAddGroupToUser(Boolean enableAutoAddGroupToUser) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ENABLE_AUTO_Add_GROUP.getKey(), (Object)BooleanUtils.toString((Boolean)enableAutoAddGroupToUser, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableCrowdROUser() {
        String enableCrowdROUser = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ENABLE_CROWD_READ_ONLY_USER.getKey());
        return BooleanUtils.toBoolean((String)((String)StringUtils.defaultIfBlank((CharSequence)enableCrowdROUser, (CharSequence)"false")));
    }

    public void setEnableCrowdROUser(Boolean enableCrowdROUser) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ENABLE_CROWD_READ_ONLY_USER.getKey(), (Object)BooleanUtils.toString((Boolean)enableCrowdROUser, (String)"true", (String)"false", (String)"false"));
    }

    public String getUsernameSuffix() {
        String usernameSuffix = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.USERNAME_SUFFIX.getKey());
        return usernameSuffix == null ? "" : usernameSuffix;
    }

    public void setUsernameSuffix(String usernameSuffix) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.USERNAME_SUFFIX.getKey(), (Object)(usernameSuffix == null ? "" : usernameSuffix));
    }

    public Boolean getPreviousSchedulerFlag() {
        String previousSchedulerFlag = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.PREVIOUS_SCHEDULER_FLAG.getKey());
        if (StringUtils.isBlank((CharSequence)previousSchedulerFlag)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)previousSchedulerFlag);
    }

    public void setPreviousSchedulerFlag(Boolean previousSchedulerFlag) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.PREVIOUS_SCHEDULER_FLAG.getKey(), (Object)BooleanUtils.toString((Boolean)previousSchedulerFlag, (String)"true", (String)"false", (String)"false"));
    }

    public void setMailServer(String mailServer) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SERVER.getKey(), (Object)(mailServer != null ? mailServer : ""));
    }

    public String getMailServer() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SERVER.getKey()) != null ? (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SERVER.getKey()) : "";
    }

    public String getMailPeriod() {
        String numberOfDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_PERIOD.getKey())), (CharSequence)"1");
        return numberOfDays;
    }

    public void setMailPeriod(String numberOfDays) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_PERIOD.getKey(), (Object)String.valueOf(numberOfDays));
    }

    public Boolean getAutoDeactivateNeverLoggedInUser() {
        String neverloggedinusers = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_DEACTIVATE_NEVER_LOGGEDIN_USERS.getKey());
        if (StringUtils.isBlank((CharSequence)neverloggedinusers)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)neverloggedinusers);
    }

    public void setAutoDeactivateNeverLoggedInUser(Boolean autodeactivatecheck) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_DEACTIVATE_NEVER_LOGGEDIN_USERS.getKey(), (Object)BooleanUtils.toString((Boolean)autodeactivatecheck, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getSendMailToNeverLoggedInUsers() {
        String SendMailToNeverLoggedInUsers = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.SEND_MAIL_TO_NEVER_LOGGED_IN_USERS.getKey());
        if (StringUtils.isBlank((CharSequence)SendMailToNeverLoggedInUsers)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)SendMailToNeverLoggedInUsers);
    }

    public void setSendMailToNeverLoggedInUsers(Boolean sendMailToNeverLoggedInUsers) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SEND_MAIL_TO_NEVER_LOGGED_IN_USERS.getKey(), (Object)BooleanUtils.toString((Boolean)sendMailToNeverLoggedInUsers, (String)"true", (String)"false", (String)"false"));
    }

    public String getMailServerForNeverLoggedIn() {
        return (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SERVER_FOR_NEVER_LOGGED_IN.getKey());
    }

    public void setMailServerForNeverLoggedIn(String mailServerForNeverLoggedIn) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SERVER_FOR_NEVER_LOGGED_IN.getKey(), (Object)mailServerForNeverLoggedIn);
    }

    public String getMailPeriodForNeverLoggedInUsers() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_PERIOD_FOR_NEVER_LOGGED_IN_USERS.getKey())), (CharSequence)"1");
    }

    public void setMailPeriodForNeverLoggedInUsers(String mailPeriodForNeverLoggedInUsers) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_PERIOD_FOR_NEVER_LOGGED_IN_USERS.getKey(), (Object)String.valueOf(mailPeriodForNeverLoggedInUsers));
    }

    public String getMailSubForNeverLoggedInUsers() {
        String mailSubForNeverLoggedInUsers = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SUB_FOR_NEVER_LOGGED_IN_USERS.getKey());
        return mailSubForNeverLoggedInUsers == null || mailSubForNeverLoggedInUsers.isEmpty() ? "Deactivating User" : mailSubForNeverLoggedInUsers;
    }

    public void setMailSubForNeverLoggedInUsers(String mailSubForNeverLoggedInUsers) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SUB_FOR_NEVER_LOGGED_IN_USERS.getKey(), (Object)(mailSubForNeverLoggedInUsers == null || mailSubForNeverLoggedInUsers.isEmpty() ? "Deactivating User" : mailSubForNeverLoggedInUsers));
    }

    public String getMailTextForNeverLoggedInUsers() {
        String mailTextForNeverLoggedInUsers = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_TEXT_FOR_NEVER_LOGGED_IN_USERS.getKey());
        return mailTextForNeverLoggedInUsers == null || mailTextForNeverLoggedInUsers.isEmpty() ? "Hello $$username$$,\n\nWe would like to inform you that your account is scheduled for deactivation due to inactivity in the last $$days$$ days. If you have any questions or require further information, please don't hesitate to contact your Administrator.\n\nThank you." : mailTextForNeverLoggedInUsers;
    }

    public void setMailTextForNeverLoggedInUsers(String mailTextForNeverLoggedInUsers) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_TEXT_FOR_NEVER_LOGGED_IN_USERS.getKey(), (Object)(mailTextForNeverLoggedInUsers != null || !mailTextForNeverLoggedInUsers.isEmpty() ? mailTextForNeverLoggedInUsers : "Hello $$username$$,\n\nWe would like to inform you that your account is scheduled for deactivation due to inactivity in the last $$days$$ days. If you have any questions or require further information, please don't hesitate to contact your Administrator.\n\nThank you."));
    }

    public String getMailSubjectForCreatedUser() {
        Object userCreationSubject = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SUBJECT_FOR_CREATED_USER.getKey());
        if (userCreationSubject == null || ((String)userCreationSubject).isEmpty()) {
            userCreationSubject = "Welcome to " + this.applicationProperties.getPlatformId() + " - Your Account Details";
        }
        return userCreationSubject;
    }

    public void setMailSubjectForCreatedUser(String userCreationSubject) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SUBJECT_FOR_CREATED_USER.getKey(), userCreationSubject == null || userCreationSubject.isEmpty() ? "Welcome to " + this.applicationProperties.getPlatformId() + " - Your Account Details" : userCreationSubject);
    }

    public String getMailTextForCreatedUser() {
        LOGGER.debug("aaplication used : " + this.applicationProperties.getPlatformId());
        Object userCreationText = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_TEXT_FOR_CREATED_USER.getKey());
        if (userCreationText == null || ((String)userCreationText).isEmpty()) {
            userCreationText = "<html>\n<body> \n\n<h2>Welcome to " + this.applicationProperties.getPlatformId() + "</h2>\n\nHello <b>$$FULLNAME$$</b>,<br>\nYour account has been successfully created. Here are your account details:<br><br>\n\n<b>Username</b>  :- $$USERNAME$$<br>\n<b>Email ID</b> &nbsp;&nbsp;&nbsp;:- $$EMAIL$$<br>\n<b>Full Name</b> :- $$FULLNAME$$<br><br>\n\nIf you have any questions or need further assistance, please don't hesitate to contact your administrator.<br><br>\n\nThank you.<br>\n\n</body>\n</html>";
        }
        return userCreationText;
    }

    public void setMailTextForCreatedUser(String mailText) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_TEXT_FOR_CREATED_USER.getKey(), mailText == null || mailText.isEmpty() ? "<html>\n<body> \n\n<h2>Welcome to " + this.applicationProperties.getPlatformId() + "</h2>\n\nHello <b>$$FULLNAME$$</b>,<br>\nYour account has been successfully created. Here are your account details:<br><br>\n\n<b>Username</b>  :- $$USERNAME$$<br>\n<b>Email ID</b> &nbsp;&nbsp;&nbsp;:- $$EMAIL$$<br>\n<b>Full Name</b> :- $$FULLNAME$$<br><br>\n\nIf you have any questions or need further assistance, please don't hesitate to contact your administrator.<br><br>\n\nThank you.<br>\n\n</body>\n</html>" : mailText);
    }

    public Boolean getSendMailToImportUser() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.SEND_MAIL_TO_IMPORT_USERS.getKey()))), (boolean)false);
    }

    public void setSendMailToImportUser(Boolean sendMailNotification) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SEND_MAIL_TO_IMPORT_USERS.getKey(), (Object)BooleanUtils.toString((Boolean)sendMailNotification, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getSendPasswordResetMail() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.SEND_PASSWORD_RESET_MAIL.getKey()))), (boolean)false);
    }

    public void setSendPasswordResetMail(Boolean sendPasswordResetMail) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SEND_PASSWORD_RESET_MAIL.getKey(), (Object)BooleanUtils.toString((Boolean)sendPasswordResetMail, (String)"true", (String)"false", (String)"false"));
    }

    public String getPasswordCreationText() {
        String text = "<html><body><h3><b>Congratulations!</b></h3><b>FULLNAME</b>, your account has been created. <br><br>\n\nTo reset your password, please click the link below:<br><br>\n<a href='PasswordResetURL' style='text-decoration: none;color: #1155cc; font-weight: bold; padding: 6px;font-size: 14px;line-height: 1.429;font-family: Arial, sans-serif;'>Reset Password</a><br><br>\nThis password reset request is valid for the next 24 hours.<br><br>\n\nDon't worry you can always ask for a new password using the following link:<br>\nResendMailURL<br><br>\n\nHere are the details of your account: <br>\n<b>Username</b> : USERNAME<br>\n<b>Email ID</b> &nbsp;&nbsp;&nbsp;: EMAIL<br>\n<b>Full Name</b>: FULLNAME<br><br>\n\nThank you!</body></html>";
        return text;
    }

    public static String sanitizeText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        text = Jsoup.parse(text).text();
        return text;
    }

    public PluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public PluginSettingsFactory getPluginSettingsFactory() {
        return this.pluginSettingsFactory;
    }

    public ArrayList<String> convertSelect2StringToList(String groups) {
        ArrayList<String> groupsList = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)groups)) {
            return groupsList;
        }
        Collections.addAll(groupsList, StringUtils.split((String)groups, (String)","));
        groupsList.removeAll(Arrays.asList(null, ""));
        return groupsList;
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public Integer getAutoDeleteLogsAfterDays() {
        String autoDeleteLogsAfterDays = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_DELETE_AUDIT_LOGS_AFTER_DAYS.getKey());
        if (NumberUtils.isDigits((String)autoDeleteLogsAfterDays)) {
            return NumberUtils.createInteger((String)autoDeleteLogsAfterDays);
        }
        return UserManagementPluginCommonConstants.AUTO_CLEAR_LOG_TIME;
    }

    public void setAutoDeleteLogsAfterDays(Integer autoDeleteLogsAfterDays) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_DELETE_AUDIT_LOGS_AFTER_DAYS.getKey(), (Object)String.valueOf(autoDeleteLogsAfterDays));
    }

    public Boolean getSortByLastLogin() {
        LOGGER.debug("inside getSortBYLAst login");
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.SORT_BY_LAST_LOGIN_TIME.getKey()))), (boolean)false);
    }

    public String getStartDateLastLoginTime() {
        String startDatelastLoginTime = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.START_DATE_LASTLOGINTIME.getKey())), (CharSequence)"1970-01-01");
        return startDatelastLoginTime;
    }

    public void setStartDateLastLoginTime(String startDatelastLoginTime) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.START_DATE_LASTLOGINTIME.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)startDatelastLoginTime, (CharSequence)"1970-01-01"))));
    }

    public String getEndDateLastLoginTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
        String[] dateAndTime = expiryDateString.split(" ");
        String currentDate = dateAndTime[0];
        String endDateLastLoginTime = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.END_DATE_LASTLOGINTIME.getKey())), (CharSequence)currentDate);
        return endDateLastLoginTime;
    }

    public void setEndDateLastLoginTime(String endDateLastLoginTime) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
        String[] dateAndTime = expiryDateString.split(" ");
        String currentDate = dateAndTime[0];
        this.pluginSettings.put(UserManagementPluginCommonConstants.END_DATE_LASTLOGINTIME.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)endDateLastLoginTime, (CharSequence)currentDate))));
    }

    public void setSortByLastLogin(Boolean sortByLastLogin) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SORT_BY_LAST_LOGIN_TIME.getKey(), (Object)String.valueOf(sortByLastLogin));
    }

    public Boolean getAutoDeleteAuditLogs() {
        String autoDeleteAuditLogs = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_DELETE_AUDIT_LOGS.getKey())), (CharSequence)"true");
        return BooleanUtils.toBoolean((String)autoDeleteAuditLogs);
    }

    public void setAutoDeleteAuditLogs(Boolean autoDeleteAuditLogs) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_DELETE_AUDIT_LOGS.getKey(), (Object)BooleanUtils.toString((Boolean)autoDeleteAuditLogs, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableDirectoryFilter() {
        String enableDirectoryFilter = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.ENABLE_DIRECTORY_FILTER.getKey())), (CharSequence)"false");
        return BooleanUtils.toBoolean((String)enableDirectoryFilter);
    }

    public void setEnableDirectoryFilter(Boolean enableDirectoryFilter) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ENABLE_DIRECTORY_FILTER.getKey(), (Object)BooleanUtils.toString((Boolean)enableDirectoryFilter, (String)"true", (String)"false", (String)"false"));
    }

    public void setDirectoryFilterList(ArrayList<String> directoryFilterList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.DIRECTORY_FILTER_LIST.getKey(), directoryFilterList);
    }

    public Object getDirectoryFilterList() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.DIRECTORY_FILTER_LIST.getKey());
    }

    public void setEnableLicenseLimitAlert(Boolean enableLicenseLimitAlert) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ENABLE_LICENSE_LIMIT_ALERT.getKey(), (Object)BooleanUtils.toString((Boolean)enableLicenseLimitAlert, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableLicenseLimitAlert() {
        String enableLicenseLimitAlert = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.ENABLE_LICENSE_LIMIT_ALERT.getKey())), (CharSequence)"false");
        return BooleanUtils.toBoolean((String)enableLicenseLimitAlert);
    }

    public void setUserLicenseLimit(String userLicenseLimit) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.LICENSE_LIMIT_ALERT_COUNT.getKey(), (Object)(userLicenseLimit != null ? userLicenseLimit : "0"));
    }

    public String getUserLicenseLimit() {
        String userLicenseLimit = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.LICENSE_LIMIT_ALERT_COUNT.getKey());
        return userLicenseLimit != null ? userLicenseLimit : "0";
    }

    public String getLicenseLimitAlertSubject() {
        return "Action Required: $$APPLICATION$$ License Limit Exceeded";
    }

    public String getLicenseLimitAlertBody() {
        return "<html>\n<head>\n    <style>\n        body { font-family: Arial, sans-serif; }\n        .container { padding: 20px; }\n        .header { font-size: 15px; margin-bottom: 20px; }\n        .details { margin-top: 20px; }\n        .details ul { list-style-type: none; padding: 0; }\n        .details ul li { margin-bottom: 10px; }\n        .footer { margin-top: 20px; }\n    </style>\n</head>\n<body>\n    <div class='container'>\n        <div class='header'>\n            Hi <b>$$Administrator$$</b>,\n        </div>\n        <div class='content'>\n            You are receiving this alert because the current 'licensed user count' has exceeded the threshold set in the Automated User Management & Auto-deactivation app.\n        </div>\n        <div class='details'>\n            <b>Here is the license information:</b>\n            <ul style='list-style-type: disc; margin-left: 20px;'>\n                <li>User tier for Jira : <b> $$userTier$$ </b></li>\n                <li>Current licensed user count: <b>$$currentCount$$</b></li>\n                <li>License threshold set in app: <b>$$licenseLimit$$</b></li>\n            </ul>\n        </div>\n        <div class='footer'>\n         Please take a moment to review the licensed users and identify any accounts that can be deactivated to avoid upgrading to a higher user tier. To streamline this process, consider enabling the auto-deactivation feature to manage inactive users automatically.<br/>            <br/>\n            Thanks,<br/>\n            <b>miniOrange</b>        </div>\n    </div>\n</body>\n</html>";
    }

    public long getRevokeDays() {
        String revokeDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.REVOKE_DAYS.getKey())), (CharSequence)"30");
        return NumberUtils.createInteger((String)revokeDays).intValue();
    }

    public void setRevokeDays(long revokeDays) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.REVOKE_DAYS.getKey(), (Object)String.valueOf(revokeDays));
    }

    public Boolean getExcludeRevokeGroups() {
        String excludeRevokeGroups = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.EXCLUDE_REVOKE_GROUPS.getKey())), (CharSequence)"false");
        return BooleanUtils.toBoolean((String)excludeRevokeGroups);
    }

    public void setExcludeRevokeGroups(Boolean excludeRevokeGroups) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.EXCLUDE_REVOKE_GROUPS.getKey(), (Object)BooleanUtils.toString((Boolean)excludeRevokeGroups, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRevokeDirectoryFilter() {
        String revokeDirectoryFilter = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.REVOKE_DIRECTORY_FILTER.getKey())), (CharSequence)"false");
        return BooleanUtils.toBoolean((String)revokeDirectoryFilter);
    }

    public void setRevokeDirectoryFilter(Boolean revokeDirectoryFilter) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.REVOKE_DIRECTORY_FILTER.getKey(), (Object)BooleanUtils.toString((Boolean)revokeDirectoryFilter, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getRevokeNeverLoggedIn() {
        String revokeNeverLoggedIn = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.REVOKE_NEVER_LOGGED_IN.getKey());
        return StringUtils.isBlank((CharSequence)revokeNeverLoggedIn) ? Boolean.FALSE : BooleanUtils.toBoolean((String)revokeNeverLoggedIn);
    }

    public void setRevokeNeverLoggedIn(Boolean revokeNeverLoggedIn) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.REVOKE_NEVER_LOGGED_IN.getKey(), (Object)BooleanUtils.toString((Boolean)revokeNeverLoggedIn, (String)"true", (String)"false", (String)"false"));
    }

    public long getRevokeNeverLoggedInDays() {
        String revokeNeverLoggedInDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.REVOKE_NEVER_LOGGED_IN_DAYS.getKey())), (CharSequence)"30");
        return NumberUtils.createInteger((String)revokeNeverLoggedInDays).intValue();
    }

    public void setRevokeNeverLoggedInDays(long revokeNeverLoggedInDays) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.REVOKE_NEVER_LOGGED_IN_DAYS.getKey(), (Object)String.valueOf(revokeNeverLoggedInDays));
    }

    public Boolean getRevokeCrowdReadOnly() {
        String revokeCrowdReadOnly = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.REVOKE_CROWD_READ_ONLY.getKey())), (CharSequence)"false");
        return BooleanUtils.toBoolean((String)revokeCrowdReadOnly);
    }

    public void setRevokeCrowdReadOnly(Boolean revokeCrowdReadOnly) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.REVOKE_CROWD_READ_ONLY.getKey(), (Object)BooleanUtils.toString((Boolean)revokeCrowdReadOnly, (String)"true", (String)"false", (String)"false"));
    }

    public Object getExcludeRevokeGroupsArray() {
        Object excludeRevokeGroupsArray = this.pluginSettings.get(UserManagementPluginCommonConstants.EXCLUDE_REVOKE_GROUPS_ARRAY.getKey());
        return excludeRevokeGroupsArray != null ? excludeRevokeGroupsArray : new ArrayList();
    }

    public void setExcludeRevokeGroupsArray(ArrayList<String> excludeRevokeGroupsArray) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.EXCLUDE_REVOKE_GROUPS_ARRAY.getKey(), (Object)(excludeRevokeGroupsArray != null ? excludeRevokeGroupsArray : new ArrayList()));
    }

    public Object getRevokeDirectoryArray() {
        Object revokeDirectoryArray = this.pluginSettings.get(UserManagementPluginCommonConstants.REVOKE_DIRECTORY_ARRAY.getKey());
        return revokeDirectoryArray != null ? revokeDirectoryArray : new ArrayList();
    }

    public void setRevokeDirectoryArray(ArrayList<String> revokeDirectoryArray) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.REVOKE_DIRECTORY_ARRAY.getKey(), (Object)(revokeDirectoryArray != null ? revokeDirectoryArray : new ArrayList()));
    }

    public void setSelectedAdminUserList(ArrayList<String> filteredAdminList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SELECTED_ADMIN_USER_LIST.getKey(), (Object)(filteredAdminList != null ? filteredAdminList : new ArrayList()));
    }

    public Object getSelectedAdminUserList() {
        Object adminUserList = this.pluginSettings.get(UserManagementPluginCommonConstants.SELECTED_ADMIN_USER_LIST.getKey());
        return adminUserList != null ? adminUserList : new ArrayList();
    }

    public void setMailServerForLicenseAlert(String mailServerForLicenseAlert) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SERVER_FOR_LICENSE_ALERT.getKey(), (Object)(mailServerForLicenseAlert != null ? mailServerForLicenseAlert : ""));
    }

    public String getMailServerForLicenseAlert() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SERVER_FOR_LICENSE_ALERT.getKey()) != null ? (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SERVER_FOR_LICENSE_ALERT.getKey()) : "";
    }

    public Boolean getEnableExcludeGroups() {
        String enableExcludeGroups = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.ENABLE_EXCLUDE_GROUPS.getKey())), (CharSequence)"false");
        return BooleanUtils.toBoolean((String)enableExcludeGroups);
    }

    public void setEnableExcludeGroups(Boolean enableExcludeGroups) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ENABLE_EXCLUDE_GROUPS.getKey(), (Object)BooleanUtils.toString((Boolean)enableExcludeGroups, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getMailNotification() {
        String mailNotificationCheck = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_NOTIFICATIoN_CHECK.getKey())), (CharSequence)"false");
        return BooleanUtils.toBoolean((String)mailNotificationCheck);
    }

    public void setMailNotification(Boolean mailNotificationCheck) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_NOTIFICATIoN_CHECK.getKey(), (Object)BooleanUtils.toString((Boolean)mailNotificationCheck, (String)"true", (String)"false", (String)"false"));
    }

    public String getMailText() {
        String getAction = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_TEXT.getKey());
        return getAction == null || getAction.isEmpty() ? "Hello $$username$$,\n\nWe noticed that you logged in on $$last_login_date$$, and wanted to inform you that your account is set to be deactivated due to In-Active since $$days$$ days. \n\nIf you have any questions or require further information, please don't hesitate to contact your Administrator.\n\nThank you." : getAction;
    }

    public void setMailText(String mailtext) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_TEXT.getKey(), (Object)(mailtext != null || !mailtext.isEmpty() ? mailtext : "Hello $$username$$,\n\nWe noticed that you logged in on $$last_login_date$$, and wanted to inform you that your account is set to be deactivated due to In-Active since $$days$$ days. \n\nIf you have any questions or require further information, please don't hesitate to contact your Administrator.\n\nThank you."));
    }

    public String getSubText() {
        String getAction = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SUBJECT_TEXT.getKey());
        return getAction == null || getAction.isEmpty() ? "Deactivating User" : getAction;
    }

    public void setSubText(String mailtext) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SUBJECT_TEXT.getKey(), (Object)(mailtext == null || mailtext.isEmpty() ? "Deactivating User" : mailtext));
    }

    public String getSettingOfAssignTikcet() {
        String getAction = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ASSIGN_TICKET_SETTINGS.getKey());
        return getAction == null || getAction.isEmpty() ? "Action" : getAction;
    }

    public void setSettingOfAssignTikcet(String selectedOption) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ASSIGN_TICKET_SETTINGS.getKey(), (Object)(selectedOption == null || selectedOption.isEmpty() ? "Action" : selectedOption));
    }

    public void setAssignTicketToUser(ArrayList<String> userName) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ASSIGN_TICKET_TO_USER.getKey(), userName);
    }

    public Object getAssignTicketToUser() {
        ArrayList assigntoUser = (ArrayList)this.pluginSettings.get(UserManagementPluginCommonConstants.ASSIGN_TICKET_TO_USER.getKey());
        if (assigntoUser != null && assigntoUser.isEmpty()) {
            assigntoUser.add("Unassign");
        }
        return assigntoUser;
    }

    public Object getExcludeGroups() {
        if (this.pluginSettings.get(UserManagementPluginCommonConstants.EXCLUDE_GROUPS.getKey()) == null) {
            List<String> defaultGroups = this.getDefaultGroupsForInitialConfiguration();
            return defaultGroups;
        }
        return this.pluginSettings.get(UserManagementPluginCommonConstants.EXCLUDE_GROUPS.getKey());
    }

    public void setExcludeGroups(ArrayList<String> defaultGroups) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.EXCLUDE_GROUPS.getKey(), defaultGroups);
    }

    public Object getAutoRemoveGroups() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_REMOVE_GROUPS.getKey());
    }

    public void setAutoRemoveGroups(ArrayList<String> autoRemoveGroupsList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_REMOVE_GROUPS.getKey(), autoRemoveGroupsList);
    }

    public Object getAutoAddGroups() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_ADD_GROUPS.getKey());
    }

    public void setAutoAddGroups(ArrayList<String> autoAddGroupsList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_ADD_GROUPS.getKey(), autoAddGroupsList);
    }

    public long getGroupDays() {
        String groupDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.GROUP_DAYS.getKey())), (CharSequence)"30");
        return NumberUtils.createInteger((String)groupDays).intValue();
    }

    public void setGroupDays(long groupDays) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.GROUP_DAYS.getKey(), (Object)String.valueOf(groupDays));
    }

    public Map<String, List<String>> getGroupMapping() {
        String groupMappingJson = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.GROUP_MAPPING.getKey());
        if (StringUtils.isBlank((CharSequence)groupMappingJson)) {
            return new HashMap<String, List<String>>();
        }
        Gson gson = new Gson();
        try {
            Map rawMap = (Map)gson.fromJson(groupMappingJson, new TypeToken<Map<String, List<String>>>(){}.getType());
            return new HashMap<String, List<String>>(rawMap);
        }
        catch (JsonSyntaxException e) {
            try {
                Map oldMapping = (Map)gson.fromJson(groupMappingJson, new TypeToken<Map<String, String>>(){}.getType());
                HashMap<String, List<String>> newMapping = new HashMap<String, List<String>>();
                for (Map.Entry entry : oldMapping.entrySet()) {
                    newMapping.put((String)entry.getKey(), Collections.singletonList((String)entry.getValue()));
                }
                this.setGroupMapping(newMapping);
                return newMapping;
            }
            catch (Exception ex) {
                LOGGER.error("Failed to convert old group mapping format: " + ex.getMessage(), (Throwable)ex);
                return new HashMap<String, List<String>>();
            }
        }
    }

    public void setGroupMapping(Map<String, List<String>> groupMapping) {
        Gson gson = new Gson();
        String groupMappingJson = gson.toJson(groupMapping != null ? groupMapping : new HashMap());
        this.pluginSettings.put(UserManagementPluginCommonConstants.GROUP_MAPPING.getKey(), (Object)groupMappingJson);
    }

    public Object getGroupsToDelete() {
        if (this.pluginSettings.get(UserManagementPluginCommonConstants.GROUPS_TO_DELETE.getKey()) == null) {
            List<String> defaultGroups = this.getDefaultGroupsForInitialConfiguration();
            return defaultGroups;
        }
        return this.pluginSettings.get(UserManagementPluginCommonConstants.GROUPS_TO_DELETE.getKey());
    }

    public void setGroupsToDelete(ArrayList<String> defaultGroups) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.GROUPS_TO_DELETE.getKey(), defaultGroups);
    }

    public List<String> getAuditLogs() {
        if (this.pluginSettings.get(UserManagementPluginCommonConstants.AUDIT_LOGS.getKey()) != null) {
            return (List)this.pluginSettings.get(UserManagementPluginCommonConstants.AUDIT_LOGS.getKey());
        }
        return new ArrayList<String>();
    }

    public void setAuditLogs(List<String> auditLogList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUDIT_LOGS.getKey(), auditLogList);
    }

    public String getNoOfDaysForUsersDashboard() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(UserManagementPluginCommonConstants.USER_DASHBOARD_PERIOD.getKey())), (CharSequence)"30");
    }

    public void setNoOfDaysForUsersDashboard(String noOfDays) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.USER_DASHBOARD_PERIOD.getKey(), (Object)noOfDays);
    }

    public Boolean isUserDeactivateMigrationEnabled() {
        String userDeactivateMigration = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.USER_DEACTIVATE_MIGRATION.getKey());
        return StringUtils.isBlank((CharSequence)userDeactivateMigration) ? Boolean.FALSE : BooleanUtils.toBoolean((String)userDeactivateMigration);
    }

    public void setUserDeactivateMigrationEnabled(Boolean userDeactivateMigration) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.USER_DEACTIVATE_MIGRATION.getKey(), (Object)BooleanUtils.toString((Boolean)userDeactivateMigration, (String)"true", (String)"false", (String)"false"));
    }

    public List<String> getDefaultGroupsForInitialConfiguration() {
        ArrayList<String> groupList = new ArrayList<String>();
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        LOGGER.debug("Query for Group : " + String.valueOf(query));
        Iterable groupsFromSystem = this.crowdService.search((Query)query);
        for (Group group : groupsFromSystem) {
            if (groupList.contains(group.getName())) continue;
            groupList.add(group.getName());
        }
        ArrayList<String> excludeGroup = new ArrayList<String>();
        if (groupList.size() > 0) {
            excludeGroup.add((String)groupList.get(0));
        }
        LOGGER.debug("Exclude Group::" + String.valueOf(excludeGroup));
        return excludeGroup;
    }

    public List<String> getLogsToDisplay(List<String> auditLogsList, String username, String ip, String action, String status, String period) throws ParseException {
        ArrayList<String> filteredAuditLogsList = new ArrayList<String>();
        ArrayList<CommonAuditLogDetails> listOfAuditLogsObjects = new ArrayList<CommonAuditLogDetails>();
        Collections.reverse(auditLogsList);
        LOGGER.debug("auditlog size :" + auditLogsList.size());
        Gson gson = new Gson();
        for (int counter = 0; counter < auditLogsList.size(); ++counter) {
            CommonAuditLogDetails backToObject = gson.fromJson(auditLogsList.get(counter), CommonAuditLogDetails.class);
            listOfAuditLogsObjects.add(backToObject);
        }
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        for (int counter = 0; counter < listOfAuditLogsObjects.size(); ++counter) {
            if (!StringUtils.isBlank((CharSequence)username) && !StringUtils.containsIgnoreCase((CharSequence)((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getUsername(), (CharSequence)username) || !StringUtils.isBlank((CharSequence)ip) && !StringUtils.equals((CharSequence)((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getIpAddress(), (CharSequence)ip) || !StringUtils.equals((CharSequence)"All Actions", (CharSequence)action) && !StringUtils.equals((CharSequence)((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getAction(), (CharSequence)action) || !StringUtils.equals((CharSequence)"All Status", (CharSequence)status) && !StringUtils.equals((CharSequence)((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getStatus(), (CharSequence)status)) continue;
            if (StringUtils.equals((CharSequence)"All Days", (CharSequence)period)) {
                filteredAuditLogsList.add(auditLogsList.get(counter));
                continue;
            }
            long intervalSelected = NumberUtils.createInteger((String)String.valueOf(period)).intValue();
            long intervalSelectedInMilliSecs = intervalSelected * 86400000L;
            long timeInPast = timeMilliSecs - intervalSelectedInMilliSecs;
            Date dateBeforeInterval = new Date(timeInPast);
            SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
            Date StringToDateForDatabaseEntry = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z").parse(((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getDateAndTime());
            int isLoginAfterInterval = StringToDateForDatabaseEntry.compareTo(dateBeforeInterval);
            if (isLoginAfterInterval < 0) continue;
            filteredAuditLogsList.add(auditLogsList.get(counter));
        }
        LOGGER.debug("filterauditlog size :" + filteredAuditLogsList.size());
        return filteredAuditLogsList;
    }

    @Generated
    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }
}

