/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.xwork.SimpleXsrfTokenGenerator;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDeactivateAction
extends ConfluenceActionSupport {
    private static Logger LOGGER = LoggerFactory.getLogger(UserDeactivateAction.class);
    private Boolean autodeactivatecheck;
    private Boolean summarySubmited;
    private String usernameSuffix;
    private UserManagementPluginHandler userManagementPluginHandler;
    private UserManagementPluginSettings settings;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private final MailServerManager mailServerManager;
    private final ConfluenceUserManagementUtility userManagementUtility;
    private Boolean enableAutoRemoveFromGroup;
    private Boolean enableAutoAddGroupToUser;
    private long limitDays;
    private String contextPath;
    private Boolean mailNotification;
    private ArrayList<String> emailServers = new ArrayList();
    private String mailPeriod = "1";
    private String mailSubject = "";
    private String emailTemplate = "";
    private Boolean neverLoggedinUsers;
    private long daysAfterUserCreation;
    private Boolean sendMailToNeverLoggedInUsers;
    private Boolean autoDeactivateSubmited;
    private Boolean autoActivateSubmited;
    private Boolean maxUsersLicense;
    private Boolean enableExcludeGroups;
    private String mailServer = "";
    private String mailServerForNeverLoggedIn = "";
    private String mailPeriodForNeverLoggedInUsers = "1";
    private String mailSubForNeverLoggedInUsers = "";
    private String mailTextForNeverLoggedInUsers = "";
    private Boolean smtpConfigured;
    private String excludeGroups;
    private long scheduler_days;
    private Date previousSchedulerDate;
    private Date nextSchedulerDate;
    private ArrayList<String> excludeGroupsList;
    private Boolean reActivateUser;
    private Boolean addGroupsToInactive;
    private String addGroups;
    private ArrayList<String> addGroupsList;
    private Boolean removeGroupsFromInactive;
    private Boolean restrictLoginUsersGroups;
    private String restrictLoginUsersGroupsList;
    private ArrayList<String> restrictLoginUsersGroupsListArray;
    private String removeGroups;
    private ArrayList<String> removeGroupsList;
    private Boolean groupsEmpty = false;
    private Boolean addGroupsToActiveUser;
    private String groupsAssignToActiveUser = "";
    private ArrayList<String> groupsListAssignToActiveUser;
    private Boolean groupEmptyForActiveUser = false;
    private String autoRemoveGroups;
    private ArrayList<String> autoRemoveGroupsList = new ArrayList();
    private String autoAddGroups;
    private ArrayList<String> autoAddGroupsList = new ArrayList();
    private String atl_token;
    private Boolean ruleBaseGroupMapping;
    private String groupCondition;
    private String addGroupBaseOnRule;
    private Boolean groupEmptyForRuleBaseMapping = false;
    private ArrayList<String> groupConditionList;
    private ArrayList<String> addGroupBaseOnRuleList;
    private Boolean floatingLicenseSubmited;
    private Map<String, List<String>> groupMapping;
    private List<SMTPMailServer> smtpServers;
    private long customSchedulerTimeHour;
    private long customSchedulerTimeMinute;
    private Boolean previousSchedulerFlag;
    private Boolean enableLicenseLimitAlert;
    private String mailServerForLicenseAlert;
    private String userLicenseLimit;
    private Integer totalLicensedUsers;
    private UserChecker userChecker;
    private String adminsForAlert = "";
    private ArrayList<String> selectedAdminList;
    private Boolean enableCrowdROUser;
    private Boolean enableDirectoryFilter;
    private String directoryFilter;
    private ArrayList<String> directoryFilterList;
    private Boolean revokeAccessSubmited;
    private long revokeDays;
    private Boolean excludeRevokeGroups;
    private String excludeRevokeGroupsList;
    private ArrayList<String> excludeRevokeGroupsArray;
    private Boolean revokeDirectoryFilter;
    private String revokeDirectoryList;
    private ArrayList<String> revokeDirectoryArray;
    private Boolean revokeNeverLoggedIn;
    private long revokeNeverLoggedInDays;
    private Boolean revokeCrowdReadOnly;
    private Boolean groupAssignmentSubmited;
    private String previousSchedulerDateString;
    private String nextSchedulerDateString;
    private long groupDays;
    private Boolean testingSubmited;
    private long inactiveUsersGroupsDays;
    private Boolean enableReadOnlyDirAutoActivate;
    private Boolean enableFloatingLicenseForRODir;

    public UserDeactivateAction(UserManagementPluginHandler userManagementPluginHandler, UserManagementPluginSettings settings, UserDeactivaterScheduler userDeactivaterScheduler, ConfluenceUserManagementUtility confluenceUserManagement, MailServerManager mailServerManager, UserChecker userChecker) {
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.settings = settings;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.userManagementUtility = confluenceUserManagement;
        this.mailServerManager = mailServerManager;
        this.userChecker = userChecker;
    }

    public Boolean doValidate() throws ParseException {
        LOGGER.debug("Settings Action doValidate");
        this.fetchDetailsFromRequest();
        LOGGER.debug("value of mail period : " + this.mailPeriod);
        Boolean isError = Boolean.FALSE;
        if (this.enableExcludeGroups == null) {
            this.enableExcludeGroups = false;
        }
        if (this.enableDirectoryFilter == null) {
            this.enableDirectoryFilter = false;
        }
        if (this.enableLicenseLimitAlert == null) {
            this.enableLicenseLimitAlert = false;
        }
        if (this.userLicenseLimit == null) {
            this.userLicenseLimit = "0";
        }
        if (BooleanUtils.toBoolean((Boolean)this.autoActivateSubmited)) {
            if (this.reActivateUser == null) {
                this.reActivateUser = false;
            }
            if (this.removeGroupsFromInactive == null) {
                this.removeGroupsFromInactive = false;
            }
            if (this.addGroupsToInactive == null) {
                this.addGroupsToInactive = false;
            }
            if (this.addGroupsToActiveUser == null) {
                this.addGroupsToActiveUser = false;
            }
            if (this.enableReadOnlyDirAutoActivate == null) {
                this.enableReadOnlyDirAutoActivate = false;
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.autoDeactivateSubmited)) {
            try {
                if (this.limitDays == 0L) {
                    this.limitDays = this.settings.getNumberOfDays();
                }
                if (this.daysAfterUserCreation == 0L) {
                    this.daysAfterUserCreation = this.settings.getNumberofDaysAfterUserCreation();
                }
                if (this.scheduler_days == 0L) {
                    this.scheduler_days = this.settings.getScheduler_days();
                }
                if (this.enableExcludeGroups.booleanValue() && StringUtils.isBlank((CharSequence)this.excludeGroups)) {
                    this.addActionError("Exclude groups is left blank. Please select at least one group");
                    isError = Boolean.TRUE;
                }
                if (this.enableDirectoryFilter.booleanValue() && StringUtils.isBlank((CharSequence)this.directoryFilter)) {
                    this.addActionError("Directory filter is left blank. Please select at least one Directory");
                    isError = Boolean.TRUE;
                }
                if (BooleanUtils.toBoolean((Boolean)this.sendMailToNeverLoggedInUsers) && StringUtils.isBlank((CharSequence)this.mailPeriodForNeverLoggedInUsers)) {
                    this.addActionError("Please enter valid mail period for Never Logged-In Users.");
                    isError = Boolean.TRUE;
                }
                if (this.limitDays < 1L) {
                    this.addActionError("Invalid Number of Days. The Inactive number of days must be more than 1 day.");
                    isError = Boolean.TRUE;
                }
                if (this.daysAfterUserCreation < 1L) {
                    this.addActionError("Invalid Number of Days. The number of days after user creation must be more than 1 day.");
                    isError = Boolean.TRUE;
                }
                if (this.scheduler_days < 1L) {
                    this.addActionError("Invalid Number of Days. The Scheduler time must be more than 1 day.");
                    isError = Boolean.TRUE;
                }
                if (Integer.parseInt(this.userLicenseLimit) <= this.totalLicensedUsers && !this.userLicenseLimit.equals("0")) {
                    this.addActionError("User license limit should not be less than the total number of licensed users.");
                    isError = Boolean.TRUE;
                }
            }
            catch (Exception e) {
                this.addActionError("Please enter valid Number.");
                isError = Boolean.TRUE;
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.summarySubmited)) {
            try {
                boolean anyAutomationEnabled;
                boolean bl = anyAutomationEnabled = this.settings.getAutoDeActivateUsers() != false || this.settings.getEnableAutoRemoveFromGroup() != false || this.settings.getEnableAutoAddGroupToUser() != false;
                if (anyAutomationEnabled) {
                    if (this.scheduler_days == 0L) {
                        this.scheduler_days = this.settings.getScheduler_days();
                    }
                    if (this.customSchedulerTimeHour == 0L) {
                        this.customSchedulerTimeHour = this.settings.getCustomSchedulerTimeHour();
                    }
                    if (this.customSchedulerTimeMinute == 0L) {
                        this.customSchedulerTimeMinute = this.settings.getCustomSchedulerTimeMinute();
                    }
                    if (this.scheduler_days < 1L) {
                        this.addActionError("Invalid Number of Days. The Scheduler time must be more than 1 day.");
                        isError = Boolean.TRUE;
                    }
                }
                if (this.enableLicenseLimitAlert.booleanValue() && StringUtils.isBlank((CharSequence)this.adminsForAlert)) {
                    this.addActionError("The Admin section cannot be left blank. Please select at least one Admin to send alert mail.");
                    isError = Boolean.TRUE;
                }
                if (Integer.parseInt(this.userLicenseLimit) <= this.totalLicensedUsers && !this.userLicenseLimit.equals("0")) {
                    this.addActionError("User license limit should not be less than the total number of licensed users.");
                    isError = Boolean.TRUE;
                }
            }
            catch (Exception e) {
                this.addActionError("Please enter valid Number.");
                isError = Boolean.TRUE;
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.revokeAccessSubmited)) {
            try {
                if (this.enableAutoRemoveFromGroup == null) {
                    this.enableAutoRemoveFromGroup = false;
                }
                if (this.excludeRevokeGroups == null) {
                    this.excludeRevokeGroups = false;
                }
                if (this.revokeDirectoryFilter == null) {
                    this.revokeDirectoryFilter = false;
                }
                if (this.revokeNeverLoggedIn == null) {
                    this.revokeNeverLoggedIn = false;
                }
                if (this.revokeCrowdReadOnly == null) {
                    this.revokeCrowdReadOnly = false;
                }
                if (this.enableAutoRemoveFromGroup.booleanValue()) {
                    if (StringUtils.isBlank((CharSequence)this.autoRemoveGroups)) {
                        this.addActionError("Revoke groups is left blank.");
                        isError = true;
                    }
                    if (this.revokeDays < 1L) {
                        this.addActionError("Revoke days must be more than 1.");
                        isError = true;
                    }
                }
                if (this.excludeRevokeGroups.booleanValue() && StringUtils.isBlank((CharSequence)this.excludeRevokeGroupsList)) {
                    this.addActionError("Exclude groups for revoke is left blank.");
                    isError = true;
                }
                if (this.revokeDirectoryFilter.booleanValue() && StringUtils.isBlank((CharSequence)this.revokeDirectoryList)) {
                    this.addActionError("Directory filter for revoke is left blank.");
                    isError = true;
                }
                if (this.revokeNeverLoggedIn.booleanValue() && this.revokeNeverLoggedInDays < 1L) {
                    this.addActionError("Revoke never logged in days must be more than 1.");
                    isError = true;
                }
                LOGGER.debug("ISError : " + isError);
            }
            catch (Exception e) {
                this.addActionError("Please enter valid Number.");
                isError = Boolean.TRUE;
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.testingSubmited)) {
            try {
                if (this.enableAutoAddGroupToUser == null) {
                    this.enableAutoAddGroupToUser = false;
                }
                if (this.enableAutoAddGroupToUser.booleanValue()) {
                    if (StringUtils.isBlank((CharSequence)this.autoAddGroups)) {
                        this.addActionError("Please select at least one group to add to inactive users.");
                        isError = true;
                    }
                    if (this.groupDays < 1L) {
                        this.addActionError("Inactive users groups days must be greater than 0.");
                        isError = true;
                    }
                }
            }
            catch (NumberFormatException e) {
                this.addActionError("Invalid input for inactive users groups days. Please enter a valid number.");
                isError = true;
            }
            catch (Exception e) {
                this.addActionError("An error occurred while validating testing settings.");
                isError = true;
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.floatingLicenseSubmited)) {
            try {
                if (this.ruleBaseGroupMapping == null) {
                    this.ruleBaseGroupMapping = false;
                }
                if (this.enableFloatingLicenseForRODir == null) {
                    this.enableFloatingLicenseForRODir = false;
                }
                this.groupMapping = new HashMap<String, List<String>>();
                if (this.ruleBaseGroupMapping.booleanValue()) {
                    HttpServletRequest request = this.getCurrentRequest();
                    int totalNumberOfRules = Integer.parseInt(request.getParameter("totalNumberOfRules") != null ? request.getParameter("totalNumberOfRules") : "0");
                    LOGGER.debug("Total number of rules: " + totalNumberOfRules);
                    boolean hasValidRule = false;
                    for (int i = 0; i < totalNumberOfRules; ++i) {
                        String condition = request.getParameter("groupCondition_" + i);
                        Object[] assignedGroups = request.getParameterValues("addGroupBaseOnRule_" + i);
                        LOGGER.debug("Rule " + i + ": condition=" + condition + ", assignedGroups=" + Arrays.toString(assignedGroups));
                        if (StringUtils.isBlank((CharSequence)condition) || assignedGroups == null || assignedGroups.length == 0) {
                            this.addActionError("Group condition or assigned group(s) cannot be left blank for rule " + (i + 1) + ".");
                            isError = true;
                            continue;
                        }
                        ArrayList<String> validAssignedGroups = new ArrayList<String>();
                        for (Object group : assignedGroups) {
                            String[] splitGroups;
                            if (StringUtils.isBlank((CharSequence)group)) continue;
                            for (String splitGroup : splitGroups = ((String)group).split(",")) {
                                String sanitizedGroup = StringUtils.trimToNull((String)splitGroup);
                                if (sanitizedGroup == null || StringUtils.isBlank((CharSequence)(sanitizedGroup = sanitizedGroup.replaceAll("[^\\p{Print}]", "")))) continue;
                                validAssignedGroups.add(sanitizedGroup);
                            }
                        }
                        if (validAssignedGroups.isEmpty()) {
                            this.addActionError("At least one valid assigned group is required for rule " + (i + 1) + ".");
                            isError = true;
                            continue;
                        }
                        String sanitizedCondition = StringUtils.trimToNull((String)condition);
                        if (sanitizedCondition == null) {
                            this.addActionError("Group condition cannot be blank for rule " + (i + 1) + ".");
                            isError = true;
                            continue;
                        }
                        sanitizedCondition = sanitizedCondition.replaceAll("[^\\p{Print}]", "");
                        this.groupMapping.put(sanitizedCondition, validAssignedGroups);
                        LOGGER.debug("Added to groupMapping: " + sanitizedCondition + " -> " + String.valueOf(validAssignedGroups));
                        hasValidRule = true;
                    }
                    if (!hasValidRule) {
                        this.addActionError("At least one valid group mapping rule must be provided when rule-based group mapping is enabled.");
                        isError = true;
                    }
                    LOGGER.debug("Final groupMapping: " + String.valueOf(this.groupMapping));
                }
            }
            catch (NumberFormatException e) {
                this.addActionError("Invalid number of rules provided.");
                isError = true;
            }
            catch (Exception e) {
                this.addActionError("An error occurred while validating floating license settings: " + e.getMessage());
                isError = true;
            }
        }
        if (isError.booleanValue()) {
            this.initalization();
            return isError;
        }
        return isError;
    }

    public String execute() throws Exception {
        ConfluenceUser loggedInAdmin;
        LOGGER.debug("inside UserDeactivateAction doExecute ");
        SimpleXsrfTokenGenerator tokenGenerator = new SimpleXsrfTokenGenerator();
        this.atl_token = tokenGenerator.generateToken(this.getCurrentRequest());
        this.doValidate();
        this.fetchDetailsFromRequest();
        this.smtpServers = this.mailServerManager.getSmtpMailServers();
        LOGGER.debug("smtpServer : " + String.valueOf(this.smtpServers));
        for (SMTPMailServer smtpServer : this.smtpServers) {
            String name = smtpServer.getName();
            this.emailServers.add(name);
        }
        LOGGER.debug("emailservers in confluence : " + String.valueOf(this.emailServers));
        if (!this.userManagementUtility.isLicenseValid().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return "invalid";
        }
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        this.userChecker.resetResult();
        this.totalLicensedUsers = this.userChecker.getNumberOfRegisteredUsers();
        if (this.adminsForAlert.isEmpty() && (loggedInAdmin = AuthenticatedUserThreadLocal.get()) != null) {
            this.adminsForAlert = loggedInAdmin.getEmail();
            if (((ArrayList)this.settings.getSelectedAdminUserList()).isEmpty()) {
                this.settings.setSelectedAdminUserList(new ArrayList<String>(Collections.singletonList(this.adminsForAlert)));
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.autoActivateSubmited)) {
            this.settings.setReActivateUser(this.reActivateUser);
            this.settings.setEnableReadOnlyDirAutoActivate(this.enableReadOnlyDirAutoActivate);
            if (this.addGroupsToInactive == null) {
                this.addGroupsToInactive = false;
            }
            if (this.removeGroupsFromInactive == null) {
                this.removeGroupsFromInactive = false;
            }
            if (this.addGroupsToActiveUser == null) {
                this.addGroupsToActiveUser = false;
            }
            if ((this.addGroups == null || this.addGroups.isEmpty()) && this.addGroupsToInactive.booleanValue()) {
                this.groupsEmpty = true;
                LOGGER.debug("Group list are empty...");
            } else {
                this.addGroupsList = this.settings.convertSelect2StringToList(this.addGroups);
                this.settings.setAddGroupsToInactive(this.addGroupsToInactive);
                this.settings.setAddGroups(this.addGroupsList);
            }
            if ((this.removeGroups == null || this.removeGroups.isEmpty()) && this.removeGroupsFromInactive.booleanValue()) {
                this.groupsEmpty = true;
                LOGGER.debug("Group list are empty...");
            } else {
                this.removeGroupsList = this.settings.convertSelect2StringToList(this.removeGroups);
                this.settings.setRemoveGroupsFromInactive(this.removeGroupsFromInactive);
                this.settings.setRemoveGroups(this.removeGroupsList);
            }
            if (this.groupsAssignToActiveUser.isEmpty() && this.addGroupsToActiveUser.booleanValue()) {
                this.groupEmptyForActiveUser = true;
                LOGGER.debug("groups added to active users are empty!");
            } else {
                this.settings.setAddGroupsToActiveUsers(this.addGroupsToActiveUser);
                this.groupsListAssignToActiveUser = this.settings.convertSelect2StringToList(this.groupsAssignToActiveUser);
                this.settings.setGroupsAssignToActiveUser(this.groupsListAssignToActiveUser);
            }
            if (this.restrictLoginUsersGroups == null) {
                this.restrictLoginUsersGroups = false;
            }
            if (!this.reActivateUser.booleanValue()) {
                this.restrictLoginUsersGroups = false;
            }
            if ((this.restrictLoginUsersGroupsList == null || StringUtils.isEmpty((CharSequence)this.restrictLoginUsersGroupsList)) && this.restrictLoginUsersGroups.booleanValue()) {
                this.groupsEmpty = true;
            } else {
                this.settings.setRestrictLoginUsersGroups(this.restrictLoginUsersGroups);
                this.restrictLoginUsersGroupsListArray = this.settings.convertSelect2StringToList(this.restrictLoginUsersGroupsList);
                this.settings.setRestrictLoginUsersGroupsList(this.restrictLoginUsersGroupsListArray);
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.autoDeactivateSubmited)) {
            if (this.autodeactivatecheck == null) {
                this.autodeactivatecheck = false;
            }
            if (this.neverLoggedinUsers == null) {
                this.neverLoggedinUsers = false;
            }
            if (this.sendMailToNeverLoggedInUsers == null) {
                this.sendMailToNeverLoggedInUsers = false;
            }
            if (this.enableExcludeGroups == null) {
                this.enableExcludeGroups = false;
            }
            if (this.enableDirectoryFilter == null) {
                this.enableDirectoryFilter = false;
            }
            if (this.enableLicenseLimitAlert == null) {
                this.enableLicenseLimitAlert = false;
            }
            if (this.mailPeriodForNeverLoggedInUsers == null) {
                this.mailPeriodForNeverLoggedInUsers = "1";
            }
            if (this.enableCrowdROUser == null) {
                this.enableCrowdROUser = false;
            }
            this.directoryFilterList = this.settings.convertSelect2StringToList(this.directoryFilter);
            this.excludeGroupsList = this.settings.convertSelect2StringToList(this.excludeGroups);
            this.userManagementPluginHandler.saveUserManagementSettings(this.limitDays, this.autodeactivatecheck, this.neverLoggedinUsers, this.daysAfterUserCreation, this.enableExcludeGroups, this.excludeGroupsList, this.previousSchedulerFlag, this.mailNotification, this.mailPeriod, this.mailSubject, this.emailTemplate, "", this.usernameSuffix, false, this.sendMailToNeverLoggedInUsers, "", this.mailPeriodForNeverLoggedInUsers, this.mailSubForNeverLoggedInUsers, this.mailTextForNeverLoggedInUsers, this.enableDirectoryFilter, this.directoryFilterList, this.enableCrowdROUser, this.enableLicenseLimitAlert, this.userLicenseLimit, this.selectedAdminList, "");
        }
        if (BooleanUtils.toBoolean((Boolean)this.revokeAccessSubmited)) {
            if (this.enableAutoRemoveFromGroup == null) {
                this.enableAutoRemoveFromGroup = false;
            }
            if (this.excludeRevokeGroups == null) {
                this.excludeRevokeGroups = false;
            }
            if (this.revokeDirectoryFilter == null) {
                this.revokeDirectoryFilter = false;
            }
            if (this.revokeNeverLoggedIn == null) {
                this.revokeNeverLoggedIn = false;
            }
            if (this.revokeCrowdReadOnly == null) {
                this.revokeCrowdReadOnly = false;
            }
            this.autoRemoveGroupsList = this.settings.convertSelect2StringToList(this.autoRemoveGroups);
            this.excludeRevokeGroupsArray = this.settings.convertSelect2StringToList(this.excludeRevokeGroupsList);
            this.revokeDirectoryArray = this.settings.convertSelect2StringToList(this.revokeDirectoryList);
            this.userManagementPluginHandler.saveRevokeSettings(this.enableAutoRemoveFromGroup, this.autoRemoveGroupsList, this.revokeDays, this.excludeRevokeGroups, this.excludeRevokeGroupsArray, this.revokeDirectoryFilter, this.revokeDirectoryArray, this.revokeNeverLoggedIn, this.revokeNeverLoggedInDays, this.revokeCrowdReadOnly);
        }
        if (BooleanUtils.toBoolean((Boolean)this.summarySubmited)) {
            if (this.enableLicenseLimitAlert == null) {
                this.enableLicenseLimitAlert = false;
            }
            if (this.userLicenseLimit == null) {
                this.userLicenseLimit = "0";
            }
            if (this.customSchedulerTimeHour == 0L) {
                this.customSchedulerTimeHour = 1L;
            }
            if (this.customSchedulerTimeMinute == 0L) {
                this.customSchedulerTimeMinute = 1L;
            }
            this.selectedAdminList = this.settings.convertSelect2StringToList(this.adminsForAlert);
            this.settings.setScheduler_days(this.scheduler_days);
            this.settings.setCustomSchedulerTimeHour(this.customSchedulerTimeHour);
            this.settings.setCustomSchedulerTimeMinute(this.customSchedulerTimeMinute);
            this.settings.setEnableLicenseLimitAlert(this.enableLicenseLimitAlert);
            this.settings.setUserLicenseLimit(this.userLicenseLimit);
            this.settings.setSelectedAdminUserList(this.selectedAdminList);
            LOGGER.debug("autodeactivatecheck: " + this.settings.getAutoDeActivateUsers() + ", enableAutoRemoveFromGroup: " + this.settings.getEnableAutoRemoveFromGroup() + ", groupBasedRevocation: " + this.settings.getEnableAutoRemoveFromGroup() + ", previousSchedulerFlag: " + this.settings.getPreviousSchedulerFlag());
            if (this.settings.getAutoDeActivateUsers().booleanValue() || this.settings.getEnableAutoRemoveFromGroup().booleanValue() || this.settings.getEnableAutoAddGroupToUser().booleanValue()) {
                LOGGER.debug(" saveUserManagementSettings : Schedule Task");
                this.settings.setPreviousSchedulerFlag(true);
                this.userDeactivaterScheduler.schedule();
            } else if (!(this.settings.getAutoDeActivateUsers().booleanValue() || this.settings.getEnableAutoRemoveFromGroup().booleanValue() || this.settings.getEnableAutoAddGroupToUser().booleanValue())) {
                LOGGER.debug(" saveUserManagementSettings : Unschedule Task");
                this.userDeactivaterScheduler.unschedule();
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.floatingLicenseSubmited)) {
            if (this.ruleBaseGroupMapping == null) {
                this.ruleBaseGroupMapping = false;
            }
            if (this.groupMapping == null) {
                this.groupMapping = new HashMap<String, List<String>>();
            }
            if (this.ruleBaseGroupMapping.booleanValue() && this.groupMapping.isEmpty()) {
                this.groupEmptyForRuleBaseMapping = true;
                LOGGER.debug("No valid group mapping provided for rule-based group mapping.");
            }
            if (!this.ruleBaseGroupMapping.booleanValue()) {
                this.groupMapping = new HashMap<String, List<String>>();
            }
            this.settings.setRuleBaseGroupMapping(this.ruleBaseGroupMapping);
            this.settings.setGroupMapping(this.groupMapping);
            this.settings.setEnableFloatingLicenseForRODir(this.enableFloatingLicenseForRODir);
            LOGGER.debug("Saved floating license settings: ruleBaseGroupMapping=" + this.ruleBaseGroupMapping + ", groupMapping=" + String.valueOf(this.groupMapping));
        }
        if (BooleanUtils.toBoolean((Boolean)this.testingSubmited)) {
            if (this.enableAutoAddGroupToUser == null) {
                this.enableAutoAddGroupToUser = false;
            }
            this.autoAddGroupsList = this.settings.convertSelect2StringToList(this.autoAddGroups);
            if (this.autoAddGroupsList.isEmpty()) {
                this.enableAutoAddGroupToUser = false;
            }
            this.userManagementPluginHandler.saveTestingSettings(this.enableAutoAddGroupToUser, this.autoAddGroupsList, this.groupDays);
        }
        this.initalization();
        return "success";
    }

    public Boolean isSmtpConfigured() {
        List smtpServers = this.mailServerManager.getSmtpMailServers();
        return smtpServers != null && !smtpServers.isEmpty();
    }

    public void initalization() throws ParseException {
        LOGGER.debug("calling initialization...");
        this.contextPath = this.settings.getBaseURL();
        this.limitDays = this.settings.getNumberOfDays();
        this.daysAfterUserCreation = this.settings.getNumberofDaysAfterUserCreation();
        this.autodeactivatecheck = this.settings.getAutoDeActivateUsers();
        this.mailNotification = this.settings.getMailNotification();
        this.mailPeriod = String.valueOf(this.settings.getMailPeriod());
        this.mailSubject = this.settings.getSubText();
        this.emailTemplate = this.settings.getMailText();
        this.neverLoggedinUsers = this.settings.getAutoDeactivateNeverLoggedInUser();
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        this.excludeGroupsList = (ArrayList)this.settings.getExcludeGroups();
        this.scheduler_days = this.settings.getScheduler_days();
        this.enableExcludeGroups = this.settings.getEnableExcludeGroups();
        this.enableAutoRemoveFromGroup = this.settings.getEnableAutoRemoveFromGroup();
        this.enableAutoAddGroupToUser = this.settings.getEnableAutoAddGroupToUser();
        this.autoRemoveGroupsList = (ArrayList)this.settings.getAutoRemoveGroups();
        this.autoAddGroupsList = (ArrayList)this.settings.getAutoAddGroups();
        this.previousSchedulerDate = this.settings.getPrevSchedulerDate();
        this.nextSchedulerDate = this.settings.getNextSchedulerDate();
        this.previousSchedulerDateString = this.settings.getPreviousSchedulerDateString();
        this.nextSchedulerDateString = this.settings.getNextSchedulerDateString();
        this.customSchedulerTimeHour = this.settings.getCustomSchedulerTimeHour();
        this.customSchedulerTimeMinute = this.settings.getCustomSchedulerTimeMinute();
        this.previousSchedulerFlag = this.settings.getPreviousSchedulerFlag();
        this.reActivateUser = this.settings.getReActivateUser();
        this.enableReadOnlyDirAutoActivate = this.settings.getEnableReadOnlyDirAutoActivate();
        this.addGroupsToInactive = this.settings.getAddGroupsToInactive();
        this.addGroupsList = (ArrayList)this.settings.getAddGroups();
        this.removeGroupsFromInactive = this.settings.getRemoveGroupsFromInactive();
        this.removeGroupsList = (ArrayList)this.settings.getRemoveGroups();
        this.addGroupsToActiveUser = this.settings.getAddGroupsToActiveUsers();
        this.groupsListAssignToActiveUser = (ArrayList)this.settings.getGroupsAssignToActiveUser();
        this.restrictLoginUsersGroups = this.settings.getRestrictLoginUsersGroups();
        this.restrictLoginUsersGroupsListArray = (ArrayList)this.settings.getRestrictLoginUsersGroupsList();
        this.mailServer = this.settings.getMailServer();
        this.usernameSuffix = this.settings.getUsernameSuffix();
        this.sendMailToNeverLoggedInUsers = this.settings.getSendMailToNeverLoggedInUsers();
        this.mailServerForNeverLoggedIn = this.settings.getMailServerForNeverLoggedIn();
        this.mailPeriodForNeverLoggedInUsers = this.settings.getMailPeriodForNeverLoggedInUsers();
        this.mailSubForNeverLoggedInUsers = this.settings.getMailSubForNeverLoggedInUsers();
        this.mailTextForNeverLoggedInUsers = this.settings.getMailTextForNeverLoggedInUsers();
        this.enableDirectoryFilter = this.settings.getEnableDirectoryFilter();
        this.directoryFilterList = (ArrayList)this.settings.getDirectoryFilterList();
        this.enableLicenseLimitAlert = this.settings.getEnableLicenseLimitAlert();
        this.userLicenseLimit = this.settings.getUserLicenseLimit();
        this.adminsForAlert = String.join((CharSequence)",", (ArrayList)this.settings.getSelectedAdminUserList());
        this.mailServerForLicenseAlert = this.settings.getMailServerForLicenseAlert();
        this.enableCrowdROUser = this.settings.getEnableCrowdROUser();
        this.groupConditionList = (ArrayList)this.settings.getGroupCondition();
        this.addGroupBaseOnRuleList = (ArrayList)this.settings.getAddGroupBaseOnRule();
        this.ruleBaseGroupMapping = this.settings.getRuleBaseGroupMapping();
        this.enableFloatingLicenseForRODir = this.settings.getEnableFloatingLicenseForRODir();
        this.revokeDays = this.settings.getRevokeDays();
        this.groupDays = this.settings.getGroupDays();
        this.excludeRevokeGroups = this.settings.getExcludeRevokeGroups();
        this.excludeRevokeGroupsArray = (ArrayList)this.settings.getExcludeRevokeGroupsArray();
        this.revokeDirectoryFilter = this.settings.getRevokeDirectoryFilter();
        this.revokeDirectoryArray = (ArrayList)this.settings.getRevokeDirectoryArray();
        this.revokeNeverLoggedIn = this.settings.getRevokeNeverLoggedIn();
        this.revokeNeverLoggedInDays = this.settings.getRevokeNeverLoggedInDays();
        this.revokeCrowdReadOnly = this.settings.getRevokeCrowdReadOnly();
        this.smtpConfigured = this.isSmtpConfigured();
        this.groupMapping = this.settings.getGroupMapping() != null ? this.settings.getGroupMapping() : new HashMap();
    }

    public void fetchDetailsFromRequest() {
        HttpServletRequest request = this.getCurrentRequest();
        this.autoActivateSubmited = Boolean.valueOf(request.getParameter("autoActivateSubmited"));
        this.reActivateUser = Boolean.valueOf(request.getParameter("reActivateUser"));
        this.addGroupsToInactive = Boolean.valueOf(request.getParameter("addGroupsToInactive"));
        this.addGroups = request.getParameter("addGroups");
        this.removeGroupsFromInactive = Boolean.valueOf(request.getParameter("removeGroupsFromInactive"));
        this.removeGroups = request.getParameter("removeGroups");
        this.addGroupsToActiveUser = Boolean.valueOf(request.getParameter("addGroupsToActiveUser"));
        this.restrictLoginUsersGroups = Boolean.valueOf(request.getParameter("restrictLoginUsersGroups"));
        this.restrictLoginUsersGroupsList = request.getParameter("restrictLoginUsersGroupsList");
        this.groupsAssignToActiveUser = request.getParameter("groupsAssignToActiveUser");
        this.autodeactivatecheck = Boolean.valueOf(request.getParameter("autodeactivatecheck"));
        this.autoDeactivateSubmited = Boolean.valueOf(request.getParameter("autoDeactivateSubmited"));
        this.usernameSuffix = request.getParameter("usernameSuffix");
        this.enableAutoRemoveFromGroup = Boolean.valueOf(request.getParameter("enableAutoRemoveFromGroup"));
        this.enableAutoAddGroupToUser = Boolean.valueOf(request.getParameter("enableAutoAddGroupToUser"));
        this.autoRemoveGroups = request.getParameter("autoRemoveGroups");
        this.autoAddGroups = request.getParameter("autoAddGroups");
        this.enableReadOnlyDirAutoActivate = Boolean.valueOf(request.getParameter("enableReadOnlyDirAutoActivate"));
        this.enableFloatingLicenseForRODir = Boolean.valueOf(request.getParameter("enableFloatingLicenseForRODir"));
        if (request.getParameter("limitDays") != null) {
            this.limitDays = Long.parseLong(request.getParameter("limitDays"));
        }
        if (request.getParameter("ruleBaseGroupMapping") != null) {
            this.ruleBaseGroupMapping = Boolean.valueOf(request.getParameter("ruleBaseGroupMapping"));
            this.groupCondition = request.getParameter("groupCondition");
            this.addGroupBaseOnRule = request.getParameter("addGroupBaseOnRule");
        }
        this.enableCrowdROUser = Boolean.valueOf(request.getParameter("enableCrowdROUser"));
        this.mailNotification = Boolean.valueOf(request.getParameter("mailNotification"));
        this.mailServer = request.getParameter("mailServer");
        this.mailPeriod = request.getParameter("mailPeriod");
        this.mailSubject = request.getParameter("mailSubject");
        this.emailTemplate = request.getParameter("emailTemplate");
        this.neverLoggedinUsers = Boolean.valueOf(request.getParameter("neverLoggedinUsers"));
        if (request.getParameter("daysAfterUserCreation") != null) {
            this.daysAfterUserCreation = Long.parseLong(request.getParameter("daysAfterUserCreation"));
        }
        this.sendMailToNeverLoggedInUsers = Boolean.valueOf(request.getParameter("sendMailToNeverLoggedInUsers"));
        this.mailServerForNeverLoggedIn = request.getParameter("mailServerForNeverLoggedIn");
        this.mailPeriodForNeverLoggedInUsers = request.getParameter("mailPeriodForNeverLoggedInUsers");
        this.mailSubForNeverLoggedInUsers = request.getParameter("mailSubForNeverLoggedInUsers");
        this.mailTextForNeverLoggedInUsers = request.getParameter("mailTextForNeverLoggedInUsers");
        this.enableDirectoryFilter = Boolean.valueOf(request.getParameter("enableDirectoryFilter"));
        this.directoryFilter = request.getParameter("directoryFilter");
        this.enableLicenseLimitAlert = Boolean.valueOf(request.getParameter("enableLicenseLimitAlert"));
        this.mailServerForLicenseAlert = request.getParameter("mailServerForLicenseAlert");
        this.userLicenseLimit = request.getParameter("userLicenseLimit");
        if (request.getParameter("adminsForAlert") != null) {
            this.adminsForAlert = request.getParameter("adminsForAlert");
        }
        this.enableExcludeGroups = Boolean.valueOf(request.getParameter("enableExcludeGroups"));
        this.excludeGroups = request.getParameter("excludeGroups");
        this.summarySubmited = Boolean.valueOf(request.getParameter("summarySubmited"));
        this.revokeAccessSubmited = Boolean.valueOf(request.getParameter("revokeAccessSubmited"));
        this.floatingLicenseSubmited = Boolean.valueOf(request.getParameter("floatingLicenseSubmited"));
        this.testingSubmited = Boolean.valueOf(request.getParameter("testingSubmited"));
        if (request.getParameter("revokeDays") != null) {
            this.revokeDays = Long.parseLong(request.getParameter("revokeDays"));
        }
        this.excludeRevokeGroups = Boolean.valueOf(request.getParameter("excludeRevokeGroups"));
        this.excludeRevokeGroupsList = request.getParameter("excludeRevokeGroupsList");
        this.revokeDirectoryFilter = Boolean.valueOf(request.getParameter("revokeDirectoryFilter"));
        this.revokeDirectoryList = request.getParameter("revokeDirectoryList");
        this.revokeNeverLoggedIn = Boolean.valueOf(request.getParameter("revokeNeverLoggedIn"));
        if (request.getParameter("revokeNeverLoggedInDays") != null) {
            this.revokeNeverLoggedInDays = Long.parseLong(request.getParameter("revokeNeverLoggedInDays"));
        }
        this.revokeCrowdReadOnly = Boolean.valueOf(request.getParameter("revokeCrowdReadOnly"));
        if (request.getParameter("customSchedulerTimeHour") != null) {
            this.customSchedulerTimeHour = Long.parseLong(request.getParameter("customSchedulerTimeHour"));
        }
        if (request.getParameter("customSchedulerTimeMinute") != null) {
            this.customSchedulerTimeMinute = Long.parseLong(request.getParameter("customSchedulerTimeMinute"));
        }
        if (request.getParameter("scheduler_days") != null) {
            this.scheduler_days = Long.parseLong(request.getParameter("scheduler_days"));
        }
        this.groupAssignmentSubmited = Boolean.valueOf(request.getParameter("groupAssignmentSubmited"));
        if (request.getParameter("groupDays") != null) {
            this.groupDays = Long.parseLong(request.getParameter("groupDays"));
        }
    }

    @Generated
    public Boolean getAutodeactivatecheck() {
        return this.autodeactivatecheck;
    }

    @Generated
    public Boolean getSummarySubmited() {
        return this.summarySubmited;
    }

    @Generated
    public String getUsernameSuffix() {
        return this.usernameSuffix;
    }

    @Generated
    public UserManagementPluginHandler getUserManagementPluginHandler() {
        return this.userManagementPluginHandler;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    @Generated
    public MailServerManager getMailServerManager() {
        return this.mailServerManager;
    }

    @Generated
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.userManagementUtility;
    }

    @Generated
    public Boolean getEnableAutoRemoveFromGroup() {
        return this.enableAutoRemoveFromGroup;
    }

    @Generated
    public Boolean getEnableAutoAddGroupToUser() {
        return this.enableAutoAddGroupToUser;
    }

    @Generated
    public long getLimitDays() {
        return this.limitDays;
    }

    @Generated
    public String getContextPath() {
        return this.contextPath;
    }

    @Generated
    public Boolean getMailNotification() {
        return this.mailNotification;
    }

    @Generated
    public ArrayList<String> getEmailServers() {
        return this.emailServers;
    }

    @Generated
    public String getMailPeriod() {
        return this.mailPeriod;
    }

    @Generated
    public String getMailSubject() {
        return this.mailSubject;
    }

    @Generated
    public String getEmailTemplate() {
        return this.emailTemplate;
    }

    @Generated
    public Boolean getNeverLoggedinUsers() {
        return this.neverLoggedinUsers;
    }

    @Generated
    public long getDaysAfterUserCreation() {
        return this.daysAfterUserCreation;
    }

    @Generated
    public Boolean getSendMailToNeverLoggedInUsers() {
        return this.sendMailToNeverLoggedInUsers;
    }

    @Generated
    public Boolean getAutoDeactivateSubmited() {
        return this.autoDeactivateSubmited;
    }

    @Generated
    public Boolean getAutoActivateSubmited() {
        return this.autoActivateSubmited;
    }

    @Generated
    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    @Generated
    public Boolean getEnableExcludeGroups() {
        return this.enableExcludeGroups;
    }

    @Generated
    public String getMailServer() {
        return this.mailServer;
    }

    @Generated
    public String getMailServerForNeverLoggedIn() {
        return this.mailServerForNeverLoggedIn;
    }

    @Generated
    public String getMailPeriodForNeverLoggedInUsers() {
        return this.mailPeriodForNeverLoggedInUsers;
    }

    @Generated
    public String getMailSubForNeverLoggedInUsers() {
        return this.mailSubForNeverLoggedInUsers;
    }

    @Generated
    public String getMailTextForNeverLoggedInUsers() {
        return this.mailTextForNeverLoggedInUsers;
    }

    @Generated
    public Boolean getSmtpConfigured() {
        return this.smtpConfigured;
    }

    @Generated
    public String getExcludeGroups() {
        return this.excludeGroups;
    }

    @Generated
    public long getScheduler_days() {
        return this.scheduler_days;
    }

    @Generated
    public Date getPreviousSchedulerDate() {
        return this.previousSchedulerDate;
    }

    @Generated
    public Date getNextSchedulerDate() {
        return this.nextSchedulerDate;
    }

    @Generated
    public ArrayList<String> getExcludeGroupsList() {
        return this.excludeGroupsList;
    }

    @Generated
    public Boolean getReActivateUser() {
        return this.reActivateUser;
    }

    @Generated
    public Boolean getAddGroupsToInactive() {
        return this.addGroupsToInactive;
    }

    @Generated
    public String getAddGroups() {
        return this.addGroups;
    }

    @Generated
    public ArrayList<String> getAddGroupsList() {
        return this.addGroupsList;
    }

    @Generated
    public Boolean getRemoveGroupsFromInactive() {
        return this.removeGroupsFromInactive;
    }

    @Generated
    public Boolean getRestrictLoginUsersGroups() {
        return this.restrictLoginUsersGroups;
    }

    @Generated
    public String getRestrictLoginUsersGroupsList() {
        return this.restrictLoginUsersGroupsList;
    }

    @Generated
    public ArrayList<String> getRestrictLoginUsersGroupsListArray() {
        return this.restrictLoginUsersGroupsListArray;
    }

    @Generated
    public String getRemoveGroups() {
        return this.removeGroups;
    }

    @Generated
    public ArrayList<String> getRemoveGroupsList() {
        return this.removeGroupsList;
    }

    @Generated
    public Boolean getGroupsEmpty() {
        return this.groupsEmpty;
    }

    @Generated
    public Boolean getAddGroupsToActiveUser() {
        return this.addGroupsToActiveUser;
    }

    @Generated
    public String getGroupsAssignToActiveUser() {
        return this.groupsAssignToActiveUser;
    }

    @Generated
    public ArrayList<String> getGroupsListAssignToActiveUser() {
        return this.groupsListAssignToActiveUser;
    }

    @Generated
    public Boolean getGroupEmptyForActiveUser() {
        return this.groupEmptyForActiveUser;
    }

    @Generated
    public String getAutoRemoveGroups() {
        return this.autoRemoveGroups;
    }

    @Generated
    public ArrayList<String> getAutoRemoveGroupsList() {
        return this.autoRemoveGroupsList;
    }

    @Generated
    public String getAutoAddGroups() {
        return this.autoAddGroups;
    }

    @Generated
    public ArrayList<String> getAutoAddGroupsList() {
        return this.autoAddGroupsList;
    }

    @Generated
    public String getAtl_token() {
        return this.atl_token;
    }

    @Generated
    public Boolean getRuleBaseGroupMapping() {
        return this.ruleBaseGroupMapping;
    }

    @Generated
    public String getGroupCondition() {
        return this.groupCondition;
    }

    @Generated
    public String getAddGroupBaseOnRule() {
        return this.addGroupBaseOnRule;
    }

    @Generated
    public Boolean getGroupEmptyForRuleBaseMapping() {
        return this.groupEmptyForRuleBaseMapping;
    }

    @Generated
    public ArrayList<String> getGroupConditionList() {
        return this.groupConditionList;
    }

    @Generated
    public ArrayList<String> getAddGroupBaseOnRuleList() {
        return this.addGroupBaseOnRuleList;
    }

    @Generated
    public Boolean getFloatingLicenseSubmited() {
        return this.floatingLicenseSubmited;
    }

    @Generated
    public Map<String, List<String>> getGroupMapping() {
        return this.groupMapping;
    }

    @Generated
    public List<SMTPMailServer> getSmtpServers() {
        return this.smtpServers;
    }

    @Generated
    public long getCustomSchedulerTimeHour() {
        return this.customSchedulerTimeHour;
    }

    @Generated
    public long getCustomSchedulerTimeMinute() {
        return this.customSchedulerTimeMinute;
    }

    @Generated
    public Boolean getPreviousSchedulerFlag() {
        return this.previousSchedulerFlag;
    }

    @Generated
    public Boolean getEnableLicenseLimitAlert() {
        return this.enableLicenseLimitAlert;
    }

    @Generated
    public String getMailServerForLicenseAlert() {
        return this.mailServerForLicenseAlert;
    }

    @Generated
    public String getUserLicenseLimit() {
        return this.userLicenseLimit;
    }

    @Generated
    public Integer getTotalLicensedUsers() {
        return this.totalLicensedUsers;
    }

    @Generated
    public UserChecker getUserChecker() {
        return this.userChecker;
    }

    @Generated
    public String getAdminsForAlert() {
        return this.adminsForAlert;
    }

    @Generated
    public ArrayList<String> getSelectedAdminList() {
        return this.selectedAdminList;
    }

    @Generated
    public Boolean getEnableCrowdROUser() {
        return this.enableCrowdROUser;
    }

    @Generated
    public Boolean getEnableDirectoryFilter() {
        return this.enableDirectoryFilter;
    }

    @Generated
    public String getDirectoryFilter() {
        return this.directoryFilter;
    }

    @Generated
    public ArrayList<String> getDirectoryFilterList() {
        return this.directoryFilterList;
    }

    @Generated
    public Boolean getRevokeAccessSubmited() {
        return this.revokeAccessSubmited;
    }

    @Generated
    public long getRevokeDays() {
        return this.revokeDays;
    }

    @Generated
    public Boolean getExcludeRevokeGroups() {
        return this.excludeRevokeGroups;
    }

    @Generated
    public String getExcludeRevokeGroupsList() {
        return this.excludeRevokeGroupsList;
    }

    @Generated
    public ArrayList<String> getExcludeRevokeGroupsArray() {
        return this.excludeRevokeGroupsArray;
    }

    @Generated
    public Boolean getRevokeDirectoryFilter() {
        return this.revokeDirectoryFilter;
    }

    @Generated
    public String getRevokeDirectoryList() {
        return this.revokeDirectoryList;
    }

    @Generated
    public ArrayList<String> getRevokeDirectoryArray() {
        return this.revokeDirectoryArray;
    }

    @Generated
    public Boolean getRevokeNeverLoggedIn() {
        return this.revokeNeverLoggedIn;
    }

    @Generated
    public long getRevokeNeverLoggedInDays() {
        return this.revokeNeverLoggedInDays;
    }

    @Generated
    public Boolean getRevokeCrowdReadOnly() {
        return this.revokeCrowdReadOnly;
    }

    @Generated
    public Boolean getGroupAssignmentSubmited() {
        return this.groupAssignmentSubmited;
    }

    @Generated
    public String getPreviousSchedulerDateString() {
        return this.previousSchedulerDateString;
    }

    @Generated
    public String getNextSchedulerDateString() {
        return this.nextSchedulerDateString;
    }

    @Generated
    public long getGroupDays() {
        return this.groupDays;
    }

    @Generated
    public Boolean getTestingSubmited() {
        return this.testingSubmited;
    }

    @Generated
    public long getInactiveUsersGroupsDays() {
        return this.inactiveUsersGroupsDays;
    }

    @Generated
    public Boolean getEnableReadOnlyDirAutoActivate() {
        return this.enableReadOnlyDirAutoActivate;
    }

    @Generated
    public Boolean getEnableFloatingLicenseForRODir() {
        return this.enableFloatingLicenseForRODir;
    }

    @Generated
    public void setAutodeactivatecheck(Boolean autodeactivatecheck) {
        this.autodeactivatecheck = autodeactivatecheck;
    }

    @Generated
    public void setSummarySubmited(Boolean summarySubmited) {
        this.summarySubmited = summarySubmited;
    }

    @Generated
    public void setUsernameSuffix(String usernameSuffix) {
        this.usernameSuffix = usernameSuffix;
    }

    @Generated
    public void setUserManagementPluginHandler(UserManagementPluginHandler userManagementPluginHandler) {
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    @Generated
    public void setEnableAutoRemoveFromGroup(Boolean enableAutoRemoveFromGroup) {
        this.enableAutoRemoveFromGroup = enableAutoRemoveFromGroup;
    }

    @Generated
    public void setEnableAutoAddGroupToUser(Boolean enableAutoAddGroupToUser) {
        this.enableAutoAddGroupToUser = enableAutoAddGroupToUser;
    }

    @Generated
    public void setLimitDays(long limitDays) {
        this.limitDays = limitDays;
    }

    @Generated
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Generated
    public void setMailNotification(Boolean mailNotification) {
        this.mailNotification = mailNotification;
    }

    @Generated
    public void setEmailServers(ArrayList<String> emailServers) {
        this.emailServers = emailServers;
    }

    @Generated
    public void setMailPeriod(String mailPeriod) {
        this.mailPeriod = mailPeriod;
    }

    @Generated
    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    @Generated
    public void setEmailTemplate(String emailTemplate) {
        this.emailTemplate = emailTemplate;
    }

    @Generated
    public void setNeverLoggedinUsers(Boolean neverLoggedinUsers) {
        this.neverLoggedinUsers = neverLoggedinUsers;
    }

    @Generated
    public void setDaysAfterUserCreation(long daysAfterUserCreation) {
        this.daysAfterUserCreation = daysAfterUserCreation;
    }

    @Generated
    public void setSendMailToNeverLoggedInUsers(Boolean sendMailToNeverLoggedInUsers) {
        this.sendMailToNeverLoggedInUsers = sendMailToNeverLoggedInUsers;
    }

    @Generated
    public void setAutoDeactivateSubmited(Boolean autoDeactivateSubmited) {
        this.autoDeactivateSubmited = autoDeactivateSubmited;
    }

    @Generated
    public void setAutoActivateSubmited(Boolean autoActivateSubmited) {
        this.autoActivateSubmited = autoActivateSubmited;
    }

    @Generated
    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    @Generated
    public void setEnableExcludeGroups(Boolean enableExcludeGroups) {
        this.enableExcludeGroups = enableExcludeGroups;
    }

    @Generated
    public void setMailServer(String mailServer) {
        this.mailServer = mailServer;
    }

    @Generated
    public void setMailServerForNeverLoggedIn(String mailServerForNeverLoggedIn) {
        this.mailServerForNeverLoggedIn = mailServerForNeverLoggedIn;
    }

    @Generated
    public void setMailPeriodForNeverLoggedInUsers(String mailPeriodForNeverLoggedInUsers) {
        this.mailPeriodForNeverLoggedInUsers = mailPeriodForNeverLoggedInUsers;
    }

    @Generated
    public void setMailSubForNeverLoggedInUsers(String mailSubForNeverLoggedInUsers) {
        this.mailSubForNeverLoggedInUsers = mailSubForNeverLoggedInUsers;
    }

    @Generated
    public void setMailTextForNeverLoggedInUsers(String mailTextForNeverLoggedInUsers) {
        this.mailTextForNeverLoggedInUsers = mailTextForNeverLoggedInUsers;
    }

    @Generated
    public void setSmtpConfigured(Boolean smtpConfigured) {
        this.smtpConfigured = smtpConfigured;
    }

    @Generated
    public void setExcludeGroups(String excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    @Generated
    public void setScheduler_days(long scheduler_days) {
        this.scheduler_days = scheduler_days;
    }

    @Generated
    public void setPreviousSchedulerDate(Date previousSchedulerDate) {
        this.previousSchedulerDate = previousSchedulerDate;
    }

    @Generated
    public void setNextSchedulerDate(Date nextSchedulerDate) {
        this.nextSchedulerDate = nextSchedulerDate;
    }

    @Generated
    public void setExcludeGroupsList(ArrayList<String> excludeGroupsList) {
        this.excludeGroupsList = excludeGroupsList;
    }

    @Generated
    public void setReActivateUser(Boolean reActivateUser) {
        this.reActivateUser = reActivateUser;
    }

    @Generated
    public void setAddGroupsToInactive(Boolean addGroupsToInactive) {
        this.addGroupsToInactive = addGroupsToInactive;
    }

    @Generated
    public void setAddGroups(String addGroups) {
        this.addGroups = addGroups;
    }

    @Generated
    public void setAddGroupsList(ArrayList<String> addGroupsList) {
        this.addGroupsList = addGroupsList;
    }

    @Generated
    public void setRemoveGroupsFromInactive(Boolean removeGroupsFromInactive) {
        this.removeGroupsFromInactive = removeGroupsFromInactive;
    }

    @Generated
    public void setRestrictLoginUsersGroups(Boolean restrictLoginUsersGroups) {
        this.restrictLoginUsersGroups = restrictLoginUsersGroups;
    }

    @Generated
    public void setRestrictLoginUsersGroupsList(String restrictLoginUsersGroupsList) {
        this.restrictLoginUsersGroupsList = restrictLoginUsersGroupsList;
    }

    @Generated
    public void setRestrictLoginUsersGroupsListArray(ArrayList<String> restrictLoginUsersGroupsListArray) {
        this.restrictLoginUsersGroupsListArray = restrictLoginUsersGroupsListArray;
    }

    @Generated
    public void setRemoveGroups(String removeGroups) {
        this.removeGroups = removeGroups;
    }

    @Generated
    public void setRemoveGroupsList(ArrayList<String> removeGroupsList) {
        this.removeGroupsList = removeGroupsList;
    }

    @Generated
    public void setGroupsEmpty(Boolean groupsEmpty) {
        this.groupsEmpty = groupsEmpty;
    }

    @Generated
    public void setAddGroupsToActiveUser(Boolean addGroupsToActiveUser) {
        this.addGroupsToActiveUser = addGroupsToActiveUser;
    }

    @Generated
    public void setGroupsAssignToActiveUser(String groupsAssignToActiveUser) {
        this.groupsAssignToActiveUser = groupsAssignToActiveUser;
    }

    @Generated
    public void setGroupsListAssignToActiveUser(ArrayList<String> groupsListAssignToActiveUser) {
        this.groupsListAssignToActiveUser = groupsListAssignToActiveUser;
    }

    @Generated
    public void setGroupEmptyForActiveUser(Boolean groupEmptyForActiveUser) {
        this.groupEmptyForActiveUser = groupEmptyForActiveUser;
    }

    @Generated
    public void setAutoRemoveGroups(String autoRemoveGroups) {
        this.autoRemoveGroups = autoRemoveGroups;
    }

    @Generated
    public void setAutoRemoveGroupsList(ArrayList<String> autoRemoveGroupsList) {
        this.autoRemoveGroupsList = autoRemoveGroupsList;
    }

    @Generated
    public void setAutoAddGroups(String autoAddGroups) {
        this.autoAddGroups = autoAddGroups;
    }

    @Generated
    public void setAutoAddGroupsList(ArrayList<String> autoAddGroupsList) {
        this.autoAddGroupsList = autoAddGroupsList;
    }

    @Generated
    public void setAtl_token(String atl_token) {
        this.atl_token = atl_token;
    }

    @Generated
    public void setRuleBaseGroupMapping(Boolean ruleBaseGroupMapping) {
        this.ruleBaseGroupMapping = ruleBaseGroupMapping;
    }

    @Generated
    public void setGroupCondition(String groupCondition) {
        this.groupCondition = groupCondition;
    }

    @Generated
    public void setAddGroupBaseOnRule(String addGroupBaseOnRule) {
        this.addGroupBaseOnRule = addGroupBaseOnRule;
    }

    @Generated
    public void setGroupEmptyForRuleBaseMapping(Boolean groupEmptyForRuleBaseMapping) {
        this.groupEmptyForRuleBaseMapping = groupEmptyForRuleBaseMapping;
    }

    @Generated
    public void setGroupConditionList(ArrayList<String> groupConditionList) {
        this.groupConditionList = groupConditionList;
    }

    @Generated
    public void setAddGroupBaseOnRuleList(ArrayList<String> addGroupBaseOnRuleList) {
        this.addGroupBaseOnRuleList = addGroupBaseOnRuleList;
    }

    @Generated
    public void setFloatingLicenseSubmited(Boolean floatingLicenseSubmited) {
        this.floatingLicenseSubmited = floatingLicenseSubmited;
    }

    @Generated
    public void setGroupMapping(Map<String, List<String>> groupMapping) {
        this.groupMapping = groupMapping;
    }

    @Generated
    public void setSmtpServers(List<SMTPMailServer> smtpServers) {
        this.smtpServers = smtpServers;
    }

    @Generated
    public void setCustomSchedulerTimeHour(long customSchedulerTimeHour) {
        this.customSchedulerTimeHour = customSchedulerTimeHour;
    }

    @Generated
    public void setCustomSchedulerTimeMinute(long customSchedulerTimeMinute) {
        this.customSchedulerTimeMinute = customSchedulerTimeMinute;
    }

    @Generated
    public void setPreviousSchedulerFlag(Boolean previousSchedulerFlag) {
        this.previousSchedulerFlag = previousSchedulerFlag;
    }

    @Generated
    public void setEnableLicenseLimitAlert(Boolean enableLicenseLimitAlert) {
        this.enableLicenseLimitAlert = enableLicenseLimitAlert;
    }

    @Generated
    public void setMailServerForLicenseAlert(String mailServerForLicenseAlert) {
        this.mailServerForLicenseAlert = mailServerForLicenseAlert;
    }

    @Generated
    public void setUserLicenseLimit(String userLicenseLimit) {
        this.userLicenseLimit = userLicenseLimit;
    }

    @Generated
    public void setTotalLicensedUsers(Integer totalLicensedUsers) {
        this.totalLicensedUsers = totalLicensedUsers;
    }

    @Generated
    public void setUserChecker(UserChecker userChecker) {
        this.userChecker = userChecker;
    }

    @Generated
    public void setAdminsForAlert(String adminsForAlert) {
        this.adminsForAlert = adminsForAlert;
    }

    @Generated
    public void setSelectedAdminList(ArrayList<String> selectedAdminList) {
        this.selectedAdminList = selectedAdminList;
    }

    @Generated
    public void setEnableCrowdROUser(Boolean enableCrowdROUser) {
        this.enableCrowdROUser = enableCrowdROUser;
    }

    @Generated
    public void setEnableDirectoryFilter(Boolean enableDirectoryFilter) {
        this.enableDirectoryFilter = enableDirectoryFilter;
    }

    @Generated
    public void setDirectoryFilter(String directoryFilter) {
        this.directoryFilter = directoryFilter;
    }

    @Generated
    public void setDirectoryFilterList(ArrayList<String> directoryFilterList) {
        this.directoryFilterList = directoryFilterList;
    }

    @Generated
    public void setRevokeAccessSubmited(Boolean revokeAccessSubmited) {
        this.revokeAccessSubmited = revokeAccessSubmited;
    }

    @Generated
    public void setRevokeDays(long revokeDays) {
        this.revokeDays = revokeDays;
    }

    @Generated
    public void setExcludeRevokeGroups(Boolean excludeRevokeGroups) {
        this.excludeRevokeGroups = excludeRevokeGroups;
    }

    @Generated
    public void setExcludeRevokeGroupsList(String excludeRevokeGroupsList) {
        this.excludeRevokeGroupsList = excludeRevokeGroupsList;
    }

    @Generated
    public void setExcludeRevokeGroupsArray(ArrayList<String> excludeRevokeGroupsArray) {
        this.excludeRevokeGroupsArray = excludeRevokeGroupsArray;
    }

    @Generated
    public void setRevokeDirectoryFilter(Boolean revokeDirectoryFilter) {
        this.revokeDirectoryFilter = revokeDirectoryFilter;
    }

    @Generated
    public void setRevokeDirectoryList(String revokeDirectoryList) {
        this.revokeDirectoryList = revokeDirectoryList;
    }

    @Generated
    public void setRevokeDirectoryArray(ArrayList<String> revokeDirectoryArray) {
        this.revokeDirectoryArray = revokeDirectoryArray;
    }

    @Generated
    public void setRevokeNeverLoggedIn(Boolean revokeNeverLoggedIn) {
        this.revokeNeverLoggedIn = revokeNeverLoggedIn;
    }

    @Generated
    public void setRevokeNeverLoggedInDays(long revokeNeverLoggedInDays) {
        this.revokeNeverLoggedInDays = revokeNeverLoggedInDays;
    }

    @Generated
    public void setRevokeCrowdReadOnly(Boolean revokeCrowdReadOnly) {
        this.revokeCrowdReadOnly = revokeCrowdReadOnly;
    }

    @Generated
    public void setGroupAssignmentSubmited(Boolean groupAssignmentSubmited) {
        this.groupAssignmentSubmited = groupAssignmentSubmited;
    }

    @Generated
    public void setPreviousSchedulerDateString(String previousSchedulerDateString) {
        this.previousSchedulerDateString = previousSchedulerDateString;
    }

    @Generated
    public void setNextSchedulerDateString(String nextSchedulerDateString) {
        this.nextSchedulerDateString = nextSchedulerDateString;
    }

    @Generated
    public void setGroupDays(long groupDays) {
        this.groupDays = groupDays;
    }

    @Generated
    public void setTestingSubmited(Boolean testingSubmited) {
        this.testingSubmited = testingSubmited;
    }

    @Generated
    public void setInactiveUsersGroupsDays(long inactiveUsersGroupsDays) {
        this.inactiveUsersGroupsDays = inactiveUsersGroupsDays;
    }

    @Generated
    public void setEnableReadOnlyDirAutoActivate(Boolean enableReadOnlyDirAutoActivate) {
        this.enableReadOnlyDirAutoActivate = enableReadOnlyDirAutoActivate;
    }

    @Generated
    public void setEnableFloatingLicenseForRODir(Boolean enableFloatingLicenseForRODir) {
        this.enableFloatingLicenseForRODir = enableFloatingLicenseForRODir;
    }
}

