/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.xwork.FileUploadUtils;
import com.atlassian.xwork.SimpleXsrfTokenGenerator;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkGroupManagementAction
extends ConfluenceActionSupport {
    private static Logger LOGGER = LoggerFactory.getLogger(BulkGroupManagementAction.class);
    private ConfluenceUserManagementUtility UserManagementUtility;
    private UserManagementPluginHandler userManagementPluginHandler;
    private UserManagementPluginSettings settings;
    private CrowdService crowdService;
    private UserAccessor userAccessor;
    private String groupsToCreate;
    private Boolean userManagementGroupsSubmitted;
    private Boolean maxUsersLicense;
    private Boolean userManagementGroupsDeletionSubmitted;
    private Boolean usermanagementGroupsUploadSubmitted;
    private String groupManagementSelectedAction;
    private String creationSelection;
    private String groupsToDelete;
    private ArrayList<String> groupsToDeleteList;
    private ArrayList<String> groupToAddCsv;
    private Boolean uploadgroupSuccessfull = Boolean.FALSE;
    private ArrayList<String> groupList;
    private ArrayList<String> currentPageGroupsList;
    private String groupSearchKeyword;
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;
    private Integer numberOfRecordsPerPage;
    private Integer groupPerPage;
    private List<String> numberOfPagesList;
    private Boolean evaluationLicense;
    private String atl_token;
    private boolean dataCenter;
    private boolean offlineLicenseValid = false;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private ConfluenceUserManagementUtility userManagementUtility;
    private DirectoryManager directoryManager;
    private String contextPath;

    public BulkGroupManagementAction(UserAccessor userAccessor, ConfluenceUserManagementUtility userManagementUtility, UserManagementPluginHandler userManagementPluginHandler, UserManagementPluginSettings settings, UserDeactivaterScheduler userDeactivaterScheduler, ConfluenceUserManagementUtility confluenceUserManagement, CrowdService crowdService, DirectoryManager directoryManager) {
        this.userAccessor = userAccessor;
        this.UserManagementUtility = userManagementUtility;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.settings = settings;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.userManagementUtility = confluenceUserManagement;
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
    }

    public Boolean doValidate() throws ParseException {
        String endIndexOfPage;
        String startIndexOfPage;
        LOGGER.debug("Settings Action doValidate");
        Boolean isError = Boolean.FALSE;
        HttpServletRequest request = this.getCurrentRequest();
        if (this.usermanagementGroupsUploadSubmitted == null) {
            this.usermanagementGroupsUploadSubmitted = Boolean.FALSE;
        }
        if (request.getParameter("userManagementGroupsDeletionSubmitted") != null) {
            this.userManagementGroupsDeletionSubmitted = Boolean.valueOf(request.getParameter("userManagementGroupsDeletionSubmitted"));
        }
        if (request.getParameter("groupPerPage") != null) {
            this.groupPerPage = Integer.valueOf(request.getParameter("groupPerPage"));
        }
        if (request.getParameter("groupSearchKeyword") != null) {
            this.groupSearchKeyword = request.getParameter("groupSearchKeyword");
        }
        if (BooleanUtils.toBoolean((Boolean)this.userManagementGroupsDeletionSubmitted)) {
            startIndexOfPage = "";
            endIndexOfPage = "";
        } else {
            startIndexOfPage = request.getParameter("startIndex");
            endIndexOfPage = request.getParameter("endIndex");
            this.groupSearchKeyword = request.getParameter("groupSearchKeywordUrl");
        }
        if (this.groupPerPage == null) {
            this.groupPerPage = request.getParameter("groupPerPageurl") == null ? UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE : Integer.valueOf(Integer.parseInt(request.getParameter("groupPerPageurl")));
        }
        this.numberOfRecordsPerPage = this.groupPerPage;
        this.groupSearchKeyword = StringUtils.isBlank((CharSequence)this.groupSearchKeyword) ? "" : UserManagementPluginSettings.sanitizeText(this.groupSearchKeyword).trim();
        if (StringUtils.isBlank((CharSequence)startIndexOfPage) && StringUtils.isBlank((CharSequence)endIndexOfPage)) {
            this.selectedPage = 1;
            this.startIndex = 0;
            this.endIndex = this.numberOfRecordsPerPage;
        } else {
            this.startIndex = Integer.parseInt(startIndexOfPage);
            this.endIndex = Integer.parseInt(endIndexOfPage);
            this.selectedPage = this.endIndex / this.groupPerPage;
        }
        this.groupList = (ArrayList)this.userManagementUtility.getAllGroups(this.groupSearchKeyword);
        this.currentPageGroupsList = (ArrayList)this.userManagementUtility.getSelectedDetailsForPagination(this.groupList, this.groupPerPage, this.startIndex, this.endIndex);
        this.numberOfPages = this.groupList.size() / this.groupPerPage;
        if (this.groupList.size() > this.numberOfPages * this.groupPerPage) {
            Integer n = this.numberOfPages;
            this.numberOfPages = this.numberOfPages + 1;
        }
        if (request.getParameter("usermanagementGroupsUploadSubmitted") != null) {
            this.usermanagementGroupsUploadSubmitted = Boolean.valueOf(request.getParameter("usermanagementGroupsUploadSubmitted"));
            if (this.usermanagementGroupsUploadSubmitted.booleanValue()) {
                try {
                    this.handleUploadedCSVFile();
                    this.uploadgroupSuccessfull = Boolean.TRUE;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (isError.booleanValue()) {
            this.initialization();
            return isError;
        }
        return isError;
    }

    public String execute() throws Exception {
        LOGGER.debug("initiating Bulk Group Management Action's doExecute");
        SimpleXsrfTokenGenerator tokenGenerator = new SimpleXsrfTokenGenerator();
        this.atl_token = tokenGenerator.generateToken(this.getCurrentRequest());
        if (!this.userManagementUtility.isLicenseValid().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return "invalid";
        }
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        if (!this.maxUsersLicense.booleanValue()) {
            this.evaluationLicense = this.userManagementUtility.isEvaluationLicense() != false && this.userManagementUtility.isValidEvaluationLicense() != false ? Boolean.TRUE : Boolean.FALSE;
        }
        this.doValidate();
        this.initialization();
        return "success";
    }

    public void initialization() throws ParseException {
        this.groupManagementSelectedAction = this.settings.getUserManagementSelectedAction();
        this.creationSelection = this.settings.getCreationSelection();
        this.groupsToCreate = this.settings.getGroupsToCreate();
        this.groupsToDeleteList = (ArrayList)this.settings.getGroupsToDelete();
        this.contextPath = this.settings.getBaseURL();
    }

    public List<String> getAllGroups(String groupRegexPattern) {
        String startWith = "";
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)startWith)).returningAtMost(-1);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        for (Group groupObject : groups) {
            if (!StringUtils.containsIgnoreCase((CharSequence)groupObject.getName(), (CharSequence)groupRegexPattern.trim())) continue;
            existingGroups.add(groupObject.getName().trim());
        }
        return existingGroups;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer groupsPerPage, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i < startIndex + groupsPerPage && i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    private void handleUploadedCSVFile() throws Exception {
        block13: {
            LOGGER.debug("handleUploadedCSVFile for groups called");
            this.groupToAddCsv = new ArrayList();
            try {
                FileUploadUtils.UploadedFile file = FileUploadUtils.getSingleUploadedFile();
                if (file.getFile() == null) {
                    LOGGER.error("Uploaded Group CSV file is null");
                    this.addActionError("File is Empty");
                    break block13;
                }
                File csvFile = file.getFile();
                LOGGER.debug("Uploaded group CSV : " + csvFile.toString());
                CSVReader csvReader = null;
                csvReader = new CSVReader(new FileReader(csvFile));
                List<String[]> rows = csvReader.readAll();
                LOGGER.debug("Uploaded CSV group file size = " + rows.size());
                if (rows == null) break block13;
                LOGGER.debug("CSV Group file is not null starting thread");
                for (int i = 1; i < rows.size(); ++i) {
                    String groups = rows.get(i)[0].toString();
                    if (groups.isEmpty()) {
                        LOGGER.error(" groups is empty");
                        continue;
                    }
                    this.groupToAddCsv.add(groups);
                }
                try {
                    ConfluenceUser confluenceUser = null;
                    confluenceUser = AuthenticatedUserThreadLocal.get();
                    InetAddress ip = InetAddress.getLocalHost();
                    Directory internalDir = this.userManagementUtility.getInternalDirectory();
                    if (internalDir != null) {
                        for (String groupsName : this.groupToAddCsv) {
                            if (groupsName.trim().isEmpty()) continue;
                            if (this.crowdService.getGroup(groupsName.trim()) == null) {
                                LOGGER.debug("Creating new Group with name : " + groupsName);
                                GroupTemplate groupTemplate = new GroupTemplate(groupsName.trim(), internalDir.getId().longValue());
                                try {
                                    this.directoryManager.addGroup(internalDir.getId().longValue(), groupTemplate);
                                    this.userManagementPluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Group Created", "Created group by uploading csv file :" + groupsName, "Success");
                                }
                                catch (Exception e) {
                                    LOGGER.error("Unable to add group '" + groupTemplate.getName() + "' in directory '" + internalDir.getName() + "'. Cause: " + String.valueOf(e));
                                }
                                continue;
                            }
                            LOGGER.error("Group with name: " + groupsName.trim() + " already exists.");
                        }
                    } else {
                        LOGGER.error("Internal directory not found. Unable to add the groups.");
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
                LOGGER.debug("Groups Imported Successfully");
                this.addActionError("Groups Imported Successfully ", new Object[]{"success", true, null});
            }
            catch (Exception e) {
                LOGGER.error("error while uploading file " + String.valueOf(e));
            }
        }
    }

    @StrutsParameter
    public void setGroupPerPage(Integer groupPerPage) {
        this.groupPerPage = groupPerPage;
    }

    @StrutsParameter
    public List<String> getNumberOfPagesList() {
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
        return this.numberOfPagesList;
    }

    @Generated
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.UserManagementUtility;
    }

    @Generated
    public UserManagementPluginHandler getUserManagementPluginHandler() {
        return this.userManagementPluginHandler;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public String getGroupsToCreate() {
        return this.groupsToCreate;
    }

    @Generated
    public Boolean getUserManagementGroupsSubmitted() {
        return this.userManagementGroupsSubmitted;
    }

    @Generated
    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    @Generated
    public Boolean getUserManagementGroupsDeletionSubmitted() {
        return this.userManagementGroupsDeletionSubmitted;
    }

    @Generated
    public Boolean getUsermanagementGroupsUploadSubmitted() {
        return this.usermanagementGroupsUploadSubmitted;
    }

    @Generated
    public String getGroupManagementSelectedAction() {
        return this.groupManagementSelectedAction;
    }

    @Generated
    public String getCreationSelection() {
        return this.creationSelection;
    }

    @Generated
    public String getGroupsToDelete() {
        return this.groupsToDelete;
    }

    @Generated
    public ArrayList<String> getGroupsToDeleteList() {
        return this.groupsToDeleteList;
    }

    @Generated
    public ArrayList<String> getGroupToAddCsv() {
        return this.groupToAddCsv;
    }

    @Generated
    public Boolean getUploadgroupSuccessfull() {
        return this.uploadgroupSuccessfull;
    }

    @Generated
    public ArrayList<String> getGroupList() {
        return this.groupList;
    }

    @Generated
    public ArrayList<String> getCurrentPageGroupsList() {
        return this.currentPageGroupsList;
    }

    @Generated
    public String getGroupSearchKeyword() {
        return this.groupSearchKeyword;
    }

    @Generated
    public Integer getSelectedPage() {
        return this.selectedPage;
    }

    @Generated
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Generated
    public Integer getEndIndex() {
        return this.endIndex;
    }

    @Generated
    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    @Generated
    public Integer getNumberOfRecordsPerPage() {
        return this.numberOfRecordsPerPage;
    }

    @Generated
    public Integer getGroupPerPage() {
        return this.groupPerPage;
    }

    @Generated
    public Boolean getEvaluationLicense() {
        return this.evaluationLicense;
    }

    @Generated
    public String getAtl_token() {
        return this.atl_token;
    }

    @Generated
    public boolean isDataCenter() {
        return this.dataCenter;
    }

    @Generated
    public boolean isOfflineLicenseValid() {
        return this.offlineLicenseValid;
    }

    @Generated
    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public String getContextPath() {
        return this.contextPath;
    }

    @Generated
    public void setUserManagementUtility(ConfluenceUserManagementUtility UserManagementUtility) {
        this.UserManagementUtility = UserManagementUtility;
    }

    @Generated
    public void setUserManagementPluginHandler(UserManagementPluginHandler userManagementPluginHandler) {
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setGroupsToCreate(String groupsToCreate) {
        this.groupsToCreate = groupsToCreate;
    }

    @Generated
    public void setUserManagementGroupsSubmitted(Boolean userManagementGroupsSubmitted) {
        this.userManagementGroupsSubmitted = userManagementGroupsSubmitted;
    }

    @Generated
    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    @Generated
    public void setUserManagementGroupsDeletionSubmitted(Boolean userManagementGroupsDeletionSubmitted) {
        this.userManagementGroupsDeletionSubmitted = userManagementGroupsDeletionSubmitted;
    }

    @Generated
    public void setUsermanagementGroupsUploadSubmitted(Boolean usermanagementGroupsUploadSubmitted) {
        this.usermanagementGroupsUploadSubmitted = usermanagementGroupsUploadSubmitted;
    }

    @Generated
    public void setGroupManagementSelectedAction(String groupManagementSelectedAction) {
        this.groupManagementSelectedAction = groupManagementSelectedAction;
    }

    @Generated
    public void setCreationSelection(String creationSelection) {
        this.creationSelection = creationSelection;
    }

    @Generated
    public void setGroupsToDelete(String groupsToDelete) {
        this.groupsToDelete = groupsToDelete;
    }

    @Generated
    public void setGroupsToDeleteList(ArrayList<String> groupsToDeleteList) {
        this.groupsToDeleteList = groupsToDeleteList;
    }

    @Generated
    public void setGroupToAddCsv(ArrayList<String> groupToAddCsv) {
        this.groupToAddCsv = groupToAddCsv;
    }

    @Generated
    public void setUploadgroupSuccessfull(Boolean uploadgroupSuccessfull) {
        this.uploadgroupSuccessfull = uploadgroupSuccessfull;
    }

    @Generated
    public void setGroupList(ArrayList<String> groupList) {
        this.groupList = groupList;
    }

    @Generated
    public void setCurrentPageGroupsList(ArrayList<String> currentPageGroupsList) {
        this.currentPageGroupsList = currentPageGroupsList;
    }

    @Generated
    public void setGroupSearchKeyword(String groupSearchKeyword) {
        this.groupSearchKeyword = groupSearchKeyword;
    }

    @Generated
    public void setSelectedPage(Integer selectedPage) {
        this.selectedPage = selectedPage;
    }

    @Generated
    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    @Generated
    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    @Generated
    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    @Generated
    public void setNumberOfRecordsPerPage(Integer numberOfRecordsPerPage) {
        this.numberOfRecordsPerPage = numberOfRecordsPerPage;
    }

    @Generated
    public void setNumberOfPagesList(List<String> numberOfPagesList) {
        this.numberOfPagesList = numberOfPagesList;
    }

    @Generated
    public void setEvaluationLicense(Boolean evaluationLicense) {
        this.evaluationLicense = evaluationLicense;
    }

    @Generated
    public void setAtl_token(String atl_token) {
        this.atl_token = atl_token;
    }

    @Generated
    public void setDataCenter(boolean dataCenter) {
        this.dataCenter = dataCenter;
    }

    @Generated
    public void setOfflineLicenseValid(boolean offlineLicenseValid) {
        this.offlineLicenseValid = offlineLicenseValid;
    }

    @Generated
    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }
}

