/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileUploadFileCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletDiskFileUpload;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.LocalizedMessage;
import org.apache.struts2.dispatcher.multipart.AbstractMultiPartRequest;
import org.apache.struts2.dispatcher.multipart.StrutsUploadedFile;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class JakartaStreamMultiPartRequest
extends AbstractMultiPartRequest {
    private static final Logger LOG = LogManager.getLogger(JakartaStreamMultiPartRequest.class);

    @Override
    protected void processUpload(HttpServletRequest request, String saveDir) throws IOException {
        Charset charset = this.readCharsetEncoding(request);
        Path location = Path.of(saveDir, new String[0]);
        JakartaServletDiskFileUpload servletFileUpload = this.prepareServletFileUpload(charset, location);
        LOG.debug("Using Jakarta Stream API to process request");
        servletFileUpload.getItemIterator(request).forEachRemaining(item -> {
            if (item.isFormField()) {
                LOG.debug(() -> "Processing a form field: " + this.sanitizeNewlines(item.getFieldName()));
                this.processFileItemAsFormField((FileItemInput)item);
            } else {
                LOG.debug(() -> "Processing a file: " + this.sanitizeNewlines(item.getFieldName()));
                this.processFileItemAsFileField((FileItemInput)item, location);
            }
        });
    }

    @Override
    protected JakartaServletDiskFileUpload createJakartaFileUpload(Charset charset, Path location) {
        DiskFileItemFactory.Builder builder = DiskFileItemFactory.builder();
        LOG.debug("Using file save directory: {}", (Object)location);
        builder.setPath(location);
        LOG.debug("Sets buffer size: {}", (Object)this.bufferSize);
        builder.setBufferSize(this.bufferSize);
        LOG.debug("Using charset: {}", (Object)charset);
        builder.setCharset(charset);
        DiskFileItemFactory factory = builder.get();
        return new JakartaServletDiskFileUpload(factory);
    }

    private String readStream(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(StandardCharsets.UTF_8);
    }

    protected void processFileItemAsFormField(FileItemInput fileItemInput) throws IOException {
        List<String> values;
        String fieldValue;
        String fieldName = fileItemInput.getFieldName();
        if (this.exceedsMaxStringLength(fieldName, fieldValue = this.readStream(fileItemInput.getInputStream()))) {
            return;
        }
        if (this.parameters.containsKey(fieldName)) {
            values = (List)this.parameters.get(fieldName);
        } else {
            values = new ArrayList();
            this.parameters.put(fieldName, values);
        }
        values.add(fieldValue);
    }

    protected Long actualSizeOfUploadedFiles() {
        return this.uploadedFiles.values().stream().map(files -> files.stream().map(UploadedFile::length).reduce(0L, Long::sum)).reduce(0L, Long::sum);
    }

    private boolean exceedsMaxFiles(FileItemInput fileItemInput) {
        if (this.maxFiles != null && this.maxFiles == (long)this.uploadedFiles.size()) {
            LocalizedMessage errorMessage;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot accept another file: {} as it will exceed max files: {}", (Object)this.sanitizeNewlines(fileItemInput.getName()), (Object)this.maxFiles);
            }
            if (!this.errors.contains(errorMessage = this.buildErrorMessage(FileUploadFileCountLimitException.class, String.format("File %s exceeds allowed maximum number of files %s", fileItemInput.getName(), this.maxFiles), new Object[]{this.maxFiles, this.uploadedFiles.size()}))) {
                this.errors.add(errorMessage);
            }
            return true;
        }
        return false;
    }

    private void exceedsMaxSizeOfFiles(FileItemInput fileItemInput, File file, Long currentFilesSize) {
        LocalizedMessage errorMessage;
        if (LOG.isDebugEnabled()) {
            LOG.debug("File: {} of size: {} exceeds allowed max size: {}, actual size of already uploaded files: {}", (Object)this.sanitizeNewlines(fileItemInput.getName()), (Object)file.length(), (Object)this.maxSizeOfFiles, (Object)currentFilesSize);
        }
        if (!this.errors.contains(errorMessage = this.buildErrorMessage(FileUploadSizeException.class, String.format("Size %s of file %s exceeds allowed max size %s", file.length(), fileItemInput.getName(), this.maxSizeOfFiles), new Object[]{this.maxSizeOfFiles, currentFilesSize}))) {
            this.errors.add(errorMessage);
        }
        if (!file.delete() && LOG.isWarnEnabled()) {
            LOG.warn("Cannot delete file: {} which exceeds maximum size: {} of all files!", (Object)this.sanitizeNewlines(fileItemInput.getName()), (Object)this.maxSizeOfFiles);
        }
    }

    protected void processFileItemAsFileField(FileItemInput fileItemInput, Path location) throws IOException {
        Long currentFilesSize;
        if (fileItemInput.getName() == null || fileItemInput.getName().trim().isEmpty()) {
            LOG.debug(() -> "No file has been uploaded for the field: " + this.sanitizeNewlines(fileItemInput.getFieldName()));
            return;
        }
        if (this.exceedsMaxFiles(fileItemInput)) {
            return;
        }
        File file = this.createTemporaryFile(fileItemInput.getName(), location);
        this.streamFileToDisk(fileItemInput, file);
        Long l = currentFilesSize = this.maxSizeOfFiles != null ? this.actualSizeOfUploadedFiles() : null;
        if (this.maxSizeOfFiles != null && currentFilesSize + file.length() >= this.maxSizeOfFiles) {
            this.exceedsMaxSizeOfFiles(fileItemInput, file, currentFilesSize);
        } else {
            this.createUploadedFile(fileItemInput, file);
        }
    }

    protected File createTemporaryFile(String fileName, Path location) {
        String uid = UUID.randomUUID().toString().replace("-", "_");
        File file = location.resolve("upload_" + uid + ".tmp").toFile();
        LOG.debug("Creating temporary file: {} (originally: {})", (Object)file.getName(), (Object)fileName);
        return file;
    }

    protected void streamFileToDisk(FileItemInput fileItemInput, File file) throws IOException {
        InputStream input = fileItemInput.getInputStream();
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]), this.bufferSize);){
            int length;
            byte[] buffer = new byte[this.bufferSize];
            LOG.debug("Streaming file: {} using buffer size: {}", (Object)fileItemInput.getName(), (Object)this.bufferSize);
            while ((length = input.read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, length);
            }
        }
    }

    protected void createUploadedFile(FileItemInput fileItemInput, File file) {
        String fileName = fileItemInput.getName();
        String fieldName = fileItemInput.getFieldName();
        UploadedFile uploadedFile = StrutsUploadedFile.Builder.create(file).withOriginalName(fileName).withContentType(fileItemInput.getContentType()).withInputName(fileItemInput.getFieldName()).build();
        if (this.uploadedFiles.containsKey(fieldName)) {
            ((List)this.uploadedFiles.get(fieldName)).add(uploadedFile);
        } else {
            ArrayList<UploadedFile> infos = new ArrayList<UploadedFile>();
            infos.add(uploadedFile);
            this.uploadedFiles.put(fieldName, infos);
        }
    }
}

