/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.utility;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.miniorange.usermanagement.confluence.action.BulkUserManagementAction;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class CrowdDirectoryHelper {
    private static Logger LOGGER = LoggerFactory.getLogger(BulkUserManagementAction.class);
    private CrowdDirectoryService crowdDirectoryService;
    private UserManagementPluginHandler pluginHandler;

    public CrowdDirectoryHelper(CrowdDirectoryService crowdDirectoryService, UserManagementPluginHandler pluginHandler) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.pluginHandler = pluginHandler;
    }

    public void handleCrowdUserOperation(User currentUser, String group, Directory directory, String ip, String action) {
        Map directoryAttribute = directory.getAttributes();
        String applicationName = (String)directoryAttribute.get("application.name");
        String applicationPassword = (String)directoryAttribute.get("application.password");
        String crowdServerUrl = (String)directoryAttribute.get("crowd.server.url");
        String username = currentUser.getName();
        if (action.equals("enableUser") || action.equals("disableUser")) {
            try {
                URL url = new URL(crowdServerUrl + "rest/usermanagement/1/user?username=" + username);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("PUT");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Accept", "application/json");
                String auth = applicationName + ":" + applicationPassword;
                String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
                String authHeaderValue = "Basic " + encodedAuth;
                connection.setRequestProperty("Authorization", authHeaderValue);
                connection.setDoOutput(true);
                Object requestBody = "";
                requestBody = action.equals("disableUser") ? "{\"name\":\"" + username + "\",\"active\":false,\"email\":\"" + currentUser.getEmailAddress() + "\"}" : "{\"name\":\"" + username + "\",\"active\":true,\"email\":\"" + currentUser.getEmailAddress() + "\"}";
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = ((String)requestBody).getBytes("utf-8");
                    os.write(input, 0, input.length);
                }
                String actionName = action.equals("disableUser") ? "User Deactivation" : "User Activation";
                boolean isDisable = action.equals("disableUser");
                switch (connection.getResponseCode()) {
                    case 204: {
                        this.crowdDirectoryService.synchroniseDirectory(directory.getId().longValue());
                        LOGGER.debug("User " + username + " has been successfully " + (isDisable ? "deactivated" : "activated"));
                        this.pluginHandler.storeAuditLogs(username, ip, actionName, "User " + (isDisable ? "Deactivated" : "Activated") + " Successfully.", "successful");
                        break;
                    }
                    case 400: {
                        LOGGER.error("User " + username + " is not " + (isDisable ? "deactivated" : "activated") + " due to invalid data.");
                        this.pluginHandler.storeAuditLogs(username, ip, actionName, "Invalid user data. Usernames mismatch.", "Error");
                        break;
                    }
                    case 403: {
                        LOGGER.error("Application is not allowed to " + (isDisable ? "deactivate" : "activate") + " user: " + username);
                        this.pluginHandler.storeAuditLogs(username, ip, actionName, "Action not permitted by the application.", "Error");
                        break;
                    }
                    case 404: {
                        LOGGER.error("User or group not found while " + (isDisable ? "deactivating" : "activating") + " user: " + username);
                        this.pluginHandler.storeAuditLogs(username, ip, actionName, "User or group could not be found.", "Error");
                        break;
                    }
                    default: {
                        LOGGER.error("Issue while " + (isDisable ? "deactivating" : "activating") + " user: " + connection.getResponseMessage());
                        this.pluginHandler.storeAuditLogs(username, ip, actionName, "Failed to " + (isDisable ? "deactivate" : "activate") + " user.", "Error");
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("MailformedURLException for user : " + username + " is : " + e.getMessage());
            }
        } else if (action.equals("addToGroup") || action.equals("removeFromGroup")) {
            if (action.equals("removeFromGroup")) {
                try {
                    URL url = new URL(crowdServerUrl + "rest/usermanagement/1/user/group/direct?username=" + username + "&groupname=" + group);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("DELETE");
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setRequestProperty("Accept", "application/json");
                    String auth = applicationName + ":" + applicationPassword;
                    String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
                    String authHeaderValue = "Basic " + encodedAuth;
                    connection.setRequestProperty("Authorization", authHeaderValue);
                    connection.setDoOutput(true);
                    switch (connection.getResponseCode()) {
                        case 204: {
                            this.crowdDirectoryService.synchroniseDirectory(directory.getId().longValue());
                            LOGGER.debug("User " + username + " was successfully removed from the group : " + group);
                            this.pluginHandler.storeAuditLogs(username, ip, "Removed from Group", "User successfully removed from group : " + group, "successful");
                            break;
                        }
                        case 403: {
                            LOGGER.error("Application is not allowed to delete the membership for user : " + username);
                            this.pluginHandler.storeAuditLogs(username, ip, "Removed from Group", "Failed to remove group membership from: " + group + ". This action is not permitted by the application.", "Error");
                            break;
                        }
                        case 404: {
                            LOGGER.error("User or group not found while removing user: " + username + " from group: " + group);
                            this.pluginHandler.storeAuditLogs(username, ip, "Removed from Group", "Failed to remove user from group " + group + ". The user or group could not be found.", "Error");
                            break;
                        }
                        default: {
                            LOGGER.debug("Issue while removing group from user : " + connection.getResponseMessage());
                            this.pluginHandler.storeAuditLogs(username, ip, "Removed from Group", "Failed to remove group membership for: " + group, "Error");
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("IOException for user : " + username + " is : " + e.getMessage());
                }
            } else {
                try {
                    String urlString = crowdServerUrl + "rest/usermanagement/1/group/user/direct?groupname=" + group;
                    URL url = new URL(urlString);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                    connection.setRequestProperty("Content-Type", "application/json");
                    String auth = applicationName + ":" + applicationPassword;
                    String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
                    connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
                    String jsonBody = "{\"name\": \"" + username + "\"}";
                    try (OutputStream os = connection.getOutputStream();){
                        byte[] input = jsonBody.getBytes(StandardCharsets.UTF_8);
                        os.write(input, 0, input.length);
                    }
                    int responseCode = connection.getResponseCode();
                    if (responseCode == 201) {
                        this.pluginHandler.storeAuditLogs(username, ip, "Added to Group", "Added User to Groups: " + group, "Success");
                    } else {
                        this.pluginHandler.storeAuditLogs(username, ip, "Added to Group", "Failed to add group membership for: " + group, "Error");
                        LOGGER.debug("Failed to add user. Response Code: " + responseCode);
                    }
                    connection.disconnect();
                }
                catch (Exception e) {
                    LOGGER.debug("exception");
                    e.printStackTrace();
                }
            }
        }
    }
}

