/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.utility;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class ADUserDirectoryHelper {
    private final CrowdDirectoryService directoryService;
    private final CrowdService crowdService;
    private UserManagementPluginHandler pluginHandler;
    private String ldapUrl;
    private String ldapUser;
    private String ldapAdmin;
    private String ldapPassword;
    private String ldapBaseDn;
    private DirContext ctx;
    private static final Logger LOGGER = LoggerFactory.getLogger(ADUserDirectoryHelper.class);

    public ADUserDirectoryHelper(CrowdDirectoryService directoryService, CrowdService crowdService, UserManagementPluginHandler pluginHandler) {
        this.directoryService = directoryService;
        this.crowdService = crowdService;
        this.pluginHandler = pluginHandler;
    }

    private void loadLdapAttributes(User user) {
        Directory directory = this.directoryService.findDirectoryById(user.getDirectoryId());
        Map directoryAttribute = directory.getAttributes();
        this.ldapUrl = (String)directoryAttribute.get("ldap.url");
        this.ldapPassword = (String)directoryAttribute.get("ldap.password");
        this.ldapAdmin = (String)directoryAttribute.get("ldap.userdn");
        this.ldapBaseDn = (String)directoryAttribute.get("ldap.basedn");
    }

    private DirContext createLdapContext(String principal, String credentials) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.credentials", credentials);
        return new InitialDirContext(env);
    }

    public Boolean handleLdapUserOperation(String username, List<String> groupsName, String ip, String action) {
        if (username == null) {
            LOGGER.debug("User is null........");
            return false;
        }
        try {
            String userDn;
            User user = this.crowdService.getUser(username);
            if (user == null) {
                return false;
            }
            this.loadLdapAttributes(user);
            this.ctx = this.getLdapContext();
            String filter = String.format("(userPrincipalName=%s)", this.ldapAdmin);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = this.ctx.search(this.ldapBaseDn, filter, controls);
            if (results.hasMore()) {
                this.ldapUser = results.next().getNameInNamespace();
            }
            if ((userDn = this.getUserDn(this.ctx, username)) == null) {
                return false;
            }
            if (action.contains("enableUser") || action.contains("disableUser")) {
                boolean enable = action.equals("enableUser");
                LOGGER.debug("User status action is performed: {}", (Object)(enable ? "enable" : "disable"));
                return this.setUserStatus(this.ctx, userDn, username, enable, ip);
            }
            if ((action.contains("addToGroup") || action.contains("removeFromGroup")) && groupsName != null && !groupsName.isEmpty()) {
                for (String group : groupsName) {
                    String groupDn = this.getGroupDn(this.ctx, group);
                    if (groupDn == null) continue;
                    if (action.equals("addToGroup")) {
                        this.manageUserGroup(this.ctx, userDn, groupDn, "add", ip);
                        continue;
                    }
                    this.manageUserGroup(this.ctx, userDn, groupDn, "remove", ip);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error: ", (Throwable)e);
        }
        return false;
    }

    public DirContext getLdapContext() throws NamingException {
        if (this.ctx != null) {
            try {
                this.ctx.getAttributes("");
                return this.ctx;
            }
            catch (NamingException e) {
                LOGGER.warn("Existing LDAP context is invalid, creating a new one...");
                this.ctx = null;
            }
        }
        this.ctx = this.createLdapContext(this.ldapAdmin, this.ldapPassword);
        LOGGER.debug("New LDAP connection established.");
        return this.ctx;
    }

    private String getUserDn(DirContext ctx, String username) throws NamingException {
        return this.getDn(ctx, "(sAMAccountName=" + username + ")");
    }

    private String getGroupDn(DirContext ctx, String groupName) throws NamingException {
        return this.getDn(ctx, "(cn=" + groupName + ")");
    }

    private String getDn(DirContext ctx, String filter) throws NamingException {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(this.ldapBaseDn, filter, controls);
        if (results.hasMore()) {
            return results.next().getNameInNamespace();
        }
        return null;
    }

    private void manageUserGroup(DirContext ctx, String userDn, String groupDn, String action, String ip) throws NamingException {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(action.equals("add") ? 1 : 3, new BasicAttribute("member", userDn))};
        String groupName = groupDn.split(",")[0].replace("CN=", "");
        try {
            ctx.modifyAttributes(groupDn, mods);
            LOGGER.info("User {} successfully {} group {}", new Object[]{userDn, action.equals("add") ? "added to" : "removed from", groupDn});
            this.pluginHandler.storeAuditLogs(userDn, ip, action.equals("add") ? "Added to Group" : "Removed from Group", action.equals("add") ? "User successfully added to group: " + groupName : "User successfully removed from group: " + groupName, "Success");
        }
        catch (NamingException e) {
            this.pluginHandler.storeAuditLogs(userDn, ip, action.equals("add") ? "Add to Group" : "Remove from Group", action.equals("add") ? "Failed to add user to group " + groupName + ". Reason: " + e.getMessage() : "Failed to remove user from group " + groupName + ". Reason: " + e.getMessage(), "Error");
        }
    }

    private Boolean setUserStatus(DirContext ctx, String userDn, String username, boolean enable, String ip) throws NamingException {
        int newValue;
        int ACCOUNTDISABLE = 2;
        Attributes attrs = ctx.getAttributes(userDn, new String[]{"userAccountControl"});
        int currentValue = Integer.parseInt(attrs.get("userAccountControl").get().toString());
        int n = newValue = enable ? currentValue & ~ACCOUNTDISABLE : currentValue | ACCOUNTDISABLE;
        if (newValue != currentValue) {
            BasicAttribute attr = new BasicAttribute("userAccountControl", String.valueOf(newValue));
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, attr)};
            ctx.modifyAttributes(userDn, mods);
            LOGGER.debug("User {} successfully {}", (Object)userDn, (Object)(enable ? "enabled" : "disabled"));
            return true;
        }
        LOGGER.debug("User {} already {}", (Object)userDn, (Object)(enable ? "enabled" : "disabled"));
        return false;
    }

    public boolean authenticateRawLdap(String username, String password) {
        if (username == null) {
            return false;
        }
        try {
            User user = this.crowdService.getUser(username);
            if (user == null) {
                return false;
            }
            this.loadLdapAttributes(user);
            DirContext adminContext = this.createLdapContext(this.ldapAdmin, this.ldapPassword);
            String filter = "(&(objectClass=user)(sAMAccountName=" + username + "))";
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(new String[]{"sAMAccountName", "cn"});
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> searchResults = adminContext.search(this.ldapBaseDn, filter, searchControls);
            String distinguishedName = null;
            if (searchResults.hasMore()) {
                SearchResult result = searchResults.next();
                distinguishedName = result.getNameInNamespace();
            } else {
                LOGGER.debug("No user found for user : {}", (Object)username);
            }
            adminContext.close();
            if (distinguishedName == null) {
                return false;
            }
            DirContext ctx = this.createLdapContext(distinguishedName, password);
            ctx.close();
            LOGGER.debug("LDAP authentication success for user {}", (Object)username);
            return true;
        }
        catch (NamingException e) {
            LOGGER.warn("LDAP authentication failed for user {}", (Object)username, (Object)e);
            return false;
        }
    }
}

