/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.scheduler;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.crowd.directory.ssl.LdapHostnameVerificationSSLSocketFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterTask;
import com.miniorange.usermanagement.confluence.utility.ADUserDirectoryHelper;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.CrowdDirectoryHelper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ConfluenceComponent
public class UserDeactivaterScheduler
implements InitializingBean,
DisposableBean {
    private static Logger LOGGER = LoggerFactory.getLogger(UserDeactivaterScheduler.class);
    private LoginManager loginManager;
    private ConfluenceUserManagementUtility UserManagementUtility;
    private UserAccessor userAccessor;
    private ADUserDirectoryHelper directoryHelper;
    private CrowdDirectoryHelper crowdDirectoryHelper;
    private MailServerManager mailServerManager;
    private PermissionManager permissionManager;
    private DirectoryManager directoryManager;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    private UserChecker userChecker;
    public static final String KEY = UserDeactivaterTask.class.getName() + ":instance";
    private static final String JOB_NAME = UserDeactivaterScheduler.class.getName() + ":job";
    private CrowdDirectoryService crowdDirectoryService;
    private CrowdService crowdService;
    private static final JobId JOB_ID = JobId.of((String)UserDeactivaterScheduler.class.getName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)UserDeactivaterScheduler.class.getName());
    @ConfluenceImport
    private final SchedulerService schedulerService;
    @Autowired
    private UserDeactivaterTask deactivaterTask;

    @Autowired
    public UserDeactivaterScheduler(MailServerManager mailServerManager, UserManagementPluginSettings settings, ConfluenceUserManagementUtility userManagementUtility, UserAccessor userAccessor, LoginManager loginManager, PermissionManager permissionManager, UserManagementPluginHandler pluginHandler, DirectoryManager directoryManager, UserChecker userChecker, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SchedulerService schedulerService, ADUserDirectoryHelper directoryHelper, CrowdDirectoryHelper crowdDirectoryHelper) {
        this.settings = settings;
        this.UserManagementUtility = userManagementUtility;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.loginManager = loginManager;
        this.pluginHandler = pluginHandler;
        this.directoryManager = directoryManager;
        this.mailServerManager = mailServerManager;
        this.userChecker = userChecker;
        this.crowdDirectoryService = crowdDirectoryService;
        this.crowdService = crowdService;
        this.schedulerService = schedulerService;
        this.directoryHelper = directoryHelper;
        this.crowdDirectoryHelper = crowdDirectoryHelper;
    }

    public void schedule() {
        LOGGER.info("Scheduleing job");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching IP address: " + e.getMessage());
        }
        String jobName = JOB_NAME;
        long refreshIntervalInMiliseconds = this.settings.getScheduler_days() * 86400000L;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        GregorianCalendar calendarCustom = new GregorianCalendar(year, month, dayOfMonth, (int)this.settings.getCustomSchedulerTimeHour(), (int)this.settings.getCustomSchedulerTimeMinute());
        while (calendarCustom.getTimeInMillis() < cal.getTimeInMillis()) {
            LOGGER.debug("Scheduled time is in the past. Incrementing by configured interval.");
            ((Calendar)calendarCustom).add(5, (int)this.settings.getScheduler_days());
        }
        cal.setTime(new Date());
        cal.add(13, 3);
        SimpleDateFormat formatterScheduler = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        if (this.settings.getPreviousSchedulerDateString() == null) {
            this.settings.setPreviousSchedulerFlag(true);
        }
        this.settings.setNextSchedulerDate(formatterScheduler.format(calendarCustom.getTime()));
        if (confluenceUser != null) {
            this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip != null ? ip.getHostAddress() : "", "Scheduler Enabled", "Enabled Automation Feature Scheduler.", "Success");
        }
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this.deactivaterTask);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)refreshIntervalInMiliseconds, (Date)calendarCustom.getTime()));
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (Exception e) {
            LOGGER.error("Error while scheduling job: " + e.getMessage());
        }
    }

    public void unschedule() {
        LOGGER.info("Unscheduling job");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching IP address: " + e.getMessage());
        }
        if (confluenceUser != null) {
            this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip != null ? ip.getHostAddress() : "", "Scheduler Disabled", "Disabled Automation Feature Scheduler.", "Success");
        }
        try {
            boolean jobDetailsMissing;
            JobDetails jobDetails = this.schedulerService.getJobDetails(JOB_ID);
            boolean bl = jobDetailsMissing = jobDetails == null;
            if (!jobDetailsMissing) {
                boolean isRunnable = jobDetails.isRunnable();
                if (isRunnable) {
                    this.schedulerService.unscheduleJob(JOB_ID);
                } else {
                    LOGGER.info("Scheduler job not runnable or status unknown, no action taken for job: " + String.valueOf(JOB_ID));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error while unscheduling job: " + e.getMessage());
        }
    }

    public List<ConfluenceUser> targetedUser() {
        Calendar targeted = Calendar.getInstance();
        int days = (int)(this.settings.getNumberOfDays() - Long.valueOf(this.settings.getMailPeriod()));
        LOGGER.debug("Target Days : " + days);
        targeted.add(5, -days);
        Date targetDate = targeted.getTime();
        Boolean excludeGroupCheck = this.settings.getEnableExcludeGroups();
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        String usernameSearchKeyword = "";
        List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "ActiveUsers", new ArrayList<String>(), "All");
        List<ConfluenceUser> userWithLastLogin = StreamSupport.stream(usernameList.spliterator(), true).map(currentUser -> this.userAccessor.getUserByName(currentUser.getName())).filter(checkUser -> {
            LoginInfo loginInfo = this.loginManager.getLoginInfo((User)checkUser);
            Date lastLoginDate = loginInfo.getLastSuccessfulLoginDate();
            Boolean presentInExcludedGroup = false;
            List userGroups = this.userAccessor.getGroupNames((User)checkUser);
            LOGGER.debug("excludeGroups : " + String.valueOf(excludeGroups));
            if (excludeGroupCheck.booleanValue()) {
                for (String userGroup : userGroups) {
                    for (String excludeGroup : excludeGroups) {
                        if (!userGroup.equals(excludeGroup)) continue;
                        presentInExcludedGroup = true;
                        break;
                    }
                    if (!presentInExcludedGroup.booleanValue()) continue;
                    LOGGER.debug("user will not deactivated due to present in exclude group : " + checkUser.getName());
                    break;
                }
            }
            if (lastLoginDate != null && !presentInExcludedGroup.booleanValue()) {
                return lastLoginDate.getTime() < targetDate.getTime();
            }
            LOGGER.debug("user is either never login or present in exluded group : " + String.valueOf(checkUser));
            return false;
        }).collect(Collectors.toList());
        return userWithLastLogin;
    }

    public ArrayList<com.atlassian.crowd.embedded.api.User> targetedNeverLoggedInUser() {
        LOGGER.debug("Inside targetedNeverLoggedInUser");
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        long numberOfDays = this.settings.getNumberofDaysAfterUserCreation() * 86400000L;
        long timeInterval = (long)Integer.parseInt(this.settings.getMailPeriodForNeverLoggedInUsers()) * 86400000L;
        long currentDate = new Date().getTime();
        long targetDate = currentDate - (numberOfDays - timeInterval);
        Boolean excludeGroupCheck = this.settings.getEnableExcludeGroups();
        String usernameSearchKeyword = "";
        List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "ActiveUsers", new ArrayList<String>(), "All");
        List userWithNeverLoggedIn = usernameList.parallelStream().filter(checkUser -> {
            ConfluenceUser currentUser = this.userAccessor.getUserByName(checkUser.getName());
            LoginInfo loginInfo = this.loginManager.getLoginInfo((User)this.userAccessor.getUserByName(currentUser.getName()));
            if (loginInfo.getLastSuccessfulLoginDate() == null) {
                Boolean presentInExcludedGroup = false;
                if (excludeGroupCheck.booleanValue()) {
                    List userGroups = this.userAccessor.getGroupNames((User)currentUser);
                    for (String userGroup : userGroups) {
                        for (String excludeGroup : excludeGroups) {
                            if (!userGroup.equals(excludeGroup)) continue;
                            presentInExcludedGroup = true;
                            break;
                        }
                        if (!presentInExcludedGroup.booleanValue()) continue;
                        break;
                    }
                }
                if (!presentInExcludedGroup.booleanValue()) {
                    TimestampedUser user = (TimestampedUser)checkUser;
                    return user.getCreatedDate().getTime() <= targetDate;
                }
            }
            return false;
        }).collect(Collectors.toList());
        return (ArrayList)userWithNeverLoggedIn;
    }

    public void sendMailBeforeDeactivate(List<ConfluenceUser> Users) {
        LOGGER.debug("Send mail before deactivate function called... ");
        long targetedTime = this.settings.getNumberOfDays() * 3600L * 1000L * 24L;
        String mailServer = this.settings.getMailServer();
        long numberOfDays = this.settings.getNumberOfDays();
        String subject = this.settings.getSubText();
        String body = this.settings.getMailText();
        List smtpServers = this.mailServerManager.getSmtpMailServers();
        SMTPMailServer selectedServer = smtpServers.stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (ConfluenceUser user : Users) {
            executor.submit(() -> {
                LoginInfo loginInfo = this.loginManager.getLoginInfo((User)user);
                Date lastLoginDate = loginInfo.getLastSuccessfulLoginDate();
                LOGGER.debug("Last login date for user " + user.getName() + "is : " + String.valueOf(lastLoginDate));
                try {
                    this.sendMailToUser(user, targetedTime, selectedServer, numberOfDays, subject, body, lastLoginDate);
                }
                catch (MailException | MessagingException e) {
                    LOGGER.debug("Error to send mail : " + e.getMessage());
                    throw new RuntimeException(e);
                }
            });
        }
        executor.shutdown();
    }

    public void sendMailToUser(ConfluenceUser user, long targetedTime, SMTPMailServer mailServer, long numberOfDays, String subject, String body, Date lastLoginDate) throws MessagingException, MailException {
        LOGGER.debug("Calling sendOtpOnEmail for user : " + String.valueOf(user));
        SimpleDateFormat sdf1 = new SimpleDateFormat("MMM dd, yyyy");
        body = StringUtils.replace((String)body, (String)"$$username$$", (String)user.getName());
        body = StringUtils.replace((String)body, (String)"$$last_login_date$$", (String)sdf1.format(lastLoginDate));
        Date currentDate = new Date();
        if (currentDate.getTime() - lastLoginDate.getTime() < targetedTime) {
            LOGGER.debug("send user: \" " + String.valueOf(user) + " \" to mail only , not deactivate them");
            long lastLoginDays = (currentDate.getTime() - lastLoginDate.getTime()) / 86400000L;
            body = StringUtils.replace((String)body, (String)"$$days$$", (String)String.valueOf(lastLoginDays));
            body = StringUtils.replace((String)body, (String)"is set to be deactivated", (String)"will be deactivated soon");
        } else if (currentDate.getTime() - lastLoginDate.getTime() >= targetedTime) {
            LOGGER.debug("send user: \" " + user.getName() + " \" to mail as well as deactivate them");
            String days = String.valueOf(numberOfDays);
            body = StringUtils.replace((String)body, (String)"$$days$$", (String)days);
            body = StringUtils.replace((String)body, (String)"will be deactivated soon", (String)"is set to be deactivated");
        }
        if (mailServer != null) {
            this.mailConfig(user.getEmail(), mailServer, subject, body);
        }
    }

    public void mailConfig(String userEmail, SMTPMailServer selectedServer, String subject, String body) throws AddressException, MailException {
        String sender = selectedServer.getDefaultFrom();
        InternetAddress address = new InternetAddress(userEmail);
        String recipient = address.getAddress();
        LOGGER.debug("recipient : " + recipient);
        final String username = selectedServer.getUsername();
        final String password = selectedServer.getPassword();
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", (Object)selectedServer.isTlsRequired());
        props.put("mail.smtp.host", selectedServer.getHostname());
        props.put("mail.smtp.port", selectedServer.getPort());
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(sender));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            message.setSubject(subject);
            message.setContent((Object)body, "text/html");
            Transport.send((Message)message);
            LOGGER.debug("Mail successfully sent.");
        }
        catch (MessagingException e) {
            LOGGER.error("Failed to send mail: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Boolean CheckLastLoginTime() throws ParseException, UnknownHostException {
        long revokeCreationInterval;
        long revokeInterval;
        long addGroupsInterval;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        LOGGER.debug("inside CheckLastLoginTime");
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        ArrayList excludeRevokeGroups = (ArrayList)this.settings.getExcludeRevokeGroupsArray();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat formatterScheduler = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        this.settings.setPrevSchedulerDate(formatterScheduler.format(cal.getTime()));
        this.settings.setPreviousSchedulerFlag(Boolean.FALSE);
        Calendar nextRunCal = Calendar.getInstance();
        nextRunCal.setTime(new Date());
        int year = nextRunCal.get(1);
        int month = nextRunCal.get(2);
        int dayOfMonth = nextRunCal.get(5);
        GregorianCalendar nextRunCalendarCustom = new GregorianCalendar(year, month, dayOfMonth, (int)this.settings.getCustomSchedulerTimeHour(), (int)this.settings.getCustomSchedulerTimeMinute());
        while (nextRunCalendarCustom.getTimeInMillis() < nextRunCal.getTimeInMillis()) {
            ((Calendar)nextRunCalendarCustom).add(5, (int)this.settings.getScheduler_days());
        }
        this.settings.setNextSchedulerDate(formatterScheduler.format(nextRunCalendarCustom.getTime()));
        InetAddress ip = InetAddress.getLocalHost();
        if (this.UserManagementUtility.isEvaluationLicense().booleanValue()) {
            if (!this.UserManagementUtility.isValidEvaluationLicense().booleanValue()) {
                LOGGER.debug("Invalid License ");
                return false;
            }
        } else if (!this.UserManagementUtility.isSubscriptionLicense().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return false;
        }
        if (!(this.settings.getAutoDeActivateUsers().booleanValue() || this.settings.getEnableAutoRemoveFromGroup().booleanValue() || this.settings.getEnableAutoAddGroupToUser().booleanValue())) {
            LOGGER.debug("Automation features are disabled. stopping the scheduler");
            this.unschedule();
            return null;
        }
        String usernameSearchKeyword = "";
        long deactivateInterval = this.settings.getNumberOfDays() * 86400000L;
        long creationInterval = this.settings.getNumberofDaysAfterUserCreation() * 86400000L;
        try {
            Long inactiveDays = this.settings.getGroupDays();
            addGroupsInterval = (inactiveDays != null ? inactiveDays.longValue() : this.settings.getNumberOfDays()) * 86400000L;
        }
        catch (Exception e) {
            LOGGER.debug("getInactiveUsersGroupsDays not available, using NumberOfDays: " + e.getMessage());
            addGroupsInterval = deactivateInterval;
        }
        try {
            Long revokeDays = this.settings.getRevokeDays();
            revokeInterval = (revokeDays != null ? revokeDays.longValue() : this.settings.getNumberOfDays()) * 86400000L;
        }
        catch (Exception e) {
            LOGGER.debug("getRevokeDays not available, using NumberOfDays: " + e.getMessage());
            revokeInterval = deactivateInterval;
        }
        try {
            Long revokeNeverLoggedInDays = this.settings.getRevokeNeverLoggedInDays();
            revokeCreationInterval = (revokeNeverLoggedInDays != null ? revokeNeverLoggedInDays.longValue() : this.settings.getNumberofDaysAfterUserCreation()) * 86400000L;
        }
        catch (Exception e) {
            LOGGER.debug("getRevokeNeverLoggedInDays not available, using NumberofDaysAfterUserCreation: " + e.getMessage());
            revokeCreationInterval = creationInterval;
        }
        List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "AllUsers", new ArrayList<String>(), "All");
        LOGGER.debug("Retrieved users for processing");
        Date date = new Date();
        long timeMilli = date.getTime();
        long lastDayDeactivate = timeMilli - deactivateInterval;
        long lastDayAddGroups = timeMilli - addGroupsInterval;
        long lastDayRevoke = timeMilli - revokeInterval;
        if (this.settings.getEnableLicenseLimitAlert().booleanValue()) {
            if (this.mailServerManager.getSmtpMailServers() != null) {
                int userCount;
                int licenseLimit = Integer.parseInt(this.settings.getUserLicenseLimit());
                String userTier = String.valueOf(this.UserManagementUtility.getLicensedUserTier());
                if (userTier.equals("-1")) {
                    userTier = "Unlimited";
                }
                if (licenseLimit <= (userCount = this.userChecker.getNumberOfRegisteredUsers())) {
                    String subject = this.settings.getLicenseLimitAlertSubject();
                    subject = StringUtils.replace((String)subject, (String)"$$APPLICATION$$", (String)"Confluence");
                    String body = this.settings.getLicenseLimitAlertBody();
                    body = StringUtils.replace((String)body, (String)"$$currentCount$$", (String)String.valueOf(userCount));
                    body = StringUtils.replace((String)body, (String)"$$licenseLimit$$", (String)String.valueOf(licenseLimit));
                    body = StringUtils.replace((String)body, (String)"$$userTier$$", (String)userTier);
                    body = StringUtils.replace((String)body, (String)"$$Administrator$$", (String)"Admin");
                    String mailServer = this.settings.getMailServerForLicenseAlert();
                    SMTPMailServer selectedServer = this.mailServerManager.getSmtpMailServers().stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
                    ArrayList confluenceAdminEmails = (ArrayList)this.settings.getSelectedAdminUserList();
                    for (String adminEmail : confluenceAdminEmails) {
                        try {
                            this.mailConfig(adminEmail, selectedServer, subject, body);
                        }
                        catch (MailException | AddressException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                LOGGER.error("SMTP is not configured");
            }
        }
        for (com.atlassian.crowd.embedded.api.User currentUser : usernameList) {
            try {
                boolean skipAdd;
                boolean isAdmin;
                LOGGER.debug("Processing user: " + currentUser.getName());
                com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(currentUser.getName());
                UserTemplate userTemplate = new UserTemplate(user);
                ConfluenceUser checkUser = this.userAccessor.getUserByName(currentUser.getName());
                if (!userTemplate.isActive()) {
                    LOGGER.debug("User " + currentUser.getName() + " is inactive, skipping");
                    continue;
                }
                boolean bl = isAdmin = this.permissionManager.isSystemAdministrator((User)checkUser) || this.permissionManager.isConfluenceAdministrator((User)checkUser);
                if (isAdmin) {
                    LOGGER.debug("User " + currentUser.getName() + " is admin, skipping");
                    continue;
                }
                LoginInfo loginInfo = this.loginManager.getLoginInfo((User)checkUser);
                if (loginInfo == null) {
                    LOGGER.warn("No login info for user: " + currentUser.getName() + ", skipping");
                    continue;
                }
                TimestampedUser timestampedUser = (TimestampedUser)currentUser;
                long userCreatedTime = timestampedUser.getCreatedDate().getTime();
                ArrayList groupsToRemove = (ArrayList)this.settings.getAutoRemoveGroups();
                ArrayList groupToAdd = (ArrayList)this.settings.getAutoAddGroups();
                cal = Calendar.getInstance();
                Thread currentThread = Thread.currentThread();
                ClassLoader origCCL = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(LdapHostnameVerificationSSLSocketFactory.class.getClassLoader());
                AuthenticatedUserThreadLocal.set((ConfluenceUser)this.getConfluenceAdministrator());
                if (this.settings.getEnableAutoAddGroupToUser().booleanValue() && !(skipAdd = false) && groupToAdd != null && !groupToAdd.isEmpty()) {
                    if (loginInfo.getLastSuccessfulLoginDate() == null) {
                        if (timeMilli - userCreatedTime > creationInterval) {
                            LOGGER.debug("Adding groups to never-logged-in user: " + currentUser.getName());
                            this.manageGroups(currentUser, "add", groupToAdd, ip);
                        }
                    } else {
                        cal.setTime(loginInfo.getLastSuccessfulLoginDate());
                        if (cal.getTimeInMillis() < lastDayAddGroups) {
                            LOGGER.debug("Adding groups to inactive user: " + currentUser.getName());
                            this.manageGroups(currentUser, "add", groupToAdd, ip);
                        }
                    }
                }
                if (this.settings.getEnableAutoRemoveFromGroup().booleanValue()) {
                    boolean skipRevoke = false;
                    if (!skipRevoke && this.settings.getExcludeRevokeGroups().booleanValue() && excludeRevokeGroups != null && !excludeRevokeGroups.isEmpty()) {
                        List userGroups = this.userAccessor.getGroupNames((User)checkUser);
                        for (String userGroup : userGroups) {
                            if (!excludeRevokeGroups.contains(userGroup)) continue;
                            LOGGER.debug("User: " + currentUser.getName() + " is in revoke exclude group: " + userGroup);
                            skipRevoke = true;
                            break;
                        }
                    }
                    if (!skipRevoke && this.settings.getRevokeDirectoryFilter().booleanValue()) {
                        try {
                            if (!this.isUserPresentInRevokeDirectory(currentUser, (List)this.settings.getRevokeDirectoryArray()).booleanValue()) {
                                LOGGER.debug("User " + currentUser.getName() + " not present in revoke directory filter");
                                skipRevoke = true;
                            }
                        }
                        catch (DirectoryNotFoundException e) {
                            LOGGER.error("Revoke directory not found for user: " + currentUser.getName(), (Throwable)e);
                            skipRevoke = true;
                        }
                    }
                    if (!skipRevoke && groupsToRemove != null && !groupsToRemove.isEmpty()) {
                        ArrayList<String> finalGroupsToRemove = new ArrayList<String>();
                        if (this.settings.getExcludeRevokeGroups().booleanValue() && excludeRevokeGroups != null && !excludeRevokeGroups.isEmpty()) {
                            for (String groupToRemove : groupsToRemove) {
                                if (!excludeRevokeGroups.contains(groupToRemove)) {
                                    finalGroupsToRemove.add(groupToRemove);
                                    continue;
                                }
                                LOGGER.debug("Excluded from removal: " + groupToRemove + " for user: " + currentUser.getName());
                            }
                        } else {
                            finalGroupsToRemove.addAll(groupsToRemove);
                        }
                        if (!finalGroupsToRemove.isEmpty()) {
                            if (loginInfo.getLastSuccessfulLoginDate() == null) {
                                if (this.settings.getRevokeNeverLoggedIn().booleanValue() && userCreatedTime <= timeMilli - revokeCreationInterval) {
                                    LOGGER.debug("Removing groups from never-logged-in user: " + currentUser.getName());
                                    this.manageGroups(currentUser, "remove", finalGroupsToRemove, ip);
                                }
                            } else {
                                cal.setTime(loginInfo.getLastSuccessfulLoginDate());
                                if (cal.getTimeInMillis() < lastDayRevoke) {
                                    LOGGER.debug("Removing groups from inactive user: " + currentUser.getName());
                                    this.manageGroups(currentUser, "remove", finalGroupsToRemove, ip);
                                }
                            }
                        }
                    }
                }
                if (!this.settings.getAutoDeActivateUsers().booleanValue()) continue;
                LOGGER.debug("Auto deactivate user is enabled...");
                boolean skipUserDeactivation = false;
                List smtpServers = this.mailServerManager.getSmtpMailServers();
                if (smtpServers != null && !smtpServers.isEmpty()) {
                    List<ConfluenceUser> Users;
                    if (this.settings.getMailNotification().booleanValue()) {
                        Users = this.targetedUser();
                        LOGGER.debug("targeted users : " + String.valueOf(Users));
                        this.sendMailBeforeDeactivate(Users);
                    }
                    if (this.settings.getSendMailToNeverLoggedInUsers().booleanValue() && this.settings.getAutoDeactivateNeverLoggedInUser().booleanValue()) {
                        Users = this.targetedNeverLoggedInUser();
                        this.sendMailToNeverLoggedInUsers((ArrayList<com.atlassian.crowd.embedded.api.User>)Users);
                    }
                } else {
                    LOGGER.debug("smtp mail server is not configured...");
                }
                if (this.settings.getEnableExcludeGroups().booleanValue()) {
                    List userGroups = this.userAccessor.getGroupNames((User)checkUser);
                    for (String userGroup : userGroups) {
                        if (!excludeGroups.contains(userGroup)) continue;
                        LOGGER.debug("User: " + currentUser.getName() + " is in exclude group: " + userGroup + " for deactivation");
                        skipUserDeactivation = true;
                        break;
                    }
                }
                if (!skipUserDeactivation && this.settings.getEnableDirectoryFilter().booleanValue()) {
                    try {
                        if (!this.isUserPresentInDirectory(currentUser, (List)this.settings.getDirectoryFilterList()).booleanValue()) {
                            LOGGER.debug("User " + currentUser.getName() + " not present in directory filter for deactivation");
                            skipUserDeactivation = true;
                        }
                    }
                    catch (DirectoryNotFoundException e) {
                        LOGGER.error("Directory not found for user: " + currentUser.getName(), (Throwable)e);
                        skipUserDeactivation = true;
                    }
                }
                if (skipUserDeactivation) continue;
                if (loginInfo.getLastSuccessfulLoginDate() == null) {
                    if (!this.settings.getAutoDeactivateNeverLoggedInUser().booleanValue() || userCreatedTime > timeMilli - creationInterval) continue;
                    LOGGER.debug("Deactivating never-logged-in user: " + currentUser.getName());
                    this.deactivateUsers(currentUser, ip);
                    this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Deactivate Never Logged-in User using Scheduler.", "Success");
                    continue;
                }
                cal.setTime(loginInfo.getLastSuccessfulLoginDate());
                if (cal.getTimeInMillis() >= lastDayDeactivate) continue;
                LOGGER.debug("Deactivating inactive user: " + currentUser.getName());
                this.deactivateUsers(currentUser, ip);
                this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Deactivate User By Last Login Time using Scheduler.", "Success");
            }
            catch (Exception e) {
                LOGGER.error("Error processing user " + currentUser.getName() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        LOGGER.debug("Completed processing all users");
        return true;
    }

    public void deactivateUsers(com.atlassian.crowd.embedded.api.User currentUser, InetAddress ip) {
        LOGGER.debug("Deactivation action performed for user: " + currentUser.getName());
        Directory directory = this.crowdDirectoryService.findDirectoryById(currentUser.getDirectoryId());
        Set operation = directory.getAllowedOperations();
        if (directory.getType() == DirectoryType.CROWD && !operation.contains(OperationType.UPDATE_USER) && this.settings.getEnableCrowdROUser().booleanValue()) {
            this.crowdDirectoryHelper.handleCrowdUserOperation(currentUser, null, directory, ip.getHostAddress(), "disableUser");
        } else if (directory.getType() == DirectoryType.CONNECTOR && directory.getImplementationClass().contains("MicrosoftActiveDirectory") && !operation.contains(OperationType.UPDATE_USER) && this.settings.getEnableCrowdROUser().booleanValue()) {
            Boolean isUserDisabled = this.directoryHelper.handleLdapUserOperation(currentUser.getName(), new ArrayList<String>(), ip.getHostAddress(), "disableUser");
            this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", isUserDisabled != false ? "Deactivate User using Scheduler." : "Failed to deactivate user from AD read only directory", isUserDisabled != false ? "Success" : "Error");
        } else {
            if (!Objects.equals(this.settings.getUsernameSuffix(), "")) {
                String newUsername = currentUser.getName() + this.settings.getUsernameSuffix();
                boolean isUserAlreadyExists = false;
                try {
                    this.directoryManager.findRemoteUserByName(Long.valueOf(currentUser.getDirectoryId()), newUsername);
                    isUserAlreadyExists = true;
                    LOGGER.debug("Unable to rename user " + currentUser.getName() + " to " + newUsername + " because it already exists.");
                }
                catch (Exception e) {
                    LOGGER.error("Issue while fetching user " + newUsername + ": " + e.getMessage());
                }
                if (!isUserAlreadyExists) {
                    try {
                        this.directoryManager.renameUser(currentUser.getDirectoryId(), currentUser.getName(), newUsername);
                        LOGGER.debug("The username for user " + currentUser.getName() + " has been updated to: " + newUsername);
                        this.pluginHandler.storeAuditLogs(newUsername, ip.getHostAddress(), "Suffix added to username: " + currentUser.getName(), "add suffix to username using Scheduler.", "Success");
                        currentUser = this.directoryManager.findUserByName(currentUser.getDirectoryId(), newUsername);
                    }
                    catch (Exception e) {
                        LOGGER.error("Issue while changing username for user: " + currentUser.getName() + ". Error: " + e.getMessage());
                    }
                }
            }
            UserTemplate user = new UserTemplate(currentUser);
            user.setActive(false);
            try {
                this.directoryManager.updateUser(directory.getId().longValue(), user);
                this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Deactivate User using Scheduler.", "Success");
            }
            catch (Exception e) {
                LOGGER.error("Unable to update user: " + user.getName() + " in directory. Cause : " + String.valueOf(e));
                this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Failed to deactivate user: " + e.getMessage(), "Error");
            }
        }
    }

    public void manageGroups(com.atlassian.crowd.embedded.api.User user, String action, List<String> groups, InetAddress ip) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        if (directory != null) {
            boolean shouldProcess;
            Set operation = directory.getAllowedOperations();
            boolean isCrowdReadOnly = directory.getType() == DirectoryType.CROWD && !operation.contains(OperationType.UPDATE_USER);
            boolean isLdapReadOnly = directory.getType() == DirectoryType.CONNECTOR && directory.getImplementationClass().contains("MicrosoftActiveDirectory") && !operation.contains(OperationType.UPDATE_USER);
            boolean isReadOnly = isCrowdReadOnly || isLdapReadOnly;
            boolean bl = shouldProcess = !isReadOnly || isReadOnly && this.settings.getRevokeCrowdReadOnly() != false;
            if (!shouldProcess) {
                return;
            }
            if ("remove".equals(action)) {
                this.UserManagementUtility.removeGroupFromExternalDirectoryUser(user, true, directory, groups, null, ip.getHostAddress());
            } else if (!isReadOnly && "add".equals(action)) {
                this.UserManagementUtility.addGroupFromExternalDirectoryUser(user, directory, groups, ip.getHostAddress(), true);
            }
        }
    }

    public void sendMailToNeverLoggedInUsers(ArrayList<com.atlassian.crowd.embedded.api.User> neverLoggedInUser) {
        LOGGER.debug("Inside sendMailToNeverLoggedInUsers");
        String subject = this.settings.getMailSubForNeverLoggedInUsers();
        String mailText = this.settings.getMailTextForNeverLoggedInUsers();
        String mailServer = this.settings.getMailServerForNeverLoggedIn();
        String numberOfDays = String.valueOf(this.settings.getNumberofDaysAfterUserCreation());
        List smtpServers = this.mailServerManager.getSmtpMailServers();
        SMTPMailServer selectedServer = smtpServers.stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (com.atlassian.crowd.embedded.api.User user : neverLoggedInUser) {
            AtomicReference<String> body = new AtomicReference<String>(mailText);
            body.set(StringUtils.replace((String)body.get(), (String)"$$days$$", (String)numberOfDays));
            executor.submit(() -> {
                ConfluenceUser currentUser = this.userAccessor.getUserByName(user.getName());
                try {
                    body.set(StringUtils.replace((String)((String)body.get()), (String)"$$username$$", (String)user.getName()));
                    if (selectedServer != null && currentUser != null) {
                        this.mailConfig(currentUser.getEmail(), selectedServer, subject, (String)body.get());
                    }
                }
                catch (MailException | MessagingException e) {
                    LOGGER.debug("Error to send mail : " + e.getMessage());
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public ConfluenceUser getConfluenceAdministrator() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        List confluenceAdministrators = userAccessor.getMemberNamesAsList(userAccessor.getGroup("confluence-administrators"));
        if (confluenceAdministrators != null && !confluenceAdministrators.isEmpty()) {
            for (String user : confluenceAdministrators) {
                ConfluenceUser confluenceAdminUser = userAccessor.getUserByName(user);
                LOGGER.error("Confluence Admin User = " + String.valueOf(confluenceAdminUser));
                UserTemplate userTemplate = new UserTemplate(this.crowdService.getUser(user));
                if (this.permissionManager.isSystemAdministrator((User)confluenceAdminUser) || this.permissionManager.isConfluenceAdministrator((User)confluenceAdminUser) && userTemplate.isActive()) {
                    return confluenceAdminUser;
                }
                LOGGER.debug("Confluence Admin User = " + String.valueOf(confluenceAdminUser) + " does not have system admin permission or user is deactivated, continue with search...");
            }
        }
        return null;
    }

    public Boolean isUserPresentInDirectory(com.atlassian.crowd.embedded.api.User user, List<String> selectedDirectories) throws DirectoryNotFoundException {
        Directory userDirectory = this.directoryManager.findDirectoryById(user.getDirectoryId());
        if (!selectedDirectories.isEmpty()) {
            if (selectedDirectories.contains(userDirectory.getName())) {
                LOGGER.debug("User : " + user.getName() + " is present in selected directory");
                return true;
            }
            LOGGER.debug("User : " + user.getName() + " is not present in selected directory");
            return false;
        }
        return false;
    }

    public Boolean isUserPresentInRevokeDirectory(com.atlassian.crowd.embedded.api.User user, List<String> selectedDirectories) throws DirectoryNotFoundException {
        Directory userDirectory = this.directoryManager.findDirectoryById(user.getDirectoryId());
        if (!selectedDirectories.isEmpty()) {
            if (selectedDirectories.contains(userDirectory.getName())) {
                LOGGER.debug("User : " + user.getName() + " is present in selected revoke directory");
                return true;
            }
            LOGGER.debug("User : " + user.getName() + " is not present in selected revoke directory");
            return false;
        }
        return false;
    }

    public void destroy() throws Exception {
        LOGGER.debug("Destroy process initiated: attempting to unschedule job.");
        try {
            this.unschedule();
        }
        catch (Exception e) {
            LOGGER.debug("No JOB exists. Can't unschedule." + e.getMessage());
        }
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("Initializing properties: checking if auto-scheduling is needed.");
        if (this.settings.getAutoDeActivateUsers().booleanValue() || this.settings.getEnableAutoRemoveFromGroup().booleanValue() || this.settings.getAddGroupsToInactive().booleanValue()) {
            this.schedule();
        }
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.UserManagementUtility;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public ADUserDirectoryHelper getDirectoryHelper() {
        return this.directoryHelper;
    }

    @Generated
    public CrowdDirectoryHelper getCrowdDirectoryHelper() {
        return this.crowdDirectoryHelper;
    }

    @Generated
    public MailServerManager getMailServerManager() {
        return this.mailServerManager;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @Generated
    public UserChecker getUserChecker() {
        return this.userChecker;
    }

    @Generated
    public CrowdDirectoryService getCrowdDirectoryService() {
        return this.crowdDirectoryService;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    @Generated
    public UserDeactivaterTask getDeactivaterTask() {
        return this.deactivaterTask;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Generated
    public void setUserManagementUtility(ConfluenceUserManagementUtility UserManagementUtility) {
        this.UserManagementUtility = UserManagementUtility;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setDirectoryHelper(ADUserDirectoryHelper directoryHelper) {
        this.directoryHelper = directoryHelper;
    }

    @Generated
    public void setCrowdDirectoryHelper(CrowdDirectoryHelper crowdDirectoryHelper) {
        this.crowdDirectoryHelper = crowdDirectoryHelper;
    }

    @Generated
    public void setMailServerManager(MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @Generated
    public void setUserChecker(UserChecker userChecker) {
        this.userChecker = userChecker;
    }

    @Generated
    public void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setDeactivaterTask(UserDeactivaterTask deactivaterTask) {
        this.deactivaterTask = deactivaterTask;
    }
}

