/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.scheduler;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.AuditLogTask;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterTask;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ConfluenceComponent
@Component
public class AuditLogScheduler
implements InitializingBean,
DisposableBean {
    private static Logger LOGGER = LoggerFactory.getLogger(AuditLogScheduler.class);
    private ConfluenceUserManagementUtility UserManagementUtility;
    private UserAccessor userAccessor;
    private PermissionManager permissionManager;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    private LoginManager loginManager;
    @ConfluenceImport
    private SchedulerService schedulerService;
    @Autowired
    private AuditLogTask auditLogTask;
    public static final String KEY = UserDeactivaterTask.class.getName() + ":instance";
    private static final String JOB_NAME = UserDeactivaterScheduler.class.getName() + ":job";
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)AuditLogScheduler.class.getName());
    private static final JobId JOB_ID = JobId.of((String)AuditLogScheduler.class.getName());
    private final PluginScheduler pluginScheduler;

    public AuditLogScheduler(PluginScheduler pluginScheduler, UserManagementPluginSettings settings, ConfluenceUserManagementUtility userManagementUtility, UserAccessor userAccessor, LoginManager loginManager, PermissionManager permissionManager, UserManagementPluginHandler pluginHandler, SchedulerService schedulerService) {
        this.pluginScheduler = pluginScheduler;
        this.settings = settings;
        this.UserManagementUtility = userManagementUtility;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.loginManager = loginManager;
        this.pluginHandler = pluginHandler;
        this.schedulerService = schedulerService;
    }

    public void schedule(Boolean isManualTrigger) throws UnknownHostException {
        LOGGER.info("Scheduling job");
        try {
            long refreshTimeInMilliSeconds = 86400000L;
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(13, 3);
            this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this.auditLogTask);
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)refreshTimeInMilliSeconds, (Date)cal.getTime()));
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
            if (isManualTrigger.booleanValue()) {
                ConfluenceUser confluenceUser = null;
                confluenceUser = AuthenticatedUserThreadLocal.get();
                InetAddress ip = InetAddress.getLocalHost();
                if (confluenceUser != null) {
                    this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip != null ? ip.getHostAddress() : "", "Auto DeleteLogs Scheduler Enabled ", "Auto Delete logs Scheduler enabled.", "Success");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while scheduling job. " + e.getMessage());
        }
    }

    public void unschedule(Boolean isManualTrigger) {
        LOGGER.info("Unscheduling job");
        try {
            boolean jobDetailsMissing;
            JobDetails jobDetails = this.schedulerService.getJobDetails(JOB_ID);
            boolean bl = jobDetailsMissing = jobDetails == null;
            if (!jobDetailsMissing) {
                boolean isRunnable = jobDetails.isRunnable();
                if (isRunnable) {
                    this.schedulerService.unscheduleJob(JOB_ID);
                } else {
                    LOGGER.info("Scheduler job not runnable or status unknown, no action taken for job: " + String.valueOf(JOB_ID));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error while unscheduled job: " + e.getMessage(), (Throwable)e);
        }
        if (isManualTrigger.booleanValue()) {
            try {
                ConfluenceUser confluenceUser = null;
                confluenceUser = AuthenticatedUserThreadLocal.get();
                InetAddress ip = InetAddress.getLocalHost();
                if (confluenceUser != null) {
                    this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip != null ? ip.getHostAddress() : "", "Auto DeleteLogs Scheduler Disabled", "Auto Delete logs Scheduler disabled.", "Success");
                }
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while storing audit logs: " + e.getMessage());
            }
        }
    }

    public Boolean deleteAuditLogs() throws ParseException {
        List<String> logsAfterDeletion = this.pluginHandler.autoDeleteAuditLogs(this.settings.getAuditLogs(), this.settings.getAutoDeleteLogsAfterDays());
        this.settings.setAuditLogs(logsAfterDeletion);
        LOGGER.debug("Successfully deleted logs!");
        return true;
    }

    public void destroy() throws Exception {
        try {
            this.unschedule(false);
        }
        catch (Exception e) {
            LOGGER.debug("No JOB exist. Can't unschedule. : " + e.getMessage());
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.settings.getAutoDeleteAuditLogs().booleanValue()) {
            try {
                this.schedule(false);
            }
            catch (Exception e) {
                LOGGER.error("Error while scheduling job: " + e.getMessage());
            }
        }
    }

    @Generated
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.UserManagementUtility;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    @Generated
    public AuditLogTask getAuditLogTask() {
        return this.auditLogTask;
    }

    @Generated
    public PluginScheduler getPluginScheduler() {
        return this.pluginScheduler;
    }

    @Generated
    public void setUserManagementUtility(ConfluenceUserManagementUtility UserManagementUtility) {
        this.UserManagementUtility = UserManagementUtility;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Generated
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Generated
    public void setAuditLogTask(AuditLogTask auditLogTask) {
        this.auditLogTask = auditLogTask;
    }
}

