/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.common;

import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.google.gson.Gson;
import com.miniorange.usermanagement.confluence.common.CommonAuditLogDetails;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class UserManagementPluginHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(UserManagementPluginHandler.class);
    private UserManagementPluginSettings settings;
    private static WebSudoManager webSudoManager;

    public UserManagementPluginHandler(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    public void saveUserManagementSettings(long days, boolean autodeactivatecheck, boolean neverloggedinusers, long numberOfDaysAfterUserCreation, Boolean enableExcludeGroups, ArrayList<String> excludeGroupsList, Boolean previousSchedulerFlag, Boolean mailNotification, String mailPeriod, String mailSubject, String emailTemplate, String mailServer, String usernameSuffix, Boolean autodeletecheck, Boolean sendMailToNeverLoggedInUsers, String mailServerForNeverLoggedIn, String mailPeriodForNeverLoggedInUsers, String mailSubForNeverLoggedInUsers, String mailTextForNeverLoggedInUsers, Boolean enableDirectoryFilter, ArrayList<String> directoryFilterList, Boolean enableCrowdROUser, Boolean enableLicenseLimitAlert, String userLicenseLimit, ArrayList<String> selectedAdminUserList, String mailServerForLicenseAlert) {
        try {
            this.settings.setNumberOfDays(days);
            LOGGER.debug("daysAfterUserCreation = " + numberOfDaysAfterUserCreation);
            this.settings.setNumberofDaysAfterUserCreation(numberOfDaysAfterUserCreation);
            this.settings.setExcludeGroups(excludeGroupsList);
            this.settings.setEnableExcludeGroups(enableExcludeGroups);
            this.settings.setAutoDeActivateUsers(autodeactivatecheck);
            this.settings.setAutoDeleteUsers(autodeletecheck);
            this.settings.setMailNotification(mailNotification);
            this.settings.setMailServer(mailServer);
            this.settings.setMailPeriod(mailPeriod);
            this.settings.setSubText(mailSubject);
            this.settings.setMailText(emailTemplate);
            this.settings.setAutoDeactivateNeverLoggedInUser(neverloggedinusers);
            this.settings.setPreviousSchedulerFlag(previousSchedulerFlag);
            this.settings.setMailNotification(mailNotification);
            this.settings.setUsernameSuffix(usernameSuffix);
            this.settings.setSendMailToNeverLoggedInUsers(sendMailToNeverLoggedInUsers);
            this.settings.setMailServerForNeverLoggedIn(mailServerForNeverLoggedIn);
            this.settings.setMailPeriodForNeverLoggedInUsers(mailPeriodForNeverLoggedInUsers);
            this.settings.setMailSubForNeverLoggedInUsers(mailSubForNeverLoggedInUsers);
            this.settings.setMailTextForNeverLoggedInUsers(mailTextForNeverLoggedInUsers);
            this.settings.setEnableDirectoryFilter(enableDirectoryFilter);
            this.settings.setDirectoryFilterList(directoryFilterList);
            this.settings.setEnableCrowdROUser(enableCrowdROUser);
            this.settings.setEnableLicenseLimitAlert(enableLicenseLimitAlert);
            this.settings.setUserLicenseLimit(userLicenseLimit);
            this.settings.setSelectedAdminUserList(selectedAdminUserList);
            this.settings.setMailServerForLicenseAlert(mailServerForLicenseAlert);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while scheduling job.", (Throwable)e);
        }
    }

    public void saveRevokeSettings(boolean enableAutoRemoveFromGroup, ArrayList<String> autoRemoveGroupsList, long revokeDays, boolean excludeRevokeGroups, ArrayList<String> excludeRevokeGroupsArray, boolean revokeDirectoryFilter, ArrayList<String> revokeDirectoryArray, boolean revokeNeverLoggedIn, long revokeNeverLoggedInDays, boolean revokeCrowdReadOnly) {
        try {
            this.settings.setEnableAutoRemoveFromGroup(enableAutoRemoveFromGroup);
            this.settings.setAutoRemoveGroups(autoRemoveGroupsList);
            this.settings.setRevokeDays(revokeDays);
            this.settings.setExcludeRevokeGroups(excludeRevokeGroups);
            this.settings.setExcludeRevokeGroupsArray(excludeRevokeGroupsArray);
            this.settings.setRevokeDirectoryFilter(revokeDirectoryFilter);
            this.settings.setRevokeDirectoryArray(revokeDirectoryArray);
            this.settings.setRevokeNeverLoggedIn(revokeNeverLoggedIn);
            this.settings.setRevokeNeverLoggedInDays(revokeNeverLoggedInDays);
            this.settings.setRevokeCrowdReadOnly(revokeCrowdReadOnly);
            LOGGER.debug("Revoke settings saved: enableAutoRemoveFromGroup=" + enableAutoRemoveFromGroup + ", autoRemoveGroupsList=" + String.valueOf(autoRemoveGroupsList) + ", revokeDays=" + revokeDays);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while saving revoke settings.", (Throwable)e);
        }
    }

    public void saveTestingSettings(Boolean enableAutoAddGroupToUser, ArrayList<String> autoAddGroupsList, long groupDays) {
        try {
            this.settings.setEnableAutoAddGroupToUser(enableAutoAddGroupToUser);
            this.settings.setAutoAddGroups(autoAddGroupsList);
            this.settings.setGroupDays(groupDays);
            LOGGER.debug("Testing settings saved: enableAutoAddGroupToUser=" + enableAutoAddGroupToUser + ", autoAddGroupsList=" + String.valueOf(autoAddGroupsList) + ", groupDays=" + groupDays);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while saving testing settings.", (Throwable)e);
        }
    }

    public List<String> autoDeleteAuditLogs(List<String> auditLogsList, Integer daysForAutoDeleteLogs) throws ParseException {
        LOGGER.debug("initiating Auto Delete Audit Logs");
        ArrayList<CommonAuditLogDetails> listOfAuditLogsObjects = new ArrayList<CommonAuditLogDetails>();
        ArrayList<String> updatedListAfterRemoval = new ArrayList<String>();
        Gson gson = new Gson();
        for (int counter = 0; counter < auditLogsList.size(); ++counter) {
            CommonAuditLogDetails backToObject = gson.fromJson(auditLogsList.get(counter), CommonAuditLogDetails.class);
            listOfAuditLogsObjects.add(backToObject);
        }
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        for (int counter = 0; counter < listOfAuditLogsObjects.size(); ++counter) {
            long daysForAutoDeleteLogsInLong = NumberUtils.createInteger((String)daysForAutoDeleteLogs.toString()).intValue();
            long givenDaysInMilliSecs = daysForAutoDeleteLogsInLong * 86400000L;
            long timeInPast = timeMilliSecs - givenDaysInMilliSecs;
            Date dateBeforeInterval = new Date(timeInPast);
            SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
            Date StringToDateForDatabaseEntry = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z").parse(((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getDateAndTime());
            int isLoginAfterInterval = StringToDateForDatabaseEntry.compareTo(dateBeforeInterval);
            if (isLoginAfterInterval < 0) continue;
            updatedListAfterRemoval.add(gson.toJson(listOfAuditLogsObjects.get(counter)));
        }
        return updatedListAfterRemoval;
    }

    public void storeAuditLogs(String username, String ip, String action, String description, String Status2) {
        LOGGER.debug("Storing audit logs for the following records:");
        LOGGER.debug("ip : " + ip + " action : " + action + " desc : " + description + " status : " + Status2 + " trip value : " + Status2.trim());
        try {
            CommonAuditLogDetails commonAuditLogDetails = new CommonAuditLogDetails();
            commonAuditLogDetails.setUsername(username.trim());
            commonAuditLogDetails.setAction(action.trim());
            commonAuditLogDetails.setDescription(description.trim());
            commonAuditLogDetails.setIpAddress(ip.trim());
            commonAuditLogDetails.setStatus(Status2.trim());
            Calendar calendar = Calendar.getInstance();
            long timeMilliSecs = calendar.getTimeInMillis();
            Date newdate = new Date(timeMilliSecs);
            SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z");
            commonAuditLogDetails.setDateAndTime(formatter.format(newdate));
            LOGGER.debug("Audit log for admin : " + String.valueOf(commonAuditLogDetails));
            List<String> updateAuditList = this.settings.getAuditLogs();
            Gson gson = new Gson();
            String jsonString = gson.toJson(commonAuditLogDetails);
            updateAuditList.add(jsonString);
            this.settings.setAuditLogs(updateAuditList);
        }
        catch (Exception e) {
            LOGGER.error("Error : " + String.valueOf(e));
            throw new RuntimeException(e);
        }
    }

    public void enforceWebsudoProtection(HttpServletRequest request, HttpServletResponse response) {
        try {
            webSudoManager.willExecuteWebSudoRequest(request);
        }
        catch (Exception e) {
            LOGGER.debug("Enforcing Websudo Protection");
            try {
                webSudoManager.enforceWebSudoProtection(request, response);
            }
            catch (Exception t2) {
                LOGGER.debug("Error in Enforcing Websudo Protection");
            }
        }
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }
}

