/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.util.fs;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.struts2.util.fs.Revision;

public class FileRevision
extends Revision {
    private final File file;
    private final long lastModified;

    public static Revision build(URL fileUrl) {
        File file;
        try {
            if (fileUrl == null) {
                return null;
            }
            file = new File(fileUrl.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(fileUrl.getPath());
        }
        catch (Throwable t2) {
            return null;
        }
        if (file.exists() && file.canRead()) {
            long lastModified = file.lastModified();
            return new FileRevision(file, lastModified);
        }
        return null;
    }

    private FileRevision(File file, long lastUpdated) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.file = file;
        this.lastModified = lastUpdated;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean needsReloading() {
        return this.lastModified < this.file.lastModified();
    }
}

