/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.ognl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.struts2.ognl.OgnlCache;

public class OgnlCaffeineCache<K, V>
implements OgnlCache<K, V> {
    private final Cache<K, V> cache;

    public OgnlCaffeineCache(int evictionLimit, int initialCapacity) {
        this.cache = Caffeine.newBuilder().initialCapacity(initialCapacity).maximumSize(evictionLimit).build();
    }

    @Override
    public V get(K key) {
        return this.cache.getIfPresent(key);
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public void putIfAbsent(K key, V value) {
        this.cache.asMap().putIfAbsent(key, value);
    }

    @Override
    public int size() {
        return this.cache.asMap().size();
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public int getEvictionLimit() {
        return Math.toIntExact(this.cache.policy().eviction().orElseThrow(IllegalStateException::new).getMaximum());
    }

    @Override
    public void setEvictionLimit(int cacheEvictionLimit) {
        this.cache.policy().eviction().orElseThrow(IllegalStateException::new).setMaximum(cacheEvictionLimit);
    }
}

