/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.conversion.ConversionAnnotationProcessor;
import com.opensymphony.xwork2.conversion.TypeConverter;
import com.opensymphony.xwork2.conversion.TypeConverterCreator;
import com.opensymphony.xwork2.conversion.TypeConverterHolder;
import com.opensymphony.xwork2.conversion.annotations.ConversionRule;
import com.opensymphony.xwork2.conversion.annotations.ConversionType;
import com.opensymphony.xwork2.conversion.annotations.TypeConversion;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Map;

public class DefaultConversionAnnotationProcessor
implements ConversionAnnotationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConversionAnnotationProcessor.class);
    private TypeConverterCreator converterCreator;
    private TypeConverterHolder converterHolder;

    @Inject
    public void setTypeConverterCreator(TypeConverterCreator converterCreator) {
        this.converterCreator = converterCreator;
    }

    @Inject
    public void setTypeConverterHolder(TypeConverterHolder converterHolder) {
        this.converterHolder = converterHolder;
    }

    @Override
    public void process(Map<String, Object> mapping, TypeConversion tc, String key) {
        block16: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("TypeConversion [#0] with key: [#1]", tc.converter(), key);
            }
            if (key == null) {
                return;
            }
            try {
                if (tc.type() == ConversionType.APPLICATION) {
                    this.converterHolder.addDefaultMapping(key, this.converterCreator.createTypeConverter(tc.converter()));
                } else if (tc.rule() == ConversionRule.KEY_PROPERTY || tc.rule() == ConversionRule.CREATE_IF_NULL) {
                    mapping.put(key, tc.value());
                } else if (tc.rule() != ConversionRule.ELEMENT || tc.rule() == ConversionRule.KEY || tc.rule() == ConversionRule.COLLECTION) {
                    mapping.put(key, this.converterCreator.createTypeConverter(tc.converter()));
                } else if (tc.rule() == ConversionRule.KEY) {
                    Class<TypeConverter> converterClass = Thread.currentThread().getContextClassLoader().loadClass(tc.converter());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Converter class: [#0]", converterClass);
                    }
                    if (converterClass.isAssignableFrom(TypeConverter.class)) {
                        mapping.put(key, this.converterCreator.createTypeConverter(tc.converter()));
                    } else {
                        mapping.put(key, converterClass);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Object placed in mapping for key [#0] is [#1]", key, mapping.get(key));
                        }
                    }
                } else {
                    mapping.put(key, Thread.currentThread().getContextClassLoader().loadClass(tc.converter()));
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block16;
                LOG.debug("Got exception for #0", e, key);
            }
        }
    }
}

