/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.servlet;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.user.User;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class AjaxCallsServlet
extends HttpServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(AjaxCallsServlet.class);
    private UserAccessor userAccessor;
    private LoginManager loginManager;
    private ConfluenceUserManagementUtility userManagementUtility;
    private UserManagementPluginSettings settings;
    private CrowdService crowdService;
    private UserManagementPluginHandler userManagementPluginHandler;
    private PermissionManager permissionManager;
    private BootstrapManager bootstrapManager;
    private DirectoryManager directoryManager;

    public AjaxCallsServlet(UserAccessor userAccessor, LoginManager loginManager, UserManagementPluginSettings settings, ConfluenceUserManagementUtility confluenceUserManagement, CrowdService crowdService, UserManagementPluginHandler userManagementPluginHandler, PermissionManager permissionManager, BootstrapManager bootstrapManager, DirectoryManager directoryManager) {
        this.userAccessor = userAccessor;
        this.loginManager = loginManager;
        this.settings = settings;
        this.userManagementUtility = confluenceUserManagement;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.crowdService = crowdService;
        this.permissionManager = permissionManager;
        this.bootstrapManager = bootstrapManager;
        this.directoryManager = directoryManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block39: {
            block38: {
                String action = req.getParameter("action");
                ConfluenceUser confluenceUser = null;
                LOGGER.debug("inside Ajax Call Servlet ");
                if (this.userManagementUtility.getMaxUsers() == 0) {
                    LOGGER.debug("No license found for app. Bulk Delete Users will not work unless app license is applied.");
                    this.userManagementUtility.sendErrorResponse("Error_User_License", 403, resp);
                    return;
                }
                confluenceUser = AuthenticatedUserThreadLocal.get();
                Boolean isAdmin = Boolean.FALSE;
                if (confluenceUser != null) {
                    isAdmin = this.permissionManager.isSystemAdministrator((User)confluenceUser) || this.permissionManager.isConfluenceAdministrator((User)confluenceUser);
                }
                LOGGER.debug("AjaxCallsServlet confluence user = " + confluenceUser.getName() + " has admin permission  = " + isAdmin);
                if (confluenceUser == null || !isAdmin.booleanValue()) break block38;
                switch (action) {
                    case "CheckEvalLicense": {
                        if (this.userManagementUtility.isEvaluationLicense().booleanValue() && this.userManagementUtility.isValidEvaluationLicense().booleanValue()) {
                            LOGGER.error("Evaluation license found for app. Operations will be allowed for only 50 users");
                            this.userManagementUtility.sendErrorResponse("Error_User_eval_License", 403, resp);
                            return;
                        }
                        if (!this.userManagementUtility.isValidEvaluationLicense().booleanValue()) {
                            LOGGER.error("Evaluation license Expired.");
                            this.userManagementUtility.sendErrorResponse("Evaluation_license_Expired", 403, resp);
                            return;
                        }
                        break block39;
                    }
                    case "BulkDeleteSelectedUser": {
                        this.deleteSelectedUsers(req, resp);
                        break;
                    }
                    case "BulkActivateSelectedUser": {
                        this.activateSelectedUsers(req, resp);
                        break;
                    }
                    case "BulkDeactivateSelectedUser": {
                        this.deactivateSelectedUsers(req, resp);
                        break;
                    }
                    case "fetchGroups": {
                        this.fetchGroups(req, resp);
                        break;
                    }
                    case "fetchDirectory": {
                        this.fetchDirectories(req, resp);
                        break;
                    }
                    case "removeUserFromGroups": {
                        String username = req.getParameter("username").trim();
                        String GroupsList = req.getParameter("groupsToRemove").trim();
                        ArrayList<String> groupsToRemove = new ArrayList<String>(Arrays.asList(GroupsList.split(",")));
                        this.userManagementUtility.removeGroupFromExternalDirectoryUser(username, false, groupsToRemove, resp, this.userManagementUtility.getCurrentIpAddress(req));
                        break;
                    }
                    case "assignGroupsToUser": {
                        this.assignGroupsToUser(req, resp);
                        break;
                    }
                    case "ChangeGroupManagementSelectedAction": {
                        this.changeGroupManagementSelectedAction(req, resp);
                        break;
                    }
                    case "ChangeGroupManagementCreationSelectedAction": {
                        this.ChangeGroupManagementCreationSelectedAction(req, resp);
                        break;
                    }
                    case "BulkCreationGroup": {
                        this.BulkCreationGroup(req, resp);
                        break;
                    }
                    case "BulkDeletionGroup": {
                        this.BulkDeletionGroup(req, resp);
                        break;
                    }
                    case "clearAuditLogs": {
                        this.clearAuditLogs(req, resp);
                        break;
                    }
                    case "downloadJiraLogs": {
                        this.downloadConfluenceLogs(req, resp);
                        break;
                    }
                    case "changeSortLastLoginButton": {
                        this.changeSortLastLoginButton(req, resp);
                    }
                    default: {
                        resp.setContentType("application/json");
                        resp.sendError(405, "The requested method is not allowed. Choose valid Method");
                        return;
                    }
                }
                break block39;
            }
            LOGGER.debug("You do not have administrator privilege to perform the Operation. ");
            this.userManagementUtility.sendErrorResponse("Error_Admin_Privilege", 401, resp);
        }
    }

    private void downloadConfluenceLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            File confluenceHomeFolder = this.bootstrapManager.getLocalHome();
            File confluenceLogFolder = null;
            File confluenceLogFile = null;
            for (File f : confluenceHomeFolder.listFiles()) {
                if (!f.isDirectory() || !StringUtils.equals((CharSequence)f.getName(), (CharSequence)"logs")) continue;
                confluenceLogFolder = f;
                break;
            }
            for (File f : confluenceLogFolder.listFiles()) {
                if (!f.isFile() || !StringUtils.equals((CharSequence)f.getName(), (CharSequence)"atlassian-confluence.log")) continue;
                confluenceLogFile = f;
                break;
            }
            resp.setHeader("Content-Disposition", "attachment; filename=\"atlassian-confluence.log\"");
            resp.setHeader("Cache-Control", "max-age=0");
            resp.setHeader("Pragma", "");
            resp.setContentType("text/plain");
            FileUtils.copyFile((File)confluenceLogFile, (OutputStream)resp.getOutputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void changeSortLastLoginButton(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String CreationSelectedAction = req.getParameter("selectedAction");
            this.settings.setSortByLastLogin(BooleanUtils.toBoolean((String)CreationSelectedAction));
        }
        catch (Exception e) {
            LOGGER.error("Error while updating Sort By Last Login " + e.getMessage());
        }
    }

    private void clearAuditLogs(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            ArrayList<String> updateAuditList = new ArrayList<String>();
            this.settings.setAuditLogs(updateAuditList);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void BulkDeletionGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String groupsToDelete = request.getParameter("groupsToDelete");
            ArrayList<String> groupToDeleteList = this.settings.convertSelect2StringToList(groupsToDelete);
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            InetAddress ip = InetAddress.getLocalHost();
            for (String groupsName : groupToDeleteList) {
                if (groupsName.equals("confluence-administrators")) {
                    LOGGER.debug("Cant Delete Group with administrator access : ");
                    this.userManagementPluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Group Deleted", " Can not delete group with administrator access :" + groupsName, "Error Logs");
                    this.userManagementUtility.sendErrorResponse("Error_User_Is_Admin", 405, response);
                    continue;
                }
                Directory internalDir = this.userManagementUtility.getInternalDirectory();
                if (internalDir != null) {
                    LOGGER.debug("Deleting Group :" + groupsName);
                    try {
                        this.directoryManager.removeGroup(internalDir.getId().longValue(), groupsName);
                        this.userManagementPluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Group Deleted", "Deleting group :" + groupsName, "Successful Logs");
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to delete group: " + groupsName + ", due to: " + String.valueOf(e));
                    }
                    continue;
                }
                LOGGER.error("Internal directory not found. Unable to remove the groups.");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void BulkCreationGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String groupsToAdd = request.getParameter("groupsToAdd");
            String[] roleValuesList = StringUtils.split((String)groupsToAdd.trim(), (String)";");
            Object groupsAlreadyExist = "";
            StringBuilder groupsCreated = new StringBuilder("");
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            InetAddress ip = InetAddress.getLocalHost();
            Directory internalDir = this.userManagementUtility.getInternalDirectory();
            if (internalDir != null) {
                for (String groupsName : roleValuesList) {
                    if (groupsName.trim().isEmpty()) continue;
                    if (this.crowdService.getGroup(groupsName.trim()) == null) {
                        LOGGER.debug("Creating new Group with name : " + groupsName);
                        GroupTemplate groupTemplate = new GroupTemplate(groupsName.trim(), internalDir.getId().longValue());
                        try {
                            this.directoryManager.addGroup(internalDir.getId().longValue(), groupTemplate);
                            groupsCreated.append(groupsName).append(",");
                            this.userManagementPluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Group Created", "Creating group :" + groupsName, "Successful Logs");
                        }
                        catch (Exception e) {
                            LOGGER.error("Unable to add group '" + groupTemplate.getName() + "' in directory '" + internalDir.getName() + "'. Cause: " + String.valueOf(e));
                        }
                        continue;
                    }
                    groupsAlreadyExist = (String)groupsAlreadyExist + this.crowdService.getGroup(groupsName.trim()).getName() + ",";
                }
            }
            JSONObject data = new JSONObject();
            data.put("groupsAlreadyExist", groupsAlreadyExist);
            data.put("groupsCreated", (Object)groupsCreated);
            this.userManagementUtility.sendSuccessFullResponse(data.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void ChangeGroupManagementCreationSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String CreationSelectedAction = request.getParameter("CreationSelectedAction");
            this.settings.setCreationSelection(CreationSelectedAction);
            this.userManagementUtility.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    private void changeGroupManagementSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String selectedAction = request.getParameter("selectedAction");
            this.settings.setUserManagementSelectedAction(selectedAction);
            this.userManagementUtility.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    private void assignGroupsToUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String username = request.getParameter("username").trim();
            String GroupsList = request.getParameter("groupsToAdd").trim();
            String ip = this.userManagementUtility.getCurrentIpAddress(request);
            if (!GroupsList.isEmpty()) {
                this.AddUserInGroup(GroupsList, username, ip);
            }
            LOGGER.debug("Added User in Groups Successfully : " + username);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    private void fetchGroups(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String search = StringUtils.trim((String)req.getParameter("search"));
            List<String> groups = this.retrieveGroups(search, 10);
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            for (String groupName : groups) {
                HashMap<String, String> groupResultsMap = new HashMap<String, String>();
                groupResultsMap.put("id", groupName);
                groupResultsMap.put("text", groupName);
                resultArray.put(groupResultsMap);
            }
            data.put("results", (Object)resultArray);
            this.userManagementUtility.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (JSONException | IOException e) {
            LOGGER.error("An error occurred while fetching groups ", e);
        }
    }

    public void fetchDirectories(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String search = StringUtils.trim((String)req.getParameter("search"));
            List directories = this.directoryManager.findAllDirectories();
            List<Directory> filterDirectories = new ArrayList();
            if (!search.isEmpty()) {
                for (Directory directory : directories) {
                    if (!StringUtils.startsWithIgnoreCase((CharSequence)directory.getName(), (CharSequence)search)) continue;
                    filterDirectories.add(directory);
                }
            } else {
                filterDirectories = directories;
            }
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            for (Directory directory : filterDirectories) {
                HashMap<String, String> directoryResultsMap = new HashMap<String, String>();
                directoryResultsMap.put("id", directory.getName());
                directoryResultsMap.put("text", directory.getName());
                resultArray.put(directoryResultsMap);
            }
            data.put("results", (Object)resultArray);
            this.userManagementUtility.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (JSONException | IOException e) {
            LOGGER.error("An error occurred while fetching groups ", e);
        }
    }

    public List<String> retrieveGroups(String groupRegexPattern, int i) {
        String startWith = groupRegexPattern;
        if (StringUtils.equalsIgnoreCase((CharSequence)groupRegexPattern, (CharSequence)"*")) {
            startWith = "";
        }
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)startWith)).returningAtMost(i);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        for (Group groupObject : groups) {
            LOGGER.debug("groups from Confluence Server = " + groupObject.getName());
            existingGroups.add(groupObject.getName().trim());
        }
        return existingGroups;
    }

    private void deleteSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String referer = request.getHeader("referer");
        try {
            String username = request.getParameter("username").trim();
            com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(username);
            boolean isUserInGroup = this.crowdService.isUserMemberOfGroup(user, this.crowdService.getGroup("confluence-administrators"));
            if (!isUserInGroup) {
                try {
                    this.directoryManager.removeUser(user.getDirectoryId(), user.getName());
                    LOGGER.debug(" Remove User Successfully :- " + username);
                    this.userManagementPluginHandler.storeAuditLogs(username, this.userManagementUtility.getCurrentIpAddress(request), "User Deleted", "User Deleted Manualy", "Successful Logs");
                }
                catch (Exception e) {
                    LOGGER.debug("Unable to delete user: " + username + " due to: " + String.valueOf(e));
                }
            } else {
                LOGGER.debug("Cant delete Admin User : " + username);
                this.userManagementUtility.sendErrorResponse("Error_User_Is_Admin", 405, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    private void activateSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String username = request.getParameter("username").trim();
            String GroupsList = request.getParameter("groupsToAdd").trim();
            String ip = this.userManagementUtility.getCurrentIpAddress(request);
            com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(username);
            UserTemplate userTemplate = new UserTemplate(user);
            if (!userTemplate.isActive()) {
                userTemplate.setActive(true);
                try {
                    this.directoryManager.updateUser(user.getDirectoryId(), userTemplate);
                    LOGGER.debug("Activated User Successfully  = " + username);
                    this.userManagementPluginHandler.storeAuditLogs(username, this.userManagementUtility.getCurrentIpAddress(request), "User Activated", "User Activated Manualy", "Successful Logs");
                }
                catch (Exception e) {
                    LOGGER.error("Unable to Activate User: " + userTemplate.getName() + " due to: " + String.valueOf(e));
                }
            }
            if (!GroupsList.isEmpty()) {
                this.AddUserInGroup(GroupsList, username, ip);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.debug("Error in Activating user = " + e.toString());
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    public void AddUserInGroup(String GroupsList, String username, String ip) {
        ArrayList<String> groupsToAdd = new ArrayList<String>(Arrays.asList(GroupsList.split(",")));
        this.userManagementUtility.addGroupFromExternalDirectoryUser(username, groupsToAdd, ip);
    }

    private void deactivateSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            LOGGER.debug("inside deactivateSelectedUser : ");
            String username = request.getParameter("username").trim();
            String GroupsList = request.getParameter("groupsToRemove").trim();
            boolean isAdmin = false;
            ConfluenceUser currentUser = this.userAccessor.getUserByName(username);
            boolean bl = isAdmin = this.permissionManager.isSystemAdministrator((User)currentUser) || this.permissionManager.isConfluenceAdministrator((User)currentUser);
            if (!isAdmin) {
                com.atlassian.crowd.embedded.api.User user;
                UserTemplate userTemplate;
                if (!GroupsList.isEmpty()) {
                    ArrayList<String> groupsToRemove = new ArrayList<String>(Arrays.asList(GroupsList.split(",")));
                    this.userManagementUtility.removeGroupFromExternalDirectoryUser(username, false, groupsToRemove, response, this.userManagementUtility.getCurrentIpAddress(request));
                }
                if ((userTemplate = new UserTemplate(user = this.crowdService.getUser(username))).isActive()) {
                    LOGGER.debug("Deactivated User Successfully  = " + username);
                    userTemplate.setActive(false);
                    try {
                        this.directoryManager.updateUser(user.getDirectoryId(), userTemplate);
                        this.userManagementPluginHandler.storeAuditLogs(username, this.userManagementUtility.getCurrentIpAddress(request), "User Deactivated", "User Deactivated Manualy", "Successful Logs");
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to Deactivate User: " + userTemplate.getName() + " due to: " + String.valueOf(e));
                    }
                } else {
                    LOGGER.debug("User is already inactive : " + username);
                    this.userManagementUtility.sendErrorResponse("Error_User_Is_Inactive", 400, response);
                }
            } else {
                LOGGER.debug("Cant Deactivate Admin User : " + username);
                this.userManagementUtility.sendErrorResponse("Error_User_Is_Admin", 405, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.userManagementUtility;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public UserManagementPluginHandler getUserManagementPluginHandler() {
        return this.userManagementPluginHandler;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public BootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Generated
    public void setUserManagementUtility(ConfluenceUserManagementUtility userManagementUtility) {
        this.userManagementUtility = userManagementUtility;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setUserManagementPluginHandler(UserManagementPluginHandler userManagementPluginHandler) {
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

