/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.web.context.HttpContext;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import java.io.InputStream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DownloadCSVSampleAction
extends ConfluenceActionSupport {
    private static Logger LOGGER = LoggerFactory.getLogger(DownloadCSVSampleAction.class);
    private static final String EXAMPLE_CSV_PATH = "/csvtempate/example_csv.csv";
    private static final String EXAMPLE_CSV_PATH_Group_Management = "/csvtempate/group_example_csv.csv";
    private HttpContext staticHttpContext;
    private UserManagementPluginSettings settings;
    private boolean isDatacenter;
    private boolean isOfflineLicensevalid = false;

    public DownloadCSVSampleAction(HttpContext staticHttpContext) {
        this.staticHttpContext = staticHttpContext;
    }

    public String execute() throws Exception {
        LOGGER.debug("Downloading Sample CSV file.");
        try {
            String exampleCSV;
            String requestUrl = this.getCurrentRequest().getHeader("referer");
            if (requestUrl.contains("group")) {
                exampleCSV = IOUtils.toString((InputStream)UserManagementPluginSettings.class.getResourceAsStream(EXAMPLE_CSV_PATH_Group_Management), (String)"UTF-8");
                this.staticHttpContext.getResponse().setHeader("Content-Disposition", "attachment; filename=\"group_example_csv.csv\"");
            } else {
                exampleCSV = IOUtils.toString((InputStream)UserManagementPluginSettings.class.getResourceAsStream(EXAMPLE_CSV_PATH), (String)"UTF-8");
                this.staticHttpContext.getResponse().setHeader("Content-Disposition", "attachment; filename=\"example_csv.csv.csv\"");
            }
            this.staticHttpContext.getResponse().setHeader("Cache-Control", "max-age=0");
            this.staticHttpContext.getResponse().setHeader("Pragma", "");
            this.staticHttpContext.getResponse().setContentType("application/octet-stream");
            this.staticHttpContext.getResponse().getOutputStream().write(exampleCSV.getBytes());
            return null;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while downloading the csv file.", (Throwable)e);
            return "input";
        }
    }

    @Generated
    public HttpContext getStaticHttpContext() {
        return this.staticHttpContext;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public boolean isDatacenter() {
        return this.isDatacenter;
    }

    @Generated
    public boolean isOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    @Generated
    public void setStaticHttpContext(HttpContext staticHttpContext) {
        this.staticHttpContext = staticHttpContext;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setDatacenter(boolean isDatacenter) {
        this.isDatacenter = isDatacenter;
    }

    @Generated
    public void setOfflineLicensevalid(boolean isOfflineLicensevalid) {
        this.isOfflineLicensevalid = isOfflineLicensevalid;
    }
}

