/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.scheduler;

import com.atlassian.confluence.core.InsufficientPrivilegeException;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.crowd.directory.ssl.LdapHostnameVerificationSSLSocketFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterTask;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ConfluenceComponent
public class UserDeactivaterScheduler
implements InitializingBean,
DisposableBean {
    private static Logger LOGGER = LoggerFactory.getLogger(UserDeactivaterScheduler.class);
    private LoginManager loginManager;
    private ConfluenceUserManagementUtility UserManagementUtility;
    private UserAccessor userAccessor;
    private MailServerManager mailServerManager;
    private PermissionManager permissionManager;
    private DirectoryManager directoryManager;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    private UserChecker userChecker;
    public static final String KEY = UserDeactivaterTask.class.getName() + ":instance";
    private static final String JOB_NAME = UserDeactivaterScheduler.class.getName() + ":job";
    private CrowdDirectoryService crowdDirectoryService;
    private CrowdService crowdService;
    private static final JobId JOB_ID = JobId.of((String)UserDeactivaterScheduler.class.getName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)UserDeactivaterScheduler.class.getName());
    @ConfluenceImport
    private final SchedulerService schedulerService;
    @Autowired
    private UserDeactivaterTask deactivaterTask;

    @Autowired
    public UserDeactivaterScheduler(MailServerManager mailServerManager, UserManagementPluginSettings settings, ConfluenceUserManagementUtility userManagementUtility, UserAccessor userAccessor, LoginManager loginManager, PermissionManager permissionManager, UserManagementPluginHandler pluginHandler, DirectoryManager directoryManager, UserChecker userChecker, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SchedulerService schedulerService) {
        this.settings = settings;
        this.UserManagementUtility = userManagementUtility;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.loginManager = loginManager;
        this.pluginHandler = pluginHandler;
        this.directoryManager = directoryManager;
        this.mailServerManager = mailServerManager;
        this.userChecker = userChecker;
        this.crowdDirectoryService = crowdDirectoryService;
        this.crowdService = crowdService;
        this.schedulerService = schedulerService;
    }

    public void schedule() {
        LOGGER.info("Scheduleing job");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching IP address: " + e.getMessage());
        }
        String jobName = JOB_NAME;
        long refreshIntervalInMiliseconds = this.settings.getScheduler_days() * 86400000L;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        GregorianCalendar calendarCustom = new GregorianCalendar(year, month, dayOfMonth, (int)this.settings.getCustomSchedulerTimeHour(), (int)this.settings.getCustomSchedulerTimeMinute());
        while (calendarCustom.getTimeInMillis() < cal.getTimeInMillis()) {
            LOGGER.debug("Scheduled time is in the past. Incrementing by configured interval.");
            ((Calendar)calendarCustom).add(5, (int)this.settings.getScheduler_days());
        }
        cal.setTime(new Date());
        cal.add(13, 3);
        SimpleDateFormat formatterScheduler = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        this.settings.setNextSchedulerDate(formatterScheduler.format(calendarCustom.getTime()));
        if (confluenceUser != null) {
            this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip != null ? ip.getHostAddress() : "", "Scheduler Enabled", "Enable Auto Deactivate User Scheduler.", "Successful Logs");
        }
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this.deactivaterTask);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)refreshIntervalInMiliseconds, (Date)calendarCustom.getTime()));
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (Exception e) {
            LOGGER.error("Error while scheduling job: " + e.getMessage());
        }
    }

    public void unschedule() {
        LOGGER.info("Unscheduling job");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching IP address: " + e.getMessage());
        }
        if (confluenceUser != null) {
            this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip != null ? ip.getHostAddress() : "", "Scheduler Disabled", "Disable Auto Deactivate User Scheduler.", "Successful Logs");
        }
        try {
            boolean jobDetailsMissing;
            JobDetails jobDetails = this.schedulerService.getJobDetails(JOB_ID);
            boolean bl = jobDetailsMissing = jobDetails == null;
            if (!jobDetailsMissing) {
                boolean isRunnable = jobDetails.isRunnable();
                if (isRunnable) {
                    this.schedulerService.unscheduleJob(JOB_ID);
                } else {
                    LOGGER.info("Scheduler job not runnable or status unknown, no action taken for job: " + String.valueOf(JOB_ID));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error while unscheduling job: " + e.getMessage());
        }
    }

    public List<ConfluenceUser> targetedUser() {
        Calendar targeted = Calendar.getInstance();
        int days = (int)(this.settings.getNumberOfDays() - Long.valueOf(this.settings.getMailPeriod()));
        LOGGER.debug("Target Days : " + days);
        targeted.add(5, -days);
        Date targetDate = targeted.getTime();
        Boolean excludeGroupCheck = this.settings.getEnableExcludeGroups();
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        String usernameSearchKeyword = "";
        List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "ActiveUsers", new ArrayList<String>(), "All");
        List<ConfluenceUser> userWithLastLogin = StreamSupport.stream(usernameList.spliterator(), true).map(currentUser -> this.userAccessor.getUserByName(currentUser.getName())).filter(checkUser -> {
            LoginInfo loginInfo = this.loginManager.getLoginInfo((User)checkUser);
            Date lastLoginDate = loginInfo.getLastSuccessfulLoginDate();
            Boolean presentInExcludedGroup = false;
            List userGroups = this.userAccessor.getGroupNames((User)checkUser);
            LOGGER.debug("excludeGroups : " + String.valueOf(excludeGroups));
            if (excludeGroupCheck.booleanValue()) {
                for (String userGroup : userGroups) {
                    for (String excludeGroup : excludeGroups) {
                        if (!userGroup.equals(excludeGroup)) continue;
                        presentInExcludedGroup = true;
                        break;
                    }
                    if (!presentInExcludedGroup.booleanValue()) continue;
                    LOGGER.debug("user will not deactivated due to present in exclude group : " + checkUser.getName());
                    break;
                }
            }
            if (lastLoginDate != null && !presentInExcludedGroup.booleanValue()) {
                return lastLoginDate.getTime() < targetDate.getTime();
            }
            LOGGER.debug("user is either never login or present in exluded group : " + String.valueOf(checkUser));
            return false;
        }).collect(Collectors.toList());
        return userWithLastLogin;
    }

    public ArrayList<com.atlassian.crowd.embedded.api.User> targetedNeverLoggedInUser() {
        LOGGER.debug("Inside targetedNeverLoggedInUser");
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        long numberOfDays = this.settings.getNumberofDaysAfterUserCreation() * 86400000L;
        long timeInterval = (long)Integer.parseInt(this.settings.getMailPeriodForNeverLoggedInUsers()) * 86400000L;
        long currentDate = new Date().getTime();
        long targetDate = currentDate - (numberOfDays - timeInterval);
        Boolean excludeGroupCheck = this.settings.getEnableExcludeGroups();
        String usernameSearchKeyword = "";
        List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "ActiveUsers", new ArrayList<String>(), "All");
        List userWithNeverLoggedIn = usernameList.parallelStream().filter(checkUser -> {
            ConfluenceUser currentUser = this.userAccessor.getUserByName(checkUser.getName());
            LoginInfo loginInfo = this.loginManager.getLoginInfo((User)this.userAccessor.getUserByName(currentUser.getName()));
            if (loginInfo.getLastSuccessfulLoginDate() == null) {
                Boolean presentInExcludedGroup = false;
                if (excludeGroupCheck.booleanValue()) {
                    List userGroups = this.userAccessor.getGroupNames((User)currentUser);
                    for (String userGroup : userGroups) {
                        for (String excludeGroup : excludeGroups) {
                            if (!userGroup.equals(excludeGroup)) continue;
                            presentInExcludedGroup = true;
                            break;
                        }
                        if (!presentInExcludedGroup.booleanValue()) continue;
                        break;
                    }
                }
                if (!presentInExcludedGroup.booleanValue()) {
                    TimestampedUser user = (TimestampedUser)checkUser;
                    return user.getCreatedDate().getTime() <= targetDate;
                }
            }
            return false;
        }).collect(Collectors.toList());
        return (ArrayList)userWithNeverLoggedIn;
    }

    public void sendMailBeforeDeactivate(List<ConfluenceUser> Users) {
        LOGGER.debug("Send mail before deactivate function called... ");
        long targetedTime = this.settings.getNumberOfDays() * 3600L * 1000L * 24L;
        String mailServer = this.settings.getMailServer();
        long numberOfDays = this.settings.getNumberOfDays();
        String subject = this.settings.getSubText();
        String body = this.settings.getMailText();
        List smtpServers = this.mailServerManager.getSmtpMailServers();
        SMTPMailServer selectedServer = smtpServers.stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (ConfluenceUser user : Users) {
            executor.submit(() -> {
                LoginInfo loginInfo = this.loginManager.getLoginInfo((User)user);
                Date lastLoginDate = loginInfo.getLastSuccessfulLoginDate();
                LOGGER.debug("Last login date for user " + user.getName() + "is : " + String.valueOf(lastLoginDate));
                try {
                    this.sendMailToUser(user, targetedTime, selectedServer, numberOfDays, subject, body, lastLoginDate);
                }
                catch (MailException | MessagingException e) {
                    LOGGER.debug("Error to send mail : " + e.getMessage());
                    throw new RuntimeException(e);
                }
            });
        }
        executor.shutdown();
    }

    public void sendMailToUser(ConfluenceUser user, long targetedTime, SMTPMailServer mailServer, long numberOfDays, String subject, String body, Date lastLoginDate) throws MessagingException, MailException {
        LOGGER.debug("Calling sendOtpOnEmail for user : " + String.valueOf(user));
        SimpleDateFormat sdf1 = new SimpleDateFormat("MMM dd, yyyy");
        body = StringUtils.replace((String)body, (String)"$$username$$", (String)user.getName());
        body = StringUtils.replace((String)body, (String)"$$last_login_date$$", (String)sdf1.format(lastLoginDate));
        Date currentDate = new Date();
        if (currentDate.getTime() - lastLoginDate.getTime() < targetedTime) {
            LOGGER.debug("send user: \" " + String.valueOf(user) + " \" to mail only , not deactivate them");
            long lastLoginDays = (currentDate.getTime() - lastLoginDate.getTime()) / 86400000L;
            body = StringUtils.replace((String)body, (String)"$$days$$", (String)String.valueOf(lastLoginDays));
            body = StringUtils.replace((String)body, (String)"is set to be deactivated", (String)"will be deactivated soon");
        } else if (currentDate.getTime() - lastLoginDate.getTime() >= targetedTime) {
            LOGGER.debug("send user: \" " + user.getName() + " \" to mail as well as deactivate them");
            String days = String.valueOf(numberOfDays);
            body = StringUtils.replace((String)body, (String)"$$days$$", (String)days);
            body = StringUtils.replace((String)body, (String)"will be deactivated soon", (String)"is set to be deactivated");
        }
        if (mailServer != null) {
            this.mailConfig(user.getEmail(), mailServer, subject, body);
        }
    }

    public void mailConfig(String userEmail, SMTPMailServer selectedServer, String subject, String body) throws AddressException, MailException {
        String sender = selectedServer.getDefaultFrom();
        InternetAddress address = new InternetAddress(userEmail);
        String recipient = address.getAddress();
        LOGGER.debug("recipient : " + recipient);
        final String username = selectedServer.getUsername();
        final String password = selectedServer.getPassword();
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", (Object)selectedServer.isTlsRequired());
        props.put("mail.smtp.host", selectedServer.getHostname());
        props.put("mail.smtp.port", selectedServer.getPort());
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(sender));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            message.setSubject(subject);
            message.setContent((Object)body, "text/html");
            Transport.send((Message)message);
            LOGGER.debug("Mail successfully sent.");
        }
        catch (MessagingException e) {
            LOGGER.error("Failed to send mail: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Boolean CheckLastLoginTime() throws ParseException, UnknownHostException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        LOGGER.debug("inside CheckLastLoginTime");
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat formatterScheduler = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        this.settings.setPrevSchedulerDate(formatterScheduler.format(cal.getTime()));
        this.settings.setPreviousSchedulerFlag(Boolean.FALSE);
        cal.setTime(this.settings.getPrevSchedulerDate());
        cal.add(5, (int)this.settings.getScheduler_days());
        this.settings.setNextSchedulerDate(formatterScheduler.format(cal.getTime()));
        InetAddress ip = InetAddress.getLocalHost();
        if (this.UserManagementUtility.isEvaluationLicense().booleanValue()) {
            if (!this.UserManagementUtility.isValidEvaluationLicense().booleanValue()) {
                LOGGER.debug("Invalid License ");
                return false;
            }
        } else if (!this.UserManagementUtility.isSubscriptionLicense().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return false;
        }
        if (this.settings.getAutoDeActivateUsers().booleanValue() || this.settings.getEnableAutoRemoveFromGroup().booleanValue() || this.settings.getEnableAutoAddGroupToUser().booleanValue()) {
            this.pluginHandler.storeAuditLogs("miniOrange Scheduler", ip.getHostAddress(), "Scheduler Start", "Scheduler initiated for automatically deactivating users or revoking application access.", "Successful Logs");
            if (this.settings.getAutoDeActivateUsers().booleanValue()) {
                LOGGER.debug("auto deactivate user is enable...");
                List smtpServers = this.mailServerManager.getSmtpMailServers();
                if (smtpServers != null && !smtpServers.isEmpty()) {
                    List<ConfluenceUser> Users;
                    if (this.settings.getMailNotification().booleanValue()) {
                        Users = this.targetedUser();
                        LOGGER.debug("targeted users : " + String.valueOf(Users));
                        this.sendMailBeforeDeactivate(Users);
                    }
                    if (this.settings.getSendMailToNeverLoggedInUsers().booleanValue() && this.settings.getAutoDeactivateNeverLoggedInUser().booleanValue()) {
                        Users = this.targetedNeverLoggedInUser();
                        this.sendMailToNeverLoggedInUsers((ArrayList<com.atlassian.crowd.embedded.api.User>)Users);
                    }
                } else {
                    LOGGER.debug("smtp mail server is not configured...");
                }
            }
            String usernameSearchKeyword = "";
            long interval = this.settings.getNumberOfDays() * 86400000L;
            long creationInterval = this.settings.getNumberofDaysAfterUserCreation() * 86400000L;
            List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "AllUsers", new ArrayList<String>(), "All");
            if (this.settings.getEnableLicenseLimitAlert().booleanValue()) {
                if (this.mailServerManager.getSmtpMailServers() != null) {
                    int userCount;
                    int licenseLimit = Integer.parseInt(this.settings.getUserLicenseLimit());
                    String userTier = String.valueOf(this.UserManagementUtility.getLicensedUserTier());
                    if (userTier.equals("-1")) {
                        userTier = "Unlimited";
                    }
                    if (licenseLimit <= (userCount = this.userChecker.getNumberOfRegisteredUsers())) {
                        String subject = this.settings.getLicenseLimitAlertSubject();
                        subject = StringUtils.replace((String)subject, (String)"$$APPLICATION$$", (String)"Confluence");
                        String body = this.settings.getLicenseLimitAlertBody();
                        body = StringUtils.replace((String)body, (String)"$$currentCount$$", (String)String.valueOf(userCount));
                        body = StringUtils.replace((String)body, (String)"$$licenseLimit$$", (String)String.valueOf(licenseLimit));
                        body = StringUtils.replace((String)body, (String)"$$userTier$$", (String)userTier);
                        body = StringUtils.replace((String)body, (String)"$$Administrator$$", (String)"Admin");
                        String mailServer = this.settings.getMailServerForLicenseAlert();
                        SMTPMailServer selectedServer = this.mailServerManager.getSmtpMailServers().stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
                        ArrayList confluenceAdminEmails = (ArrayList)this.settings.getSelectedAdminUserList();
                        for (String adminEmail : confluenceAdminEmails) {
                            try {
                                this.mailConfig(adminEmail, selectedServer, subject, body);
                            }
                            catch (MailException | AddressException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else {
                    LOGGER.error("SMTP is not configured");
                }
            }
            Date date = new Date();
            long timeMilli = date.getTime();
            long Lastday = timeMilli - interval;
            for (com.atlassian.crowd.embedded.api.User currentUser : usernameList) {
                long lastDay;
                TimestampedUser User2;
                long userCreatedTime;
                LOGGER.debug("Checking User  :- " + currentUser.getName());
                com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(currentUser.getName());
                UserTemplate userTemplate = new UserTemplate(user);
                ConfluenceUser checkUser = this.userAccessor.getUserByName(currentUser.getName());
                boolean isAdmin = this.permissionManager.isSystemAdministrator((User)checkUser) || this.permissionManager.isConfluenceAdministrator((User)checkUser);
                if (isAdmin || !userTemplate.isActive()) continue;
                LoginInfo loginInfo = this.loginManager.getLoginInfo((User)checkUser);
                Boolean skipUserDeactivation = false;
                if (this.settings.getEnableExcludeGroups().booleanValue()) {
                    List userGroups = this.userAccessor.getGroupNames((User)checkUser);
                    for (String userGroup : userGroups) {
                        for (String excludeGroup : excludeGroups) {
                            LOGGER.debug("userGroup = " + userGroup);
                            LOGGER.debug("excludeGroup = " + excludeGroup);
                            if (!userGroup.equals(excludeGroup)) continue;
                            skipUserDeactivation = true;
                            break;
                        }
                        if (!skipUserDeactivation.booleanValue()) continue;
                        break;
                    }
                }
                try {
                    if (this.settings.getEnableDirectoryFilter().booleanValue() && !this.isUserPresentInDirectory(currentUser, (List)this.settings.getDirectoryFilterList()).booleanValue()) {
                        LOGGER.debug("User " + currentUser.getName() + " not present in selected directory filter : " + String.valueOf((List)this.settings.getDirectoryFilterList()));
                        continue;
                    }
                }
                catch (DirectoryNotFoundException e) {
                    throw new RuntimeException(e);
                }
                cal = Calendar.getInstance();
                Thread currentThread = Thread.currentThread();
                ClassLoader origCCL = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(LdapHostnameVerificationSSLSocketFactory.class.getClassLoader());
                AuthenticatedUserThreadLocal.set((ConfluenceUser)this.getConfluenceAdministrator());
                ArrayList groupsToRemove = (ArrayList)this.settings.getAutoRemoveGroups();
                ArrayList groupToAdd = (ArrayList)this.settings.getAutoAddGroups();
                if (loginInfo.getLastSuccessfulLoginDate() != null) {
                    cal.setTime(loginInfo.getLastSuccessfulLoginDate());
                    long lastlogintime = cal.getTimeInMillis();
                    if (lastlogintime >= Lastday || skipUserDeactivation.booleanValue()) continue;
                    try {
                        if (this.settings.getEnableAutoAddGroupToUser().booleanValue()) {
                            this.UserManagementUtility.addGroupFromExternalDirectoryUser(currentUser.getName(), groupToAdd, ip.getHostAddress());
                        }
                        if (this.settings.getEnableAutoRemoveFromGroup().booleanValue()) {
                            this.UserManagementUtility.removeGroupFromExternalDirectoryUser(currentUser.getName(), true, groupsToRemove, null, ip.getHostAddress());
                        }
                        if (!this.settings.getAutoDeActivateUsers().booleanValue()) continue;
                        this.deactivateUsers(currentUser, ip);
                        this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Deactivate User By Last Login Time using Scheduler.", "Successful Logs");
                    }
                    catch (InsufficientPrivilegeException t2) {
                        LOGGER.debug("Error InsufficientPrivilegeException = " + t2.toString());
                    }
                    catch (Throwable t3) {
                        LOGGER.debug("Error in task else " + t3.getMessage());
                    }
                    continue;
                }
                if (!this.settings.getAutoDeactivateNeverLoggedInUser().booleanValue() || loginInfo.getLastSuccessfulLoginDate() != null || skipUserDeactivation.booleanValue() || (userCreatedTime = (User2 = (TimestampedUser)currentUser).getCreatedDate().getTime()) > (lastDay = timeMilli - this.settings.getNumberofDaysAfterUserCreation() * 86400000L)) continue;
                try {
                    if (this.settings.getEnableAutoAddGroupToUser().booleanValue()) {
                        this.UserManagementUtility.addGroupFromExternalDirectoryUser(currentUser.getName(), groupToAdd, ip.getHostAddress());
                    }
                    if (this.settings.getEnableAutoRemoveFromGroup().booleanValue()) {
                        this.UserManagementUtility.removeGroupFromExternalDirectoryUser(currentUser.getName(), true, groupsToRemove, null, ip.getHostAddress());
                    }
                    if (!this.settings.getAutoDeActivateUsers().booleanValue()) continue;
                    this.deactivateUsers(currentUser, ip);
                    this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Deactivate Never Logged-in User using Scheduler.", "Successful Logs");
                }
                catch (InsufficientPrivilegeException t4) {
                    LOGGER.debug("Error InsufficientPrivilegeException = " + t4.toString());
                }
                catch (Throwable t5) {
                    LOGGER.debug("Error in task else " + t5.getMessage());
                }
            }
        } else {
            LOGGER.debug("Disable auto Deactivate users");
            return false;
        }
        this.pluginHandler.storeAuditLogs("miniOrange Scheduler", ip.getHostAddress(), "Scheduler End", "Scheduler completed for auto-deactivation of users or revocation of application access.", "Successful Logs");
        return true;
    }

    public void deactivateUsers(com.atlassian.crowd.embedded.api.User currentUser, InetAddress ip) {
        LOGGER.debug("Deactivation action performed for user: " + currentUser.getName());
        Directory directory = this.crowdDirectoryService.findDirectoryById(currentUser.getDirectoryId());
        Set operation = directory.getAllowedOperations();
        if (directory.getType() == DirectoryType.CROWD && !operation.contains(OperationType.UPDATE_USER)) {
            LOGGER.debug("User is from crowd read only directory which have permission to update user : " + currentUser.getName());
            if (this.settings.getEnableCrowdROUser().booleanValue()) {
                Map directoryAttribute = directory.getAttributes();
                String applicationName = (String)directoryAttribute.get("application.name");
                String applicationPassword = (String)directoryAttribute.get("application.password");
                String crowdServerUrl = (String)directoryAttribute.get("crowd.server.url");
                try {
                    LOGGER.debug("User : " + currentUser.getName() + " is allowed for deactivate from crowd read only directory");
                    URL url = new URL(crowdServerUrl + "rest/usermanagement/1/user?username=" + currentUser.getName());
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("PUT");
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setRequestProperty("Accept", "application/json");
                    String auth = applicationName + ":" + applicationPassword;
                    String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
                    String authHeaderValue = "Basic " + encodedAuth;
                    connection.setRequestProperty("Authorization", authHeaderValue);
                    connection.setDoOutput(true);
                    String requestBody = "{\"name\":\"" + currentUser.getName() + "\",\"active\":false,\"email\":\"" + currentUser.getEmailAddress() + "\"}";
                    try (OutputStream os = connection.getOutputStream();){
                        byte[] input = requestBody.getBytes("utf-8");
                        os.write(input, 0, input.length);
                    }
                    LOGGER.debug("Response code for user : " + currentUser.getName() + " is : " + connection.getResponseCode());
                    switch (connection.getResponseCode()) {
                        case 204: {
                            this.crowdDirectoryService.synchroniseDirectory(directory.getId().longValue());
                            LOGGER.debug("User " + currentUser.getName() + " has been successfully deactivated");
                            this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivation", "User Deactivated Successfully.", "successful");
                            break;
                        }
                        case 400: {
                            LOGGER.error("User " + currentUser.getName() + " is not deactivated due to invalid data.");
                            this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivation", "Invalid user data. For instance, the usernames provided in the body do not match the URI.", "Error");
                            break;
                        }
                        case 403: {
                            LOGGER.error("Application is not allowed to deactivate user : " + currentUser.getName());
                            this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivation", "Failed to deactivate user. This action is not permitted by the application", "Error");
                            break;
                        }
                        case 404: {
                            LOGGER.error("User or group not found while deactivating user: " + currentUser.getName());
                            this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivation", "Failed to deactivate user. The user or group could not be found.", "Error");
                            break;
                        }
                        default: {
                            LOGGER.error("Issue while deactivating user : " + connection.getResponseMessage());
                            this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivation", "Failed to deactivate user.", "Error");
                            break;
                        }
                    }
                }
                catch (MalformedURLException e) {
                    LOGGER.error("MailformedURLException for user : " + currentUser.getName() + " is : " + e.getMessage());
                }
                catch (ProtocolException e) {
                    LOGGER.error("ProtocolException for user : " + currentUser.getName() + " is : " + e.getMessage());
                }
                catch (IOException e) {
                    LOGGER.error("IOException for user : " + currentUser.getName() + " is : " + e.getMessage());
                }
            }
        } else {
            if (!Objects.equals(this.settings.getUsernameSuffix(), "")) {
                String newUsername = currentUser.getName() + this.settings.getUsernameSuffix();
                boolean isUserAlreadyExists = false;
                try {
                    this.directoryManager.findRemoteUserByName(Long.valueOf(currentUser.getDirectoryId()), newUsername);
                    isUserAlreadyExists = true;
                    LOGGER.debug("Unable to rename user " + currentUser.getName() + " to " + newUsername + " because it already exists.");
                }
                catch (Exception e) {
                    LOGGER.error("Issue while fetching user " + newUsername + ": " + e.getMessage());
                }
                if (!isUserAlreadyExists) {
                    try {
                        this.directoryManager.renameUser(currentUser.getDirectoryId(), currentUser.getName(), newUsername);
                        LOGGER.debug("The username for user " + currentUser.getName() + " has been updated to: " + newUsername);
                        this.pluginHandler.storeAuditLogs(newUsername, ip.getHostAddress(), "Suffix added to username: " + currentUser.getName(), "add suffix to username using Scheduler.", "Successful Logs");
                        currentUser = this.directoryManager.findUserByName(currentUser.getDirectoryId(), newUsername);
                    }
                    catch (Exception e) {
                        LOGGER.error("Issue while changing username for user: " + currentUser.getName() + ". Error: " + e.getMessage());
                    }
                }
            }
            UserTemplate user = new UserTemplate(currentUser);
            user.setActive(false);
            try {
                this.directoryManager.updateUser(directory.getId().longValue(), user);
            }
            catch (Exception e) {
                LOGGER.error("Unable to update user: " + user.getName() + " in directory. Cause : " + String.valueOf(e));
            }
        }
    }

    public void sendMailToNeverLoggedInUsers(ArrayList<com.atlassian.crowd.embedded.api.User> neverLoggedInUser) {
        LOGGER.debug("Inside sendMailToNeverLoggedInUsers");
        String subject = this.settings.getMailSubForNeverLoggedInUsers();
        String mailText = this.settings.getMailTextForNeverLoggedInUsers();
        String mailServer = this.settings.getMailServerForNeverLoggedIn();
        String numberOfDays = String.valueOf(this.settings.getNumberofDaysAfterUserCreation());
        List smtpServers = this.mailServerManager.getSmtpMailServers();
        SMTPMailServer selectedServer = smtpServers.stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (com.atlassian.crowd.embedded.api.User user : neverLoggedInUser) {
            AtomicReference<String> body = new AtomicReference<String>(mailText);
            body.set(StringUtils.replace((String)body.get(), (String)"$$days$$", (String)numberOfDays));
            executor.submit(() -> {
                ConfluenceUser currentUser = this.userAccessor.getUserByName(user.getName());
                try {
                    body.set(StringUtils.replace((String)((String)body.get()), (String)"$$username$$", (String)user.getName()));
                    if (selectedServer != null && currentUser != null) {
                        this.mailConfig(currentUser.getEmail(), selectedServer, subject, (String)body.get());
                    }
                }
                catch (MailException | MessagingException e) {
                    LOGGER.debug("Error to send mail : " + e.getMessage());
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public ConfluenceUser getConfluenceAdministrator() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        List confluenceAdministrators = userAccessor.getMemberNamesAsList(userAccessor.getGroup("confluence-administrators"));
        if (confluenceAdministrators != null && !confluenceAdministrators.isEmpty()) {
            for (String user : confluenceAdministrators) {
                ConfluenceUser confluenceAdminUser = userAccessor.getUserByName(user);
                LOGGER.error("Confluence Admin User = " + String.valueOf(confluenceAdminUser));
                UserTemplate userTemplate = new UserTemplate(this.crowdService.getUser(user));
                if (this.permissionManager.isSystemAdministrator((User)confluenceAdminUser) || this.permissionManager.isConfluenceAdministrator((User)confluenceAdminUser) && userTemplate.isActive()) {
                    return confluenceAdminUser;
                }
                LOGGER.debug("Confluence Admin User = " + String.valueOf(confluenceAdminUser) + " does not have system admin permission or user is deactivated, continue with search...");
            }
        }
        return null;
    }

    public Boolean isUserPresentInDirectory(com.atlassian.crowd.embedded.api.User user, List<String> selectedDirectories) throws DirectoryNotFoundException {
        Directory userDirectory = this.directoryManager.findDirectoryById(user.getDirectoryId());
        if (!selectedDirectories.isEmpty()) {
            if (selectedDirectories.contains(userDirectory.getName())) {
                LOGGER.debug("User : " + user.getName() + " is present in selected directory");
                return true;
            }
            LOGGER.debug("User : " + user.getName() + " is not present in selected directory");
            return false;
        }
        return false;
    }

    public void destroy() throws Exception {
        LOGGER.debug("Destroy process initiated: attempting to unschedule job.");
        try {
            this.unschedule();
        }
        catch (Exception e) {
            LOGGER.debug("No JOB exists. Can't unschedule." + e.getMessage());
        }
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("Initializing properties: checking if auto-scheduling is needed.");
        if (this.settings.getAutoDeActivateUsers().booleanValue() || this.settings.getEnableAutoRemoveFromGroup().booleanValue() || this.settings.getAddGroupsToInactive().booleanValue()) {
            this.schedule();
        }
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.UserManagementUtility;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public MailServerManager getMailServerManager() {
        return this.mailServerManager;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @Generated
    public UserChecker getUserChecker() {
        return this.userChecker;
    }

    @Generated
    public CrowdDirectoryService getCrowdDirectoryService() {
        return this.crowdDirectoryService;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    @Generated
    public UserDeactivaterTask getDeactivaterTask() {
        return this.deactivaterTask;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Generated
    public void setUserManagementUtility(ConfluenceUserManagementUtility UserManagementUtility) {
        this.UserManagementUtility = UserManagementUtility;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setMailServerManager(MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @Generated
    public void setUserChecker(UserChecker userChecker) {
        this.userChecker = userChecker;
    }

    @Generated
    public void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setDeactivaterTask(UserDeactivaterTask deactivaterTask) {
        this.deactivaterTask = deactivaterTask;
    }
}

