/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.gson.Gson;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagementDashboard
extends HttpServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(UserManagementDashboard.class);
    private final TemplateRenderer renderer;
    private ConfluenceUserManagementUtility userManagementUtility;
    private UserAccessor userAccessor;
    private UserChecker userChecker;
    private UserManagementPluginSettings settings;
    private LoginManager loginManager;
    private CrowdService crowdService;
    private ContextPathHolder contextPathHolder;
    private PermissionManager permissionManager;
    private String totalUsers = "";
    private String activatedUsers = "";
    private String deactivatedUsers = "";
    private String activeUsers = "";
    private String inactiveUsers = "";
    private String licensedInactiveUsers = "";
    private String licensedActiveUsers = "";
    private String usedLicense = "";
    private String licenseTier = "";
    private String availableLicense = "";
    private String neverLoggedInUsers = "";
    Map<String, Map<Integer, Integer>> userStatusCounts = new HashMap<String, Map<Integer, Integer>>();
    private List<String> licensedUsersList = new ArrayList<String>();
    private List<String> licensedInactiveUsersList = Collections.synchronizedList(new ArrayList());
    private List<String> licensedActiveUsersList = Collections.synchronizedList(new ArrayList());
    private List<String> activeUsersList = Collections.synchronizedList(new ArrayList());
    private List<String> inActiveUsersList = Collections.synchronizedList(new ArrayList());
    private List<String> activatedUserswithTimestamps = Collections.synchronizedList(new ArrayList());
    private List<String> deactivatedUsersWithTimestamps = new ArrayList<String>();
    private List<User> activatedUsersList = new ArrayList<User>();
    private List<User> deactivatedUsersList = new ArrayList<User>();
    private List<String> neverLoggedInUsersList = Collections.synchronizedList(new ArrayList());
    long dayInMillis = 86400000L;
    private HashMap<String, Object> context;
    private String noOfDays = "";

    public UserManagementDashboard(TemplateRenderer renderer, ConfluenceUserManagementUtility userManagementUtility, UserChecker userChecker, UserAccessor userAccessor, UserManagementPluginSettings settings, LoginManager loginManager, CrowdService crowdService, ContextPathHolder contextPathHolder, PermissionManager permissionManager) {
        this.renderer = renderer;
        this.userManagementUtility = userManagementUtility;
        this.userChecker = userChecker;
        this.userAccessor = userAccessor;
        this.settings = settings;
        this.loginManager = loginManager;
        this.crowdService = crowdService;
        this.contextPathHolder = contextPathHolder;
        this.permissionManager = permissionManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("The doGet method is called for the user dashboard");
        this.authenticateAdminAndLicenseValidation(request, response);
        this.UserDetails(request, response);
        this.context = this.initializeConfig();
        response.setContentType("text/html");
        this.renderer.render("/templates/Dashboard.vm", this.context, (Writer)response.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("The doPost method is called for the user dashboard");
        this.authenticateAdminAndLicenseValidation(req, resp);
        String noOfdays = req.getParameter("noOfDaysSubmitted");
        if (noOfdays != null && noOfdays.equals("true")) {
            this.settings.setNoOfDaysForUsersDashboard(req.getParameter("noOfDays"));
        }
        this.UserDetails(req, resp);
        this.context = this.initializeConfig();
        resp.setContentType("text/html");
        this.renderer.render("/templates/Dashboard.vm", this.context, (Writer)resp.getWriter());
    }

    public void UserDetails(HttpServletRequest request, HttpServletResponse response) {
        int[] intervals;
        Date date = new Date();
        long currentTime = date.getTime();
        this.deactivatedUsersWithTimestamps = new ArrayList<String>();
        this.noOfDays = this.settings.getNoOfDaysForUsersDashboard();
        long lastDay = currentTime - (long)Integer.parseInt(this.noOfDays) * this.dayInMillis;
        this.activatedUsersList = this.userManagementUtility.getUserFromConfluenceUsingUsername("", "ActiveUsers", new ArrayList<String>(), "ALL");
        this.licensedUsersList = this.userAccessor.getUserNamesWithConfluenceAccess();
        this.deactivatedUsersList = this.userManagementUtility.getUserFromConfluenceUsingUsername("", "InactiveUsers", new ArrayList<String>(), "ALL");
        ArrayList<String> deactivatedUsersWithDate = new ArrayList<String>();
        this.deactivatedUsersList.parallelStream().forEach(user -> {
            String userInfo = user.getName() + ";" + String.valueOf(((TimestampedUser)this.crowdService.getUser(user.getName())).getCreatedDate());
            List list = deactivatedUsersWithDate;
            synchronized (list) {
                deactivatedUsersWithDate.add(userInfo);
            }
        });
        this.deactivatedUsersWithTimestamps = deactivatedUsersWithDate;
        this.activatedUserswithTimestamps = Collections.synchronizedList(new ArrayList());
        this.activeUsersList = Collections.synchronizedList(new ArrayList());
        this.inActiveUsersList = Collections.synchronizedList(new ArrayList());
        this.licensedActiveUsersList = Collections.synchronizedList(new ArrayList());
        this.licensedInactiveUsersList = Collections.synchronizedList(new ArrayList());
        this.neverLoggedInUsersList = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<Integer, Integer> activeCounts = new ConcurrentHashMap<Integer, Integer>();
        ConcurrentHashMap<Integer, Integer> inactiveCounts = new ConcurrentHashMap<Integer, Integer>();
        for (int interval : intervals = new int[]{5, 15, 30, 60, 120}) {
            activeCounts.put(interval, 0);
            inactiveCounts.put(interval, 0);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (User user2 : this.activatedUsersList) {
            executorService.submit(() -> {
                String lastLoginBefore = "";
                Object userInfo = "";
                ConfluenceUser currentUser = this.userAccessor.getUserByName(user2.getName());
                LoginInfo loginInfo = this.loginManager.getLoginInfo((com.atlassian.user.User)currentUser);
                boolean isNeverLoggedIn = loginInfo.getLastSuccessfulLoginDate() == null;
                long userTime = isNeverLoggedIn ? ((TimestampedUser)this.crowdService.getUser(user2.getName())).getCreatedDate().getTime() : loginInfo.getLastSuccessfulLoginDate().getTime();
                boolean isActive = userTime >= lastDay;
                boolean isLicensed = this.licensedUsersList.contains(user2.getName());
                if (!isNeverLoggedIn) {
                    long lastLoginBeforeDay = currentTime - loginInfo.getLastSuccessfulLoginDate().getTime();
                    long lastLoginBeforeDays = TimeUnit.MILLISECONDS.toDays(lastLoginBeforeDay);
                    lastLoginBefore = String.valueOf(lastLoginBeforeDays);
                } else {
                    lastLoginBefore = "Never Logged In";
                }
                for (int interval : intervals) {
                    if (userTime < currentTime - (long)interval * this.dayInMillis) {
                        inactiveCounts.merge(interval, 1, Integer::sum);
                        continue;
                    }
                    activeCounts.merge(interval, 1, Integer::sum);
                }
                userInfo = user2.getName() + ";" + String.valueOf(((TimestampedUser)this.crowdService.getUser(user2.getName())).getCreatedDate()) + ";" + lastLoginBefore;
                this.activatedUserswithTimestamps.add((String)userInfo);
                (isActive ? this.activeUsersList : this.inActiveUsersList).add((String)userInfo);
                if (isLicensed) {
                    (isActive ? this.licensedActiveUsersList : this.licensedInactiveUsersList).add((String)userInfo);
                    if (isNeverLoggedIn) {
                        this.neverLoggedInUsersList.add((String)userInfo);
                    }
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.debug("error occurred while shutting down executor: " + String.valueOf(e));
            throw new RuntimeException(e);
        }
        this.userStatusCounts.put("activeCounts", activeCounts);
        this.userStatusCounts.put("inactiveCounts", inactiveCounts);
        this.activatedUsers = String.valueOf(this.activatedUsersList.size());
        this.deactivatedUsers = String.valueOf(this.deactivatedUsersList.size());
        this.totalUsers = String.valueOf(this.activatedUsersList.size() + this.deactivatedUsersList.size());
        this.activeUsers = String.valueOf(this.activeUsersList.size());
        this.inactiveUsers = String.valueOf(this.inActiveUsersList.size());
        this.licensedInactiveUsers = String.valueOf(this.licensedInactiveUsersList.size());
        this.licensedActiveUsers = String.valueOf(this.licensedActiveUsersList.size());
        this.neverLoggedInUsers = String.valueOf(this.neverLoggedInUsersList.size());
        this.licenseTier = String.valueOf(this.userManagementUtility.getLicensedUserTier());
        this.usedLicense = String.valueOf(this.userAccessor.countLicenseConsumingUsers());
        this.availableLicense = this.licenseTier.equals("-1") ? "-1" : String.valueOf(Integer.max(this.userManagementUtility.getLicensedUserTier() - this.userAccessor.countLicenseConsumingUsers(), 0));
    }

    private HashMap<String, Object> initializeConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("licensedInactiveUsers", this.licensedInactiveUsers);
        context.put("activatedUsers", this.activatedUsers);
        context.put("totalUsers", this.totalUsers);
        context.put("licensedActiveUsers", this.licensedActiveUsers);
        context.put("inactiveUsers", this.inactiveUsers);
        context.put("usedLicense", this.usedLicense);
        context.put("licenseTier", this.licenseTier);
        context.put("availableLicense", this.availableLicense);
        context.put("neverLoggedInUsers", this.neverLoggedInUsers);
        context.put("activeUsers", this.activeUsers);
        context.put("deactivatedUsers", this.deactivatedUsers);
        context.put("noOfDays", this.noOfDays);
        context.put("contextPath", this.contextPathHolder.getContextPath());
        context.put("activatedUsersList", new Gson().toJson(this.activatedUserswithTimestamps));
        context.put("activeUsersList", new Gson().toJson(this.activeUsersList));
        context.put("inactiveUsersList", new Gson().toJson(this.inActiveUsersList));
        context.put("deactivatedUsersList", new Gson().toJson(this.deactivatedUsersWithTimestamps));
        context.put("licensedActiveuserslist", new Gson().toJson(this.licensedActiveUsersList));
        context.put("licensedInactiveuserslist", new Gson().toJson(this.licensedInactiveUsersList));
        context.put("neverLoggedInUsersList", new Gson().toJson(this.neverLoggedInUsersList));
        context.put("userStatusCounts", new Gson().toJson(this.userStatusCounts));
        return context;
    }

    private void authenticateAdminAndLicenseValidation(HttpServletRequest request, HttpServletResponse response) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        String baseURL = this.settings.getBaseURL();
        if (confluenceUser != null) {
            Boolean isAdmin = this.permissionManager.isSystemAdministrator((com.atlassian.user.User)confluenceUser) || this.permissionManager.isConfluenceAdministrator((com.atlassian.user.User)confluenceUser);
            if (!isAdmin.booleanValue()) {
                LOGGER.error("You do not have access to the admin settings. Please contact your system administrator for further assistance");
                try {
                    response.sendRedirect(baseURL);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.userManagementUtility.isLicenseValid().booleanValue()) {
                LOGGER.debug("You do not have a valid license. Please upgrade your license or provide a valid one.");
                try {
                    response.sendRedirect(baseURL + "/plugins/servlet/upm");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            LOGGER.debug("Unable to retrieve login user details. Please refresh the page and try again.");
            try {
                response.sendRedirect(baseURL);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

