/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.conversion.NullHandler;
import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.ognl.OgnlNullHandlerWrapper;
import com.opensymphony.xwork2.ognl.OgnlValueStack;
import com.opensymphony.xwork2.ognl.SecurityMemberAccess;
import com.opensymphony.xwork2.ognl.accessor.RootAccessor;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import java.util.Set;
import ognl.MethodAccessor;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OgnlValueStackFactory
implements ValueStackFactory {
    private static final Logger LOG = LogManager.getLogger(OgnlValueStackFactory.class);
    protected XWorkConverter xworkConverter;
    protected RootAccessor compoundRootAccessor;
    protected TextProvider textProvider;
    protected Container container;

    @Inject
    protected void setXWorkConverter(XWorkConverter converter) {
        this.xworkConverter = converter;
    }

    @Inject
    protected void setCompoundRootAccessor(RootAccessor compoundRootAccessor) {
        this.compoundRootAccessor = compoundRootAccessor;
        OgnlRuntime.setPropertyAccessor(CompoundRoot.class, compoundRootAccessor);
        OgnlRuntime.setMethodAccessor(CompoundRoot.class, compoundRootAccessor);
    }

    @Inject
    protected void setMethodAccessor(MethodAccessor methodAccessor) {
        OgnlRuntime.setMethodAccessor(Object.class, methodAccessor);
    }

    @Inject(value="system")
    protected void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    @Override
    public ValueStack createValueStack() {
        return this.createValueStack(null, true);
    }

    @Override
    public ValueStack createValueStack(ValueStack stack) {
        return this.createValueStack(stack, false);
    }

    protected ValueStack createValueStack(ValueStack stack, boolean useTextProvider) {
        OgnlValueStack newStack = new OgnlValueStack(stack, this.xworkConverter, this.compoundRootAccessor, useTextProvider ? this.textProvider : null, this.container.getInstance(SecurityMemberAccess.class));
        this.container.inject(newStack);
        return newStack.getActionContext().withContainer(this.container).withValueStack(newStack).getValueStack();
    }

    @Inject
    protected void setContainer(Container container) throws ClassNotFoundException {
        this.container = container;
        this.registerPropertyAccessors();
        this.registerNullHandlers();
        this.registerAdditionalMethodAccessors();
    }

    protected void registerAdditionalMethodAccessors() {
        Set<String> names = this.container.getInstanceNames(MethodAccessor.class);
        for (String name : names) {
            Class<?> cls;
            try {
                cls = Class.forName(name);
                if (cls.equals(Object.class)) continue;
                if (cls.equals(CompoundRoot.class)) {
                }
            }
            catch (ClassNotFoundException e) {}
            continue;
            MethodAccessor methodAccessor = this.container.getInstance(MethodAccessor.class, name);
            OgnlRuntime.setMethodAccessor(cls, methodAccessor);
            LOG.debug("Registered custom OGNL MethodAccessor [{}] for class [{}]", (Object)methodAccessor.getClass().getName(), (Object)cls.getName());
        }
    }

    protected void registerNullHandlers() throws ClassNotFoundException {
        Set<String> names = this.container.getInstanceNames(NullHandler.class);
        for (String name : names) {
            Class<?> cls = Class.forName(name);
            NullHandler nullHandler = this.container.getInstance(NullHandler.class, name);
            OgnlRuntime.setNullHandler(cls, new OgnlNullHandlerWrapper(nullHandler));
            LOG.debug("Registered custom OGNL NullHandler [{}] for class [{}]", (Object)nullHandler.getClass().getName(), (Object)cls.getName());
        }
    }

    protected void registerPropertyAccessors() throws ClassNotFoundException {
        Set<String> names = this.container.getInstanceNames(PropertyAccessor.class);
        for (String name : names) {
            Class<?> cls = Class.forName(name);
            if (cls.equals(CompoundRoot.class)) continue;
            PropertyAccessor propertyAccessor = this.container.getInstance(PropertyAccessor.class, name);
            OgnlRuntime.setPropertyAccessor(cls, propertyAccessor);
            LOG.debug("Registered custom OGNL PropertyAccessor [{}] for class [{}]", (Object)propertyAccessor.getClass().getName(), (Object)cls.getName());
        }
    }

    @Deprecated
    protected boolean containerAllowsStaticFieldAccess() {
        return BooleanUtils.toBoolean((String)this.container.getInstance(String.class, "struts.ognl.allowStaticFieldAccess"));
    }
}

