/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.wrapper;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RestReadingServletRequest
extends HttpServletRequestWrapper {
    private final byte[] body;

    public RestReadingServletRequest(HttpServletRequest request) throws IOException {
        super(request);
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                bis = new BufferedInputStream((InputStream)inputStream);
                byte[] byteBuffer = new byte[1024];
                int bytesRead = -1;
                while ((bytesRead = bis.read(byteBuffer)) > 0) {
                    baos.write(byteBuffer, 0, bytesRead);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (bis != null) {
                bis.close();
                baos.close();
            }
        }
        this.body = baos.toByteArray();
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
        ServletInputStream servletInputStream = new ServletInputStream(){

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
        return servletInputStream;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getBody() {
        try {
            return new String(this.body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.body);
        }
    }
}

