/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.utility;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ConfluenceComponent
public class ConfluenceUserManagementUtility {
    private static Log LOGGER = LogFactory.getLog(ConfluenceUserManagementUtility.class);
    private CrowdService crowdService;
    private PluginLicenseManager pluginLicenseManager;
    private LoginManager loginManager;
    private UserAccessor userAccessor;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler userManagementPluginHandler;
    private DirectoryManager directoryManager;
    private LicenseService licenseService;
    private PermissionManager permissionManager;
    private CrowdDirectoryService crowdDirectoryService;

    public ConfluenceUserManagementUtility(CrowdService crowdService, PluginLicenseManager pluginLicenseManager, LoginManager loginManager, UserAccessor userAccessor, UserManagementPluginHandler userManagementPluginHandler, UserManagementPluginSettings settings, DirectoryManager directoryManager, LicenseService licenseService, PermissionManager permissionManager, CrowdDirectoryService crowdDirectoryService) {
        this.crowdService = crowdService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.loginManager = loginManager;
        this.userAccessor = userAccessor;
        this.settings = settings;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.directoryManager = directoryManager;
        this.licenseService = licenseService;
        this.permissionManager = permissionManager;
        this.crowdDirectoryService = crowdDirectoryService;
    }

    public List<com.atlassian.crowd.embedded.api.User> getUserFromConfluenceUsingUsername(String usernameSearchKeyword, String userSearchFilter, List<String> groupSearchList, String directory) {
        LOGGER.debug((Object)"getUserFromConfluenceUsingUsername");
        ArrayList availableUser = new ArrayList();
        Object activeUser = null;
        Object inactiveUser = null;
        ArrayList<List> userLists = new ArrayList<List>();
        ArrayList usersList = new ArrayList();
        List userSearchFilterList = new ArrayList();
        ArrayList<com.atlassian.crowd.embedded.api.User> finalUserList = new ArrayList<com.atlassian.crowd.embedded.api.User>();
        String groupSearchKey = "";
        MembershipQuery queryForGroup = null;
        EntityQuery query = null;
        if (groupSearchList.size() > 0) {
            for (int i = 0; i < groupSearchList.size(); ++i) {
                groupSearchKey = groupSearchList.get(i);
                if (!StringUtils.isNotBlank((CharSequence)groupSearchKey)) continue;
                queryForGroup = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(new String[]{groupSearchKey}).returningAtMost(-1);
                userLists.add((List)this.crowdService.search((Query)queryForGroup));
            }
            if (userLists.size() > 0) {
                usersList.addAll((Collection)userLists.get(0));
                ListIterator iter = userLists.listIterator(0);
                while (iter.hasNext()) {
                    usersList.retainAll((Collection)iter.next());
                }
            }
            finalUserList = usersList;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)userSearchFilter, (CharSequence)"AllUsers") || userSearchFilter.isEmpty()) {
            LOGGER.debug((Object)"Get all User");
            query = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)).returningAtMost(-1);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)userSearchFilter, (CharSequence)"ActiveUsers")) {
            LOGGER.debug((Object)"Get active users");
            query = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)true), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)})).returningAtMost(-1);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)userSearchFilter, (CharSequence)"InactiveUsers")) {
            LOGGER.debug((Object)"Get inactive users");
            query = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)false), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)})).returningAtMost(-1);
        }
        userSearchFilterList = (List)this.crowdService.search((Query)query);
        if (!finalUserList.isEmpty()) {
            finalUserList.retainAll(userSearchFilterList);
        } else if (groupSearchList.isEmpty()) {
            finalUserList = userSearchFilterList;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)"All", (CharSequence)directory)) {
            try {
                List directoryUsers = new ArrayList();
                DirectoryInstanceLoader directoryLoader = (DirectoryInstanceLoader)ContainerManager.getComponent((String)"directoryInstanceLoader");
                List allDirectories = this.directoryManager.findAllDirectories();
                for (int i = 0; i < allDirectories.size(); ++i) {
                    String dirName = ((Directory)allDirectories.get(i)).getName();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)dirName, (CharSequence)directory)) continue;
                    RemoteDirectory dir = directoryLoader.getDirectory(this.directoryManager.findDirectoryByName(dirName));
                    EntityQuery query1 = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
                    directoryUsers = dir.searchUsers(query1);
                }
                finalUserList.retainAll(directoryUsers);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error occurred while querying based on directory" + e));
            }
        }
        Collections.sort(finalUserList);
        return finalUserList;
    }

    public List<List<com.atlassian.crowd.embedded.api.User>> fetchUsersWithLastLoginFilter(List<com.atlassian.crowd.embedded.api.User> usernameList) {
        ArrayList<List<com.atlassian.crowd.embedded.api.User>> resultList = new ArrayList<List<com.atlassian.crowd.embedded.api.User>>();
        List userListToReturnNull = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<Long, com.atlassian.crowd.embedded.api.User> userMapWithLastLogin = new ConcurrentHashMap<Long, com.atlassian.crowd.embedded.api.User>();
        int batchSize = 2000;
        int numBatches = (int)Math.ceil((double)usernameList.size() / (double)batchSize);
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<CompletableFuture<Void>> allDirectoryUsers = new ArrayList<CompletableFuture<Void>>();
        for (int j = 0; j < numBatches; ++j) {
            int start = j * batchSize;
            int end = Math.min((j + 1) * batchSize, usernameList.size());
            List<com.atlassian.crowd.embedded.api.User> batch = usernameList.subList(start, end);
            CompletableFuture<Void> directoryUsers = CompletableFuture.runAsync(() -> {
                HashMap<Long, com.atlassian.crowd.embedded.api.User> tempUserMap = new HashMap<Long, com.atlassian.crowd.embedded.api.User>();
                for (com.atlassian.crowd.embedded.api.User user : batch) {
                    LoginInfo loginInfo = this.loginManager.getLoginInfo((User)this.userAccessor.getUserByName(user.getName()));
                    if (loginInfo.getLastSuccessfulLoginDate() == null) {
                        userListToReturnNull.add(user);
                        continue;
                    }
                    long loginTime = loginInfo.getLastSuccessfulLoginDate().getTime();
                    tempUserMap.put(loginTime, user);
                }
                userMapWithLastLogin.putAll(tempUserMap);
            }, executorService);
            allDirectoryUsers.add(directoryUsers);
        }
        CompletableFuture.allOf(allDirectoryUsers.toArray(new CompletableFuture[0])).join();
        resultList.add(userMapWithLastLogin != null ? this.sortUsersByLastLogin(userMapWithLastLogin) : null);
        resultList.add(userListToReturnNull);
        executorService.shutdown();
        return resultList;
    }

    public List<com.atlassian.crowd.embedded.api.User> sortUsersByLastLogin(Map<Long, com.atlassian.crowd.embedded.api.User> userListWithLastLogin) {
        TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
        sortedMap.putAll(userListWithLastLogin);
        ArrayList<com.atlassian.crowd.embedded.api.User> userListToReturn = new ArrayList<com.atlassian.crowd.embedded.api.User>(sortedMap.size());
        for (com.atlassian.crowd.embedded.api.User user : sortedMap.values()) {
            userListToReturn.add(user);
        }
        return userListToReturn;
    }

    public String getCurrentIpAddress(HttpServletRequest request) {
        String remoteAddr = "";
        if (request != null && (StringUtils.isBlank((CharSequence)(remoteAddr = request.getHeader("X-FORWARDED-FOR"))) || StringUtils.isEmpty((CharSequence)remoteAddr))) {
            remoteAddr = request.getRemoteAddr();
        }
        return remoteAddr;
    }

    public void removeGroupFromExternalDirectoryUser(String userName, Boolean autoRemove, List<String> groupsToRemove, HttpServletResponse response, String ip) {
        block11: {
            block10: {
                com.atlassian.crowd.embedded.api.User currentUser = this.crowdService.getUser(userName);
                Directory directory = this.crowdDirectoryService.findDirectoryById(currentUser.getDirectoryId());
                Set operation = directory.getAllowedOperations();
                if (directory.getType() != DirectoryType.CROWD || operation.contains(OperationType.UPDATE_USER)) break block10;
                LOGGER.debug((Object)("User is from crowd read only directory which have permission to update user : " + userName));
                if (!this.settings.getEnableCrowdROUser().booleanValue() && autoRemove.booleanValue()) break block11;
                Map directoryAttribute = directory.getAttributes();
                String applicationName = (String)directoryAttribute.get("application.name");
                String applicationPassword = (String)directoryAttribute.get("application.password");
                String crowdServerUrl = (String)directoryAttribute.get("crowd.server.url");
                List userGroups = this.userAccessor.getGroupNames((User)this.userAccessor.getUserByName(userName));
                for (String group : groupsToRemove) {
                    if (!userGroups.contains(group)) continue;
                    try {
                        LOGGER.debug((Object)("User : " + userName + " is allowed for remove application access from crowd read only directory"));
                        URL url = new URL(crowdServerUrl + "rest/usermanagement/1/user/group/direct?username=" + userName + "&groupname=" + group);
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("DELETE");
                        connection.setRequestProperty("Content-Type", "application/json");
                        connection.setRequestProperty("Accept", "application/json");
                        String auth = applicationName + ":" + applicationPassword;
                        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
                        String authHeaderValue = "Basic " + encodedAuth;
                        connection.setRequestProperty("Authorization", authHeaderValue);
                        connection.setDoOutput(true);
                        LOGGER.debug((Object)("Response code for user : " + userName + " is : " + connection.getResponseCode()));
                        switch (connection.getResponseCode()) {
                            case 204: {
                                this.crowdDirectoryService.synchroniseDirectory(directory.getId().longValue());
                                LOGGER.debug((Object)("User " + userName + " was successfully removed from the group : " + group));
                                this.userManagementPluginHandler.storeAuditLogs(userName, ip, "Group Removed", "User successfully removed from group : " + group, "successful");
                                break;
                            }
                            case 403: {
                                LOGGER.error((Object)("Application is not allowed to delete the membership for user : " + userName));
                                this.userManagementPluginHandler.storeAuditLogs(userName, ip, "Group Removed", "Failed to remove group membership from: " + group + ". This action is not permitted by the application.", "Error");
                                break;
                            }
                            case 404: {
                                LOGGER.error((Object)("User or group not found while removing user: " + userName + " from group: " + group));
                                this.userManagementPluginHandler.storeAuditLogs(userName, ip, "Group Removed", "Failed to remove user from group " + group + ". The user or group could not be found.", "Error");
                                break;
                            }
                            default: {
                                LOGGER.debug((Object)("Issue while removing group from user : " + connection.getResponseMessage()));
                                this.userManagementPluginHandler.storeAuditLogs(userName, ip, "Group Removed", "Failed to remove group membership for: " + group, "Error");
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.debug((Object)("IOException for user : " + userName + " is : " + e.getMessage()));
                    }
                }
                break block11;
            }
            try {
                this.removeUserFromGroups(userName, autoRemove, groupsToRemove, response, ip);
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage());
            }
        }
    }

    public void addGroupFromExternalDirectoryUser(String userName, List<String> groupsToAdd, String ip) {
        LOGGER.debug((Object)"Add group to read only external drectory user function");
        com.atlassian.crowd.embedded.api.User currentUser = this.crowdService.getUser(userName);
        Directory directory = this.crowdDirectoryService.findDirectoryById(currentUser.getDirectoryId());
        Set operation = directory.getAllowedOperations();
        if (directory.getType() == DirectoryType.CROWD && !operation.contains(OperationType.UPDATE_USER)) {
            LOGGER.debug((Object)("User is from crowd read only directory which have permission to update user : " + userName));
            Map directoryAttribute = directory.getAttributes();
            String applicationName = (String)directoryAttribute.get("application.name");
            String applicationPassword = (String)directoryAttribute.get("application.password");
            String crowdServerUrl = (String)directoryAttribute.get("crowd.server.url");
            for (String group : groupsToAdd) {
                try {
                    String urlString = crowdServerUrl + "rest/usermanagement/1/group/user/direct?groupname=" + group;
                    URL url = new URL(urlString);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                    connection.setRequestProperty("Content-Type", "application/json");
                    String auth = applicationName + ":" + applicationPassword;
                    String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
                    connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
                    String jsonBody = "{\"name\": \"" + userName + "\"}";
                    try (OutputStream os = connection.getOutputStream();){
                        byte[] input = jsonBody.getBytes(StandardCharsets.UTF_8);
                        os.write(input, 0, input.length);
                    }
                    int responseCode = connection.getResponseCode();
                    if (responseCode == 201) {
                        LOGGER.debug((Object)"User successfully added to the group.");
                        this.userManagementPluginHandler.storeAuditLogs(userName, ip, "Added to Group", "Added User to Groups : " + group, "Successful Logs");
                    } else {
                        this.userManagementPluginHandler.storeAuditLogs(userName, ip, "Group Removed", "Failed to remove group membership for: " + group, "Error");
                        LOGGER.debug((Object)("Failed to add user. Response Code: " + responseCode));
                    }
                    connection.disconnect();
                }
                catch (Exception e) {
                    LOGGER.debug((Object)"exception");
                    e.printStackTrace();
                }
            }
        } else {
            for (String group : groupsToAdd) {
                try {
                    this.directoryManager.addUserToGroup(currentUser.getDirectoryId(), userName, group);
                    this.userManagementPluginHandler.storeAuditLogs(userName, ip, "Added to Group", "Added User to Groups : " + group, "Successful Logs");
                    LOGGER.debug((Object)("Added User to Groups : " + group));
                }
                catch (Exception e) {
                    this.userManagementPluginHandler.storeAuditLogs(userName, ip, "Group Removed", "Failed to remove group membership for: " + group, "Error");
                    LOGGER.error((Object)("Unable to add user '" + userName + "' to group '" + group + "' due to: " + e));
                }
            }
        }
    }

    public void removeUserFromGroups(String username, Boolean autoRemove, List<String> groupsToRemove, HttpServletResponse response, String ip) throws IOException {
        long userDir = this.crowdService.getUser(username).getDirectoryId();
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        boolean isAdmin = this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
        if (!isAdmin) {
            block6: {
                try {
                    for (String groupToRemove : groupsToRemove) {
                        this.directoryManager.removeUserFromGroup(userDir, username, groupToRemove);
                        LOGGER.debug((Object)("User :" + username + "  is successfully removed from group : " + groupToRemove));
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Issue while remove user: " + username + "from group : " + e));
                    if (autoRemove.booleanValue()) break block6;
                    this.sendErrorResponse("Error", 500, response);
                }
            }
            if (!groupsToRemove.isEmpty()) {
                String UserInGroup = groupsToRemove.toString();
                this.userManagementPluginHandler.storeAuditLogs(username, ip, "Removed from Group", "Removed User from Groups: " + UserInGroup.replaceAll("[\\[\\]]", ""), "Successful Logs");
            }
        } else {
            LOGGER.error((Object)("Could not remove the group from user '" + username + "' as the user has admin privileges."));
            this.sendErrorResponse("Error_User_Is_Admin", 500, response);
        }
    }

    public void sendErrorResponse(String errorMessages, int statusCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(statusCode);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }

    public void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }

    public List<String> getAllGroups(String groupRegexPattern) {
        String startWith = "";
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)startWith)).returningAtMost(-1);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        for (Group groupObject : groups) {
            if (!StringUtils.containsIgnoreCase((CharSequence)groupObject.getName(), (CharSequence)groupRegexPattern.trim())) continue;
            existingGroups.add(groupObject.getName().trim());
        }
        return existingGroups;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer groupsPerPage, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i < startIndex + groupsPerPage && i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public List<com.atlassian.crowd.embedded.api.User> filterUsers(List<com.atlassian.crowd.embedded.api.User> usernameList, boolean isDateFilter, String startDateFilter, String endDateFilter, boolean onlyLicensedUsers, List<String> excludeGroupFilterList) {
        long endDateMillis;
        long startDateMillis;
        LOGGER.debug((Object)"Filtering users based on date, licensed status, and excluding groups");
        HashSet licensedUsers = new HashSet(this.userAccessor.getUserNamesWithConfluenceAccess());
        HashSet<String> excludeGroupSet = new HashSet<String>(excludeGroupFilterList);
        String startDate = startDateFilter + " 00:00:00";
        String endDate = endDateFilter + " 23:59:59";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            startDateMillis = sdf.parse(startDate).getTime();
            endDateMillis = sdf.parse(endDate).getTime();
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Error while parsing dates: startDate=" + startDate + ", endDate=" + endDate + ": " + e));
            throw new RuntimeException(e);
        }
        long finalStartDateMillis = startDateMillis;
        long finalEndDateMillis = endDateMillis;
        List<com.atlassian.crowd.embedded.api.User> targetedUser = usernameList.parallelStream().filter(user -> {
            HashSet userGroups;
            if (onlyLicensedUsers && !licensedUsers.contains(user.getName())) {
                return false;
            }
            if (!excludeGroupSet.isEmpty() && !Collections.disjoint(userGroups = new HashSet(this.userAccessor.getGroupNamesForUserName(user.getName())), excludeGroupSet)) {
                return false;
            }
            if (!isDateFilter) {
                return true;
            }
            LoginInfo loginInfo = this.loginManager.getLoginInfo((User)this.userAccessor.getUserByName(user.getName()));
            if (loginInfo.getLastSuccessfulLoginDate() != null) {
                long lastLoginTime = loginInfo.getLastSuccessfulLoginDate().getTime();
                return lastLoginTime >= finalStartDateMillis && lastLoginTime <= finalEndDateMillis;
            }
            return false;
        }).collect(Collectors.toList());
        return targetedUser;
    }

    public int getMaxUsers() {
        int t2 = 0;
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                t2 = (Integer)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().get();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return t2;
    }

    public Boolean isValidEvaluationLicense() {
        return ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid();
    }

    public Boolean isEvaluationLicense() {
        if (this.isLicenseDefined().booleanValue()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            LOGGER.debug((Object)("pluginLicense.isEvaluation() :- " + pluginLicense.isEvaluation()));
            return pluginLicense.isEvaluation();
        }
        return Boolean.FALSE;
    }

    public Boolean isSubscriptionLicense() {
        if (this.isLicenseDefined().booleanValue()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            LOGGER.debug((Object)("pluginLicense.isSubscription() :- " + pluginLicense.isSubscription()));
            if (pluginLicense.isSubscription()) {
                return pluginLicense.isSubscription();
            }
            if (!pluginLicense.isEvaluation() || this.isLicenseValid().booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseDefined() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseValid() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            if (!((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() || ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public int getLicensedUserTier() {
        try {
            ConfluenceLicense license = this.licenseService.retrieve();
            int userTier = license.getMaximumNumberOfUsers();
            LOGGER.debug((Object)("userTier is :- " + userTier));
            return userTier;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occured", (Throwable)e);
            return 0;
        }
    }

    public Directory getInternalDirectory() {
        EntityQuery query = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory(), (SearchRestriction)NullRestriction.INSTANCE, (int)0, (int)Integer.MAX_VALUE);
        List allDirectories = this.directoryManager.searchDirectories(query);
        for (Directory dir : allDirectories) {
            if (dir.getType() != DirectoryType.INTERNAL) continue;
            LOGGER.debug((Object)("Internal Confluence Directory : " + dir.getName()));
            return dir;
        }
        return null;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserManagementPluginHandler getUserManagementPluginHandler() {
        return this.userManagementPluginHandler;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public LicenseService getLicenseService() {
        return this.licenseService;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public CrowdDirectoryService getCrowdDirectoryService() {
        return this.crowdDirectoryService;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setUserManagementPluginHandler(UserManagementPluginHandler userManagementPluginHandler) {
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }
}

