/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.wrapper.CachedBodyHttpServletRequestWrapper;
import com.miniorange.usermanagement.confluence.wrapper.RestReadingServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ConfluenceComponent
@UnrestrictedAccess
@WebFilter(value={"/*"})
public class MoLoginFilter
implements Filter {
    private static Log LOGGER = LogFactory.getLog(MoLoginFilter.class);
    private UserManagementPluginSettings settings;
    private UserAccessor userAccessor;
    private ConfluenceUserManagementUtility usermanagementutils;
    private UserManagementPluginHandler pluginHandler;
    private CrowdService crowdService;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private DirectoryManager directoryManager;
    private LoginManager loginManager;

    public MoLoginFilter(ConfluenceUserManagementUtility usermanagementutils, UserManagementPluginSettings settings, UserAccessor userAccessor, UserManagementPluginHandler pluginHandler, CrowdService crowdService, UserDeactivaterScheduler userDeactivaterScheduler, DirectoryManager directoryManager, LoginManager loginManager) {
        this.settings = settings;
        this.userAccessor = userAccessor;
        this.usermanagementutils = usermanagementutils;
        this.pluginHandler = pluginHandler;
        this.crowdService = crowdService;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.directoryManager = directoryManager;
        this.loginManager = loginManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block19: {
            try {
                HttpServletRequest req = (HttpServletRequest)request;
                HttpServletResponse resp = (HttpServletResponse)response;
                String requestUrl = req.getRequestURL().toString();
                LOGGER.debug((Object)("Login filter has been invoked from the request URL: " + requestUrl));
                if (!this.usermanagementutils.isLicenseValid().booleanValue()) {
                    LOGGER.error((Object)"Invalid License.");
                    chain.doFilter(request, response);
                }
                if (requestUrl.contains("/dologin.action")) {
                    if (this.settings.getReActivateUser().booleanValue() || this.settings.getAddGroupsToActiveUsers().booleanValue() || this.settings.getRuleBaseGroupMapping().booleanValue()) {
                        String pwd;
                        String username = req.getParameter("os_username");
                        if (!this.isUserAuthenticated(username, pwd = req.getParameter("os_password")).booleanValue()) {
                            chain.doFilter(request, response);
                            return;
                        }
                        this.handleUserAction(username, pwd);
                    }
                    chain.doFilter(request, response);
                    return;
                }
                if (requestUrl.contains("/rest/tsv/1.0/authenticate")) {
                    HttpServletRequestWrapper wrappedRequest;
                    try {
                        wrappedRequest = new RestReadingServletRequest((HttpServletRequest)request);
                        wrappedRequest = new CachedBodyHttpServletRequestWrapper((HttpServletRequest)wrappedRequest);
                    }
                    catch (Exception e) {
                        chain.doFilter(request, response);
                        return;
                    }
                    if (this.settings.getReActivateUser().booleanValue() || this.settings.getAddGroupsToActiveUsers().booleanValue() || this.settings.getRuleBaseGroupMapping().booleanValue()) {
                        String pwd;
                        StringBuilder requestBody = new StringBuilder();
                        try (BufferedReader reader = wrappedRequest.getReader();){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                requestBody.append(line);
                            }
                        }
                        JSONObject jsonBody = new JSONObject(requestBody.toString());
                        String username = jsonBody.getString("username");
                        if (!this.isUserAuthenticated(username, pwd = jsonBody.getString("password")).booleanValue()) {
                            resp.setContentType("application/json;charset=utf-8");
                            resp.setStatus(401);
                            String errorResponse = "{\"message\": \"Incorrect username or password.\",\"captchaRequired\": \"true \",\"expiredCredentials\": false}";
                            resp.getWriter().write(errorResponse);
                            return;
                        }
                        this.handleUserAction(username, pwd);
                    }
                    chain.doFilter((ServletRequest)wrappedRequest, response);
                    break block19;
                }
                chain.doFilter(request, response);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error occurred while login: ", (Throwable)e);
                if (response.isCommitted()) break block19;
                chain.doFilter(request, response);
            }
        }
    }

    public void handleUserAction(String username, String pwd) throws UnknownHostException {
        block16: {
            InetAddress ip = InetAddress.getLocalHost();
            long userDir = this.crowdService.getUser(username).getDirectoryId();
            com.atlassian.crowd.model.user.User user = null;
            try {
                LOGGER.debug((Object)("User: " + username + " & User's Directory: " + this.directoryManager.findDirectoryById(userDir).getName()));
                user = this.directoryManager.findUserByName(userDir, username);
                UserTemplate userTemplate = new UserTemplate((User)user);
                if (this.settings.getReActivateUser().booleanValue() && !userTemplate.isActive()) {
                    userTemplate.setActive(true);
                    this.directoryManager.updateUser(userTemplate.getDirectoryId(), userTemplate);
                    LOGGER.debug((Object)(username + " has been successfully reactivated."));
                    this.pluginHandler.storeAuditLogs(username, ip.getHostAddress(), "User Reactivated", "Deactivated user activate on successful authentication", "Successful Logs");
                    if (this.settings.getAddGroupsToInactive().booleanValue()) {
                        List groupsToAdd = (List)this.settings.getAddGroups();
                        try {
                            this.usermanagementutils.addGroupFromExternalDirectoryUser(userTemplate.getName(), groupsToAdd, ip.getHostAddress());
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)("Exception while adding group: " + groupsToAdd + " to user: " + userTemplate.getName()), (Throwable)e);
                        }
                        LOGGER.debug((Object)("Groups have been added to the user after reactivation: " + groupsToAdd));
                    }
                    if (!this.settings.getRemoveGroupsFromInactive().booleanValue()) break block16;
                    List groupsToRemove = (List)this.settings.getRemoveGroups();
                    try {
                        this.usermanagementutils.removeGroupFromExternalDirectoryUser(userTemplate.getName(), true, groupsToRemove, null, ip.getHostAddress());
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Exception while removing group: " + groupsToRemove + " to user: " + userTemplate.getName()), (Throwable)e);
                    }
                    LOGGER.debug((Object)("Groups have been removed from the user after reactivation: " + groupsToRemove));
                    break block16;
                }
                if (!this.settings.getAddGroupsToActiveUsers().booleanValue() && !this.settings.getRuleBaseGroupMapping().booleanValue() || !userTemplate.isActive()) break block16;
                if (this.settings.getAddGroupsToActiveUsers().booleanValue()) {
                    List groupsToAdd = (List)this.settings.getGroupsAssignToActiveUser();
                    try {
                        this.usermanagementutils.addGroupFromExternalDirectoryUser(userTemplate.getName(), groupsToAdd, ip.getHostAddress());
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Exception while adding group: " + groupsToAdd + " to user: " + userTemplate.getName()), (Throwable)e);
                    }
                    LOGGER.debug((Object)("Groups have been added to the user after a successful login: " + groupsToAdd));
                    this.pluginHandler.storeAuditLogs(username, ip.getHostAddress(), "Groups Assigned to Active Users", "Groups Assigned to users on successful authentication", "Successful Logs");
                }
                if (this.settings.getRuleBaseGroupMapping().booleanValue()) {
                    LOGGER.debug((Object)"Rule base group mapping is enable ");
                    List groupCondition = (List)this.settings.getGroupCondition();
                    List groupsToAdd = (List)this.settings.getAddGroupBaseOnRule();
                    List userGroups = this.userAccessor.getGroupNamesForUserName(username);
                    block10: for (String userGroup : userGroups) {
                        LOGGER.debug((Object)("Inside Floating License : user group:- " + userGroup));
                        for (String excludeGroup : groupCondition) {
                            LOGGER.debug((Object)("exclude group :- " + excludeGroup));
                            if (!userGroup.equals(excludeGroup)) continue;
                            LOGGER.debug((Object)("Group :-" + groupsToAdd + " add to the user :- " + username));
                            try {
                                this.usermanagementutils.addGroupFromExternalDirectoryUser(userTemplate.getName(), groupsToAdd, ip.getHostAddress());
                            }
                            catch (Exception e) {
                                LOGGER.error((Object)("Exception while adding group: " + groupsToAdd + " to user: " + userTemplate.getName()), (Throwable)e);
                            }
                            continue block10;
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"An issue occurred while fetching user details: ", (Throwable)e);
            }
        }
    }

    public Boolean isUserAuthenticated(String username, String pwd) {
        try {
            UserTemplate userTemplate;
            if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)pwd)) {
                return false;
            }
            com.atlassian.crowd.model.user.User user = this.directoryManager.findUserByName(this.crowdService.getUser(username).getDirectoryId(), username);
            if (user == null) {
                LOGGER.error((Object)("User not found: " + username));
                return false;
            }
            boolean wasInactive = !user.isActive();
            UserTemplate userTemplate2 = userTemplate = wasInactive ? new UserTemplate((User)user) : null;
            if (wasInactive) {
                if (!this.settings.getReActivateUser().booleanValue()) {
                    return false;
                }
                userTemplate.setActive(true);
                this.directoryManager.updateUser(userTemplate.getDirectoryId(), userTemplate);
            }
            boolean isUserAuthenticate = false;
            try {
                this.crowdService.authenticate(username, pwd);
                LOGGER.debug((Object)("Authentication successful for user: " + username));
                isUserAuthenticate = true;
            }
            catch (FailedAuthenticationException e) {
                LOGGER.error((Object)("Invalid credentials for user: " + username));
            }
            if (wasInactive) {
                userTemplate.setActive(false);
                this.directoryManager.updateUser(userTemplate.getDirectoryId(), userTemplate);
            }
            return isUserAuthenticate;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error authenticating user: " + username), (Throwable)e);
            return false;
        }
    }

    public void destroy() {
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public ConfluenceUserManagementUtility getUsermanagementutils() {
        return this.usermanagementutils;
    }

    @Generated
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setUsermanagementutils(ConfluenceUserManagementUtility usermanagementutils) {
        this.usermanagementutils = usermanagementutils;
    }

    @Generated
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }
}

