/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.xwork.SimpleXsrfTokenGenerator;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserDeactivateAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(UserDeactivateAction.class);
    private Boolean autodeactivatecheck;
    private String usernameSuffix;
    private UserManagementPluginHandler userManagementPluginHandler;
    private UserManagementPluginSettings settings;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private final MailServerManager mailServerManager;
    private final ConfluenceUserManagementUtility userManagementUtility;
    private Boolean enableAutoRemoveFromGroup;
    private Boolean enableAutoAddGroupToUser;
    private long limitDays;
    private String contextPath;
    private Boolean mailNotification;
    private ArrayList<String> emailServers = new ArrayList();
    private String mailPeriod = "1";
    private String mailSubject = "";
    private String emailTemplate = "";
    private Boolean neverLoggedinUsers;
    private long daysAfterUserCreation;
    private Boolean sendMailToNeverLoggedInUsers;
    private Boolean autoDeactivateSubmited;
    private Boolean autoActivateSubmited;
    private Boolean maxUsersLicense;
    private Boolean enableExcludeGroups;
    private String mailServer = "";
    private String mailServerForNeverLoggedIn = "";
    private String mailPeriodForNeverLoggedInUsers = "1";
    private String mailSubForNeverLoggedInUsers = "";
    private String mailTextForNeverLoggedInUsers = "";
    private String excludeGroups;
    private long scheduler_days;
    private Date previousSchedulerDate;
    private Date nextSchedulerDate;
    private ArrayList<String> excludeGroupsList;
    private Boolean reActivateUser;
    private Boolean addGroupsToInactive;
    private String addGroups;
    private ArrayList<String> addGroupsList;
    private Boolean removeGroupsFromInactive;
    private String removeGroups;
    private ArrayList<String> removeGroupsList;
    private Boolean isGroupsEmpty = false;
    private Boolean addGroupsToActiveUser;
    private String groupsAssignToActiveUser = "";
    private ArrayList<String> groupsListAssignToActiveUser;
    private Boolean groupEmptyForActiveUser = false;
    private String autoRemoveGroups;
    private ArrayList<String> autoRemoveGroupsList = new ArrayList();
    private String autoAddGroups;
    private ArrayList<String> autoAddGroupsList = new ArrayList();
    private String atl_token;
    private Boolean ruleBaseGroupMapping;
    private String groupCondition;
    private String addGroupBaseOnRule;
    private Boolean groupEmptyForRuleBaseMapping = false;
    private ArrayList<String> groupConditionList;
    private ArrayList<String> addGroupBaseOnRuleList;
    private List<SMTPMailServer> smtpServers;
    private long customSchedulerTimeHour;
    private long customSchedulerTimeMinute;
    private Boolean previousSchedulerFlag;
    private Boolean enableLicenseLimitAlert;
    private String mailServerForLicenseAlert;
    private String userLicenseLimit;
    private Integer totalLicensedUsers;
    private UserChecker userChecker;
    private String adminsForAlert = "";
    private ArrayList<String> selectedAdminList;
    private Boolean enableCrowdROUser;
    private Boolean enableDirectoryFilter;
    private String directoryFilter;
    private ArrayList<String> directoryFilterList;

    public UserDeactivateAction(UserManagementPluginHandler userManagementPluginHandler, UserManagementPluginSettings settings, UserDeactivaterScheduler userDeactivaterScheduler, ConfluenceUserManagementUtility confluenceUserManagement, MailServerManager mailServerManager, UserChecker userChecker) {
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.settings = settings;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.userManagementUtility = confluenceUserManagement;
        this.mailServerManager = mailServerManager;
        this.userChecker = userChecker;
    }

    public Boolean doValidate() throws ParseException {
        LOGGER.debug((Object)"Settings Action doValidate");
        this.fetchDetailsFromRequest();
        LOGGER.debug((Object)("value of mail period : " + this.mailPeriod));
        Boolean isError = Boolean.FALSE;
        if (this.enableExcludeGroups == null) {
            this.enableExcludeGroups = false;
        }
        if (this.enableLicenseLimitAlert == null) {
            this.enableLicenseLimitAlert = false;
        }
        if (this.enableDirectoryFilter == null) {
            this.enableDirectoryFilter = false;
        }
        if (this.userLicenseLimit == null) {
            this.userLicenseLimit = "0";
        }
        if (BooleanUtils.toBoolean((Boolean)this.autoDeactivateSubmited)) {
            try {
                long number;
                if (this.limitDays == 0L) {
                    this.limitDays = this.settings.getNumberOfDays();
                }
                if (this.daysAfterUserCreation == 0L) {
                    this.daysAfterUserCreation = this.settings.getNumberofDaysAfterUserCreation();
                }
                if (this.enableCrowdROUser == null) {
                    this.enableCrowdROUser = false;
                }
                if (BooleanUtils.toBoolean((Boolean)this.enableAutoRemoveFromGroup) && StringUtils.isBlank((CharSequence)this.autoRemoveGroups)) {
                    this.addActionError("Groups field is left blank. Please select at groups to revoke application access from inactive users");
                    isError = Boolean.TRUE;
                }
                if (BooleanUtils.toBoolean((Boolean)this.enableAutoAddGroupToUser) && StringUtils.isBlank((CharSequence)this.autoAddGroups)) {
                    this.addActionError("Groups field is left blank. Please select at groups to revoke application access from inactive users");
                    isError = Boolean.TRUE;
                }
                if (StringUtils.isBlank((CharSequence)this.excludeGroups)) {
                    this.addActionError("Exclude groups is left blank. Please select at least one group");
                    isError = Boolean.TRUE;
                }
                if (BooleanUtils.toBoolean((Boolean)this.mailNotification) && StringUtils.isBlank((CharSequence)this.mailPeriod)) {
                    this.addActionError("Please enter valid mail period");
                    isError = Boolean.TRUE;
                }
                if (BooleanUtils.toBoolean((Boolean)this.sendMailToNeverLoggedInUsers) && StringUtils.isBlank((CharSequence)this.mailPeriodForNeverLoggedInUsers)) {
                    this.addActionError("Please enter valid mail period for Never Logged-In Users.");
                    isError = Boolean.TRUE;
                }
                if (this.scheduler_days == 0L) {
                    this.scheduler_days = this.settings.getScheduler_days();
                }
                if (this.enableDirectoryFilter.booleanValue() && StringUtils.isBlank((CharSequence)this.directoryFilter)) {
                    this.addActionError("Directory filter is left blank. Please select at least one Directory");
                    isError = Boolean.TRUE;
                }
                if ((number = this.limitDays) < 1L) {
                    isError = Boolean.TRUE;
                    this.addActionError("Invalid Number of Days. The Inactive number of days must be more than 1 day. :" + number);
                    LOGGER.debug((Object)("Entered Invalid number :" + number));
                    return isError;
                }
                if (this.daysAfterUserCreation < 1L) {
                    this.addActionError("Invalid Number of Days. The number of days after user creation must be more than 1 day.");
                    isError = Boolean.TRUE;
                }
                if (this.scheduler_days < 1L) {
                    this.addActionError("Invalid Number of Days. The Scheduler time must be more than 1 day.");
                    isError = Boolean.TRUE;
                    LOGGER.error((Object)("Entered Invalid number :" + this.scheduler_days));
                }
                if (this.autodeactivatecheck == Boolean.TRUE && (this.mailNotification == Boolean.TRUE || this.sendMailToNeverLoggedInUsers == Boolean.TRUE) && this.mailServerManager.getSmtpMailServers().isEmpty()) {
                    isError = Boolean.TRUE;
                    this.addActionError("Please configure mail server.");
                    LOGGER.debug((Object)"Mail server configuration is empty.");
                }
                if (Boolean.valueOf(this.enableLicenseLimitAlert).booleanValue()) {
                    if (Integer.parseInt(this.userLicenseLimit) <= this.totalLicensedUsers && !this.userLicenseLimit.equals("0")) {
                        this.addActionError("User license limit should not be less than the total number of licensed users.");
                        LOGGER.error((Object)"User License Limit is less than total licensed users size.");
                        isError = Boolean.TRUE;
                    }
                    if (this.mailServerManager.getSmtpMailServers().isEmpty()) {
                        this.addActionError("Please configure mail server.");
                        LOGGER.debug((Object)"Mail server configuration is empty.");
                        isError = Boolean.TRUE;
                    }
                }
            }
            catch (Exception e) {
                isError = Boolean.TRUE;
                this.addActionError("Please enter valid Number. ");
                LOGGER.debug((Object)"you have enter negative or zero number ");
                return isError;
            }
        }
        if (isError.booleanValue()) {
            this.initalization();
            return isError;
        }
        return isError;
    }

    public String execute() throws Exception {
        ConfluenceUser loggedInAdmin;
        LOGGER.debug((Object)"inside UserDeactivateAction doExecute ");
        SimpleXsrfTokenGenerator tokenGenerator = new SimpleXsrfTokenGenerator();
        this.atl_token = tokenGenerator.generateToken(this.getCurrentRequest());
        this.fetchDetailsFromRequest();
        this.smtpServers = this.mailServerManager.getSmtpMailServers();
        LOGGER.debug((Object)("smtpServer : " + this.smtpServers));
        for (SMTPMailServer smtpServer : this.smtpServers) {
            String name = smtpServer.getName();
            this.emailServers.add(name);
        }
        LOGGER.debug((Object)("emailservers in confluence : " + this.emailServers));
        if (!this.userManagementUtility.isLicenseValid().booleanValue()) {
            LOGGER.debug((Object)"Invalid License ");
            return "invalid";
        }
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        this.totalLicensedUsers = this.userChecker.getNumberOfRegisteredUsers();
        if (this.adminsForAlert.isEmpty() && (loggedInAdmin = AuthenticatedUserThreadLocal.get()) != null) {
            this.adminsForAlert = loggedInAdmin.getEmail();
            if (((ArrayList)this.settings.getSelectedAdminUserList()).isEmpty()) {
                this.settings.setSelectedAdminUserList(new ArrayList<String>(Collections.singletonList(this.adminsForAlert)));
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.autoActivateSubmited)) {
            this.settings.setReActivateUser(this.reActivateUser);
            if (this.addGroupsToInactive == null) {
                this.addGroupsToInactive = false;
            }
            if (this.removeGroupsFromInactive == null) {
                this.removeGroupsFromInactive = false;
            }
            if (this.addGroupsToActiveUser == null) {
                this.addGroupsToActiveUser = false;
            }
            if (this.ruleBaseGroupMapping == null) {
                this.ruleBaseGroupMapping = false;
            }
            if (this.groupCondition == null) {
                this.groupCondition = "";
            }
            if (this.addGroupBaseOnRule == null) {
                this.addGroupBaseOnRule = "";
            }
            if ((this.addGroups == null || this.addGroups.isEmpty()) && this.addGroupsToInactive.booleanValue()) {
                this.isGroupsEmpty = true;
                LOGGER.debug((Object)"Group list are empty...");
            } else {
                this.addGroupsList = this.settings.convertSelect2StringToList(this.addGroups);
                this.settings.setAddGroupsToInactive(this.addGroupsToInactive);
                this.settings.setAddGroups(this.addGroupsList);
            }
            if ((this.removeGroups == null || this.removeGroups.isEmpty()) && this.removeGroupsFromInactive.booleanValue()) {
                this.isGroupsEmpty = true;
                LOGGER.debug((Object)"Group list are empty...");
            } else {
                this.removeGroupsList = this.settings.convertSelect2StringToList(this.removeGroups);
                this.settings.setRemoveGroupsFromInactive(this.removeGroupsFromInactive);
                this.settings.setRemoveGroups(this.removeGroupsList);
            }
            if (this.groupsAssignToActiveUser.isEmpty() && this.addGroupsToActiveUser.booleanValue()) {
                this.groupEmptyForActiveUser = true;
                LOGGER.debug((Object)"groups added to active users are empty!");
            } else {
                this.settings.setAddGroupsToActiveUsers(this.addGroupsToActiveUser);
                this.groupsListAssignToActiveUser = this.settings.convertSelect2StringToList(this.groupsAssignToActiveUser);
                this.settings.setGroupsAssignToActiveUser(this.groupsListAssignToActiveUser);
            }
            if ((this.groupCondition.isEmpty() || this.addGroupBaseOnRule.isEmpty()) && this.ruleBaseGroupMapping.booleanValue()) {
                this.groupEmptyForRuleBaseMapping = true;
            } else {
                this.settings.setRuleBaseGroupMapping(this.ruleBaseGroupMapping);
                this.groupConditionList = this.settings.convertSelect2StringToList(this.groupCondition);
                this.addGroupBaseOnRuleList = this.settings.convertSelect2StringToList(this.addGroupBaseOnRule);
                this.settings.setGroupCondition(this.groupConditionList);
                this.settings.setAddGroupBaseOnRule(this.addGroupBaseOnRuleList);
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.autoDeactivateSubmited) && !BooleanUtils.toBoolean((Boolean)this.doValidate())) {
            if (this.enableAutoRemoveFromGroup == null) {
                this.enableAutoRemoveFromGroup = false;
            }
            if (this.enableAutoAddGroupToUser == null) {
                this.enableAutoAddGroupToUser = false;
            }
            if (this.autodeactivatecheck == null) {
                this.autodeactivatecheck = false;
            }
            if (this.neverLoggedinUsers == null) {
                this.neverLoggedinUsers = false;
            }
            if (this.sendMailToNeverLoggedInUsers == null) {
                this.sendMailToNeverLoggedInUsers = false;
            }
            if (this.mailNotification == null) {
                this.mailNotification = false;
            }
            if (this.mailPeriod == null) {
                this.mailPeriod = "1";
            }
            if (this.mailPeriodForNeverLoggedInUsers == null) {
                this.mailPeriodForNeverLoggedInUsers = "1";
            }
            if (this.enableExcludeGroups == null) {
                this.enableExcludeGroups = false;
            }
            if (this.enableLicenseLimitAlert == null) {
                this.enableLicenseLimitAlert = false;
            }
            if (this.userLicenseLimit == null) {
                this.userLicenseLimit = "0";
            }
            this.directoryFilterList = this.settings.convertSelect2StringToList(this.directoryFilter);
            this.excludeGroupsList = this.settings.convertSelect2StringToList(this.excludeGroups);
            this.autoRemoveGroupsList = this.settings.convertSelect2StringToList(this.autoRemoveGroups);
            this.autoAddGroupsList = this.settings.convertSelect2StringToList(this.autoAddGroups);
            this.selectedAdminList = this.settings.convertSelect2StringToList(this.adminsForAlert);
            if (this.autoRemoveGroupsList.isEmpty()) {
                this.enableAutoRemoveFromGroup = false;
            }
            if (this.autoAddGroupsList.isEmpty()) {
                this.enableAutoAddGroupToUser = false;
            }
            if (this.customSchedulerTimeHour == 0L) {
                this.customSchedulerTimeHour = 1L;
            }
            if (this.customSchedulerTimeMinute == 0L) {
                this.customSchedulerTimeMinute = 1L;
            }
            this.userManagementPluginHandler.saveUserManagementSettings(this.limitDays, this.autodeactivatecheck, this.enableAutoRemoveFromGroup, this.autoRemoveGroupsList, this.neverLoggedinUsers, this.daysAfterUserCreation, this.scheduler_days, this.enableExcludeGroups, this.excludeGroupsList, this.customSchedulerTimeHour, this.customSchedulerTimeMinute, this.previousSchedulerFlag, false, 0L, this.mailNotification, this.mailPeriod, this.mailSubject, this.emailTemplate, this.mailServer, this.usernameSuffix, false, this.sendMailToNeverLoggedInUsers, this.mailServerForNeverLoggedIn, this.mailPeriodForNeverLoggedInUsers, this.mailSubForNeverLoggedInUsers, this.mailTextForNeverLoggedInUsers, this.enableDirectoryFilter, this.directoryFilterList, this.enableCrowdROUser, this.enableLicenseLimitAlert, this.userLicenseLimit, this.selectedAdminList, this.mailServerForLicenseAlert, this.enableAutoAddGroupToUser, this.autoAddGroupsList);
            if (this.autodeactivatecheck.booleanValue() || this.enableAutoRemoveFromGroup.booleanValue() || this.enableAutoAddGroupToUser.booleanValue()) {
                this.settings.setPreviousSchedulerFlag(true);
                LOGGER.debug((Object)" saveUserManagementSettings : Schedule Task");
                this.userDeactivaterScheduler.schedule();
            } else if (!(this.autodeactivatecheck.booleanValue() || this.enableAutoRemoveFromGroup.booleanValue() || this.enableAutoAddGroupToUser.booleanValue())) {
                LOGGER.debug((Object)" saveUserManagementSettings : Unschedule Task");
                this.userDeactivaterScheduler.unschedule();
            }
            this.addActionMessage("Configuration saved Successfully", new Object[]{"success", true, null});
        }
        this.initalization();
        return "success";
    }

    public void initalization() throws ParseException {
        LOGGER.debug((Object)"calling initialization...");
        this.contextPath = this.settings.getBaseURL();
        this.limitDays = this.settings.getNumberOfDays();
        this.daysAfterUserCreation = this.settings.getNumberofDaysAfterUserCreation();
        this.autodeactivatecheck = this.settings.getAutoDeActivateUsers();
        this.mailNotification = this.settings.getMailNotification();
        this.mailPeriod = String.valueOf(this.settings.getMailPeriod());
        this.mailSubject = this.settings.getSubText();
        this.emailTemplate = this.settings.getMailText();
        this.neverLoggedinUsers = this.settings.getAutoDeactivateNeverLoggedInUser();
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        this.excludeGroupsList = (ArrayList)this.settings.getExcludeGroups();
        this.scheduler_days = this.settings.getScheduler_days();
        this.enableExcludeGroups = this.settings.getEnableExcludeGroups();
        this.enableAutoRemoveFromGroup = this.settings.getEnableAutoRemoveFromGroup();
        this.enableAutoAddGroupToUser = this.settings.getEnableAutoAddGroupToUser();
        this.autoRemoveGroupsList = (ArrayList)this.settings.getAutoRemoveGroups();
        this.autoAddGroupsList = (ArrayList)this.settings.getAutoAddGroups();
        this.previousSchedulerDate = this.settings.getPrevSchedulerDate();
        this.nextSchedulerDate = this.settings.getNextSchedulerDate();
        this.customSchedulerTimeHour = this.settings.getCustomSchedulerTimeHour();
        this.customSchedulerTimeMinute = this.settings.getCustomSchedulerTimeMinute();
        this.previousSchedulerFlag = this.settings.getPreviousSchedulerFlag();
        this.reActivateUser = this.settings.getReActivateUser();
        this.addGroupsToInactive = this.settings.getAddGroupsToInactive();
        this.addGroupsList = (ArrayList)this.settings.getAddGroups();
        this.removeGroupsFromInactive = this.settings.getRemoveGroupsFromInactive();
        this.removeGroupsList = (ArrayList)this.settings.getRemoveGroups();
        this.addGroupsToActiveUser = this.settings.getAddGroupsToActiveUsers();
        this.groupsListAssignToActiveUser = (ArrayList)this.settings.getGroupsAssignToActiveUser();
        this.mailServer = this.settings.getMailServer();
        this.usernameSuffix = this.settings.getUsernameSuffix();
        this.sendMailToNeverLoggedInUsers = this.settings.getSendMailToNeverLoggedInUsers();
        this.mailServerForNeverLoggedIn = this.settings.getMailServerForNeverLoggedIn();
        this.mailPeriodForNeverLoggedInUsers = this.settings.getMailPeriodForNeverLoggedInUsers();
        this.mailSubForNeverLoggedInUsers = this.settings.getMailSubForNeverLoggedInUsers();
        this.mailTextForNeverLoggedInUsers = this.settings.getMailTextForNeverLoggedInUsers();
        this.enableDirectoryFilter = this.settings.getEnableDirectoryFilter();
        this.directoryFilterList = (ArrayList)this.settings.getDirectoryFilterList();
        this.enableLicenseLimitAlert = this.settings.getEnableLicenseLimitAlert();
        this.userLicenseLimit = this.settings.getUserLicenseLimit();
        this.adminsForAlert = String.join((CharSequence)",", (ArrayList)this.settings.getSelectedAdminUserList());
        this.mailServerForLicenseAlert = this.settings.getMailServerForLicenseAlert();
        this.enableCrowdROUser = this.settings.getEnableCrowdROUser();
        this.groupConditionList = (ArrayList)this.settings.getGroupCondition();
        this.addGroupBaseOnRuleList = (ArrayList)this.settings.getAddGroupBaseOnRule();
        this.ruleBaseGroupMapping = this.settings.getRuleBaseGroupMapping();
    }

    public void fetchDetailsFromRequest() {
        HttpServletRequest request = this.getCurrentRequest();
        this.autoActivateSubmited = Boolean.valueOf(request.getParameter("autoActivateSubmited"));
        this.reActivateUser = Boolean.valueOf(request.getParameter("reActivateUser"));
        this.addGroupsToInactive = Boolean.valueOf(request.getParameter("addGroupsToInactive"));
        this.addGroups = request.getParameter("addGroups");
        this.removeGroupsFromInactive = Boolean.valueOf(request.getParameter("removeGroupsFromInactive"));
        this.removeGroups = request.getParameter("removeGroups");
        this.addGroupsToActiveUser = Boolean.valueOf(request.getParameter("addGroupsToActiveUser"));
        this.groupsAssignToActiveUser = request.getParameter("groupsAssignToActiveUser");
        this.autodeactivatecheck = Boolean.valueOf(request.getParameter("autodeactivatecheck"));
        this.autoDeactivateSubmited = Boolean.valueOf(request.getParameter("autoDeactivateSubmited"));
        this.usernameSuffix = request.getParameter("usernameSuffix");
        this.enableAutoRemoveFromGroup = Boolean.valueOf(request.getParameter("enableAutoRemoveFromGroup"));
        this.enableAutoAddGroupToUser = Boolean.valueOf(request.getParameter("enableAutoAddGroupToUser"));
        this.autoRemoveGroups = request.getParameter("autoRemoveGroups");
        this.autoAddGroups = request.getParameter("autoAddGroups");
        if (request.getParameter("limitDays") != null) {
            this.limitDays = Long.parseLong(request.getParameter("limitDays"));
        }
        if (request.getParameter("ruleBaseGroupMapping") != null) {
            this.ruleBaseGroupMapping = Boolean.valueOf(request.getParameter("ruleBaseGroupMapping"));
            this.groupCondition = request.getParameter("groupCondition");
            this.addGroupBaseOnRule = request.getParameter("addGroupBaseOnRule");
        }
        this.enableCrowdROUser = Boolean.valueOf(request.getParameter("enableCrowdROUser"));
        this.mailNotification = Boolean.valueOf(request.getParameter("mailNotification"));
        this.mailServer = request.getParameter("mailServer");
        this.mailPeriod = request.getParameter("mailPeriod");
        this.mailSubject = request.getParameter("mailSubject");
        this.emailTemplate = request.getParameter("emailTemplate");
        this.neverLoggedinUsers = Boolean.valueOf(request.getParameter("neverLoggedinUsers"));
        if (request.getParameter("daysAfterUserCreation") != null) {
            this.daysAfterUserCreation = Long.parseLong(request.getParameter("daysAfterUserCreation"));
        }
        this.sendMailToNeverLoggedInUsers = Boolean.valueOf(request.getParameter("sendMailToNeverLoggedInUsers"));
        this.mailServerForNeverLoggedIn = request.getParameter("mailServerForNeverLoggedIn");
        this.mailPeriodForNeverLoggedInUsers = request.getParameter("mailPeriodForNeverLoggedInUsers");
        this.mailSubForNeverLoggedInUsers = request.getParameter("mailSubForNeverLoggedInUsers");
        this.mailTextForNeverLoggedInUsers = request.getParameter("mailTextForNeverLoggedInUsers");
        this.enableDirectoryFilter = Boolean.valueOf(request.getParameter("enableDirectoryFilter"));
        this.directoryFilter = request.getParameter("directoryFilter");
        this.enableLicenseLimitAlert = Boolean.valueOf(request.getParameter("enableLicenseLimitAlert"));
        this.mailServerForLicenseAlert = request.getParameter("mailServerForLicenseAlert");
        this.userLicenseLimit = request.getParameter("userLicenseLimit");
        if (request.getParameter("adminsForAlert") != null) {
            this.adminsForAlert = request.getParameter("adminsForAlert");
        }
        this.enableExcludeGroups = Boolean.valueOf(request.getParameter("enableExcludeGroups"));
        this.excludeGroups = request.getParameter("excludeGroups");
        if (request.getParameter("customSchedulerTimeHour") != null) {
            this.customSchedulerTimeHour = Long.parseLong(request.getParameter("customSchedulerTimeHour"));
        }
        if (request.getParameter("customSchedulerTimeMinute") != null) {
            this.customSchedulerTimeMinute = Long.parseLong(request.getParameter("customSchedulerTimeMinute"));
        }
        if (request.getParameter("scheduler_days") != null) {
            this.scheduler_days = Long.parseLong(request.getParameter("scheduler_days"));
        }
    }

    @Generated
    public Boolean getAutodeactivatecheck() {
        return this.autodeactivatecheck;
    }

    @Generated
    public String getUsernameSuffix() {
        return this.usernameSuffix;
    }

    @Generated
    public UserManagementPluginHandler getUserManagementPluginHandler() {
        return this.userManagementPluginHandler;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    @Generated
    public MailServerManager getMailServerManager() {
        return this.mailServerManager;
    }

    @Generated
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.userManagementUtility;
    }

    @Generated
    public Boolean getEnableAutoRemoveFromGroup() {
        return this.enableAutoRemoveFromGroup;
    }

    @Generated
    public Boolean getEnableAutoAddGroupToUser() {
        return this.enableAutoAddGroupToUser;
    }

    @Generated
    public long getLimitDays() {
        return this.limitDays;
    }

    @Generated
    public String getContextPath() {
        return this.contextPath;
    }

    @Generated
    public Boolean getMailNotification() {
        return this.mailNotification;
    }

    @Generated
    public ArrayList<String> getEmailServers() {
        return this.emailServers;
    }

    @Generated
    public String getMailPeriod() {
        return this.mailPeriod;
    }

    @Generated
    public String getMailSubject() {
        return this.mailSubject;
    }

    @Generated
    public String getEmailTemplate() {
        return this.emailTemplate;
    }

    @Generated
    public Boolean getNeverLoggedinUsers() {
        return this.neverLoggedinUsers;
    }

    @Generated
    public long getDaysAfterUserCreation() {
        return this.daysAfterUserCreation;
    }

    @Generated
    public Boolean getSendMailToNeverLoggedInUsers() {
        return this.sendMailToNeverLoggedInUsers;
    }

    @Generated
    public Boolean getAutoDeactivateSubmited() {
        return this.autoDeactivateSubmited;
    }

    @Generated
    public Boolean getAutoActivateSubmited() {
        return this.autoActivateSubmited;
    }

    @Generated
    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    @Generated
    public Boolean getEnableExcludeGroups() {
        return this.enableExcludeGroups;
    }

    @Generated
    public String getMailServer() {
        return this.mailServer;
    }

    @Generated
    public String getMailServerForNeverLoggedIn() {
        return this.mailServerForNeverLoggedIn;
    }

    @Generated
    public String getMailPeriodForNeverLoggedInUsers() {
        return this.mailPeriodForNeverLoggedInUsers;
    }

    @Generated
    public String getMailSubForNeverLoggedInUsers() {
        return this.mailSubForNeverLoggedInUsers;
    }

    @Generated
    public String getMailTextForNeverLoggedInUsers() {
        return this.mailTextForNeverLoggedInUsers;
    }

    @Generated
    public String getExcludeGroups() {
        return this.excludeGroups;
    }

    @Generated
    public long getScheduler_days() {
        return this.scheduler_days;
    }

    @Generated
    public Date getPreviousSchedulerDate() {
        return this.previousSchedulerDate;
    }

    @Generated
    public Date getNextSchedulerDate() {
        return this.nextSchedulerDate;
    }

    @Generated
    public ArrayList<String> getExcludeGroupsList() {
        return this.excludeGroupsList;
    }

    @Generated
    public Boolean getReActivateUser() {
        return this.reActivateUser;
    }

    @Generated
    public Boolean getAddGroupsToInactive() {
        return this.addGroupsToInactive;
    }

    @Generated
    public String getAddGroups() {
        return this.addGroups;
    }

    @Generated
    public ArrayList<String> getAddGroupsList() {
        return this.addGroupsList;
    }

    @Generated
    public Boolean getRemoveGroupsFromInactive() {
        return this.removeGroupsFromInactive;
    }

    @Generated
    public String getRemoveGroups() {
        return this.removeGroups;
    }

    @Generated
    public ArrayList<String> getRemoveGroupsList() {
        return this.removeGroupsList;
    }

    @Generated
    public Boolean getIsGroupsEmpty() {
        return this.isGroupsEmpty;
    }

    @Generated
    public Boolean getAddGroupsToActiveUser() {
        return this.addGroupsToActiveUser;
    }

    @Generated
    public String getGroupsAssignToActiveUser() {
        return this.groupsAssignToActiveUser;
    }

    @Generated
    public ArrayList<String> getGroupsListAssignToActiveUser() {
        return this.groupsListAssignToActiveUser;
    }

    @Generated
    public Boolean getGroupEmptyForActiveUser() {
        return this.groupEmptyForActiveUser;
    }

    @Generated
    public String getAutoRemoveGroups() {
        return this.autoRemoveGroups;
    }

    @Generated
    public ArrayList<String> getAutoRemoveGroupsList() {
        return this.autoRemoveGroupsList;
    }

    @Generated
    public String getAutoAddGroups() {
        return this.autoAddGroups;
    }

    @Generated
    public ArrayList<String> getAutoAddGroupsList() {
        return this.autoAddGroupsList;
    }

    @Generated
    public String getAtl_token() {
        return this.atl_token;
    }

    @Generated
    public Boolean getRuleBaseGroupMapping() {
        return this.ruleBaseGroupMapping;
    }

    @Generated
    public String getGroupCondition() {
        return this.groupCondition;
    }

    @Generated
    public String getAddGroupBaseOnRule() {
        return this.addGroupBaseOnRule;
    }

    @Generated
    public Boolean getGroupEmptyForRuleBaseMapping() {
        return this.groupEmptyForRuleBaseMapping;
    }

    @Generated
    public ArrayList<String> getGroupConditionList() {
        return this.groupConditionList;
    }

    @Generated
    public ArrayList<String> getAddGroupBaseOnRuleList() {
        return this.addGroupBaseOnRuleList;
    }

    @Generated
    public List<SMTPMailServer> getSmtpServers() {
        return this.smtpServers;
    }

    @Generated
    public long getCustomSchedulerTimeHour() {
        return this.customSchedulerTimeHour;
    }

    @Generated
    public long getCustomSchedulerTimeMinute() {
        return this.customSchedulerTimeMinute;
    }

    @Generated
    public Boolean getPreviousSchedulerFlag() {
        return this.previousSchedulerFlag;
    }

    @Generated
    public Boolean getEnableLicenseLimitAlert() {
        return this.enableLicenseLimitAlert;
    }

    @Generated
    public String getMailServerForLicenseAlert() {
        return this.mailServerForLicenseAlert;
    }

    @Generated
    public String getUserLicenseLimit() {
        return this.userLicenseLimit;
    }

    @Generated
    public Integer getTotalLicensedUsers() {
        return this.totalLicensedUsers;
    }

    @Generated
    public UserChecker getUserChecker() {
        return this.userChecker;
    }

    @Generated
    public String getAdminsForAlert() {
        return this.adminsForAlert;
    }

    @Generated
    public ArrayList<String> getSelectedAdminList() {
        return this.selectedAdminList;
    }

    @Generated
    public Boolean getEnableCrowdROUser() {
        return this.enableCrowdROUser;
    }

    @Generated
    public Boolean getEnableDirectoryFilter() {
        return this.enableDirectoryFilter;
    }

    @Generated
    public String getDirectoryFilter() {
        return this.directoryFilter;
    }

    @Generated
    public ArrayList<String> getDirectoryFilterList() {
        return this.directoryFilterList;
    }

    @Generated
    public void setAutodeactivatecheck(Boolean autodeactivatecheck) {
        this.autodeactivatecheck = autodeactivatecheck;
    }

    @Generated
    public void setUsernameSuffix(String usernameSuffix) {
        this.usernameSuffix = usernameSuffix;
    }

    @Generated
    public void setUserManagementPluginHandler(UserManagementPluginHandler userManagementPluginHandler) {
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    @Generated
    public void setEnableAutoRemoveFromGroup(Boolean enableAutoRemoveFromGroup) {
        this.enableAutoRemoveFromGroup = enableAutoRemoveFromGroup;
    }

    @Generated
    public void setEnableAutoAddGroupToUser(Boolean enableAutoAddGroupToUser) {
        this.enableAutoAddGroupToUser = enableAutoAddGroupToUser;
    }

    @Generated
    public void setLimitDays(long limitDays) {
        this.limitDays = limitDays;
    }

    @Generated
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Generated
    public void setMailNotification(Boolean mailNotification) {
        this.mailNotification = mailNotification;
    }

    @Generated
    public void setEmailServers(ArrayList<String> emailServers) {
        this.emailServers = emailServers;
    }

    @Generated
    public void setMailPeriod(String mailPeriod) {
        this.mailPeriod = mailPeriod;
    }

    @Generated
    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    @Generated
    public void setEmailTemplate(String emailTemplate) {
        this.emailTemplate = emailTemplate;
    }

    @Generated
    public void setNeverLoggedinUsers(Boolean neverLoggedinUsers) {
        this.neverLoggedinUsers = neverLoggedinUsers;
    }

    @Generated
    public void setDaysAfterUserCreation(long daysAfterUserCreation) {
        this.daysAfterUserCreation = daysAfterUserCreation;
    }

    @Generated
    public void setSendMailToNeverLoggedInUsers(Boolean sendMailToNeverLoggedInUsers) {
        this.sendMailToNeverLoggedInUsers = sendMailToNeverLoggedInUsers;
    }

    @Generated
    public void setAutoDeactivateSubmited(Boolean autoDeactivateSubmited) {
        this.autoDeactivateSubmited = autoDeactivateSubmited;
    }

    @Generated
    public void setAutoActivateSubmited(Boolean autoActivateSubmited) {
        this.autoActivateSubmited = autoActivateSubmited;
    }

    @Generated
    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    @Generated
    public void setEnableExcludeGroups(Boolean enableExcludeGroups) {
        this.enableExcludeGroups = enableExcludeGroups;
    }

    @Generated
    public void setMailServer(String mailServer) {
        this.mailServer = mailServer;
    }

    @Generated
    public void setMailServerForNeverLoggedIn(String mailServerForNeverLoggedIn) {
        this.mailServerForNeverLoggedIn = mailServerForNeverLoggedIn;
    }

    @Generated
    public void setMailPeriodForNeverLoggedInUsers(String mailPeriodForNeverLoggedInUsers) {
        this.mailPeriodForNeverLoggedInUsers = mailPeriodForNeverLoggedInUsers;
    }

    @Generated
    public void setMailSubForNeverLoggedInUsers(String mailSubForNeverLoggedInUsers) {
        this.mailSubForNeverLoggedInUsers = mailSubForNeverLoggedInUsers;
    }

    @Generated
    public void setMailTextForNeverLoggedInUsers(String mailTextForNeverLoggedInUsers) {
        this.mailTextForNeverLoggedInUsers = mailTextForNeverLoggedInUsers;
    }

    @Generated
    public void setExcludeGroups(String excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    @Generated
    public void setScheduler_days(long scheduler_days) {
        this.scheduler_days = scheduler_days;
    }

    @Generated
    public void setPreviousSchedulerDate(Date previousSchedulerDate) {
        this.previousSchedulerDate = previousSchedulerDate;
    }

    @Generated
    public void setNextSchedulerDate(Date nextSchedulerDate) {
        this.nextSchedulerDate = nextSchedulerDate;
    }

    @Generated
    public void setExcludeGroupsList(ArrayList<String> excludeGroupsList) {
        this.excludeGroupsList = excludeGroupsList;
    }

    @Generated
    public void setReActivateUser(Boolean reActivateUser) {
        this.reActivateUser = reActivateUser;
    }

    @Generated
    public void setAddGroupsToInactive(Boolean addGroupsToInactive) {
        this.addGroupsToInactive = addGroupsToInactive;
    }

    @Generated
    public void setAddGroups(String addGroups) {
        this.addGroups = addGroups;
    }

    @Generated
    public void setAddGroupsList(ArrayList<String> addGroupsList) {
        this.addGroupsList = addGroupsList;
    }

    @Generated
    public void setRemoveGroupsFromInactive(Boolean removeGroupsFromInactive) {
        this.removeGroupsFromInactive = removeGroupsFromInactive;
    }

    @Generated
    public void setRemoveGroups(String removeGroups) {
        this.removeGroups = removeGroups;
    }

    @Generated
    public void setRemoveGroupsList(ArrayList<String> removeGroupsList) {
        this.removeGroupsList = removeGroupsList;
    }

    @Generated
    public void setIsGroupsEmpty(Boolean isGroupsEmpty) {
        this.isGroupsEmpty = isGroupsEmpty;
    }

    @Generated
    public void setAddGroupsToActiveUser(Boolean addGroupsToActiveUser) {
        this.addGroupsToActiveUser = addGroupsToActiveUser;
    }

    @Generated
    public void setGroupsAssignToActiveUser(String groupsAssignToActiveUser) {
        this.groupsAssignToActiveUser = groupsAssignToActiveUser;
    }

    @Generated
    public void setGroupsListAssignToActiveUser(ArrayList<String> groupsListAssignToActiveUser) {
        this.groupsListAssignToActiveUser = groupsListAssignToActiveUser;
    }

    @Generated
    public void setGroupEmptyForActiveUser(Boolean groupEmptyForActiveUser) {
        this.groupEmptyForActiveUser = groupEmptyForActiveUser;
    }

    @Generated
    public void setAutoRemoveGroups(String autoRemoveGroups) {
        this.autoRemoveGroups = autoRemoveGroups;
    }

    @Generated
    public void setAutoRemoveGroupsList(ArrayList<String> autoRemoveGroupsList) {
        this.autoRemoveGroupsList = autoRemoveGroupsList;
    }

    @Generated
    public void setAutoAddGroups(String autoAddGroups) {
        this.autoAddGroups = autoAddGroups;
    }

    @Generated
    public void setAutoAddGroupsList(ArrayList<String> autoAddGroupsList) {
        this.autoAddGroupsList = autoAddGroupsList;
    }

    @Generated
    public void setAtl_token(String atl_token) {
        this.atl_token = atl_token;
    }

    @Generated
    public void setRuleBaseGroupMapping(Boolean ruleBaseGroupMapping) {
        this.ruleBaseGroupMapping = ruleBaseGroupMapping;
    }

    @Generated
    public void setGroupCondition(String groupCondition) {
        this.groupCondition = groupCondition;
    }

    @Generated
    public void setAddGroupBaseOnRule(String addGroupBaseOnRule) {
        this.addGroupBaseOnRule = addGroupBaseOnRule;
    }

    @Generated
    public void setGroupEmptyForRuleBaseMapping(Boolean groupEmptyForRuleBaseMapping) {
        this.groupEmptyForRuleBaseMapping = groupEmptyForRuleBaseMapping;
    }

    @Generated
    public void setGroupConditionList(ArrayList<String> groupConditionList) {
        this.groupConditionList = groupConditionList;
    }

    @Generated
    public void setAddGroupBaseOnRuleList(ArrayList<String> addGroupBaseOnRuleList) {
        this.addGroupBaseOnRuleList = addGroupBaseOnRuleList;
    }

    @Generated
    public void setSmtpServers(List<SMTPMailServer> smtpServers) {
        this.smtpServers = smtpServers;
    }

    @Generated
    public void setCustomSchedulerTimeHour(long customSchedulerTimeHour) {
        this.customSchedulerTimeHour = customSchedulerTimeHour;
    }

    @Generated
    public void setCustomSchedulerTimeMinute(long customSchedulerTimeMinute) {
        this.customSchedulerTimeMinute = customSchedulerTimeMinute;
    }

    @Generated
    public void setPreviousSchedulerFlag(Boolean previousSchedulerFlag) {
        this.previousSchedulerFlag = previousSchedulerFlag;
    }

    @Generated
    public void setEnableLicenseLimitAlert(Boolean enableLicenseLimitAlert) {
        this.enableLicenseLimitAlert = enableLicenseLimitAlert;
    }

    @Generated
    public void setMailServerForLicenseAlert(String mailServerForLicenseAlert) {
        this.mailServerForLicenseAlert = mailServerForLicenseAlert;
    }

    @Generated
    public void setUserLicenseLimit(String userLicenseLimit) {
        this.userLicenseLimit = userLicenseLimit;
    }

    @Generated
    public void setTotalLicensedUsers(Integer totalLicensedUsers) {
        this.totalLicensedUsers = totalLicensedUsers;
    }

    @Generated
    public void setUserChecker(UserChecker userChecker) {
        this.userChecker = userChecker;
    }

    @Generated
    public void setAdminsForAlert(String adminsForAlert) {
        this.adminsForAlert = adminsForAlert;
    }

    @Generated
    public void setSelectedAdminList(ArrayList<String> selectedAdminList) {
        this.selectedAdminList = selectedAdminList;
    }

    @Generated
    public void setEnableCrowdROUser(Boolean enableCrowdROUser) {
        this.enableCrowdROUser = enableCrowdROUser;
    }

    @Generated
    public void setEnableDirectoryFilter(Boolean enableDirectoryFilter) {
        this.enableDirectoryFilter = enableDirectoryFilter;
    }

    @Generated
    public void setDirectoryFilter(String directoryFilter) {
        this.directoryFilter = directoryFilter;
    }

    @Generated
    public void setDirectoryFilterList(ArrayList<String> directoryFilterList) {
        this.directoryFilterList = directoryFilterList;
    }
}

