/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.xwork.FileUploadUtils;
import com.atlassian.xwork.SimpleXsrfTokenGenerator;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportExportAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(ImportExportAction.class);
    private ConfluenceUserManagementUtility UserManagementUtility;
    private Boolean maxUsersLicense;
    private Integer totalUpdations = 0;
    private Integer totalCreations = 0;
    private DirectoryManager directoryManager;
    private UserManager userManager;
    private UserAccessor userAccessor;
    private CrowdDirectoryService crowdDirectoryService;
    private CrowdService crowdService;
    private Boolean usermanagementuploadSubmitted;
    private Boolean uploadSuccessful = Boolean.FALSE;
    private UserManagementPluginHandler pluginHandler;
    private Boolean evaluationLicense;
    private String atl_token;

    public ImportExportAction(ConfluenceUserManagementUtility userManagementUtility, DirectoryManager directoryManager, UserAccessor userAccessor, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, UserManagementPluginHandler pluginHandler, UserManager userManager) {
        this.UserManagementUtility = userManagementUtility;
        this.directoryManager = directoryManager;
        this.userAccessor = userAccessor;
        this.crowdDirectoryService = crowdDirectoryService;
        this.crowdService = crowdService;
        this.pluginHandler = pluginHandler;
        this.userManager = userManager;
    }

    public String execute() {
        LOGGER.debug((Object)" ImportExportAction inside Do execute");
        SimpleXsrfTokenGenerator tokenGenerator = new SimpleXsrfTokenGenerator();
        this.atl_token = tokenGenerator.generateToken(this.getCurrentRequest());
        HttpServletRequest req = this.getCurrentRequest();
        if (this.usermanagementuploadSubmitted == null) {
            this.usermanagementuploadSubmitted = Boolean.FALSE;
        }
        if (!this.UserManagementUtility.isLicenseValid().booleanValue()) {
            LOGGER.debug((Object)"Invalid License ");
            return "invalid";
        }
        this.usermanagementuploadSubmitted = Boolean.valueOf(req.getParameter("usermanagementuploadSubmitted"));
        if (this.usermanagementuploadSubmitted != null && this.usermanagementuploadSubmitted.booleanValue()) {
            LOGGER.debug((Object)"Inside usermanagementuploadSubmitted");
            try {
                this.handleUploadedCSVFile();
                this.uploadSuccessful = Boolean.TRUE;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.maxUsersLicense = this.UserManagementUtility.getMaxUsers() == 0;
        if (!this.maxUsersLicense.booleanValue()) {
            this.evaluationLicense = this.UserManagementUtility.isEvaluationLicense() != false && this.UserManagementUtility.isValidEvaluationLicense() != false ? Boolean.TRUE : Boolean.FALSE;
        }
        return "success";
    }

    private void handleUploadedCSVFile() throws IOException, PermissionException, OperationNotPermittedException, UserNotFoundException, DirectoryNotFoundException, OperationFailedException, InvalidUserException, InvalidCredentialException, UserAlreadyExistsException {
        block63: {
            LOGGER.debug((Object)"handleUploadedCSVFile called");
            CSVReader csvReader = null;
            try {
                FileUploadUtils.UploadedFile file = FileUploadUtils.getSingleUploadedFile();
                if (file.getFile() == null) {
                    LOGGER.error((Object)"Upoaded CSV file is null");
                    this.addActionError("File is Empty");
                    break block63;
                }
                File csvFile = file.getFile();
                LOGGER.debug((Object)("Upoaded CSV : " + csvFile.toString()));
                csvReader = new CSVReader(new FileReader(csvFile));
                int usernameIndex = -1;
                int userEmailIndex = -1;
                int fullNameIndex = -1;
                int groupsIndex = -1;
                int statusIndex = -1;
                int lastLoginTimeIndex = -1;
                int directoryIndex = -1;
                int passwordIndex = -1;
                String[] nextLine = csvReader.readNext();
                if (nextLine != null) {
                    int colCount = nextLine.length;
                    block32: for (int i = 0; i < colCount; ++i) {
                        if (nextLine[i].contains("Username") || nextLine[i].contains("username")) {
                            nextLine[i] = "Username";
                        }
                        switch (nextLine[i].toString().toLowerCase()) {
                            case "username": {
                                usernameIndex = i;
                                continue block32;
                            }
                            case "email": {
                                userEmailIndex = i;
                                continue block32;
                            }
                            case "fullname": {
                                fullNameIndex = i;
                                continue block32;
                            }
                            case "groups": {
                                groupsIndex = i;
                                continue block32;
                            }
                            case "status": {
                                statusIndex = i;
                                continue block32;
                            }
                            case "directory": {
                                directoryIndex = i;
                                continue block32;
                            }
                            case "lastlogindate": {
                                lastLoginTimeIndex = i;
                                continue block32;
                            }
                            case "password": {
                                passwordIndex = i;
                            }
                        }
                    }
                }
                List<String[]> rows = csvReader.readAll();
                LOGGER.debug((Object)("Uploaded CSV file size = " + rows.size()));
                if (rows == null) break block63;
                LOGGER.debug((Object)"CSV file is not null starting thread");
                String password = "";
                ConfluenceUser confluenceUser = null;
                int updations = 0;
                int creations = 0;
                this.totalCreations = creations;
                this.totalUpdations = updations;
                for (int i = 0; i < rows.size(); ++i) {
                    String str;
                    String directory;
                    String groups;
                    String userEmail;
                    String userName;
                    if (usernameIndex != -1) {
                        userName = rows.get(i)[usernameIndex].toString();
                        if (userName.isEmpty()) {
                            LOGGER.error((Object)" Username is empty cant create user  ");
                            continue;
                        }
                    } else {
                        LOGGER.error((Object)" Username is empty cant create user  ");
                        continue;
                    }
                    if (userEmailIndex != -1) {
                        userEmail = rows.get(i)[userEmailIndex].toString();
                        if (userEmail.isEmpty()) {
                            LOGGER.error((Object)" Email is empty cant create user  ");
                            continue;
                        }
                    } else {
                        LOGGER.error((Object)" Email is empty cant create user  ");
                        continue;
                    }
                    String fullName = fullNameIndex != -1 ? rows.get(i)[fullNameIndex].toString() : userName;
                    List<Object> defaultGroupList = new ArrayList();
                    if (groupsIndex != -1) {
                        groups = rows.get(i)[groupsIndex].toString().replaceAll(",+\\s+", ",");
                        if (!groups.isEmpty()) {
                            defaultGroupList = Arrays.asList(StringUtils.split((String)groups, (String)","));
                        } else {
                            groups = "";
                            defaultGroupList = Collections.singletonList("");
                        }
                    } else {
                        groups = "";
                        defaultGroupList = Collections.singletonList("");
                    }
                    String status = statusIndex != -1 ? rows.get(i)[statusIndex].toString() : "";
                    Long directoryId = null;
                    Directory userDirectory = null;
                    if (directoryIndex != -1) {
                        directory = rows.get(i)[directoryIndex].toString();
                        if (!directory.isEmpty()) {
                            try {
                                userDirectory = this.directoryManager.findDirectoryByName(directory.trim());
                                directoryId = userDirectory.getId();
                            }
                            catch (DirectoryNotFoundException e) {
                                LOGGER.error((Object)"Directory of user  Doesn't exist", (Throwable)e);
                                directory = "";
                            }
                        } else {
                            directory = "";
                        }
                    } else {
                        directory = "";
                    }
                    String lastLoginTime = lastLoginTimeIndex != -1 ? rows.get(i)[lastLoginTimeIndex].toString() : "";
                    if (defaultGroupList.size() > 0 && (str = (String)defaultGroupList.get(0)).length() > 0) {
                        str = str.substring(1);
                        defaultGroupList.set(0, str);
                        str = (String)defaultGroupList.get(defaultGroupList.size() - 1);
                        str = str.substring(0, str.length() - 1);
                        defaultGroupList.set(defaultGroupList.size() - 1, str);
                    }
                    if (passwordIndex != -1) {
                        password = rows.get(i)[passwordIndex].toString();
                    }
                    InetAddress ip = InetAddress.getLocalHost();
                    List<Object> groupsKeepAsItIs = defaultGroupList;
                    if (this.userAccessor.exists(userName)) {
                        com.atlassian.crowd.embedded.api.User crowdUser;
                        LOGGER.debug((Object)("User " + userName + " Already Exists. Updating user info."));
                        LOGGER.debug((Object)("user email = " + userEmail + " full name = " + fullName));
                        Boolean isAdmin = Boolean.FALSE;
                        confluenceUser = this.userAccessor.getUserByName(userName);
                        isAdmin = this.permissionManager.isSystemAdministrator((User)confluenceUser);
                        long userDir = this.crowdService.getUser(userName).getDirectoryId();
                        com.atlassian.crowd.model.user.User user = this.directoryManager.findUserByName(userDir, userName);
                        UserTemplate userTemplate = new UserTemplate((com.atlassian.crowd.embedded.api.User)user);
                        if (isAdmin.booleanValue()) continue;
                        if (userTemplate.isActive() && (status.equalsIgnoreCase("Inactive") || status.equalsIgnoreCase("false"))) {
                            LOGGER.debug((Object)("deactivating user from import action :" + (com.atlassian.crowd.embedded.api.User)user));
                            userTemplate.setActive(false);
                            try {
                                this.directoryManager.updateUser(userDir, userTemplate);
                                this.pluginHandler.storeAuditLogs(userName, ip.getHostAddress(), "Imported Users", "User Deactivated", "Successful Logs");
                            }
                            catch (Exception e) {
                                LOGGER.debug((Object)("Error while deactivate user: " + userTemplate.getName() + ". Exception: " + e));
                            }
                        }
                        if (!userTemplate.isActive() && (status.equalsIgnoreCase("Active") || status.equalsIgnoreCase("true"))) {
                            LOGGER.debug((Object)("activating user from import action :" + (com.atlassian.crowd.embedded.api.User)user));
                            userTemplate.setActive(true);
                            try {
                                this.directoryManager.updateUser(userDir, userTemplate);
                                this.pluginHandler.storeAuditLogs(userName, ip.getHostAddress(), "Imported Users", "User Activated", "Successful Logs");
                            }
                            catch (Exception e) {
                                LOGGER.error((Object)("Error while Activate user: " + userTemplate.getName() + ". Exception: " + e));
                            }
                        }
                        if (this.canGroupsBeUpdated(confluenceUser) && groupsIndex != -1) {
                            List currentGroups = this.userAccessor.getGroupNames((User)confluenceUser);
                            LOGGER.debug((Object)("Current Groups of the user " + currentGroups.toString()));
                            ArrayList<String> groupsToRemove = new ArrayList<String>();
                            for (String groupName : currentGroups) {
                                if (groupsKeepAsItIs.contains(groupName) || groupName.contains("confluence-administrators")) continue;
                                groupsToRemove.add(groupName);
                            }
                            LOGGER.debug((Object)("Groups to Remove from " + userName + " are :- " + ((Object)groupsToRemove).toString()));
                            this.removeUserFromGroups(userName, groupsToRemove, ip.getHostAddress());
                            ArrayList groupsToAssign = (ArrayList)this.createAndAssignNewGroupsUser(groupsKeepAsItIs);
                            if (!currentGroups.toString().equals(groupsToAssign.toString())) {
                                LOGGER.debug((Object)("groupsToAssign := " + groupsToAssign));
                                this.addUserToGroups(userName, groupsToAssign);
                                this.pluginHandler.storeAuditLogs(userName, ip.getHostAddress(), "Imported Users", "User Updated. Added User to Groups:-" + groupsToAssign, "Successful Logs");
                                this.totalUpdations = ++updations;
                            }
                        }
                        if ((crowdUser = this.crowdService.getUser(user.getName())).getDisplayName().equals(fullName) && crowdUser.getEmailAddress().equals(userEmail)) continue;
                        userTemplate.setEmailAddress(userEmail);
                        userTemplate.setDisplayName(fullName);
                        this.directoryManager.updateUser(userDir, userTemplate);
                        this.pluginHandler.storeAuditLogs(userName, ip.getHostAddress(), "Imported Users", "User Updated. Updated User Profile. ", "Successful Logs");
                        this.totalUpdations = ++updations;
                        continue;
                    }
                    LOGGER.debug((Object)("User " + userName + " does Not Exist. Creating User "));
                    if (directory.isEmpty()) {
                        Directory internalDir = this.directoryManager.findDirectoryByName("Confluence Internal Directory");
                        directoryId = internalDir.getId();
                    }
                    try {
                        UserTemplate newUser = new UserTemplate(userName, directoryId.longValue());
                        this.pluginHandler.storeAuditLogs(userName, ip.getHostAddress(), "Imported Users", "User Created Successfuly. ", "Successful Logs");
                        newUser.setDisplayName(fullName);
                        newUser.setEmailAddress(userEmail);
                        newUser.setDirectoryId(directoryId.longValue());
                        if (status.equalsIgnoreCase("Inactive") || status.equalsIgnoreCase("false")) {
                            newUser.setActive(Boolean.FALSE.booleanValue());
                        } else {
                            newUser.setActive(Boolean.TRUE.booleanValue());
                        }
                        this.directoryManager.addUser(directoryId.longValue(), newUser, PasswordCredential.NONE);
                        if (!password.isEmpty()) {
                            try {
                                LOGGER.debug((Object)"This is used for alter password ");
                                this.userManager.alterPassword(this.userManager.getUser(newUser.getName()), password);
                            }
                            catch (Exception e) {
                                LOGGER.error((Object)("Error while set Password to " + newUser.getName() + " : " + e));
                                throw new RuntimeException(e);
                            }
                        }
                        this.totalCreations = ++creations;
                    }
                    catch (PermissionException e) {
                        e.printStackTrace();
                    }
                    ArrayList groupsToAssignToNewUser = (ArrayList)this.createAndAssignNewGroupsUser(defaultGroupList);
                    this.addUserToGroups(userName, groupsToAssignToNewUser);
                }
                LOGGER.debug((Object)"User Imported Successfully");
                this.addActionError("Users Imported Successfully ", new Object[]{"success", true, null});
                LOGGER.debug((Object)("Updations = " + this.totalUpdations + " Creations = " + this.totalCreations));
            }
            catch (Exception e) {
                LOGGER.error((Object)("error while uploading file " + e));
            }
        }
    }

    private boolean canGroupsBeUpdated(ConfluenceUser confluenceUser) {
        LOGGER.debug((Object)"checking if groups of the user can be updated");
        com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(confluenceUser.getName());
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        return directory != null && directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    private void removeUserFromGroups(String username, List<String> groupsToRemove, String ip) throws OperationNotPermittedException {
        LOGGER.debug((Object)"Removing user from groups");
        com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(username);
        for (String group : groupsToRemove) {
            LOGGER.debug((Object)("Removing user " + username + " from " + group));
            LOGGER.debug((Object)("Removing user [" + username + "] from group [" + group + "]"));
            Group grp = this.crowdService.getGroup(group);
            this.crowdService.removeUserFromGroup(user, grp);
            this.pluginHandler.storeAuditLogs(username, ip, "Imported Users", "User Updated.. Removed User from Groups:- " + groupsToRemove, "Successful Logs");
        }
    }

    public void addUserToGroups(String username, List<String> groupsToAssign) throws OperationNotPermittedException {
        LOGGER.debug((Object)"Adding user to groups");
        try {
            com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(username);
            for (String group : groupsToAssign) {
                if (group.length() <= 0) continue;
                LOGGER.debug((Object)("Adding user " + username + " to " + group));
                LOGGER.debug((Object)("Adding user [" + username + "] to group [" + group + "]"));
                Group grp = this.crowdService.getGroup(group);
                this.crowdService.addUserToGroup(user, grp);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Error adding user to groups");
            e.printStackTrace();
        }
    }

    private List<String> createAndAssignNewGroupsUser(List<String> roleValuesList) {
        ArrayList<String> groupsToAssign = new ArrayList<String>();
        try {
            Directory internalDir = this.UserManagementUtility.getInternalDirectory();
            if (internalDir != null) {
                for (String groupsName : roleValuesList) {
                    if (groupsName.trim().isEmpty() || this.crowdService.getGroup(groupsName.trim()) != null) continue;
                    LOGGER.debug((Object)("Creating new Group with name : " + groupsName));
                    GroupTemplate groupTemplate = new GroupTemplate(groupsName.trim(), internalDir.getId().longValue());
                    try {
                        this.directoryManager.addGroup(internalDir.getId().longValue(), groupTemplate);
                        groupsToAssign.add(groupsName);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Unable to add group '" + groupTemplate.getName() + "' in directory '" + internalDir.getName() + "'. Cause: " + e));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
        return groupsToAssign;
    }

    @Generated
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.UserManagementUtility;
    }

    @Generated
    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    @Generated
    public Integer getTotalUpdations() {
        return this.totalUpdations;
    }

    @Generated
    public Integer getTotalCreations() {
        return this.totalCreations;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public UserManager getUserManager() {
        return this.userManager;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public CrowdDirectoryService getCrowdDirectoryService() {
        return this.crowdDirectoryService;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public Boolean getUsermanagementuploadSubmitted() {
        return this.usermanagementuploadSubmitted;
    }

    @Generated
    public Boolean getUploadSuccessful() {
        return this.uploadSuccessful;
    }

    @Generated
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @Generated
    public Boolean getEvaluationLicense() {
        return this.evaluationLicense;
    }

    @Generated
    public String getAtl_token() {
        return this.atl_token;
    }

    @Generated
    public void setUserManagementUtility(ConfluenceUserManagementUtility UserManagementUtility) {
        this.UserManagementUtility = UserManagementUtility;
    }

    @Generated
    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    @Generated
    public void setTotalUpdations(Integer totalUpdations) {
        this.totalUpdations = totalUpdations;
    }

    @Generated
    public void setTotalCreations(Integer totalCreations) {
        this.totalCreations = totalCreations;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setUsermanagementuploadSubmitted(Boolean usermanagementuploadSubmitted) {
        this.usermanagementuploadSubmitted = usermanagementuploadSubmitted;
    }

    @Generated
    public void setUploadSuccessful(Boolean uploadSuccessful) {
        this.uploadSuccessful = uploadSuccessful;
    }

    @Generated
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @Generated
    public void setEvaluationLicense(Boolean evaluationLicense) {
        this.evaluationLicense = evaluationLicense;
    }

    @Generated
    public void setAtl_token(String atl_token) {
        this.atl_token = atl_token;
    }
}

