/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.MoUserUtility;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BulkUserManagementAction
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(BulkUserManagementAction.class);
    private static final String BULK_USER_MANAGEMENT_VM_PATH = "/templates/BulkUserManagement.vm";
    private ConfluenceUserManagementUtility userManagementUtility;
    private UserManagementPluginSettings settings;
    private UserAccessor userAccessor;
    private final TemplateRenderer renderer;
    private LoginManager loginManager;
    private PermissionManager permissionManager;
    private DirectoryManager directoryManager;
    private String usernameSearchKeyword;
    private String startDateFilter;
    private String endDateFilter;
    private Integer numberOfRecordsPerPage;
    private List<User> currentPageUsersList;
    private List<String> numberOfPagesList;
    private Boolean maxUsersLicense;
    private Boolean evaluationLicense;
    private List<User> usernameList;
    private Integer userPerPage;
    private String groupSearchKey;
    private List<String> groupSearchList;
    private String excludeGroupFilter;
    private List<String> excludeGroupFilterList;
    private Boolean userDetailsSubmitted;
    private String userSearchFilter;
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;
    private String startIndexOfPage = "";
    private String endIndexOfPage = "";
    private ContextPathHolder contextPathHolder;
    private String currentDate;
    private List<String> directories;
    private String selectedDirectory = "ALL";
    private Boolean sortByLastLogin = false;
    private String userType;
    private Boolean isAdditionalFilterActive;

    public BulkUserManagementAction(ConfluenceUserManagementUtility userManagementUtility, UserAccessor userAccessor, LoginManager loginManager, DirectoryManager directoryManager, TemplateRenderer renderer, ContextPathHolder contextPathHolder, PermissionManager permissionManager, UserManagementPluginSettings settings) {
        this.userManagementUtility = userManagementUtility;
        this.userAccessor = userAccessor;
        this.loginManager = loginManager;
        this.directoryManager = directoryManager;
        this.renderer = renderer;
        this.contextPathHolder = contextPathHolder;
        this.permissionManager = permissionManager;
        this.settings = settings;
        this.directories = new ArrayList<String>();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug((Object)"inside do post");
        ConfluenceUser confluenceUser = null;
        confluenceUser = AuthenticatedUserThreadLocal.get();
        Boolean isAdmin = Boolean.FALSE;
        if (confluenceUser != null) {
            isAdmin = this.permissionManager.hasPermission((com.atlassian.user.User)confluenceUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
        }
        try {
            List list = this.directoryManager.findAllDirectories();
            ArrayList<String> listNames = new ArrayList<String>();
            listNames.add("All");
            for (Directory x : list) {
                if (!x.isActive()) continue;
                listNames.add(x.getName());
            }
            this.directories = listNames;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Directories were not found:" + e.getMessage()));
        }
        if (isAdmin.booleanValue()) {
            this.userPerPage = req.getParameter("userPerPage") == null ? UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE : Integer.valueOf(Integer.parseInt(req.getParameter("userPerPage")));
            this.userType = req.getParameter("userType") == null ? "All" : req.getParameter("userType");
            String searchKeyword = req.getParameter("usernameSearchKeyword");
            this.usernameSearchKeyword = StringUtils.isNotBlank((CharSequence)searchKeyword) ? searchKeyword.trim() : "";
            this.groupSearchKey = req.getParameter("groupSearchKey");
            this.groupSearchList = Arrays.asList(StringUtils.split((String)this.groupSearchKey, (String)","));
            this.excludeGroupFilter = req.getParameter("excludeGroupFilter");
            this.excludeGroupFilterList = this.excludeGroupFilter == null ? new ArrayList<String>() : Arrays.asList(StringUtils.split((String)this.excludeGroupFilter, (String)","));
            this.startIndexOfPage = req.getParameter("startIndex");
            this.endIndexOfPage = req.getParameter("endIndex");
            this.userSearchFilter = req.getParameter("userSearchFilter");
            this.selectedDirectory = req.getParameter("selectedDirectory");
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
            String[] dateAndTime = expiryDateString.split(" ");
            this.currentDate = dateAndTime[0];
            LOGGER.error((Object)("current date :" + this.currentDate));
            this.startDateFilter = req.getParameter("startDateFilter");
            if (StringUtils.isBlank((CharSequence)this.startDateFilter) || this.startDateFilter == null) {
                this.startDateFilter = "1970-01-01";
            }
            this.endDateFilter = req.getParameter("endDateFilter");
            if (StringUtils.isBlank((CharSequence)this.endDateFilter) || this.endDateFilter == null) {
                this.endDateFilter = this.currentDate;
            }
            if (this.userPerPage == null) {
                this.userPerPage = UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE;
            }
            this.sortByLastLogin = this.settings.getSortByLastLogin();
            this.isAdditionalFilterActive = false;
            this.UserDetails(req, resp);
            HashMap<String, Object> context = this.initializeSAMLConfig();
            resp.setContentType("text/html;charset=utf-8");
            this.renderer.render(BULK_USER_MANAGEMENT_VM_PATH, context, (Writer)resp.getWriter());
        } else {
            LOGGER.debug((Object)"You do not have administrator privilege to perform the Operation. ");
            this.userManagementUtility.sendErrorResponse("You do not have admin privileges to perform this action.", 401, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug((Object)"inside do get");
        ConfluenceUser confluenceUser = null;
        confluenceUser = AuthenticatedUserThreadLocal.get();
        Boolean isAdmin = Boolean.FALSE;
        if (confluenceUser != null) {
            isAdmin = this.permissionManager.hasPermission((com.atlassian.user.User)confluenceUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
        }
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        if (!this.maxUsersLicense.booleanValue()) {
            this.evaluationLicense = this.userManagementUtility.isEvaluationLicense() != false && this.userManagementUtility.isValidEvaluationLicense() != false ? Boolean.TRUE : Boolean.FALSE;
        }
        LOGGER.debug((Object)("evaluationLicense :" + this.evaluationLicense));
        try {
            List list = this.directoryManager.findAllDirectories();
            ArrayList<String> listNames = new ArrayList<String>();
            listNames.add("All");
            for (Directory x : list) {
                if (!x.isActive()) continue;
                listNames.add(x.getName());
            }
            this.directories = listNames;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Directories were not found:" + e.getMessage()));
        }
        if (isAdmin.booleanValue()) {
            this.userPerPage = req.getParameter("userPerPageGet") == null ? UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE : Integer.valueOf(Integer.parseInt(req.getParameter("userPerPageGet")));
            this.userType = req.getParameter("userType") == null ? "All" : req.getParameter("userType");
            String searchKeyword = req.getParameter("usernameSearchKeywordGet");
            this.groupSearchKey = req.getParameter("groupSearchKey");
            this.groupSearchList = this.groupSearchKey == null ? new ArrayList<String>() : Arrays.asList(StringUtils.split((String)this.groupSearchKey, (String)","));
            this.excludeGroupFilter = req.getParameter("excludeGroupFilter");
            this.excludeGroupFilterList = this.excludeGroupFilter == null ? new ArrayList<String>() : Arrays.asList(StringUtils.split((String)this.excludeGroupFilter, (String)","));
            this.usernameSearchKeyword = StringUtils.isNotBlank((CharSequence)searchKeyword) ? searchKeyword.trim() : "";
            this.startIndexOfPage = req.getParameter("startIndexGet");
            this.endIndexOfPage = req.getParameter("endIndexGet");
            this.userSearchFilter = req.getParameter("userSearchFilterGet");
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
            String[] dateAndTime = expiryDateString.split(" ");
            this.currentDate = dateAndTime[0];
            LOGGER.error((Object)("current date :" + this.currentDate));
            this.startDateFilter = req.getParameter("startDateFilterGet");
            if (StringUtils.isBlank((CharSequence)this.startDateFilter) || this.startDateFilter == null) {
                this.startDateFilter = "1970-01-01";
            }
            this.endDateFilter = req.getParameter("endDateFilterGet");
            if (StringUtils.isBlank((CharSequence)this.endDateFilter) || this.endDateFilter == null) {
                this.endDateFilter = this.currentDate;
            }
            this.sortByLastLogin = this.settings.getSortByLastLogin();
            this.isAdditionalFilterActive = false;
            this.UserDetails(req, resp);
            resp.setContentType("text/html;charset=utf-8");
            this.renderer.render(BULK_USER_MANAGEMENT_VM_PATH, this.initializeSAMLConfig(), (Writer)resp.getWriter());
        } else {
            LOGGER.debug((Object)"You do not have administrator privilege to perform the Operation. ");
            this.userManagementUtility.sendErrorResponse("You do not have admin privileges to perform this action.", 401, resp);
        }
    }

    private HashMap<String, Object> initializeSAMLConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("userPerPage", this.userPerPage);
        context.put("usernameSearchKeyword", this.usernameSearchKeyword);
        context.put("startIndex", this.startIndex);
        context.put("endIndex", this.endIndex);
        context.put("userSearchFilter", this.userSearchFilter);
        context.put("currentPageUsersList", this.currentPageUsersList);
        context.put("userAccessor", this.userAccessor);
        context.put("directoryManager", this.directoryManager);
        context.put("usernameList", this.usernameList);
        context.put("numberOfRecordsPerPage", this.numberOfRecordsPerPage);
        context.put("selectedPage", this.selectedPage);
        context.put("numberOfPagesList", this.numberOfPagesList);
        context.put("maxUsersLicense", this.maxUsersLicense);
        context.put("groupSearchList", this.groupSearchList);
        context.put("contextPath", this.contextPathHolder.getContextPath());
        context.put("loginManager", this.loginManager);
        context.put("evaluationLicense", this.evaluationLicense);
        context.put("currentDate", this.currentDate);
        context.put("moUserDetailsMap", this.getUserDetailsMap());
        context.put("directories", this.directories);
        context.put("selectedDirectory", this.selectedDirectory);
        context.put("startDateFilter", this.startDateFilter);
        context.put("endDateFilter", this.endDateFilter);
        context.put("sortByLastLogin", this.sortByLastLogin);
        context.put("userType", this.userType);
        context.put("excludeGroupFilterList", this.excludeGroupFilterList);
        context.put("isAdditionalFilterActive", this.isAdditionalFilterActive);
        return context;
    }

    private Map<String, MoUserUtility> getUserDetailsMap() {
        HashMap<String, MoUserUtility> userMapLogin = new HashMap<String, MoUserUtility>();
        for (User user : this.currentPageUsersList) {
            String directory = null;
            List group = this.userAccessor.getGroupNamesForUserName(user.getName());
            String logindate = Objects.requireNonNull(this.loginManager.getLoginInfo(user.getName())).getLastSuccessfulLoginDate() != null ? new SimpleDateFormat("E, dd/MMM/yyyy hh:mm aaa").format(this.loginManager.getLoginInfo(user.getName()).getLastSuccessfulLoginDate()) : "Never Logged In";
            try {
                directory = this.directoryManager.findDirectoryById(user.getDirectoryId()).getName();
            }
            catch (DirectoryNotFoundException e) {
                e.printStackTrace();
            }
            MoUserUtility moUserDetails = new MoUserUtility(group, directory, logindate);
            userMapLogin.put(user.getName(), moUserDetails);
        }
        return userMapLogin;
    }

    public void UserDetails(HttpServletRequest req, HttpServletResponse resp) {
        Object resultList;
        boolean onlyLicensedUsers;
        this.numberOfRecordsPerPage = this.userPerPage;
        if (StringUtils.isBlank((CharSequence)this.startIndexOfPage) && StringUtils.isBlank((CharSequence)this.endIndexOfPage)) {
            this.selectedPage = 1;
            this.startIndex = 1;
            this.endIndex = this.numberOfRecordsPerPage;
        } else {
            this.startIndex = Integer.parseInt(this.startIndexOfPage);
            this.endIndex = Integer.parseInt(this.endIndexOfPage);
            this.selectedPage = this.endIndex / this.userPerPage;
        }
        if (StringUtils.isBlank((CharSequence)this.userSearchFilter)) {
            this.userSearchFilter = "AllUsers";
        }
        if (StringUtils.isBlank((CharSequence)this.usernameSearchKeyword)) {
            this.usernameSearchKeyword = "";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.userSearchFilter, (CharSequence)"ActiveUsers")) {
            this.userSearchFilter = "ActiveUsers";
            LOGGER.debug((Object)("usernameSearchKeyword :- " + this.usernameSearchKeyword.trim()));
            this.usernameList = this.userManagementUtility.getUserFromConfluenceUsingUsername(this.usernameSearchKeyword.trim(), this.userSearchFilter, this.groupSearchList, this.selectedDirectory);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.userSearchFilter, (CharSequence)"InactiveUsers")) {
            this.userSearchFilter = "InactiveUsers";
            this.usernameList = this.userManagementUtility.getUserFromConfluenceUsingUsername(this.usernameSearchKeyword.trim(), this.userSearchFilter, this.groupSearchList, this.selectedDirectory);
        } else {
            this.userSearchFilter = "AllUsers";
            this.usernameList = this.userManagementUtility.getUserFromConfluenceUsingUsername(this.usernameSearchKeyword.trim(), this.userSearchFilter, this.groupSearchList, this.selectedDirectory);
        }
        LocalDate dateNow = LocalDate.now();
        boolean isDateFilter = !this.startDateFilter.equals("1970-01-01") || !this.endDateFilter.equals(dateNow.toString());
        boolean bl = onlyLicensedUsers = !this.userType.equals("All");
        if (isDateFilter || onlyLicensedUsers || !this.excludeGroupFilterList.isEmpty()) {
            this.isAdditionalFilterActive = true;
            this.usernameList = this.userManagementUtility.filterUsers(this.usernameList, isDateFilter, this.startDateFilter, this.endDateFilter, onlyLicensedUsers, this.excludeGroupFilterList);
        }
        if (this.sortByLastLogin.booleanValue()) {
            resultList = new ArrayList();
            ArrayList<User> userListToReturn = new ArrayList<User>();
            resultList = this.userManagementUtility.fetchUsersWithLastLoginFilter(this.usernameList);
            userListToReturn.addAll((Collection)resultList.get(0));
            userListToReturn.addAll((Collection)resultList.get(1));
            this.usernameList = userListToReturn;
        }
        this.currentPageUsersList = this.getSelectedUsersForPagination(this.usernameList, this.startIndex - 1, this.endIndex - 1);
        this.numberOfPages = this.usernameList.size() / this.userPerPage;
        if (this.usernameList.size() > this.numberOfPages * this.userPerPage) {
            resultList = this.numberOfPages;
            this.numberOfPages = this.numberOfPages + 1;
        }
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
    }

    public List<User> getSelectedUsersForPagination(List<User> selectedUsers, Integer startIndex, Integer endIndex) {
        ArrayList<User> selectedUserPagination = new ArrayList<User>();
        for (int i = startIndex.intValue(); i <= endIndex && i < selectedUsers.size(); ++i) {
            selectedUserPagination.add(selectedUsers.get(i));
        }
        return selectedUserPagination;
    }

    @Generated
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.userManagementUtility;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public String getUsernameSearchKeyword() {
        return this.usernameSearchKeyword;
    }

    @Generated
    public String getStartDateFilter() {
        return this.startDateFilter;
    }

    @Generated
    public String getEndDateFilter() {
        return this.endDateFilter;
    }

    @Generated
    public Integer getNumberOfRecordsPerPage() {
        return this.numberOfRecordsPerPage;
    }

    @Generated
    public List<User> getCurrentPageUsersList() {
        return this.currentPageUsersList;
    }

    @Generated
    public List<String> getNumberOfPagesList() {
        return this.numberOfPagesList;
    }

    @Generated
    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    @Generated
    public Boolean getEvaluationLicense() {
        return this.evaluationLicense;
    }

    @Generated
    public List<User> getUsernameList() {
        return this.usernameList;
    }

    @Generated
    public Integer getUserPerPage() {
        return this.userPerPage;
    }

    @Generated
    public String getGroupSearchKey() {
        return this.groupSearchKey;
    }

    @Generated
    public List<String> getGroupSearchList() {
        return this.groupSearchList;
    }

    @Generated
    public String getExcludeGroupFilter() {
        return this.excludeGroupFilter;
    }

    @Generated
    public List<String> getExcludeGroupFilterList() {
        return this.excludeGroupFilterList;
    }

    @Generated
    public Boolean getUserDetailsSubmitted() {
        return this.userDetailsSubmitted;
    }

    @Generated
    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    @Generated
    public Integer getSelectedPage() {
        return this.selectedPage;
    }

    @Generated
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Generated
    public Integer getEndIndex() {
        return this.endIndex;
    }

    @Generated
    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    @Generated
    public String getStartIndexOfPage() {
        return this.startIndexOfPage;
    }

    @Generated
    public String getEndIndexOfPage() {
        return this.endIndexOfPage;
    }

    @Generated
    public ContextPathHolder getContextPathHolder() {
        return this.contextPathHolder;
    }

    @Generated
    public String getCurrentDate() {
        return this.currentDate;
    }

    @Generated
    public List<String> getDirectories() {
        return this.directories;
    }

    @Generated
    public String getSelectedDirectory() {
        return this.selectedDirectory;
    }

    @Generated
    public Boolean getSortByLastLogin() {
        return this.sortByLastLogin;
    }

    @Generated
    public String getUserType() {
        return this.userType;
    }

    @Generated
    public Boolean getIsAdditionalFilterActive() {
        return this.isAdditionalFilterActive;
    }

    @Generated
    public void setUserManagementUtility(ConfluenceUserManagementUtility userManagementUtility) {
        this.userManagementUtility = userManagementUtility;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setUsernameSearchKeyword(String usernameSearchKeyword) {
        this.usernameSearchKeyword = usernameSearchKeyword;
    }

    @Generated
    public void setStartDateFilter(String startDateFilter) {
        this.startDateFilter = startDateFilter;
    }

    @Generated
    public void setEndDateFilter(String endDateFilter) {
        this.endDateFilter = endDateFilter;
    }

    @Generated
    public void setNumberOfRecordsPerPage(Integer numberOfRecordsPerPage) {
        this.numberOfRecordsPerPage = numberOfRecordsPerPage;
    }

    @Generated
    public void setCurrentPageUsersList(List<User> currentPageUsersList) {
        this.currentPageUsersList = currentPageUsersList;
    }

    @Generated
    public void setNumberOfPagesList(List<String> numberOfPagesList) {
        this.numberOfPagesList = numberOfPagesList;
    }

    @Generated
    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    @Generated
    public void setEvaluationLicense(Boolean evaluationLicense) {
        this.evaluationLicense = evaluationLicense;
    }

    @Generated
    public void setUsernameList(List<User> usernameList) {
        this.usernameList = usernameList;
    }

    @Generated
    public void setUserPerPage(Integer userPerPage) {
        this.userPerPage = userPerPage;
    }

    @Generated
    public void setGroupSearchKey(String groupSearchKey) {
        this.groupSearchKey = groupSearchKey;
    }

    @Generated
    public void setGroupSearchList(List<String> groupSearchList) {
        this.groupSearchList = groupSearchList;
    }

    @Generated
    public void setExcludeGroupFilter(String excludeGroupFilter) {
        this.excludeGroupFilter = excludeGroupFilter;
    }

    @Generated
    public void setExcludeGroupFilterList(List<String> excludeGroupFilterList) {
        this.excludeGroupFilterList = excludeGroupFilterList;
    }

    @Generated
    public void setUserDetailsSubmitted(Boolean userDetailsSubmitted) {
        this.userDetailsSubmitted = userDetailsSubmitted;
    }

    @Generated
    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    @Generated
    public void setSelectedPage(Integer selectedPage) {
        this.selectedPage = selectedPage;
    }

    @Generated
    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    @Generated
    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    @Generated
    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    @Generated
    public void setStartIndexOfPage(String startIndexOfPage) {
        this.startIndexOfPage = startIndexOfPage;
    }

    @Generated
    public void setEndIndexOfPage(String endIndexOfPage) {
        this.endIndexOfPage = endIndexOfPage;
    }

    @Generated
    public void setContextPathHolder(ContextPathHolder contextPathHolder) {
        this.contextPathHolder = contextPathHolder;
    }

    @Generated
    public void setCurrentDate(String currentDate) {
        this.currentDate = currentDate;
    }

    @Generated
    public void setDirectories(List<String> directories) {
        this.directories = directories;
    }

    @Generated
    public void setSelectedDirectory(String selectedDirectory) {
        this.selectedDirectory = selectedDirectory;
    }

    @Generated
    public void setSortByLastLogin(Boolean sortByLastLogin) {
        this.sortByLastLogin = sortByLastLogin;
    }

    @Generated
    public void setUserType(String userType) {
        this.userType = userType;
    }

    @Generated
    public void setIsAdditionalFilterActive(Boolean isAdditionalFilterActive) {
        this.isAdditionalFilterActive = isAdditionalFilterActive;
    }
}

