/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.xwork.SimpleXsrfTokenGenerator;
import com.google.gson.Gson;
import com.miniorange.usermanagement.confluence.common.CommonAuditLogDetails;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.AuditLogScheduler;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuditLogsAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(AuditLogsAction.class);
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    CommonAuditLogDetails backToObject;
    private Boolean auditLogsUserDetailsSubmitted;
    private AuditLogScheduler auditLogScheduler;
    private String auditLogUsernameSearchKeyword;
    private String auditLogIpSearchKeyword;
    private String filterUsersByPeriod;
    private String filterUsersByAction;
    private String filterByStatus;
    private List<String> auditLogs;
    private List<CommonAuditLogDetails> listOfAuditLogsObjects = new ArrayList<CommonAuditLogDetails>();
    private List<CommonAuditLogDetails> auditLogsToDisplay = new ArrayList<CommonAuditLogDetails>();
    private List<String> auditLogsAfterAllFilters = new ArrayList<String>();
    private Boolean autoDeleteAuditLogs;
    private Boolean autoDeleteAuditLogsDetailsSubmitted;
    private String autoDeleteLogsAfterDays;
    private List<String> numberOfPagesList;
    private Integer numberOfRecordsPerPage;
    private List<String> currentPageUsersList;
    private boolean isDatacenter;
    private boolean isOfflineLicensevalid = false;
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;
    private String atl_token;

    public AuditLogsAction(UserManagementPluginSettings settings, UserManagementPluginHandler pluginHandler, AuditLogScheduler auditLogScheduler) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.auditLogScheduler = auditLogScheduler;
    }

    public String execute() throws Exception {
        LOGGER.debug((Object)"AuditLogsAction doExecute called");
        SimpleXsrfTokenGenerator tokenGenerator = new SimpleXsrfTokenGenerator();
        this.atl_token = tokenGenerator.generateToken(this.getCurrentRequest());
        HttpServletRequest request = this.getCurrentRequest();
        this.fetchValuesFromRequest(request);
        String startIndexAsString = "";
        String endIndexAsString = "";
        if (BooleanUtils.toBoolean((Boolean)this.autoDeleteAuditLogsDetailsSubmitted)) {
            this.settings.setAutoDeleteAuditLogs(BooleanUtils.toBoolean((Boolean)this.autoDeleteAuditLogs));
            if (BooleanUtils.toBoolean((Boolean)this.autoDeleteAuditLogs)) {
                int days = Integer.parseInt(this.autoDeleteLogsAfterDays);
                this.settings.setAutoDeleteLogsAfterDays(days);
                LOGGER.debug((Object)"Scheduling Task");
                this.auditLogScheduler.schedule();
            } else {
                this.settings.setAutoDeleteAuditLogs(false);
                LOGGER.debug((Object)"Un-scheduling Task");
                this.auditLogScheduler.unschedule();
            }
        }
        if (StringUtils.isBlank((CharSequence)this.auditLogUsernameSearchKeyword)) {
            this.auditLogUsernameSearchKeyword = "";
        }
        if (StringUtils.isBlank((CharSequence)this.auditLogIpSearchKeyword)) {
            this.auditLogIpSearchKeyword = "";
        }
        if (BooleanUtils.toBoolean((Boolean)this.auditLogsUserDetailsSubmitted)) {
            startIndexAsString = "";
            endIndexAsString = "";
        } else {
            String usernameSearchKeyword = request.getParameter("logsUsernameSearchKeywordUrl");
            String ipSearchKeyword = request.getParameter("logsIpSearchKeywordUrl");
            String actionSearchFilter = request.getParameter("actionSearchFilter");
            String periodSearchFilter = request.getParameter("periodSearchFilter");
            String statusSearchFilter = request.getParameter("statusSearchFilter");
            if (StringUtils.isNotBlank((CharSequence)usernameSearchKeyword)) {
                this.auditLogUsernameSearchKeyword = usernameSearchKeyword.trim();
            }
            if (StringUtils.isNotBlank((CharSequence)ipSearchKeyword)) {
                this.auditLogIpSearchKeyword = ipSearchKeyword.trim();
            }
            if (StringUtils.isNotBlank((CharSequence)actionSearchFilter)) {
                this.filterUsersByAction = actionSearchFilter.trim();
            }
            if (StringUtils.isNotBlank((CharSequence)periodSearchFilter)) {
                this.filterUsersByPeriod = periodSearchFilter.trim();
            }
            if (StringUtils.isNotBlank((CharSequence)statusSearchFilter)) {
                this.filterByStatus = statusSearchFilter.trim();
            }
            startIndexAsString = request.getParameter("startIndex");
            endIndexAsString = request.getParameter("endIndex");
        }
        this.auditLogUsernameSearchKeyword = this.auditLogUsernameSearchKeyword.trim();
        this.auditLogIpSearchKeyword = this.auditLogIpSearchKeyword.trim();
        this.numberOfRecordsPerPage = UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE;
        if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
            this.selectedPage = 1;
            this.startIndex = 1;
            this.endIndex = this.numberOfRecordsPerPage;
        } else {
            this.startIndex = Integer.parseInt(startIndexAsString);
            this.endIndex = Integer.parseInt(endIndexAsString);
            this.selectedPage = this.endIndex / UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE;
        }
        if (StringUtils.isBlank((CharSequence)this.filterUsersByAction)) {
            this.filterUsersByAction = "All Actions";
        }
        if (StringUtils.isBlank((CharSequence)this.filterUsersByPeriod)) {
            this.filterUsersByPeriod = "All Days";
        }
        if (StringUtils.isBlank((CharSequence)this.filterByStatus)) {
            this.filterByStatus = "All Status";
        }
        ArrayList<String> auditLogs = new ArrayList<String>(this.settings.getAuditLogs());
        LOGGER.debug((Object)("auditLogs = " + auditLogs));
        LOGGER.info((Object)("auditLogUsernameSearchKeyword =  " + this.auditLogUsernameSearchKeyword));
        LOGGER.info((Object)("auditLogIpSearchKeyword =  " + this.auditLogIpSearchKeyword));
        LOGGER.info((Object)("filterUsersByAction=  " + this.filterUsersByAction));
        LOGGER.info((Object)("filterUsersByPeriod =  " + this.filterUsersByPeriod));
        LOGGER.info((Object)("filterByStatus= " + this.filterByStatus));
        this.auditLogsAfterAllFilters = this.settings.getLogsToDisplay(auditLogs, this.auditLogUsernameSearchKeyword, this.auditLogIpSearchKeyword, this.filterUsersByAction, this.filterByStatus, this.filterUsersByPeriod);
        this.currentPageUsersList = this.getSelectedDetailsForPaginationForLogs(this.auditLogsAfterAllFilters, this.startIndex - 1, this.endIndex - 1);
        Gson gson = new Gson();
        for (int counter = 0; counter < this.currentPageUsersList.size(); ++counter) {
            this.backToObject = gson.fromJson(this.currentPageUsersList.get(counter), CommonAuditLogDetails.class);
            this.auditLogsToDisplay.add(this.backToObject);
        }
        LOGGER.debug((Object)("auditLogsAfterAllFilters = " + this.auditLogsAfterAllFilters));
        LOGGER.debug((Object)("current auditLog list = " + this.currentPageUsersList));
        LOGGER.debug((Object)("auditLogsToDisplay = " + this.auditLogsToDisplay));
        this.numberOfPages = this.auditLogsAfterAllFilters.size() / UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE;
        if (this.auditLogsAfterAllFilters.size() > this.numberOfPages * UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE) {
            Integer n = this.numberOfPages;
            this.numberOfPages = this.numberOfPages + 1;
        }
        LOGGER.debug((Object)("number of pages = " + this.numberOfPages));
        this.initializeAuditLogs();
        return "success";
    }

    public List<String> getSelectedDetailsForPaginationForLogs(List<String> detailsList, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int counter = startIndex.intValue(); counter <= endIndex && counter < detailsList.size(); ++counter) {
            selectedDetailsPagination.add(detailsList.get(counter));
        }
        LOGGER.debug((Object)("Selected Details : " + selectedDetailsPagination));
        return selectedDetailsPagination;
    }

    private void initializeAuditLogs() {
        this.autoDeleteAuditLogs = this.settings.getAutoDeleteAuditLogs();
        this.autoDeleteLogsAfterDays = this.settings.getAutoDeleteLogsAfterDays().toString();
    }

    private void fetchValuesFromRequest(HttpServletRequest request) {
        if (request.getParameter("autoDeleteAuditLogsDetailsSubmitted") != null) {
            this.autoDeleteAuditLogsDetailsSubmitted = Boolean.valueOf(request.getParameter("autoDeleteAuditLogsDetailsSubmitted"));
        }
        if (request.getParameter("autoDeleteAuditLogs") != null) {
            this.autoDeleteAuditLogs = Boolean.valueOf(request.getParameter("autoDeleteAuditLogs"));
        }
        if (request.getParameter("autoDeleteLogsAfterDays") != null) {
            this.autoDeleteLogsAfterDays = request.getParameter("autoDeleteLogsAfterDays");
        }
        if (request.getParameter("auditLogsUserDetailsSubmitted") != null) {
            this.auditLogsUserDetailsSubmitted = Boolean.valueOf(request.getParameter("auditLogsUserDetailsSubmitted"));
        }
        if (request.getParameter("auditLogUsernameSearchKeyword") != null) {
            this.auditLogUsernameSearchKeyword = request.getParameter("auditLogUsernameSearchKeyword");
        }
        if (request.getParameter("filterUsersByAction") != null) {
            this.filterUsersByAction = request.getParameter("filterUsersByAction");
        }
        if (request.getParameter("filterByStatus") != null) {
            this.filterByStatus = request.getParameter("filterByStatus");
        }
        if (request.getParameter("filterUsersByPeriod") != null) {
            this.filterUsersByPeriod = request.getParameter("filterUsersByPeriod");
        }
        if (request.getParameter("auditLogIpSearchKeyword") != null) {
            this.auditLogIpSearchKeyword = request.getParameter("auditLogIpSearchKeyword");
        }
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @Generated
    public CommonAuditLogDetails getBackToObject() {
        return this.backToObject;
    }

    @Generated
    public Boolean getAuditLogsUserDetailsSubmitted() {
        return this.auditLogsUserDetailsSubmitted;
    }

    @Generated
    public AuditLogScheduler getAuditLogScheduler() {
        return this.auditLogScheduler;
    }

    @Generated
    public String getAuditLogUsernameSearchKeyword() {
        return this.auditLogUsernameSearchKeyword;
    }

    @Generated
    public String getAuditLogIpSearchKeyword() {
        return this.auditLogIpSearchKeyword;
    }

    @Generated
    public String getFilterUsersByPeriod() {
        return this.filterUsersByPeriod;
    }

    @Generated
    public String getFilterUsersByAction() {
        return this.filterUsersByAction;
    }

    @Generated
    public String getFilterByStatus() {
        return this.filterByStatus;
    }

    @Generated
    public List<String> getAuditLogs() {
        return this.auditLogs;
    }

    @Generated
    public List<CommonAuditLogDetails> getListOfAuditLogsObjects() {
        return this.listOfAuditLogsObjects;
    }

    @Generated
    public List<CommonAuditLogDetails> getAuditLogsToDisplay() {
        return this.auditLogsToDisplay;
    }

    @Generated
    public List<String> getAuditLogsAfterAllFilters() {
        return this.auditLogsAfterAllFilters;
    }

    @Generated
    public Boolean getAutoDeleteAuditLogs() {
        return this.autoDeleteAuditLogs;
    }

    @Generated
    public Boolean getAutoDeleteAuditLogsDetailsSubmitted() {
        return this.autoDeleteAuditLogsDetailsSubmitted;
    }

    @Generated
    public String getAutoDeleteLogsAfterDays() {
        return this.autoDeleteLogsAfterDays;
    }

    @Generated
    public List<String> getNumberOfPagesList() {
        return this.numberOfPagesList;
    }

    @Generated
    public Integer getNumberOfRecordsPerPage() {
        return this.numberOfRecordsPerPage;
    }

    @Generated
    public List<String> getCurrentPageUsersList() {
        return this.currentPageUsersList;
    }

    @Generated
    public boolean isDatacenter() {
        return this.isDatacenter;
    }

    @Generated
    public boolean isOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    @Generated
    public Integer getSelectedPage() {
        return this.selectedPage;
    }

    @Generated
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Generated
    public Integer getEndIndex() {
        return this.endIndex;
    }

    @Generated
    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    @Generated
    public String getAtl_token() {
        return this.atl_token;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @Generated
    public void setBackToObject(CommonAuditLogDetails backToObject) {
        this.backToObject = backToObject;
    }

    @Generated
    public void setAuditLogsUserDetailsSubmitted(Boolean auditLogsUserDetailsSubmitted) {
        this.auditLogsUserDetailsSubmitted = auditLogsUserDetailsSubmitted;
    }

    @Generated
    public void setAuditLogScheduler(AuditLogScheduler auditLogScheduler) {
        this.auditLogScheduler = auditLogScheduler;
    }

    @Generated
    public void setAuditLogUsernameSearchKeyword(String auditLogUsernameSearchKeyword) {
        this.auditLogUsernameSearchKeyword = auditLogUsernameSearchKeyword;
    }

    @Generated
    public void setAuditLogIpSearchKeyword(String auditLogIpSearchKeyword) {
        this.auditLogIpSearchKeyword = auditLogIpSearchKeyword;
    }

    @Generated
    public void setFilterUsersByPeriod(String filterUsersByPeriod) {
        this.filterUsersByPeriod = filterUsersByPeriod;
    }

    @Generated
    public void setFilterUsersByAction(String filterUsersByAction) {
        this.filterUsersByAction = filterUsersByAction;
    }

    @Generated
    public void setFilterByStatus(String filterByStatus) {
        this.filterByStatus = filterByStatus;
    }

    @Generated
    public void setAuditLogs(List<String> auditLogs) {
        this.auditLogs = auditLogs;
    }

    @Generated
    public void setListOfAuditLogsObjects(List<CommonAuditLogDetails> listOfAuditLogsObjects) {
        this.listOfAuditLogsObjects = listOfAuditLogsObjects;
    }

    @Generated
    public void setAuditLogsToDisplay(List<CommonAuditLogDetails> auditLogsToDisplay) {
        this.auditLogsToDisplay = auditLogsToDisplay;
    }

    @Generated
    public void setAuditLogsAfterAllFilters(List<String> auditLogsAfterAllFilters) {
        this.auditLogsAfterAllFilters = auditLogsAfterAllFilters;
    }

    @Generated
    public void setAutoDeleteAuditLogs(Boolean autoDeleteAuditLogs) {
        this.autoDeleteAuditLogs = autoDeleteAuditLogs;
    }

    @Generated
    public void setAutoDeleteAuditLogsDetailsSubmitted(Boolean autoDeleteAuditLogsDetailsSubmitted) {
        this.autoDeleteAuditLogsDetailsSubmitted = autoDeleteAuditLogsDetailsSubmitted;
    }

    @Generated
    public void setAutoDeleteLogsAfterDays(String autoDeleteLogsAfterDays) {
        this.autoDeleteLogsAfterDays = autoDeleteLogsAfterDays;
    }

    @Generated
    public void setNumberOfPagesList(List<String> numberOfPagesList) {
        this.numberOfPagesList = numberOfPagesList;
    }

    @Generated
    public void setNumberOfRecordsPerPage(Integer numberOfRecordsPerPage) {
        this.numberOfRecordsPerPage = numberOfRecordsPerPage;
    }

    @Generated
    public void setCurrentPageUsersList(List<String> currentPageUsersList) {
        this.currentPageUsersList = currentPageUsersList;
    }

    @Generated
    public void setDatacenter(boolean isDatacenter) {
        this.isDatacenter = isDatacenter;
    }

    @Generated
    public void setOfflineLicensevalid(boolean isOfflineLicensevalid) {
        this.isOfflineLicensevalid = isOfflineLicensevalid;
    }

    @Generated
    public void setSelectedPage(Integer selectedPage) {
        this.selectedPage = selectedPage;
    }

    @Generated
    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    @Generated
    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    @Generated
    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    @Generated
    public void setAtl_token(String atl_token) {
        this.atl_token = atl_token;
    }
}

