/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class DefaultLocaleProvider
implements LocaleProvider {
    private static final Logger LOG = LogManager.getLogger(DefaultLocaleProvider.class);

    @Override
    public Locale getLocale() {
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null) {
            return ctx.getLocale();
        }
        LOG.debug("Action context not initialized");
        return null;
    }

    @Override
    public boolean isValidLocaleString(String localeStr) {
        Locale locale = null;
        try {
            locale = LocaleUtils.toLocale((String)StringUtils.trimToNull((String)localeStr));
        }
        catch (IllegalArgumentException e) {
            LOG.warn(new ParameterizedMessage("Cannot convert [{}] to proper locale", (Object)localeStr), (Throwable)e);
        }
        return this.isValidLocale(locale);
    }

    @Override
    public boolean isValidLocale(Locale locale) {
        return LocaleUtils.isAvailableLocale((Locale)locale);
    }
}

