/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.wrapper.CachedBodyHttpServletRequestWrapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ConfluenceComponent
@UnrestrictedAccess
@WebFilter(value={"/*"})
public class MoLoginFilter
implements Filter {
    private static Log LOGGER = LogFactory.getLog(MoLoginFilter.class);
    private UserManagementPluginSettings settings;
    private UserAccessor userAccessor;
    private ConfluenceUserManagementUtility usermanagementutils;
    private UserManagementPluginHandler pluginHandler;
    private CrowdService crowdService;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private DirectoryManager directoryManager;

    public MoLoginFilter(ConfluenceUserManagementUtility usermanagementutils, UserManagementPluginSettings settings, UserAccessor userAccessor, UserManagementPluginHandler pluginHandler, CrowdService crowdService, UserDeactivaterScheduler userDeactivaterScheduler, DirectoryManager directoryManager) {
        this.settings = settings;
        this.userAccessor = userAccessor;
        this.usermanagementutils = usermanagementutils;
        this.pluginHandler = pluginHandler;
        this.crowdService = crowdService;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.directoryManager = directoryManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            String requestUrl = String.valueOf(req.getRequestURL());
            LOGGER.debug((Object)("Login filter has been invoked from the request URL: " + requestUrl));
            if (requestUrl.contains("/dologin.action")) {
                String username = req.getParameter("os_username");
                String pwd = req.getParameter("os_password");
                if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)pwd)) {
                    this.handleUserAction(username, pwd);
                }
                chain.doFilter(request, response);
            } else if (requestUrl.contains("/rest/tsv/1.0/authenticate")) {
                CachedBodyHttpServletRequestWrapper wrappedRequest = new CachedBodyHttpServletRequestWrapper(req);
                String body = new String(wrappedRequest.getInputStream().readAllBytes());
                JSONObject jsonBody = new JSONObject(body);
                String username = jsonBody.getString("username");
                String pwd = jsonBody.getString("password");
                if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)pwd)) {
                    this.handleUserAction(username, pwd);
                }
                chain.doFilter((ServletRequest)wrappedRequest, response);
            } else {
                chain.doFilter(request, response);
            }
            return;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error occurred while login : " + e));
            chain.doFilter(request, response);
            return;
        }
    }

    public void handleUserAction(String username, String pwd) throws UnknownHostException {
        block20: {
            InetAddress ip = InetAddress.getLocalHost();
            long userDir = this.crowdService.getUser(username).getDirectoryId();
            com.atlassian.crowd.model.user.User user = null;
            try {
                LOGGER.debug((Object)("User: " + username + " & User's Directory: " + this.directoryManager.findDirectoryById(userDir).getName()));
                user = this.directoryManager.findUserByName(userDir, username);
                UserTemplate userTemplate = new UserTemplate((User)user);
                if (this.settings.getReActivateUser().booleanValue() && !userTemplate.isActive()) {
                    LOGGER.debug((Object)("Calling 'reactivate user' for: " + username));
                    userTemplate.setActive(true);
                    this.directoryManager.updateUser(userTemplate.getDirectoryId(), userTemplate);
                    try {
                        this.crowdService.authenticate(username, pwd);
                        LOGGER.debug((Object)("Authentication successful, and user '" + username + "' has been successfully reactivated."));
                        this.pluginHandler.storeAuditLogs(username, ip.getHostAddress(), "User Reactivated", "Deactivated user activate on successful authentication", "Successful Logs");
                    }
                    catch (FailedAuthenticationException e) {
                        LOGGER.error((Object)("Invalid credentials provided for user: " + username));
                        userTemplate.setActive(false);
                        this.directoryManager.updateUser(userTemplate.getDirectoryId(), userTemplate);
                        throw new Exception();
                    }
                    if (this.settings.getAddGroupsToInactive().booleanValue()) {
                        List groupsToAdd = (List)this.settings.getAddGroups();
                        for (String group : groupsToAdd) {
                            try {
                                this.directoryManager.addUserToGroup(userTemplate.getDirectoryId(), userTemplate.getName(), group);
                            }
                            catch (Exception e) {
                                LOGGER.error((Object)("Exception while adding group: " + group + " to user: " + userTemplate.getName()), (Throwable)e);
                            }
                        }
                        LOGGER.debug((Object)("Groups have been added to the user after reactivation: " + groupsToAdd));
                    }
                    break block20;
                }
                if (!this.settings.getAddGroupsToActiveUsers().booleanValue() && !this.settings.getRuleBaseGroupMapping().booleanValue() || !userTemplate.isActive()) break block20;
                try {
                    this.crowdService.authenticate(username, pwd);
                    LOGGER.debug((Object)("Authentication successful for user '" + username));
                }
                catch (FailedAuthenticationException e) {
                    LOGGER.error((Object)("Invalid credentials provided for user: " + username));
                    userTemplate.setActive(false);
                    throw new Exception();
                }
                if (this.settings.getAddGroupsToActiveUsers().booleanValue()) {
                    List groupsToAdd = (List)this.settings.getGroupsAssignToActiveUser();
                    for (String group : groupsToAdd) {
                        try {
                            this.directoryManager.addUserToGroup(userTemplate.getDirectoryId(), userTemplate.getName(), group);
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)("Exception while adding group: " + group + " to user: " + userTemplate.getName()), (Throwable)e);
                        }
                    }
                    LOGGER.debug((Object)("Groups have been added to the user after a successful login: " + groupsToAdd));
                    this.pluginHandler.storeAuditLogs(username, ip.getHostAddress(), "Groups Assigned to Active Users", "Groups Assigned to users on successful authentication", "Successful Logs");
                }
                if (this.settings.getRuleBaseGroupMapping().booleanValue()) {
                    LOGGER.debug((Object)"Rule base group mapping is enable ");
                    List groupCondition = (List)this.settings.getGroupCondition();
                    List groupsToAdd = (List)this.settings.getAddGroupBaseOnRule();
                    List userGroups = this.userAccessor.getGroupNamesForUserName(username);
                    for (String userGroup : userGroups) {
                        LOGGER.debug((Object)("Inside Floating License : user group:- " + userGroup));
                        for (String excludeGroup : groupCondition) {
                            Iterator iterator;
                            LOGGER.debug((Object)("exclude group :- " + excludeGroup));
                            if (!userGroup.equals(excludeGroup) || !(iterator = groupsToAdd.iterator()).hasNext()) continue;
                            String groupAdd = (String)iterator.next();
                            LOGGER.debug((Object)("Group :-" + groupAdd + " add to the user :- " + username));
                            try {
                                this.directoryManager.addUserToGroup(userTemplate.getDirectoryId(), userTemplate.getName(), groupAdd);
                            }
                            catch (Exception e) {
                                LOGGER.error((Object)("Exception while adding group: " + groupAdd + " to user: " + userTemplate.getName()), (Throwable)e);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"An issue occurred while fetching user details: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void destroy() {
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public ConfluenceUserManagementUtility getUsermanagementutils() {
        return this.usermanagementutils;
    }

    @Generated
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setUsermanagementutils(ConfluenceUserManagementUtility usermanagementutils) {
        this.usermanagementutils = usermanagementutils;
    }

    @Generated
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

