/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.servlet;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.user.User;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ConfluenceComponent
public class MoGroupExport
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoGroupExport.class);
    private UserAccessor userAccessor;
    private DirectoryManager directoryManager;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private PermissionManager permissionManager;
    private CrowdService crowdService;
    private ConfluenceUserManagementUtility usermanagementutils;

    public MoGroupExport(ConfluenceUserManagementUtility usermanagementutils, UserAccessor userAccessor, DirectoryManager directoryManager, UserDeactivaterScheduler userDeactivaterScheduler, PermissionManager permissionManager, CrowdService crowdService) {
        this.usermanagementutils = usermanagementutils;
        this.userAccessor = userAccessor;
        this.directoryManager = directoryManager;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.permissionManager = permissionManager;
        this.crowdService = crowdService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Boolean isEvaluationLicensefound;
        LOGGER.debug((Object)"inside MoGroupExport do get ");
        ConfluenceUser confluenceUser = null;
        if (this.usermanagementutils.getMaxUsers() == 0) {
            LOGGER.debug((Object)"No license found for app. Bulk User management plugin will not work unless app license is applied.");
            response.sendRedirect("/admin/plugins/confluence-user-management/bulkgroupmanagement.action");
            return;
        }
        if (this.usermanagementutils.isEvaluationLicense().booleanValue() && this.usermanagementutils.isValidEvaluationLicense().booleanValue()) {
            LOGGER.error((Object)"Evaluation license found for app. Operations will be allowed for only 50 users");
            isEvaluationLicensefound = true;
        } else {
            isEvaluationLicensefound = false;
        }
        confluenceUser = AuthenticatedUserThreadLocal.get();
        Boolean isAdmin = Boolean.FALSE;
        if (confluenceUser != null) {
            isAdmin = this.permissionManager.hasPermission((User)confluenceUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
        }
        LOGGER.debug((Object)("AjaxCallsServlet confluence user = " + confluenceUser.getName() + " has admin permission  = " + isAdmin));
        if (isAdmin.booleanValue()) {
            boolean Group2 = Boolean.parseBoolean(request.getParameter("group"));
            boolean NoOfUserInGroup = Boolean.parseBoolean(request.getParameter("noOfUsers"));
            CSVPrinter printer = new CSVPrinter(response.getWriter(), CSVFormat.DEFAULT);
            String fileName = "./ConfluenceGroupList.csv";
            ArrayList groups = (ArrayList)this.usermanagementutils.getAllGroups("");
            Object[] ExportGroupPrintRecord = new Object[2];
            boolean count = false;
            int groupExport = 0;
            if (isEvaluationLicensefound.booleanValue()) {
                int n = 50;
            }
            int ind = 0;
            ExportGroupPrintRecord[ind++] = "GroupNames";
            if (BooleanUtils.toBoolean((Boolean)NoOfUserInGroup)) {
                ExportGroupPrintRecord[ind] = "UserCount";
            }
            printer.printRecord(ExportGroupPrintRecord);
            Object[] InformationOfGroup = new Object[2];
            for (String groupname : groups) {
                int indextries = 0;
                InformationOfGroup[indextries++] = groupname;
                if (BooleanUtils.toBoolean((Boolean)NoOfUserInGroup)) {
                    InformationOfGroup[indextries] = this.userAccessor.getMemberNamesAsList(this.userAccessor.getGroup(groupname)).size();
                }
                printer.printRecord(InformationOfGroup);
                if (!isEvaluationLicensefound.booleanValue() || ++groupExport < 50) continue;
                break;
            }
            LOGGER.debug((Object)"Groups exported Successfully");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        } else {
            LOGGER.debug((Object)"You do not have administrator privilege to Perform the Operation. ");
            this.sendErrorResponse("Error_Admin_Privilege", response);
        }
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public ConfluenceUserManagementUtility getUsermanagementutils() {
        return this.usermanagementutils;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setUsermanagementutils(ConfluenceUserManagementUtility usermanagementutils) {
        this.usermanagementutils = usermanagementutils;
    }
}

