/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.scheduler;

import com.atlassian.confluence.core.InsufficientPrivilegeException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.crowd.directory.ssl.LdapHostnameVerificationSSLSocketFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterTask;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
public class UserDeactivaterScheduler
implements LifecycleAware {
    private static Log LOGGER = LogFactory.getLog(UserDeactivaterScheduler.class);
    private LoginManager loginManager;
    private ConfluenceUserManagementUtility UserManagementUtility;
    private UserAccessor userAccessor;
    private MailServerManager mailServerManager;
    private PermissionManager permissionManager;
    private DirectoryManager directoryManager;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    private UserChecker userChecker;
    public static final String KEY = UserDeactivaterTask.class.getName() + ":instance";
    private static final String JOB_NAME = UserDeactivaterScheduler.class.getName() + ":job";
    private final PluginScheduler pluginScheduler;
    private CrowdDirectoryService crowdDirectoryService;
    private CrowdService crowdService;

    @Autowired
    public UserDeactivaterScheduler(PluginScheduler pluginScheduler, MailServerManager mailServerManager, UserManagementPluginSettings settings, ConfluenceUserManagementUtility userManagementUtility, UserAccessor userAccessor, LoginManager loginManager, PermissionManager permissionManager, UserManagementPluginHandler pluginHandler, DirectoryManager directoryManager, UserChecker userChecker, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService) {
        this.pluginScheduler = pluginScheduler;
        this.settings = settings;
        this.UserManagementUtility = userManagementUtility;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.loginManager = loginManager;
        this.pluginHandler = pluginHandler;
        this.directoryManager = directoryManager;
        this.mailServerManager = mailServerManager;
        this.userChecker = userChecker;
        this.crowdDirectoryService = crowdDirectoryService;
        this.crowdService = crowdService;
    }

    public void schedule() {
        LOGGER.error((Object)"Scheduleing job");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String jobName = JOB_NAME;
        long refreshIntervalInMiliseconds = this.settings.getScheduler_days() * 86400000L;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        GregorianCalendar calendarCustom = new GregorianCalendar(year, month, dayOfMonth, (int)this.settings.getCustomSchedulerTimeHour(), (int)this.settings.getCustomSchedulerTimeMinute());
        if (calendarCustom.getTimeInMillis() < cal.getTimeInMillis()) {
            LOGGER.debug((Object)"inside custom time < current time");
            ((Calendar)calendarCustom).add(5, (int)this.settings.getScheduler_days());
        }
        cal.setTime(new Date());
        cal.add(13, 3);
        SimpleDateFormat formatterScheduler = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        this.settings.setNextSchedulerDate(formatterScheduler.format(calendarCustom.getTime()));
        this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Scheduler Enabled", "Enable Auto Deactivate User Scheduler.", "Successful Logs");
        this.pluginScheduler.scheduleJob(jobName, UserDeactivaterTask.class, (Map)new HashMap<String, Object>(){
            {
                this.put(KEY, UserDeactivaterScheduler.this);
            }
        }, calendarCustom.getTime(), refreshIntervalInMiliseconds);
    }

    public void unschedule() {
        LOGGER.error((Object)"Unscheduleing job");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Scheduler Disabled", "Disable Auto Deactivate User Scheduler.", "Successful Logs");
        try {
            String jobName = JOB_NAME;
            this.pluginScheduler.unscheduleJob(jobName);
        }
        catch (IllegalArgumentException t2) {
            LOGGER.debug((Object)"No JOB exist. Can't unschedule.");
        }
        catch (Throwable t3) {
            LOGGER.debug((Object)"An Error occurred while unscheduleing JOB");
        }
    }

    public void onStart() {
        this.schedule();
    }

    public void onStop() {
        try {
            this.unschedule();
        }
        catch (IllegalArgumentException t2) {
            LOGGER.debug((Object)"No JOB exist. Can't unschedule.");
        }
        catch (Throwable t3) {
            LOGGER.debug((Object)"An Error occurred while unscheduleing JOB");
        }
    }

    public List<ConfluenceUser> targetedUser() {
        Calendar targeted = Calendar.getInstance();
        int days = (int)(this.settings.getNumberOfDays() - Long.valueOf(this.settings.getMailPeriod()));
        LOGGER.debug((Object)("Target Days : " + days));
        targeted.add(5, -days);
        Date targetDate = targeted.getTime();
        Boolean excludeGroupCheck = this.settings.getEnableExcludeGroups();
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        String usernameSearchKeyword = "";
        List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "ActiveUsers", new ArrayList<String>(), "All");
        List<ConfluenceUser> userWithLastLogin = StreamSupport.stream(usernameList.spliterator(), true).map(currentUser -> this.userAccessor.getUserByName(currentUser.getName())).filter(checkUser -> {
            LoginInfo loginInfo = this.loginManager.getLoginInfo((User)checkUser);
            Date lastLoginDate = loginInfo.getLastSuccessfulLoginDate();
            Boolean presentInExcludedGroup = false;
            List userGroups = this.userAccessor.getGroupNames((User)checkUser);
            LOGGER.debug((Object)("excludeGroups : " + excludeGroups));
            if (excludeGroupCheck.booleanValue()) {
                for (String userGroup : userGroups) {
                    for (String excludeGroup : excludeGroups) {
                        if (!userGroup.equals(excludeGroup)) continue;
                        presentInExcludedGroup = true;
                        break;
                    }
                    if (!presentInExcludedGroup.booleanValue()) continue;
                    LOGGER.debug((Object)("user will not deactivated due to present in exclude group : " + checkUser.getName()));
                    break;
                }
            }
            if (lastLoginDate != null && !presentInExcludedGroup.booleanValue()) {
                return lastLoginDate.getTime() < targetDate.getTime();
            }
            LOGGER.debug((Object)("user is either never login or present in exluded group : " + checkUser));
            return false;
        }).collect(Collectors.toList());
        return userWithLastLogin;
    }

    public ArrayList<com.atlassian.crowd.embedded.api.User> targetedNeverLoggedInUser() {
        LOGGER.debug((Object)"Inside targetedNeverLoggedInUser");
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        long numberOfDays = this.settings.getNumberofDaysAfterUserCreation() * 86400000L;
        long timeInterval = (long)Integer.parseInt(this.settings.getMailPeriodForNeverLoggedInUsers()) * 86400000L;
        long currentDate = new Date().getTime();
        long targetDate = currentDate - (numberOfDays - timeInterval);
        Boolean excludeGroupCheck = this.settings.getEnableExcludeGroups();
        String usernameSearchKeyword = "";
        List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "ActiveUsers", new ArrayList<String>(), "All");
        List userWithNeverLoggedIn = usernameList.parallelStream().filter(checkUser -> {
            ConfluenceUser currentUser = this.userAccessor.getUserByName(checkUser.getName());
            LoginInfo loginInfo = this.loginManager.getLoginInfo((User)this.userAccessor.getUserByName(currentUser.getName()));
            if (loginInfo.getLastSuccessfulLoginDate() == null) {
                Boolean presentInExcludedGroup = false;
                if (excludeGroupCheck.booleanValue()) {
                    List userGroups = this.userAccessor.getGroupNames((User)currentUser);
                    for (String userGroup : userGroups) {
                        for (String excludeGroup : excludeGroups) {
                            if (!userGroup.equals(excludeGroup)) continue;
                            presentInExcludedGroup = true;
                            break;
                        }
                        if (!presentInExcludedGroup.booleanValue()) continue;
                        break;
                    }
                }
                if (!presentInExcludedGroup.booleanValue()) {
                    TimestampedUser user = (TimestampedUser)checkUser;
                    return user.getCreatedDate().getTime() <= targetDate;
                }
            }
            return false;
        }).collect(Collectors.toList());
        return (ArrayList)userWithNeverLoggedIn;
    }

    public void sendMailBeforeDeactivate(List<ConfluenceUser> Users) {
        LOGGER.debug((Object)"Send mail before deactivate function called... ");
        long targetedTime = this.settings.getNumberOfDays() * 3600L * 1000L * 24L;
        String mailServer = this.settings.getMailServer();
        long numberOfDays = this.settings.getNumberOfDays();
        String subject = this.settings.getSubText();
        String body = this.settings.getMailText();
        List smtpServers = this.mailServerManager.getSmtpMailServers();
        SMTPMailServer selectedServer = smtpServers.stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (ConfluenceUser user : Users) {
            executor.submit(() -> {
                LoginInfo loginInfo = this.loginManager.getLoginInfo((User)user);
                Date lastLoginDate = loginInfo.getLastSuccessfulLoginDate();
                LOGGER.debug((Object)("Last login date for user " + user.getName() + "is : " + lastLoginDate));
                try {
                    this.sendMailToUser(user, targetedTime, selectedServer, numberOfDays, subject, body, lastLoginDate);
                }
                catch (MailException | MessagingException e) {
                    LOGGER.debug((Object)("Error to send mail : " + e.getMessage()));
                    throw new RuntimeException(e);
                }
            });
        }
        executor.shutdown();
    }

    public void sendMailToUser(ConfluenceUser user, long targetedTime, SMTPMailServer mailServer, long numberOfDays, String subject, String body, Date lastLoginDate) throws MessagingException, MailException {
        LOGGER.debug((Object)("Calling sendOtpOnEmail for user : " + user));
        SimpleDateFormat sdf1 = new SimpleDateFormat("MMM dd, yyyy");
        body = StringUtils.replace((String)body, (String)"$$username$$", (String)user.getName());
        body = StringUtils.replace((String)body, (String)"$$last_login_date$$", (String)sdf1.format(lastLoginDate));
        Date currentDate = new Date();
        if (currentDate.getTime() - lastLoginDate.getTime() < targetedTime) {
            LOGGER.debug((Object)("send user: \" " + user + " \" to mail only , not deactivate them"));
            long lastLoginDays = (currentDate.getTime() - lastLoginDate.getTime()) / 86400000L;
            body = StringUtils.replace((String)body, (String)"$$days$$", (String)String.valueOf(lastLoginDays));
            body = StringUtils.replace((String)body, (String)"is set to be deactivated", (String)"will be deactivated soon");
        } else if (currentDate.getTime() - lastLoginDate.getTime() >= targetedTime) {
            LOGGER.debug((Object)("send user: \" " + user.getName() + " \" to mail as well as deactivate them"));
            String days = String.valueOf(numberOfDays);
            body = StringUtils.replace((String)body, (String)"$$days$$", (String)days);
            body = StringUtils.replace((String)body, (String)"will be deactivated soon", (String)"is set to be deactivated");
        }
        if (mailServer != null) {
            this.mailConfig(user.getEmail(), mailServer, subject, body);
        }
    }

    public void mailConfig(String userEmail, SMTPMailServer selectedServer, String subject, String body) throws AddressException, MailException {
        String sender = selectedServer.getDefaultFrom();
        InternetAddress address = new InternetAddress(userEmail);
        String recipient = address.getAddress();
        LOGGER.debug((Object)("recipient : " + recipient));
        final String username = selectedServer.getUsername();
        final String password = selectedServer.getPassword();
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", (Object)selectedServer.isTlsRequired());
        props.put("mail.smtp.host", selectedServer.getHostname());
        props.put("mail.smtp.port", selectedServer.getPort());
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(sender));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            message.setSubject(subject);
            message.setContent((Object)body, "text/html");
            Transport.send((Message)message);
            LOGGER.debug((Object)"Mail successfully sent.");
        }
        catch (MessagingException e) {
            LOGGER.error((Object)("Failed to send mail: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public Boolean CheckLastLoginTime() throws ParseException, UnknownHostException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        LOGGER.debug((Object)"inside CheckLastLoginTime");
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat formatterScheduler = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        this.settings.setPrevSchedulerDate(formatterScheduler.format(cal.getTime()));
        this.settings.setPreviousSchedulerFlag(Boolean.FALSE);
        cal.setTime(this.settings.getPrevSchedulerDate());
        cal.add(5, (int)this.settings.getScheduler_days());
        this.settings.setNextSchedulerDate(formatterScheduler.format(cal.getTime()));
        InetAddress ip = InetAddress.getLocalHost();
        if (this.UserManagementUtility.isEvaluationLicense().booleanValue()) {
            if (!this.UserManagementUtility.isValidEvaluationLicense().booleanValue()) {
                LOGGER.debug((Object)"Invalid License ");
                return null;
            }
        } else if (!this.UserManagementUtility.isSubscriptionLicense().booleanValue()) {
            LOGGER.debug((Object)"Invalid License ");
            return null;
        }
        if (this.settings.getAutoDeActivateUsers().booleanValue() || this.settings.getEnableAutoRemoveFromGroup().booleanValue()) {
            this.pluginHandler.storeAuditLogs("miniOrange Deactivatoer", ip.getHostAddress(), "Scheduler Start", "Scheduler initiated for automatically deactivating users or revoking application access.", "Successful Logs");
            if (this.settings.getAutoDeActivateUsers().booleanValue()) {
                LOGGER.debug((Object)"auto deactivate user is enable...");
                List smtpServers = this.mailServerManager.getSmtpMailServers();
                if (smtpServers != null && !smtpServers.isEmpty()) {
                    List<ConfluenceUser> Users;
                    if (this.settings.getMailNotification().booleanValue()) {
                        Users = this.targetedUser();
                        LOGGER.debug((Object)("targeted users : " + Users));
                        this.sendMailBeforeDeactivate(Users);
                    }
                    if (this.settings.getSendMailToNeverLoggedInUsers().booleanValue() && this.settings.getAutoDeactivateNeverLoggedInUser().booleanValue()) {
                        Users = this.targetedNeverLoggedInUser();
                        this.sendMailToNeverLoggedInUsers((ArrayList<com.atlassian.crowd.embedded.api.User>)Users);
                    }
                } else {
                    LOGGER.debug((Object)"smtp mail server is not configured...");
                }
            }
            String usernameSearchKeyword = "";
            long interval = this.settings.getNumberOfDays() * 86400000L;
            long creationInterval = this.settings.getNumberofDaysAfterUserCreation() * 86400000L;
            List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "AllUsers", new ArrayList<String>(), "All");
            if (this.settings.getEnableLicenseLimitAlert().booleanValue()) {
                if (this.mailServerManager.getSmtpMailServers() != null) {
                    int userCount;
                    int licenseLimit = Integer.parseInt(this.settings.getUserLicenseLimit());
                    String userTier = String.valueOf(this.UserManagementUtility.getLicensedUserTier());
                    if (userTier.equals("-1")) {
                        userTier = "Unlimited";
                    }
                    if (licenseLimit <= (userCount = this.userChecker.getNumberOfRegisteredUsers())) {
                        String subject = this.settings.getLicenseLimitAlertSubject();
                        subject = StringUtils.replace((String)subject, (String)"$$APPLICATION$$", (String)"Confluence");
                        String body = this.settings.getLicenseLimitAlertBody();
                        body = StringUtils.replace((String)body, (String)"$$currentCount$$", (String)String.valueOf(userCount));
                        body = StringUtils.replace((String)body, (String)"$$licenseLimit$$", (String)String.valueOf(licenseLimit));
                        body = StringUtils.replace((String)body, (String)"$$userTier$$", (String)userTier);
                        body = StringUtils.replace((String)body, (String)"$$Administrator$$", (String)"Admin");
                        String mailServer = this.settings.getMailServerForLicenseAlert();
                        SMTPMailServer selectedServer = this.mailServerManager.getSmtpMailServers().stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
                        ArrayList confluenceAdminEmails = (ArrayList)this.settings.getSelectedAdminUserList();
                        for (String adminEmail : confluenceAdminEmails) {
                            try {
                                this.mailConfig(adminEmail, selectedServer, subject, body);
                            }
                            catch (MailException | AddressException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else {
                    LOGGER.error((Object)"SMTP is not configured");
                }
            }
            Date date = new Date();
            long timeMilli = date.getTime();
            long Lastday = timeMilli - interval;
            for (com.atlassian.crowd.embedded.api.User currentUser : usernameList) {
                long lastDay;
                TimestampedUser User2;
                long userCreatedTime;
                LOGGER.debug((Object)("Checking User  :- " + currentUser.getName()));
                com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(currentUser.getName());
                UserTemplate userTemplate = new UserTemplate(user);
                ConfluenceUser checkUser = this.userAccessor.getUserByName(currentUser.getName());
                boolean isAdmin = this.permissionManager.hasPermission((User)checkUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
                if (isAdmin || !userTemplate.isActive()) continue;
                LoginInfo loginInfo = this.loginManager.getLoginInfo((User)checkUser);
                Boolean skipUserDeactivation = false;
                if (this.settings.getEnableExcludeGroups().booleanValue()) {
                    List userGroups = this.userAccessor.getGroupNames((User)checkUser);
                    for (String userGroup : userGroups) {
                        for (String excludeGroup : excludeGroups) {
                            LOGGER.debug((Object)("userGroup = " + userGroup));
                            LOGGER.debug((Object)("excludeGroup = " + excludeGroup));
                            if (!userGroup.equals(excludeGroup)) continue;
                            skipUserDeactivation = true;
                            break;
                        }
                        if (!skipUserDeactivation.booleanValue()) continue;
                        break;
                    }
                }
                try {
                    if (this.settings.getEnableDirectoryFilter().booleanValue() && !this.isUserPresentInDirectory(currentUser, (List)this.settings.getDirectoryFilterList()).booleanValue()) {
                        LOGGER.debug((Object)("User " + currentUser.getName() + " not present in selected directory filter : " + (List)this.settings.getDirectoryFilterList()));
                        continue;
                    }
                }
                catch (DirectoryNotFoundException e) {
                    throw new RuntimeException(e);
                }
                cal = Calendar.getInstance();
                Thread currentThread = Thread.currentThread();
                ClassLoader origCCL = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(LdapHostnameVerificationSSLSocketFactory.class.getClassLoader());
                AuthenticatedUserThreadLocal.set((ConfluenceUser)this.getConfluenceAdministrator());
                ArrayList groupsToRemove = (ArrayList)this.settings.getAutoRemoveGroups();
                if (loginInfo.getLastSuccessfulLoginDate() != null) {
                    cal.setTime(loginInfo.getLastSuccessfulLoginDate());
                    long lastlogintime = cal.getTimeInMillis();
                    if (lastlogintime >= Lastday || skipUserDeactivation.booleanValue()) continue;
                    try {
                        if (this.settings.getEnableAutoRemoveFromGroup().booleanValue()) {
                            this.removeGroupFromUser(currentUser, groupsToRemove, ip);
                        }
                        if (!this.settings.getAutoDeActivateUsers().booleanValue()) continue;
                        this.deactivateUsers(currentUser, ip);
                        this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Deactivate User By Last Login Time using Scheduler.", "Successful Logs");
                    }
                    catch (InsufficientPrivilegeException t2) {
                        LOGGER.debug((Object)("Error InsufficientPrivilegeException = " + t2.toString()));
                    }
                    catch (Throwable t3) {
                        LOGGER.debug((Object)("Error in task else " + t3.getMessage()));
                    }
                    continue;
                }
                if (!this.settings.getAutoDeactivateNeverLoggedInUser().booleanValue() || loginInfo.getLastSuccessfulLoginDate() != null || skipUserDeactivation.booleanValue() || (userCreatedTime = (User2 = (TimestampedUser)currentUser).getCreatedDate().getTime()) > (lastDay = timeMilli - this.settings.getNumberofDaysAfterUserCreation() * 86400000L)) continue;
                try {
                    if (this.settings.getEnableAutoRemoveFromGroup().booleanValue()) {
                        this.removeGroupFromUser(currentUser, groupsToRemove, ip);
                    }
                    if (!this.settings.getAutoDeActivateUsers().booleanValue()) continue;
                    this.deactivateUsers(currentUser, ip);
                    this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Deactivate Never Logged-in User using Scheduler.", "Successful Logs");
                }
                catch (InsufficientPrivilegeException t4) {
                    LOGGER.debug((Object)("Error InsufficientPrivilegeException = " + t4.toString()));
                }
                catch (Throwable t5) {
                    LOGGER.debug((Object)("Error in task else " + t5.getMessage()));
                }
            }
        } else {
            LOGGER.debug((Object)"Disable auto Deactivate users");
            return false;
        }
        this.pluginHandler.storeAuditLogs("miniOrange Deactivatoer", ip.getHostAddress(), "Scheduler End", "Scheduler completed for auto-deactivation of users or revocation of application access.", "Successful Logs");
        return true;
    }

    public void removeGroupFromUser(com.atlassian.crowd.embedded.api.User currentUser, List<String> groupsToRemove, InetAddress ip) {
        block11: {
            block10: {
                Directory directory = this.crowdDirectoryService.findDirectoryById(currentUser.getDirectoryId());
                Set operation = directory.getAllowedOperations();
                if (directory.getType() != DirectoryType.CROWD || operation.contains(OperationType.UPDATE_USER)) break block10;
                LOGGER.debug((Object)("User is from crowd read only directory which have permission to update user : " + currentUser.getName()));
                if (!this.settings.getEnableCrowdROUser().booleanValue()) break block11;
                Map directoryAttribute = directory.getAttributes();
                String applicationName = (String)directoryAttribute.get("application.name");
                String applicationPassword = (String)directoryAttribute.get("application.password");
                String crowdServerUrl = (String)directoryAttribute.get("crowd.server.url");
                List userGroups = this.userAccessor.getGroupNames((User)this.userAccessor.getUserByName(currentUser.getName()));
                for (String group : groupsToRemove) {
                    if (!userGroups.contains(group)) continue;
                    try {
                        LOGGER.debug((Object)("User : " + currentUser.getName() + " is allowed for remove application access from crowd read only directory"));
                        URL url = new URL(crowdServerUrl + "rest/usermanagement/1/user/group/direct?username=" + currentUser.getName() + "&groupname=" + group);
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("DELETE");
                        connection.setRequestProperty("Content-Type", "application/json");
                        connection.setRequestProperty("Accept", "application/json");
                        String auth = applicationName + ":" + applicationPassword;
                        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
                        String authHeaderValue = "Basic " + encodedAuth;
                        connection.setRequestProperty("Authorization", authHeaderValue);
                        connection.setDoOutput(true);
                        LOGGER.debug((Object)("Response code for user : " + currentUser.getName() + " is : " + connection.getResponseCode()));
                        switch (connection.getResponseCode()) {
                            case 204: {
                                this.crowdDirectoryService.synchroniseDirectory(directory.getId().longValue());
                                LOGGER.debug((Object)("User " + currentUser.getName() + " was successfully removed from the group : " + group));
                                this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "Group Removed", "User successfully removed from group : " + group, "successful");
                                break;
                            }
                            case 403: {
                                LOGGER.error((Object)("Application is not allowed to delete the membership for user : " + currentUser.getName()));
                                this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "Group Removed", "Failed to remove group membership from: " + group + ". This action is not permitted by the application.", "Error");
                                break;
                            }
                            case 404: {
                                LOGGER.error((Object)("User or group not found while removing user: " + currentUser.getName() + " from group: " + group));
                                this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "Group Removed", "Failed to remove user from group " + group + ". The user or group could not be found.", "Error");
                                break;
                            }
                            default: {
                                LOGGER.debug((Object)("Issue while removing group from user : " + connection.getResponseMessage()));
                                this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "Group Removed", "Failed to remove group membership for: " + group, "Error");
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.debug((Object)("IOException for user : " + currentUser.getName() + " is : " + e.getMessage()));
                    }
                }
                break block11;
            }
            try {
                this.UserManagementUtility.removeUserFromGroups(currentUser.getName(), true, groupsToRemove, null, ip.getHostAddress());
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage());
            }
        }
    }

    public void deactivateUsers(com.atlassian.crowd.embedded.api.User currentUser, InetAddress ip) {
        LOGGER.debug((Object)("Deactivation action performed for user: " + currentUser.getName()));
        Directory directory = this.crowdDirectoryService.findDirectoryById(currentUser.getDirectoryId());
        Set operation = directory.getAllowedOperations();
        if (directory.getType() == DirectoryType.CROWD && !operation.contains(OperationType.UPDATE_USER)) {
            LOGGER.debug((Object)("User is from crowd read only directory which have permission to update user : " + currentUser.getName()));
            if (this.settings.getEnableCrowdROUser().booleanValue()) {
                Map directoryAttribute = directory.getAttributes();
                String applicationName = (String)directoryAttribute.get("application.name");
                String applicationPassword = (String)directoryAttribute.get("application.password");
                String crowdServerUrl = (String)directoryAttribute.get("crowd.server.url");
                try {
                    LOGGER.debug((Object)("User : " + currentUser.getName() + " is allowed for deactivate from crowd read only directory"));
                    URL url = new URL(crowdServerUrl + "rest/usermanagement/1/user?username=" + currentUser.getName());
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("PUT");
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setRequestProperty("Accept", "application/json");
                    String auth = applicationName + ":" + applicationPassword;
                    String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
                    String authHeaderValue = "Basic " + encodedAuth;
                    connection.setRequestProperty("Authorization", authHeaderValue);
                    connection.setDoOutput(true);
                    String requestBody = "{\"name\":\"" + currentUser.getName() + "\",\"active\":false,\"email\":\"" + currentUser.getEmailAddress() + "\"}";
                    try (OutputStream os = connection.getOutputStream();){
                        byte[] input = requestBody.getBytes("utf-8");
                        os.write(input, 0, input.length);
                    }
                    LOGGER.debug((Object)("Response code for user : " + currentUser.getName() + " is : " + connection.getResponseCode()));
                    switch (connection.getResponseCode()) {
                        case 204: {
                            this.crowdDirectoryService.synchroniseDirectory(directory.getId().longValue());
                            LOGGER.debug((Object)("User " + currentUser.getName() + " has been successfully deactivated"));
                            this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivation", "User Deactivated Successfully.", "successful");
                            break;
                        }
                        case 400: {
                            LOGGER.error((Object)("User " + currentUser.getName() + " is not deactivated due to invalid data."));
                            this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivation", "Invalid user data. For instance, the usernames provided in the body do not match the URI.", "Error");
                            break;
                        }
                        case 403: {
                            LOGGER.error((Object)("Application is not allowed to deactivate user : " + currentUser.getName()));
                            this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivation", "Failed to deactivate user. This action is not permitted by the application", "Error");
                            break;
                        }
                        case 404: {
                            LOGGER.error((Object)("User or group not found while deactivating user: " + currentUser.getName()));
                            this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivation", "Failed to deactivate user. The user or group could not be found.", "Error");
                            break;
                        }
                        default: {
                            LOGGER.error((Object)("Issue while deactivating user : " + connection.getResponseMessage()));
                            this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivation", "Failed to deactivate user.", "Error");
                            break;
                        }
                    }
                }
                catch (MalformedURLException e) {
                    LOGGER.error((Object)("MailformedURLException for user : " + currentUser.getName() + " is : " + e.getMessage()));
                }
                catch (ProtocolException e) {
                    LOGGER.error((Object)("ProtocolException for user : " + currentUser.getName() + " is : " + e.getMessage()));
                }
                catch (IOException e) {
                    LOGGER.error((Object)("IOException for user : " + currentUser.getName() + " is : " + e.getMessage()));
                }
            }
        } else {
            if (!Objects.equals(this.settings.getUsernameSuffix(), "")) {
                String newUsername = currentUser.getName() + this.settings.getUsernameSuffix();
                boolean isUserAlreadyExists = false;
                try {
                    this.directoryManager.findRemoteUserByName(Long.valueOf(currentUser.getDirectoryId()), newUsername);
                    isUserAlreadyExists = true;
                    LOGGER.debug((Object)("Unable to rename user " + currentUser.getName() + " to " + newUsername + " because it already exists."));
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Issue while fetching user " + newUsername + ": " + e.getMessage()));
                }
                if (!isUserAlreadyExists) {
                    try {
                        this.directoryManager.renameUser(currentUser.getDirectoryId(), currentUser.getName(), newUsername);
                        LOGGER.debug((Object)("The username for user " + currentUser.getName() + " has been updated to: " + newUsername));
                        this.pluginHandler.storeAuditLogs(newUsername, ip.getHostAddress(), "Suffix added to username: " + currentUser.getName(), "add suffix to username using Scheduler.", "Successful Logs");
                        currentUser = this.directoryManager.findUserByName(currentUser.getDirectoryId(), newUsername);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Issue while changing username for user: " + currentUser.getName() + ". Error: " + e.getMessage()));
                    }
                }
            }
            UserTemplate user = new UserTemplate(currentUser);
            user.setActive(false);
            try {
                this.directoryManager.updateUser(directory.getId().longValue(), user);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to update user: " + user.getName() + " in directory. Cause : " + e));
            }
        }
    }

    public void sendMailToNeverLoggedInUsers(ArrayList<com.atlassian.crowd.embedded.api.User> neverLoggedInUser) {
        LOGGER.debug((Object)"Inside sendMailToNeverLoggedInUsers");
        String subject = this.settings.getMailSubForNeverLoggedInUsers();
        String mailText = this.settings.getMailTextForNeverLoggedInUsers();
        String mailServer = this.settings.getMailServerForNeverLoggedIn();
        String numberOfDays = String.valueOf(this.settings.getNumberofDaysAfterUserCreation());
        List smtpServers = this.mailServerManager.getSmtpMailServers();
        SMTPMailServer selectedServer = smtpServers.stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (com.atlassian.crowd.embedded.api.User user : neverLoggedInUser) {
            AtomicReference<String> body = new AtomicReference<String>(mailText);
            body.set(StringUtils.replace((String)body.get(), (String)"$$days$$", (String)numberOfDays));
            executor.submit(() -> {
                ConfluenceUser currentUser = this.userAccessor.getUserByName(user.getName());
                try {
                    body.set(StringUtils.replace((String)((String)body.get()), (String)"$$username$$", (String)user.getName()));
                    if (selectedServer != null && currentUser != null) {
                        this.mailConfig(currentUser.getEmail(), selectedServer, subject, (String)body.get());
                    }
                }
                catch (MailException | MessagingException e) {
                    LOGGER.debug((Object)("Error to send mail : " + e.getMessage()));
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public ConfluenceUser getConfluenceAdministrator() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        List confluenceAdministrators = userAccessor.getMemberNamesAsList(userAccessor.getGroup("confluence-administrators"));
        if (confluenceAdministrators != null && !confluenceAdministrators.isEmpty()) {
            for (String user : confluenceAdministrators) {
                ConfluenceUser confluenceAdminUser = userAccessor.getUserByName(user);
                LOGGER.error((Object)("Confluence Admin User = " + confluenceAdminUser));
                UserTemplate userTemplate = new UserTemplate(this.crowdService.getUser(user));
                if (this.permissionManager.isSystemAdministrator((User)confluenceAdminUser) && userTemplate.isActive()) {
                    return confluenceAdminUser;
                }
                LOGGER.debug((Object)("Confluence Admin User = " + confluenceAdminUser + " does not have system admin permission or user is deactivated, continue with search..."));
            }
        }
        return null;
    }

    public Boolean isUserPresentInDirectory(com.atlassian.crowd.embedded.api.User user, List<String> selectedDirectories) throws DirectoryNotFoundException {
        Directory userDirectory = this.directoryManager.findDirectoryById(user.getDirectoryId());
        if (!selectedDirectories.isEmpty()) {
            if (selectedDirectories.contains(userDirectory.getName())) {
                LOGGER.debug((Object)("User : " + user.getName() + " is present in selected directory"));
                return true;
            }
            LOGGER.debug((Object)("User : " + user.getName() + " is not present in selected directory"));
            return false;
        }
        return false;
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.UserManagementUtility;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public MailServerManager getMailServerManager() {
        return this.mailServerManager;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @Generated
    public UserChecker getUserChecker() {
        return this.userChecker;
    }

    @Generated
    public PluginScheduler getPluginScheduler() {
        return this.pluginScheduler;
    }

    @Generated
    public CrowdDirectoryService getCrowdDirectoryService() {
        return this.crowdDirectoryService;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Generated
    public void setUserManagementUtility(ConfluenceUserManagementUtility UserManagementUtility) {
        this.UserManagementUtility = UserManagementUtility;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setMailServerManager(MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @Generated
    public void setUserChecker(UserChecker userChecker) {
        this.userChecker = userChecker;
    }

    @Generated
    public void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }
}

