/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.scheduler;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.AuditLogTask;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterTask;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ConfluenceComponent
public class AuditLogScheduler
implements LifecycleAware {
    private static Log LOGGER = LogFactory.getLog(AuditLogScheduler.class);
    private ConfluenceUserManagementUtility UserManagementUtility;
    private UserAccessor userAccessor;
    private PermissionManager permissionManager;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    private LoginManager loginManager;
    public static final String KEY = UserDeactivaterTask.class.getName() + ":instance";
    private static final String JOB_NAME = UserDeactivaterScheduler.class.getName() + ":job";
    private final PluginScheduler pluginScheduler;

    public AuditLogScheduler(PluginScheduler pluginScheduler, UserManagementPluginSettings settings, ConfluenceUserManagementUtility userManagementUtility, UserAccessor userAccessor, LoginManager loginManager, PermissionManager permissionManager, UserManagementPluginHandler pluginHandler) {
        this.pluginScheduler = pluginScheduler;
        this.settings = settings;
        this.UserManagementUtility = userManagementUtility;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.loginManager = loginManager;
        this.pluginHandler = pluginHandler;
    }

    public void schedule() throws UnknownHostException {
        LOGGER.info((Object)"Scheduling job");
        try {
            String jobName = JOB_NAME;
            long refreshTimeInMilliSeconds = 86400000L;
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(13, 3);
            this.pluginScheduler.scheduleJob(jobName, AuditLogTask.class, (Map)new HashMap<String, Object>(){
                {
                    this.put(KEY, AuditLogScheduler.this);
                }
            }, cal.getTime(), refreshTimeInMilliSeconds);
            if (!this.settings.getAutoDeleteAuditLogs().booleanValue()) {
                LOGGER.debug((Object)"Auto delete audit logs is disabled. Stopping the scheduler");
                this.pluginScheduler.unscheduleJob(jobName);
            } else {
                ConfluenceUser confluenceUser = null;
                confluenceUser = AuthenticatedUserThreadLocal.get();
                InetAddress ip = InetAddress.getLocalHost();
                this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Auto DeleteLogs Scheduler Enabled ", "Auto Delete logs Scheduler enabled.", "Successful Logs");
            }
        }
        catch (UnknownHostException e) {
            LOGGER.error((Object)"An error occurred while scheduling job.");
            e.printStackTrace();
        }
    }

    public void unschedule() {
        try {
            LOGGER.info((Object)"Un-scheduling job");
            String jobName = JOB_NAME;
            this.pluginScheduler.unscheduleJob(jobName);
            ConfluenceUser confluenceUser = null;
            confluenceUser = AuthenticatedUserThreadLocal.get();
            InetAddress ip = InetAddress.getLocalHost();
            this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Auto DeleteLogs Scheduler Disabled", "Auto Delete logs Scheduler disabled.", "Successful Logs");
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while Un-scheduling job.", (Throwable)e);
        }
    }

    public void onStart() {
        try {
            this.schedule();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public void onStop() {
        try {
            this.unschedule();
        }
        catch (IllegalArgumentException t2) {
            LOGGER.error((Object)"No job exist. Can't un-schedule.");
        }
        catch (Throwable t3) {
            t3.printStackTrace();
            LOGGER.error((Object)"An Error occurred while un-scheduling job");
        }
    }

    public Boolean deleteAuditLogs() throws ParseException {
        List<String> logsAfterDeletion = this.pluginHandler.autoDeleteAuditLogs(this.settings.getAuditLogs(), this.settings.getAutoDeleteLogsAfterDays());
        this.settings.setAuditLogs(logsAfterDeletion);
        LOGGER.debug((Object)"Successfully deleted logs!");
        return true;
    }

    @Generated
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.UserManagementUtility;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public PluginScheduler getPluginScheduler() {
        return this.pluginScheduler;
    }

    @Generated
    public void setUserManagementUtility(ConfluenceUserManagementUtility UserManagementUtility) {
        this.UserManagementUtility = UserManagementUtility;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }
}

