/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractBeanField;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldDate;
import com.opencsv.bean.BeanFieldPrimitiveTypes;
import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvCustomBindByName;
import com.opencsv.bean.CsvDate;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvBeanIntrospectionException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.text.StrBuilder;

public class HeaderColumnNameMappingStrategy<T>
implements MappingStrategy<T> {
    private static final int INITIAL_CAPACITY = 256;
    protected String[] header;
    protected Map<String, Integer> indexLookup = new HashMap<String, Integer>();
    protected Map<String, PropertyDescriptor> descriptorMap = null;
    protected Map<String, BeanField> fieldMap = null;
    protected Class<? extends T> type;
    protected boolean annotationDriven;
    protected Locale errorLocale = Locale.getDefault();

    @Override
    public void captureHeader(CSVReader reader) throws IOException, CsvRequiredFieldEmptyException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.unset"));
        }
        this.header = (String[])ObjectUtils.defaultIfNull((Object)reader.readNext(), (Object)ArrayUtils.EMPTY_STRING_ARRAY);
        ArrayList<String> requiredKeys = new ArrayList<String>();
        for (Map.Entry<String, BeanField> entrySet : this.fieldMap.entrySet()) {
            BeanField beanField = entrySet.getValue();
            if (!beanField.isRequired()) continue;
            requiredKeys.add(entrySet.getKey().toUpperCase());
        }
        if (requiredKeys.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.header.length && !requiredKeys.isEmpty(); ++i) {
            requiredKeys.remove(this.header[i].toUpperCase());
        }
        if (!requiredKeys.isEmpty()) {
            StrBuilder builder = new StrBuilder(256);
            String missingRequiredFields = builder.appendWithSeparators(requiredKeys, ",").toString();
            throw new CsvRequiredFieldEmptyException(this.type, this.fieldMap.get(requiredKeys.get(0)).getField(), String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.required.field.absent"), missingRequiredFields));
        }
    }

    @Override
    public void verifyLineLength(int numberOfFields) throws CsvRequiredFieldEmptyException {
        if (this.header != null) {
            StringBuilder sb = null;
            for (int i = numberOfFields; i < this.header.length && numberOfFields == this.header.length; ++i) {
                BeanField f = this.findField(i);
                if (!f.isRequired()) continue;
                if (sb == null) {
                    sb = new StringBuilder(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("multiple.required.field.empty"));
                }
                sb.append(' ');
                sb.append(f.getField().getName());
            }
            if (numberOfFields != this.header.length) {
                sb = new StringBuilder(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.data.mismatch"));
            }
            if (sb != null) {
                throw new CsvRequiredFieldEmptyException(this.type, sb.toString());
            }
        }
    }

    @Override
    public String[] generateHeader() {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.before.header"));
        }
        if (this.header == null) {
            TreeSet<String> set = new TreeSet<String>(this.fieldMap.keySet());
            this.header = set.toArray(new String[this.fieldMap.size()]);
        }
        return (String[])ArrayUtils.clone((Object[])this.header);
    }

    protected void createIndexLookup(String[] values) {
        if (this.indexLookup.isEmpty()) {
            for (int i = 0; i < values.length; ++i) {
                this.indexLookup.put(values[i], i);
            }
        }
    }

    protected void resetIndexMap() {
        this.indexLookup.clear();
    }

    @Override
    public Integer getColumnIndex(String name) {
        if (null == this.header) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.unread"));
        }
        this.createIndexLookup(this.header);
        return this.indexLookup.get(name);
    }

    @Override
    @Deprecated
    public PropertyDescriptor findDescriptor(int col) {
        String columnName = this.getColumnName(col);
        BeanField beanField = null;
        if (StringUtils.isNotBlank((CharSequence)columnName)) {
            beanField = this.fieldMap.get(columnName.toUpperCase().trim());
        }
        if (beanField != null) {
            return this.findDescriptor(beanField.getField().getName());
        }
        if (StringUtils.isNotBlank((CharSequence)columnName)) {
            return this.findDescriptor(columnName);
        }
        return null;
    }

    @Override
    public BeanField findField(int col) throws CsvBadConverterException {
        BeanField beanField = null;
        String columnName = this.getColumnName(col);
        if (StringUtils.isNotBlank((CharSequence)columnName)) {
            beanField = this.fieldMap.get(columnName.toUpperCase().trim());
        }
        return beanField;
    }

    @Override
    public int findMaxFieldIndex() {
        return this.header == null ? -1 : this.header.length - 1;
    }

    public String getColumnName(int col) {
        return null != this.header && col < this.header.length ? this.header[col] : null;
    }

    @Deprecated
    protected PropertyDescriptor findDescriptor(String name) {
        return this.descriptorMap.get(name.toUpperCase().trim());
    }

    @Deprecated
    protected Map<String, PropertyDescriptor> loadDescriptorMap() throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : descriptors = this.loadDescriptors(this.getType())) {
            map.put(descriptor.getName().toUpperCase(), descriptor);
        }
        return map;
    }

    protected BeanField instantiateCustomConverter(Class<? extends AbstractBeanField> converter) throws CsvBadConverterException {
        try {
            BeanField c = converter.newInstance();
            c.setErrorLocale(this.errorLocale);
            return c;
        }
        catch (IllegalAccessException | InstantiationException oldEx) {
            CsvBadConverterException newEx = new CsvBadConverterException(converter, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("custom.converter.invalid"), converter.getCanonicalName()));
            newEx.initCause(oldEx);
            throw newEx;
        }
    }

    protected void loadFieldMap() throws CsvBadConverterException {
        this.fieldMap = new HashMap<String, BeanField>();
        for (Field field : this.loadFields(this.getType())) {
            boolean required;
            String columnName;
            Annotation annotation;
            if (field.isAnnotationPresent(CsvCustomBindByName.class)) {
                annotation = field.getAnnotation(CsvCustomBindByName.class);
                columnName = annotation.column().toUpperCase().trim();
                if (StringUtils.isEmpty((CharSequence)columnName)) {
                    columnName = field.getName().toUpperCase();
                }
                Class<? extends AbstractBeanField> converter = field.getAnnotation(CsvCustomBindByName.class).converter();
                BeanField bean = this.instantiateCustomConverter(converter);
                bean.setField(field);
                required = annotation.required();
                bean.setRequired(required);
                this.fieldMap.put(columnName, bean);
                continue;
            }
            annotation = field.getAnnotation(CsvBindByName.class);
            required = annotation.required();
            columnName = annotation.column().toUpperCase().trim();
            String locale = annotation.locale();
            if (field.isAnnotationPresent(CsvDate.class)) {
                String formatString = field.getAnnotation(CsvDate.class).value();
                if (StringUtils.isEmpty((CharSequence)columnName)) {
                    this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldDate(field, required, formatString, locale, this.errorLocale));
                    continue;
                }
                this.fieldMap.put(columnName, new BeanFieldDate(field, required, formatString, locale, this.errorLocale));
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldPrimitiveTypes(field, required, locale, this.errorLocale));
                continue;
            }
            this.fieldMap.put(columnName, new BeanFieldPrimitiveTypes(field, required, locale, this.errorLocale));
        }
    }

    private PropertyDescriptor[] loadDescriptors(Class<? extends T> cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        return beanInfo.getPropertyDescriptors();
    }

    private List<Field> loadFields(Class<? extends T> cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : FieldUtils.getAllFields(cls)) {
            if (!field.isAnnotationPresent(CsvBindByName.class) && !field.isAnnotationPresent(CsvCustomBindByName.class)) continue;
            fields.add(field);
        }
        this.annotationDriven = !fields.isEmpty();
        return fields;
    }

    @Override
    public T createBean() throws InstantiationException, IllegalAccessException, IllegalStateException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.unset"));
        }
        return this.type.newInstance();
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public void setType(Class<? extends T> type) throws CsvBadConverterException {
        this.type = type;
        this.loadFieldMap();
        try {
            this.descriptorMap = this.loadDescriptorMap();
        }
        catch (IntrospectionException e) {
            CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("bean.descriptors.uninitialized"));
            csve.initCause(e);
            throw csve;
        }
    }

    @Override
    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = (Locale)ObjectUtils.defaultIfNull((Object)errorLocale, (Object)Locale.getDefault());
        if (this.fieldMap != null) {
            for (BeanField f : this.fieldMap.values()) {
                f.setErrorLocale(errorLocale);
            }
        }
    }

    @Override
    public boolean isAnnotationDriven() {
        return this.annotationDriven;
    }
}

