/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.utility;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ConfluenceComponent
public class ConfluenceUserManagementUtility {
    private static Log LOGGER = LogFactory.getLog(ConfluenceUserManagementUtility.class);
    private CrowdService crowdService;
    private PluginLicenseManager pluginLicenseManager;
    private LoginManager loginManager;
    private UserAccessor userAccessor;
    private UserManagementPluginSettings settting;
    private UserManagementPluginHandler userManagementPluginHandler;
    private DirectoryManager directoryManager;
    private LicenseService licenseService;

    public ConfluenceUserManagementUtility(CrowdService crowdService, PluginLicenseManager pluginLicenseManager, LoginManager loginManager, UserAccessor userAccessor, UserManagementPluginHandler userManagementPluginHandler, UserManagementPluginSettings settting, DirectoryManager directoryManager, LicenseService licenseService) {
        this.crowdService = crowdService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.loginManager = loginManager;
        this.userAccessor = userAccessor;
        this.settting = settting;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.directoryManager = directoryManager;
        this.licenseService = licenseService;
    }

    public List<com.atlassian.crowd.embedded.api.User> getUserFromConfluenceUsingUsername(String usernameSearchKeyword, String userSearchFilter, List<String> groupSearchList, String directory) {
        LOGGER.debug((Object)"getUserFromConfluenceUsingUsername");
        ArrayList availableUser = new ArrayList();
        Object activeUser = null;
        Object inactiveUser = null;
        ArrayList<List> userLists = new ArrayList<List>();
        ArrayList usersList = new ArrayList();
        List userSearchFilterList = new ArrayList();
        ArrayList<com.atlassian.crowd.embedded.api.User> finalUserList = new ArrayList<com.atlassian.crowd.embedded.api.User>();
        String groupSearchKey = "";
        MembershipQuery queryForGroup = null;
        EntityQuery query = null;
        if (groupSearchList.size() > 0) {
            for (int i = 0; i < groupSearchList.size(); ++i) {
                groupSearchKey = groupSearchList.get(i);
                if (!StringUtils.isNotBlank((CharSequence)groupSearchKey)) continue;
                queryForGroup = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(new String[]{groupSearchKey}).returningAtMost(-1);
                userLists.add((List)this.crowdService.search((Query)queryForGroup));
            }
            if (userLists.size() > 0) {
                usersList.addAll((Collection)userLists.get(0));
                ListIterator iter = userLists.listIterator(0);
                while (iter.hasNext()) {
                    usersList.retainAll((Collection)iter.next());
                }
            }
            finalUserList = usersList;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)userSearchFilter, (CharSequence)"AllUsers") || userSearchFilter.isEmpty()) {
            LOGGER.debug((Object)"Get all User");
            query = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)).returningAtMost(-1);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)userSearchFilter, (CharSequence)"ActiveUsers")) {
            LOGGER.debug((Object)"Get active users");
            query = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)true), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)})).returningAtMost(-1);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)userSearchFilter, (CharSequence)"InactiveUsers")) {
            LOGGER.debug((Object)"Get inactive users");
            query = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)false), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)})).returningAtMost(-1);
        }
        userSearchFilterList = (List)this.crowdService.search((Query)query);
        if (!finalUserList.isEmpty()) {
            finalUserList.retainAll(userSearchFilterList);
        } else if (groupSearchList.isEmpty()) {
            finalUserList = userSearchFilterList;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)"All", (CharSequence)directory)) {
            try {
                List directoryUsers = new ArrayList();
                DirectoryInstanceLoader directoryLoader = (DirectoryInstanceLoader)ContainerManager.getComponent((String)"directoryInstanceLoader");
                List allDirectories = this.directoryManager.findAllDirectories();
                for (int i = 0; i < allDirectories.size(); ++i) {
                    String dirName = ((Directory)allDirectories.get(i)).getName();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)dirName, (CharSequence)directory)) continue;
                    RemoteDirectory dir = directoryLoader.getDirectory(this.directoryManager.findDirectoryByName(dirName));
                    EntityQuery query1 = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
                    directoryUsers = dir.searchUsers(query1);
                }
                finalUserList.retainAll(directoryUsers);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error occurred while querying based on directory" + e));
            }
        }
        Collections.sort(finalUserList);
        return finalUserList;
    }

    public List<List<com.atlassian.crowd.embedded.api.User>> fetchUsersWithLastLoginFilter(List<com.atlassian.crowd.embedded.api.User> usernameList) {
        ArrayList<List<com.atlassian.crowd.embedded.api.User>> resultList = new ArrayList<List<com.atlassian.crowd.embedded.api.User>>();
        List userListToReturnNull = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<Long, com.atlassian.crowd.embedded.api.User> userMapWithLastLogin = new ConcurrentHashMap<Long, com.atlassian.crowd.embedded.api.User>();
        int batchSize = 2000;
        int numBatches = (int)Math.ceil((double)usernameList.size() / (double)batchSize);
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<CompletableFuture<Void>> allDirectoryUsers = new ArrayList<CompletableFuture<Void>>();
        for (int j = 0; j < numBatches; ++j) {
            int start = j * batchSize;
            int end = Math.min((j + 1) * batchSize, usernameList.size());
            List<com.atlassian.crowd.embedded.api.User> batch = usernameList.subList(start, end);
            CompletableFuture<Void> directoryUsers = CompletableFuture.runAsync(() -> {
                HashMap<Long, com.atlassian.crowd.embedded.api.User> tempUserMap = new HashMap<Long, com.atlassian.crowd.embedded.api.User>();
                for (com.atlassian.crowd.embedded.api.User user : batch) {
                    LoginInfo loginInfo = this.loginManager.getLoginInfo((User)this.userAccessor.getUserByName(user.getName()));
                    if (loginInfo.getLastSuccessfulLoginDate() == null) {
                        userListToReturnNull.add(user);
                        continue;
                    }
                    long loginTime = loginInfo.getLastSuccessfulLoginDate().getTime();
                    tempUserMap.put(loginTime, user);
                }
                userMapWithLastLogin.putAll(tempUserMap);
            }, executorService);
            allDirectoryUsers.add(directoryUsers);
        }
        CompletableFuture.allOf(allDirectoryUsers.toArray(new CompletableFuture[0])).join();
        resultList.add(userMapWithLastLogin != null ? this.sortUsersByLastLogin(userMapWithLastLogin) : null);
        resultList.add(userListToReturnNull);
        executorService.shutdown();
        return resultList;
    }

    public List<com.atlassian.crowd.embedded.api.User> sortUsersByLastLogin(Map<Long, com.atlassian.crowd.embedded.api.User> userListWithLastLogin) {
        TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
        sortedMap.putAll(userListWithLastLogin);
        ArrayList<com.atlassian.crowd.embedded.api.User> userListToReturn = new ArrayList<com.atlassian.crowd.embedded.api.User>(sortedMap.size());
        for (com.atlassian.crowd.embedded.api.User user : sortedMap.values()) {
            userListToReturn.add(user);
        }
        return userListToReturn;
    }

    public String getCurrentIpAddress(HttpServletRequest request) {
        String remoteAddr = "";
        if (request != null && (StringUtils.isBlank((CharSequence)(remoteAddr = request.getHeader("X-FORWARDED-FOR"))) || StringUtils.isEmpty((CharSequence)remoteAddr))) {
            remoteAddr = request.getRemoteAddr();
        }
        return remoteAddr;
    }

    public void removeUserFromGroups(String username, Boolean autoRemove, List<String> groupsToRemove, HttpServletResponse response, String ip) throws IOException {
        block4: {
            LOGGER.debug((Object)"Removing user from groups");
            try {
                for (String groupToRemove : groupsToRemove) {
                    LOGGER.debug((Object)("Removing User from " + groupToRemove + " group "));
                    this.userAccessor.removeMembership(groupToRemove, username);
                    LOGGER.debug((Object)("User :" + username + "  is successfully removed from group : " + groupToRemove));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (autoRemove.booleanValue()) break block4;
                this.sendErrorResponse("Error", 500, response);
            }
        }
        if (!groupsToRemove.isEmpty()) {
            String UserInGroup = groupsToRemove.toString();
            this.userManagementPluginHandler.storeAuditLogs(username, ip, "Removed from Group", "Removed User from Groups: " + UserInGroup.replaceAll("[\\[\\]]", ""), "Successful Logs");
        }
    }

    public void sendErrorResponse(String errorMessages, int statusCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(statusCode);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }

    public void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }

    public List<String> getAllGroups(String groupRegexPattern) {
        String startWith = "";
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)startWith)).returningAtMost(-1);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        for (Group groupObject : groups) {
            if (!StringUtils.containsIgnoreCase((CharSequence)groupObject.getName(), (CharSequence)groupRegexPattern.trim())) continue;
            existingGroups.add(groupObject.getName().trim());
        }
        return existingGroups;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer groupsPerPage, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i < startIndex + groupsPerPage && i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public int getMaxUsers() {
        int t2 = 0;
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                t2 = (Integer)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().get();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return t2;
    }

    public Boolean isValidEvaluationLicense() {
        return ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid();
    }

    public Boolean isEvaluationLicense() {
        if (this.isLicenseDefined().booleanValue()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            LOGGER.debug((Object)("pluginLicense.isEvaluation() :- " + pluginLicense.isEvaluation()));
            return pluginLicense.isEvaluation();
        }
        return Boolean.FALSE;
    }

    public Boolean isSubscriptionLicense() {
        if (this.isLicenseDefined().booleanValue()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            LOGGER.debug((Object)("pluginLicense.isSubscription() :- " + pluginLicense.isSubscription()));
            if (pluginLicense.isSubscription()) {
                return pluginLicense.isSubscription();
            }
            if (!pluginLicense.isEvaluation() || this.isLicenseValid().booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseDefined() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseValid() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            if (!((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() || ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public int getLicensedUserTier() {
        try {
            ConfluenceLicense license = this.licenseService.retrieve();
            int userTier = license.getMaximumNumberOfUsers();
            LOGGER.debug((Object)("userTier is :- " + userTier));
            return userTier;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occured", (Throwable)e);
            return 0;
        }
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public UserManagementPluginSettings getSettting() {
        return this.settting;
    }

    @Generated
    public UserManagementPluginHandler getUserManagementPluginHandler() {
        return this.userManagementPluginHandler;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public LicenseService getLicenseService() {
        return this.licenseService;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setSettting(UserManagementPluginSettings settting) {
        this.settting = settting;
    }

    @Generated
    public void setUserManagementPluginHandler(UserManagementPluginHandler userManagementPluginHandler) {
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }
}

