/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.directory.ssl.LdapHostnameVerificationSSLSocketFactory;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.user.User;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ConfluenceComponent
public class MoLoginFilter
implements Filter {
    private static Log LOGGER = LogFactory.getLog(MoLoginFilter.class);
    private UserManagementPluginSettings settings;
    private UserAccessor userAccessor;
    private ConfluenceUserManagementUtility usermanagementutils;
    private UserManagementPluginHandler pluginHandler;
    private CrowdService crowdService;
    private UserDeactivaterScheduler userDeactivaterScheduler;

    public MoLoginFilter(ConfluenceUserManagementUtility usermanagementutils, UserManagementPluginSettings settings, UserAccessor userAccessor, UserManagementPluginHandler pluginHandler, CrowdService crowdService, UserDeactivaterScheduler userDeactivaterScheduler) {
        this.settings = settings;
        this.userAccessor = userAccessor;
        this.usermanagementutils = usermanagementutils;
        this.pluginHandler = pluginHandler;
        this.crowdService = crowdService;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * Unable to fully structure code
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            req = (HttpServletRequest)request;
            resp = (HttpServletResponse)response;
            MoLoginFilter.LOGGER.debug((Object)("request url :" + req.getRequestURL()));
            confluenceUser = AuthenticatedUserThreadLocal.get();
            username = req.getParameter("os_username");
            pwd = req.getParameter("os_password");
            ip = InetAddress.getLocalHost();
            if (this.settings.getReActivateUser().booleanValue() && this.userAccessor.isDeactivated(username)) {
                currentThread = Thread.currentThread();
                currentThread.setContextClassLoader(LdapHostnameVerificationSSLSocketFactory.class.getClassLoader());
                AuthenticatedUserThreadLocal.set((ConfluenceUser)this.userDeactivaterScheduler.getConfluenceAdministrator());
                this.userAccessor.reactivateUser((User)this.userAccessor.getUserByName(username));
                MoLoginFilter.LOGGER.debug((Object)("activating user for credentials check :" + username));
                try {
                    if (!StringUtils.isNotBlank((CharSequence)username) || !StringUtils.isNotBlank((CharSequence)pwd)) ** GOTO lbl50
                    this.crowdService.authenticate(username, pwd);
                    MoLoginFilter.LOGGER.debug((Object)"correct credentials");
                    this.pluginHandler.storeAuditLogs(username, ip.getHostAddress(), "User Reactivated", "Deactivated user activated on successful authentication", "Successful Logs");
                    if (!this.settings.getAddGroupsToInactive().booleanValue()) ** GOTO lbl50
                    groupsToAdd = (List)this.settings.getAddGroups();
                    for (String group : groupsToAdd) {
                        MoLoginFilter.LOGGER.debug((Object)("group add to user : " + username + " : " + group));
                        this.userAccessor.addMembership(group, username);
                    }
                }
                catch (Exception e) {
                    this.userAccessor.deactivateUser((User)this.userAccessor.getUserByName(username));
                    MoLoginFilter.LOGGER.debug((Object)("Authentication Failed! Deactivating user in credential check scope :" + username));
                }
            } else if (this.settings.getAddGroupsToActiveUsers().booleanValue() && !this.userAccessor.isDeactivated(username)) {
                currentThread = Thread.currentThread();
                currentThread.setContextClassLoader(LdapHostnameVerificationSSLSocketFactory.class.getClassLoader());
                AuthenticatedUserThreadLocal.set((ConfluenceUser)this.userDeactivaterScheduler.getConfluenceAdministrator());
                try {
                    this.crowdService.authenticate(username, pwd);
                    MoLoginFilter.LOGGER.debug((Object)"correct credentials");
                    groupsToAdd = (List)this.settings.getGroupsAssignToActiveUser();
                    for (String group : groupsToAdd) {
                        MoLoginFilter.LOGGER.debug((Object)("group add to user : " + username + " : " + group));
                        this.userAccessor.addMembership(group, username);
                    }
                }
                catch (FailedAuthenticationException e) {
                    throw new RuntimeException(e);
                }
                catch (OperationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
lbl50:
            // 7 sources

            chain.doFilter(request, response);
            return;
        }
        catch (Exception e) {
            MoLoginFilter.LOGGER.error((Object)"Error occurred while login", (Throwable)e);
            chain.doFilter(request, response);
            return;
        }
    }

    public void destroy() {
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public ConfluenceUserManagementUtility getUsermanagementutils() {
        return this.usermanagementutils;
    }

    @Generated
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setUsermanagementutils(ConfluenceUserManagementUtility usermanagementutils) {
        this.usermanagementutils = usermanagementutils;
    }

    @Generated
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }
}

