/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.servlet;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.google.gson.Gson;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.io.IOException;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ConfluenceComponent
public class MoAjaxExportUser
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoAjaxExportUser.class);
    private UserAccessor userAccessor;
    private DirectoryManager directoryManager;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private UserManagementPluginSettings settings;
    private PermissionManager permissionManager;
    private LoginManager loginManager;
    private Date date;
    private Format format;
    private Boolean LimitExceeded = Boolean.FALSE;
    private ConfluenceUserManagementUtility usermanagementutils;
    private CrowdService crowdService;

    public MoAjaxExportUser(ConfluenceUserManagementUtility usermanagementutils, UserAccessor userAccessor, DirectoryManager directoryManager, UserDeactivaterScheduler userDeactivaterScheduler, PermissionManager permissionManager, LoginManager loginManager, UserManagementPluginSettings settings, CrowdService crowdService) {
        this.usermanagementutils = usermanagementutils;
        this.userAccessor = userAccessor;
        this.directoryManager = directoryManager;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.permissionManager = permissionManager;
        this.loginManager = loginManager;
        this.settings = settings;
        this.crowdService = crowdService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug((Object)"inside MoAjaxExportUser do get ");
        ConfluenceUser confluenceUser = null;
        if (this.usermanagementutils.getMaxUsers() == 0) {
            LOGGER.debug((Object)"No license found for app. Bulk User management plugin will not work unless app license is applied.");
            response.sendRedirect("/admin/plugins/confluence-user-management/importexport.action");
            return;
        }
        confluenceUser = AuthenticatedUserThreadLocal.get();
        Boolean isAdmin = Boolean.FALSE;
        Boolean isEvaluationLicensefound = Boolean.FALSE;
        if (this.usermanagementutils.isEvaluationLicense().booleanValue() && this.usermanagementutils.isValidEvaluationLicense().booleanValue()) {
            isEvaluationLicensefound = Boolean.TRUE;
            LOGGER.debug((Object)"Evaluation license found for app. Operations will be allowed for only 100 users for exporting users");
        }
        if (isEvaluationLicensefound.booleanValue()) {
            int exportUsersFlagEvalLicense = this.settings.getExportUsersFlagEvalLicense();
            this.settings.setExportUsersFlagEvalLicense(--exportUsersFlagEvalLicense);
            if (exportUsersFlagEvalLicense < 0) {
                this.LimitExceeded = Boolean.TRUE;
                LOGGER.error((Object)"Evaluation license found for app. Export Users functionality can be used only once.");
                if (request.getHeader("Referer").contains("bulkusermanagement")) {
                    response.sendRedirect("/plugins/servlet/usermanagement/bulkusermanagementaction");
                } else {
                    response.sendRedirect("/admin/plugins/confluence-user-management/importexport.action");
                }
                return;
            }
        }
        if (confluenceUser != null) {
            isAdmin = this.permissionManager.hasPermission((com.atlassian.user.User)confluenceUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
        }
        LOGGER.debug((Object)("AjaxCallsServlet confluence user = " + confluenceUser.getName() + " has admin permission  = " + isAdmin));
        if (isAdmin.booleanValue()) {
            List<User> usernameList;
            boolean Username = Boolean.parseBoolean(request.getParameter("name"));
            boolean Email = Boolean.parseBoolean(request.getParameter("email"));
            boolean FullName = Boolean.parseBoolean(request.getParameter("FullName"));
            boolean Groups = Boolean.parseBoolean(request.getParameter("Groups"));
            boolean Status2 = Boolean.parseBoolean(request.getParameter("Status"));
            boolean Directory2 = Boolean.parseBoolean(request.getParameter("Directory"));
            boolean LastLoginDate = Boolean.parseBoolean(request.getParameter("LastLoginDate"));
            CSVPrinter printer = new CSVPrinter(response.getWriter(), CSVFormat.DEFAULT);
            String fileName = "./ConfluenceUserList.csv";
            if (request.getHeader("Referer").contains("bulkusermanagement")) {
                List<Object> groupSearchKeyList;
                if (request.getParameter("groupSearchKey") == null) {
                    groupSearchKeyList = new ArrayList();
                } else {
                    String groupSearchKey = request.getParameter("groupSearchKey").replaceAll("[\\[\\]]", "");
                    groupSearchKeyList = Arrays.asList(StringUtils.split((String)groupSearchKey, (String)","));
                    groupSearchKeyList.removeAll(Arrays.asList(null, ""));
                }
                String usernameSearchKeyword = request.getParameter("usernameSearchKeyword") == null ? "" : request.getParameter("usernameSearchKeyword");
                String userSearchFilter = request.getParameter("userSearchFilter").trim();
                String selectedDirectory = request.getParameter("selectedDirectory") == null ? "All" : request.getParameter("selectedDirectory");
                usernameList = this.usermanagementutils.getUserFromConfluenceUsingUsername(usernameSearchKeyword, userSearchFilter, groupSearchKeyList, selectedDirectory);
                String selectedUsers = request.getParameter("selectedUsers");
                String[] userList = new Gson().fromJson(selectedUsers, String[].class);
                if (userList.length > 0) {
                    ArrayList<User> selectedUser = new ArrayList<User>();
                    for (String username : userList) {
                        User user = this.crowdService.getUser(username);
                        selectedUser.add(user);
                    }
                    usernameList = selectedUser;
                }
            } else {
                usernameList = this.usermanagementutils.getUserFromConfluenceUsingUsername("", "", new ArrayList<String>(), "All");
            }
            Object[] ExportUserPrintRecord = new Object[7];
            this.format = new SimpleDateFormat(" dd/MMM/yyyy hh:mm aaa");
            int count = 0;
            int allowedUsers = 0;
            if (!(Username || Email || FullName || Groups || Status2 || Directory2 || LastLoginDate)) {
                printer.printRecord("Username", "Email", "FullName", "Groups", "Status", "Directory", "LastLoginDate");
                for (User username : usernameList) {
                    LoginInfo loginInfo = this.loginManager.getLoginInfo(username.getName());
                    LOGGER.debug((Object)("Loginfo for user : " + username.getName() + " is : " + loginInfo));
                    String lastLoginInfo = "";
                    if (loginInfo != null && loginInfo.getLastSuccessfulLoginDate() != null) {
                        long dateCurrent = loginInfo.getLastSuccessfulLoginDate().getTime();
                        this.date = new Date(dateCurrent);
                        lastLoginInfo = this.format.format(this.date);
                    } else {
                        lastLoginInfo = "Never Logged In";
                    }
                    try {
                        printer.printRecord(username.getName(), username.getEmailAddress(), username.getDisplayName(), this.userAccessor.getGroupNamesForUserName(username.getName()), username.isActive(), this.directoryManager.findDirectoryById(username.getDirectoryId()).getName(), lastLoginInfo);
                    }
                    catch (DirectoryNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    if (!isEvaluationLicensefound.booleanValue() || ++allowedUsers < 50) continue;
                    break;
                }
            } else {
                if (Username) {
                    ExportUserPrintRecord[count] = "Username";
                    ++count;
                }
                if (Email) {
                    ExportUserPrintRecord[count] = "Email";
                    ++count;
                }
                if (FullName) {
                    ExportUserPrintRecord[count] = "FullName";
                    ++count;
                }
                if (Groups) {
                    ExportUserPrintRecord[count] = "Groups";
                    ++count;
                }
                if (Status2) {
                    ExportUserPrintRecord[count] = "Status";
                    ++count;
                }
                if (Directory2) {
                    ExportUserPrintRecord[count] = "Directory";
                    ++count;
                }
                if (LastLoginDate) {
                    ExportUserPrintRecord[count] = "LastLoginDate";
                    ++count;
                }
                printer.printRecord(ExportUserPrintRecord);
                Object[] InformationOfUser = new Object[7];
                for (User username : usernameList) {
                    LoginInfo loginInfo = this.loginManager.getLoginInfo((com.atlassian.user.User)this.userAccessor.getUserByName(username.getName()));
                    int count1 = 0;
                    if (Username) {
                        LOGGER.debug((Object)("user name " + username.getName()));
                        InformationOfUser[count1] = username.getName();
                        ++count1;
                    }
                    if (Email) {
                        InformationOfUser[count1] = username.getEmailAddress();
                        ++count1;
                    }
                    if (FullName) {
                        InformationOfUser[count1] = username.getDisplayName();
                        ++count1;
                    }
                    if (Groups) {
                        InformationOfUser[count1] = this.userAccessor.getGroupNamesForUserName(username.getName());
                        ++count1;
                    }
                    if (Status2) {
                        InformationOfUser[count1] = username.isActive();
                        ++count1;
                    }
                    if (Directory2) {
                        try {
                            InformationOfUser[count1] = this.directoryManager.findDirectoryById(username.getDirectoryId()).getName();
                        }
                        catch (DirectoryNotFoundException e) {
                            e.printStackTrace();
                        }
                        ++count1;
                    }
                    if (LastLoginDate) {
                        if (loginInfo.getLastSuccessfulLoginDate() != null) {
                            long dateCurrent = loginInfo.getLastSuccessfulLoginDate().getTime();
                            this.date = new Date(dateCurrent);
                            LOGGER.debug((Object)("last login time :" + this.format.format(this.date)));
                            InformationOfUser[count1] = this.format.format(this.date);
                        } else {
                            InformationOfUser[count1] = "Never Logged In ";
                        }
                        ++count1;
                    }
                    printer.printRecord(InformationOfUser);
                    if (!isEvaluationLicensefound.booleanValue() || ++allowedUsers < 50) continue;
                    break;
                }
            }
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        } else {
            LOGGER.debug((Object)"You do not have administrator privilege to Perform the Operation. ");
            this.sendErrorResponse("Error_Admin_Privilege", response);
        }
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public Date getDate() {
        return this.date;
    }

    @Generated
    public Format getFormat() {
        return this.format;
    }

    @Generated
    public Boolean getLimitExceeded() {
        return this.LimitExceeded;
    }

    @Generated
    public ConfluenceUserManagementUtility getUsermanagementutils() {
        return this.usermanagementutils;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Generated
    public void setDate(Date date) {
        this.date = date;
    }

    @Generated
    public void setFormat(Format format) {
        this.format = format;
    }

    @Generated
    public void setLimitExceeded(Boolean LimitExceeded) {
        this.LimitExceeded = LimitExceeded;
    }

    @Generated
    public void setUsermanagementutils(ConfluenceUserManagementUtility usermanagementutils) {
        this.usermanagementutils = usermanagementutils;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }
}

