/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.scheduler;

import com.atlassian.confluence.core.InsufficientPrivilegeException;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.crowd.directory.ssl.LdapHostnameVerificationSSLSocketFactory;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterTask;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.OfflineLicenseSettings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserDeactivaterScheduler
implements LifecycleAware {
    private static Log LOGGER = LogFactory.getLog(UserDeactivaterScheduler.class);
    private LoginManager loginManager;
    private ConfluenceUserManagementUtility UserManagementUtility;
    private UserAccessor userAccessor;
    private MailServerManager mailServerManager;
    private PermissionManager permissionManager;
    private DirectoryManager DirectoryManager;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    private OfflineLicenseSettings offlineLicenseSettings;
    private UserChecker userChecker;
    public static final String KEY = UserDeactivaterTask.class.getName() + ":instance";
    private static final String JOB_NAME = UserDeactivaterScheduler.class.getName() + ":job";
    private final PluginScheduler pluginScheduler;

    @Inject
    public UserDeactivaterScheduler(PluginScheduler pluginScheduler, MailServerManager mailServerManager, UserManagementPluginSettings settings, ConfluenceUserManagementUtility userManagementUtility, UserAccessor userAccessor, LoginManager loginManager, OfflineLicenseSettings offlineLicenseSettings, PermissionManager permissionManager, UserManagementPluginHandler pluginHandler, DirectoryManager DirectoryManager2, UserChecker userChecker) {
        this.pluginScheduler = pluginScheduler;
        this.settings = settings;
        this.UserManagementUtility = userManagementUtility;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.loginManager = loginManager;
        this.offlineLicenseSettings = offlineLicenseSettings;
        this.pluginHandler = pluginHandler;
        this.DirectoryManager = DirectoryManager2;
        this.mailServerManager = mailServerManager;
        this.userChecker = userChecker;
    }

    public void schedule() {
        LOGGER.error("Scheduleing job");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String jobName = JOB_NAME;
        long refreshIntervalInMiliseconds = this.settings.getScheduler_days() * 86400000L;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        GregorianCalendar calendarCustom = new GregorianCalendar(year, month, dayOfMonth, (int)this.settings.getCustomSchedulerTimeHour(), (int)this.settings.getCustomSchedulerTimeMinute());
        if (calendarCustom.getTimeInMillis() < cal.getTimeInMillis()) {
            LOGGER.debug("inside custom time < current time");
            ((Calendar)calendarCustom).add(5, (int)this.settings.getScheduler_days());
        }
        cal.setTime(new Date());
        cal.add(13, 3);
        SimpleDateFormat formatterScheduler = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        this.settings.setNextSchedulerDate(formatterScheduler.format(calendarCustom.getTime()));
        this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Scheduler Enabled", "Enable Auto Deactivate User Scheduler.", "Successful Logs");
        this.pluginScheduler.scheduleJob(jobName, UserDeactivaterTask.class, (Map)new HashMap<String, Object>(){
            {
                this.put(KEY, UserDeactivaterScheduler.this);
            }
        }, calendarCustom.getTime(), refreshIntervalInMiliseconds);
    }

    public void unschedule() {
        LOGGER.error("Unscheduleing job");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Scheduler Disabled", "Disable Auto Deactivate User Scheduler.", "Successful Logs");
        try {
            String jobName = JOB_NAME;
            this.pluginScheduler.unscheduleJob(jobName);
        }
        catch (IllegalArgumentException t) {
            LOGGER.debug("No JOB exist. Can't unschedule.");
        }
        catch (Throwable t) {
            LOGGER.debug("An Error occurred while unscheduleing JOB");
        }
    }

    public void onStart() {
        this.schedule();
    }

    public void onStop() {
        try {
            this.unschedule();
        }
        catch (IllegalArgumentException t) {
            LOGGER.debug("No JOB exist. Can't unschedule.");
        }
        catch (Throwable t) {
            LOGGER.debug("An Error occurred while unscheduleing JOB");
        }
    }

    public List<ConfluenceUser> targetedUser() {
        Calendar targeted = Calendar.getInstance();
        int days = (int)(this.settings.getNumberOfDays() - Long.valueOf(this.settings.getMailPeriod()));
        LOGGER.debug("Target Days : " + days);
        targeted.add(5, -days);
        Date targetDate = targeted.getTime();
        Boolean excludeGroupCheck = this.settings.getEnableExcludeGroups();
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        String usernameSearchKeyword = "";
        List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "ActiveUsers", new ArrayList<String>(), "All");
        List<ConfluenceUser> userWithLastLogin = StreamSupport.stream(usernameList.spliterator(), true).map(currentUser -> this.userAccessor.getUserByName(currentUser.getName())).filter(checkUser -> {
            LoginInfo loginInfo = this.loginManager.getLoginInfo((User)checkUser);
            Date lastLoginDate = loginInfo.getLastSuccessfulLoginDate();
            Boolean presentInExcludedGroup = false;
            List userGroups = this.userAccessor.getGroupNames((User)checkUser);
            LOGGER.debug("excludeGroups : " + excludeGroups);
            if (excludeGroupCheck.booleanValue()) {
                for (String userGroup : userGroups) {
                    for (String excludeGroup : excludeGroups) {
                        if (!userGroup.equals(excludeGroup)) continue;
                        presentInExcludedGroup = true;
                        break;
                    }
                    if (!presentInExcludedGroup.booleanValue()) continue;
                    LOGGER.debug("user will not deactivated due to present in exclude group : " + checkUser.getName());
                    break;
                }
            }
            if (lastLoginDate != null && !presentInExcludedGroup.booleanValue()) {
                return lastLoginDate.getTime() < targetDate.getTime();
            }
            LOGGER.debug("user is either never login or present in exluded group : " + checkUser);
            return false;
        }).collect(Collectors.toList());
        return userWithLastLogin;
    }

    public ArrayList<com.atlassian.crowd.embedded.api.User> targetedNeverLoggedInUser() {
        LOGGER.debug("Inside targetedNeverLoggedInUser");
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        long numberOfDays = this.settings.getNumberofDaysAfterUserCreation() * 86400000L;
        long timeInterval = (long)Integer.parseInt(this.settings.getMailPeriodForNeverLoggedInUsers()) * 86400000L;
        long currentDate = new Date().getTime();
        long targetDate = currentDate - (numberOfDays - timeInterval);
        Boolean excludeGroupCheck = this.settings.getEnableExcludeGroups();
        String usernameSearchKeyword = "";
        List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "ActiveUsers", new ArrayList<String>(), "All");
        List userWithNeverLoggedIn = usernameList.parallelStream().filter(checkUser -> {
            ConfluenceUser currentUser = this.userAccessor.getUserByName(checkUser.getName());
            LoginInfo loginInfo = this.loginManager.getLoginInfo((User)this.userAccessor.getUserByName(currentUser.getName()));
            if (loginInfo.getLastSuccessfulLoginDate() == null) {
                Boolean presentInExcludedGroup = false;
                if (excludeGroupCheck.booleanValue()) {
                    List userGroups = this.userAccessor.getGroupNames((User)currentUser);
                    for (String userGroup : userGroups) {
                        for (String excludeGroup : excludeGroups) {
                            if (!userGroup.equals(excludeGroup)) continue;
                            presentInExcludedGroup = true;
                            break;
                        }
                        if (!presentInExcludedGroup.booleanValue()) continue;
                        break;
                    }
                }
                if (!presentInExcludedGroup.booleanValue()) {
                    TimestampedUser user = (TimestampedUser)checkUser;
                    return user.getCreatedDate().getTime() <= targetDate;
                }
            }
            return false;
        }).collect(Collectors.toList());
        return (ArrayList)userWithNeverLoggedIn;
    }

    public void sendMailBeforeDeactivate(List<ConfluenceUser> Users) {
        LOGGER.debug("Send mail before deactivate function called... ");
        long targetedTime = this.settings.getNumberOfDays() * 3600L * 1000L * 24L;
        String mailServer = this.settings.getMailServer();
        long numberOfDays = this.settings.getNumberOfDays();
        String subject = this.settings.getSubText();
        String body = this.settings.getMailText();
        List smtpServers = this.mailServerManager.getSmtpMailServers();
        SMTPMailServer selectedServer = smtpServers.stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (ConfluenceUser user : Users) {
            executor.submit(() -> {
                LoginInfo loginInfo = this.loginManager.getLoginInfo((User)user);
                Date lastLoginDate = loginInfo.getLastSuccessfulLoginDate();
                LOGGER.debug("Last login date for user " + user.getName() + "is : " + lastLoginDate);
                try {
                    this.sendMailToUser(user, targetedTime, selectedServer, numberOfDays, subject, body, lastLoginDate);
                }
                catch (MailException | MessagingException e) {
                    LOGGER.debug("Error to send mail : " + e.getMessage());
                    throw new RuntimeException(e);
                }
            });
        }
        executor.shutdown();
    }

    public void sendMailToUser(ConfluenceUser user, long targetedTime, SMTPMailServer mailServer, long numberOfDays, String subject, String body, Date lastLoginDate) throws MessagingException, MailException {
        LOGGER.debug("Calling sendOtpOnEmail for user : " + user);
        SimpleDateFormat sdf1 = new SimpleDateFormat("MMM dd, yyyy");
        body = StringUtils.replace(body, "$$username$$", user.getName());
        body = StringUtils.replace(body, "$$last_login_date$$", sdf1.format(lastLoginDate));
        Date currentDate = new Date();
        if (currentDate.getTime() - lastLoginDate.getTime() < targetedTime) {
            LOGGER.debug("send user: \" " + user + " \" to mail only , not deactivate them");
            long lastLoginDays = (currentDate.getTime() - lastLoginDate.getTime()) / 86400000L;
            body = StringUtils.replace(body, "$$days$$", String.valueOf(lastLoginDays));
            body = StringUtils.replace(body, "is set to be deactivated", "will be deactivated soon");
        } else if (currentDate.getTime() - lastLoginDate.getTime() >= targetedTime) {
            LOGGER.debug("send user: \" " + user.getName() + " \" to mail as well as deactivate them");
            String days = String.valueOf(numberOfDays);
            body = StringUtils.replace(body, "$$days$$", days);
            body = StringUtils.replace(body, "will be deactivated soon", "is set to be deactivated");
        }
        if (mailServer != null) {
            this.mailConfig(user.getEmail(), mailServer, subject, body);
        }
    }

    public void mailConfig(String userEmail, SMTPMailServer selectedServer, String subject, String body) throws AddressException, MailException {
        String sender = selectedServer.getDefaultFrom();
        InternetAddress address = new InternetAddress(userEmail);
        String recipient = address.getAddress();
        LOGGER.debug("recipient : " + recipient);
        final String username = selectedServer.getUsername();
        final String password = selectedServer.getPassword();
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", (Object)selectedServer.isTlsRequired());
        props.put("mail.smtp.host", selectedServer.getHostname());
        props.put("mail.smtp.port", selectedServer.getPort());
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(sender));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            message.setSubject(subject);
            message.setContent((Object)body, "text/html");
            Transport.send((Message)message);
            LOGGER.debug("Mail successfully sent.");
        }
        catch (MessagingException e) {
            LOGGER.error("Failed to send mail: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Boolean CheckLastLoginTime() throws ParseException, UnknownHostException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        LOGGER.debug("inside CheckLastLoginTime");
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat formatterScheduler = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        this.settings.setPrevSchedulerDate(formatterScheduler.format(cal.getTime()));
        this.settings.setPreviousSchedulerFlag(Boolean.FALSE);
        cal.setTime(this.settings.getPrevSchedulerDate());
        cal.add(5, (int)this.settings.getScheduler_days());
        this.settings.setNextSchedulerDate(formatterScheduler.format(cal.getTime()));
        InetAddress ip = InetAddress.getLocalHost();
        if (!this.offlineLicenseSettings.isDatacenter()) {
            if (!this.offlineLicenseSettings.isOfflineLicenseValid()) {
                LOGGER.error("No Offline License ");
                return null;
            }
        } else if (this.UserManagementUtility.isEvaluationLicense().booleanValue()) {
            if (!this.UserManagementUtility.isValidEvaluationLicense().booleanValue()) {
                LOGGER.debug("Invalid License ");
                return null;
            }
        } else if (!this.UserManagementUtility.isSubscriptionLicense().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return null;
        }
        if (this.settings.getAutoDeActivateUsers().booleanValue() || this.settings.getEnableAutoRemoveFromGroup().booleanValue()) {
            if (this.settings.getAutoDeActivateUsers().booleanValue()) {
                LOGGER.debug("auto deactivate user is enable...");
                List smtpServers = this.mailServerManager.getSmtpMailServers();
                if (smtpServers != null && !smtpServers.isEmpty()) {
                    List<ConfluenceUser> Users;
                    if (this.settings.getMailNotification().booleanValue()) {
                        Users = this.targetedUser();
                        LOGGER.debug("targeted users : " + Users);
                        this.sendMailBeforeDeactivate(Users);
                    }
                    if (this.settings.getSendMailToNeverLoggedInUsers().booleanValue() && this.settings.getAutoDeactivateNeverLoggedInUser().booleanValue()) {
                        Users = this.targetedNeverLoggedInUser();
                        this.sendMailToNeverLoggedInUsers((ArrayList<com.atlassian.crowd.embedded.api.User>)Users);
                    }
                } else {
                    LOGGER.debug("smtp mail server is not configured...");
                }
            }
            String usernameSearchKeyword = "";
            long interval = this.settings.getNumberOfDays() * 86400000L;
            long creationInterval = this.settings.getNumberofDaysAfterUserCreation() * 86400000L;
            List<com.atlassian.crowd.embedded.api.User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(usernameSearchKeyword, "AllUsers", new ArrayList<String>(), "All");
            if (this.settings.getEnableLicenseLimitAlert().booleanValue()) {
                if (this.mailServerManager.getSmtpMailServers() != null) {
                    int userCount;
                    int licenseLimit = Integer.parseInt(this.settings.getUserLicenseLimit());
                    String userTier = String.valueOf(this.offlineLicenseSettings.getLicensedUserTier());
                    if (userTier.equals("-1")) {
                        userTier = "Unlimited";
                    }
                    if (licenseLimit <= (userCount = this.userChecker.getNumberOfRegisteredUsers())) {
                        String subject = this.settings.getLicenseLimitAlertSubject();
                        subject = StringUtils.replace(subject, "$$APPLICATION$$", "Confluence");
                        String body = this.settings.getLicenseLimitAlertBody();
                        body = StringUtils.replace(body, "$$currentCount$$", String.valueOf(userCount));
                        body = StringUtils.replace(body, "$$licenseLimit$$", String.valueOf(licenseLimit));
                        body = StringUtils.replace(body, "$$userTier$$", userTier);
                        body = StringUtils.replace(body, "$$Administrator$$", "Admin");
                        String mailServer = this.settings.getMailServerForLicenseAlert();
                        SMTPMailServer selectedServer = this.mailServerManager.getSmtpMailServers().stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
                        ArrayList confluenceAdminEmails = (ArrayList)this.settings.getSelectedAdminUserList();
                        for (String adminEmail : confluenceAdminEmails) {
                            try {
                                this.mailConfig(adminEmail, selectedServer, subject, body);
                            }
                            catch (MailException | AddressException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else {
                    LOGGER.error("SMTP is not configured");
                }
            }
            Date date = new Date();
            long timeMilli = date.getTime();
            long Lastday = timeMilli - interval;
            for (com.atlassian.crowd.embedded.api.User currentUser : usernameList) {
                long lastDay;
                TimestampedUser User2;
                long userCreatedTime;
                LOGGER.debug("Checking User  :- " + currentUser.getName());
                if (this.userAccessor.hasMembership("confluence-administrators", currentUser.getName()) || this.userAccessor.isDeactivated(currentUser.getName())) continue;
                ConfluenceUser checkUser = this.userAccessor.getUserByName(currentUser.getName());
                LoginInfo loginInfo = this.loginManager.getLoginInfo((User)checkUser);
                Boolean skipUserDeactivation = false;
                if (this.settings.getEnableExcludeGroups().booleanValue()) {
                    List userGroups = this.userAccessor.getGroupNames((User)checkUser);
                    for (String userGroup : userGroups) {
                        for (String excludeGroup : excludeGroups) {
                            LOGGER.debug("userGroup = " + userGroup);
                            LOGGER.debug("excludeGroup = " + excludeGroup);
                            if (!userGroup.equals(excludeGroup)) continue;
                            skipUserDeactivation = true;
                            break;
                        }
                        if (!skipUserDeactivation.booleanValue()) continue;
                        break;
                    }
                }
                cal = Calendar.getInstance();
                Thread currentThread = Thread.currentThread();
                ClassLoader origCCL = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(LdapHostnameVerificationSSLSocketFactory.class.getClassLoader());
                AuthenticatedUserThreadLocal.set((ConfluenceUser)this.getConfluenceAdministrator());
                ArrayList groupsToRemove = (ArrayList)this.settings.getAutoRemoveGroups();
                if (loginInfo.getLastSuccessfulLoginDate() != null) {
                    cal.setTime(loginInfo.getLastSuccessfulLoginDate());
                    long lastlogintime = cal.getTimeInMillis();
                    if (lastlogintime >= Lastday || skipUserDeactivation.booleanValue()) continue;
                    try {
                        if (this.settings.getEnableAutoRemoveFromGroup().booleanValue()) {
                            try {
                                this.UserManagementUtility.removeUserFromGroups(currentUser.getName(), true, groupsToRemove, null, ip.getHostAddress());
                            }
                            catch (IOException e) {
                                LOGGER.error(e.getMessage());
                            }
                        }
                        if (!this.settings.getAutoDeActivateUsers().booleanValue()) continue;
                        this.deactivateUsers(currentUser, ip);
                        this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Deactivate User By Last Login Time using Scheduler.", "Successful Logs");
                    }
                    catch (InsufficientPrivilegeException t) {
                        LOGGER.debug("Error InsufficientPrivilegeException = " + t.toString());
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Error in task else " + t.getMessage());
                    }
                    continue;
                }
                if (!this.settings.getAutoDeactivateNeverLoggedInUser().booleanValue() || loginInfo.getLastSuccessfulLoginDate() != null || skipUserDeactivation.booleanValue() || (userCreatedTime = (User2 = (TimestampedUser)currentUser).getCreatedDate().getTime()) > (lastDay = timeMilli - this.settings.getNumberofDaysAfterUserCreation() * 86400000L)) continue;
                try {
                    if (this.settings.getEnableAutoRemoveFromGroup().booleanValue()) {
                        try {
                            this.UserManagementUtility.removeUserFromGroups(currentUser.getName(), true, groupsToRemove, null, ip.getHostAddress());
                        }
                        catch (IOException e) {
                            LOGGER.error(e.getMessage());
                        }
                    }
                    if (!this.settings.getAutoDeActivateUsers().booleanValue()) continue;
                    this.deactivateUsers(currentUser, ip);
                    this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Deactivate Never Logged-in User using Scheduler.", "Successful Logs");
                }
                catch (InsufficientPrivilegeException t) {
                    LOGGER.debug("Error InsufficientPrivilegeException = " + t.toString());
                }
                catch (Throwable t) {
                    LOGGER.debug("Error in task else " + t.getMessage());
                }
            }
        } else {
            LOGGER.debug("Disable auto Deactivate users");
            return false;
        }
        return true;
    }

    public void deactivateUsers(com.atlassian.crowd.embedded.api.User currentUser, InetAddress ip) {
        ConfluenceUser updateUser = this.userAccessor.getUserByName(currentUser.getName());
        if (!Objects.equals(this.settings.getUsernameSuffix(), "")) {
            String newUsername = currentUser.getName() + this.settings.getUsernameSuffix();
            try {
                updateUser = this.userAccessor.renameUser(this.userAccessor.getUserByName(currentUser.getName()), newUsername);
                this.pluginHandler.storeAuditLogs(updateUser.getName(), ip.getHostAddress(), "Suffix added to username", "add suffix to username using Scheduler.", "Successful Logs");
            }
            catch (EntityException e) {
                throw new RuntimeException(e);
            }
        }
        this.userAccessor.deactivateUser((User)this.userAccessor.getUserByName(updateUser.getName()));
    }

    public void sendMailToNeverLoggedInUsers(ArrayList<com.atlassian.crowd.embedded.api.User> neverLoggedInUser) {
        LOGGER.debug("Inside sendMailToNeverLoggedInUsers");
        String subject = this.settings.getMailSubForNeverLoggedInUsers();
        String mailText = this.settings.getMailTextForNeverLoggedInUsers();
        String mailServer = this.settings.getMailServerForNeverLoggedIn();
        String numberOfDays = String.valueOf(this.settings.getNumberofDaysAfterUserCreation());
        List smtpServers = this.mailServerManager.getSmtpMailServers();
        SMTPMailServer selectedServer = smtpServers.stream().filter(smtpServer -> smtpServer.getName().equals(mailServer)).findFirst().orElse(null);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (com.atlassian.crowd.embedded.api.User user : neverLoggedInUser) {
            AtomicReference<String> body = new AtomicReference<String>(mailText);
            body.set(StringUtils.replace(body.get(), "$$days$$", numberOfDays));
            executor.submit(() -> {
                ConfluenceUser currentUser = this.userAccessor.getUserByName(user.getName());
                try {
                    body.set(StringUtils.replace((String)body.get(), "$$username$$", user.getName()));
                    if (selectedServer != null && currentUser != null) {
                        this.mailConfig(currentUser.getEmail(), selectedServer, subject, (String)body.get());
                    }
                }
                catch (MailException | MessagingException e) {
                    LOGGER.debug("Error to send mail : " + e.getMessage());
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public ConfluenceUser getConfluenceAdministrator() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        List confluenceAdministrators = userAccessor.getMemberNamesAsList(userAccessor.getGroup("confluence-administrators"));
        if (confluenceAdministrators != null && confluenceAdministrators.size() > 0) {
            for (String user : confluenceAdministrators) {
                ConfluenceUser confluenceAdminUser = userAccessor.getUserByName(user);
                LOGGER.error("Confluence Admin User = " + confluenceAdminUser);
                if (this.permissionManager.isSystemAdministrator((User)confluenceAdminUser) && !userAccessor.isDeactivated((User)confluenceAdminUser)) {
                    return confluenceAdminUser;
                }
                LOGGER.debug("Confluence Admin User = " + confluenceAdminUser + " does not have system admin permission or user is deactivated, continue with search...");
            }
        }
        return null;
    }

    public PluginScheduler getPluginScheduler() {
        return this.pluginScheduler;
    }

    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.UserManagementUtility;
    }

    public void setUserManagementUtility(ConfluenceUserManagementUtility userManagementUtility) {
        this.UserManagementUtility = userManagementUtility;
    }

    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

