/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import au.com.bytecode.opencsv.CSVReader;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.xwork.FileUploadUtils;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.OfflineLicenseSettings;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ImportExportAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(ImportExportAction.class);
    private ConfluenceUserManagementUtility UserManagementUtility;
    private Boolean maxUsersLicense;
    private Integer totalUpdations = 0;
    private Integer totalCreations = 0;
    private DirectoryManager directoryManager;
    private UserManager userManager;
    private UserAccessor userAccessor;
    private CrowdDirectoryService crowdDirectoryService;
    private CrowdService crowdService;
    private Boolean usermanagementuploadSubmitted;
    private Boolean uploadSuccessful = Boolean.FALSE;
    private UserManagementPluginHandler pluginHandler;
    private Boolean evaluationLicense;
    private OfflineLicenseSettings licenseSettings;
    private boolean isDatacenter;
    private boolean isOfflineLicensevalid = false;

    public ImportExportAction(ConfluenceUserManagementUtility userManagementUtility, DirectoryManager directoryManager, UserAccessor userAccessor, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, UserManagementPluginHandler pluginHandler, OfflineLicenseSettings licenseSettings, UserManager userManager) {
        this.UserManagementUtility = userManagementUtility;
        this.directoryManager = directoryManager;
        this.userAccessor = userAccessor;
        this.crowdDirectoryService = crowdDirectoryService;
        this.crowdService = crowdService;
        this.pluginHandler = pluginHandler;
        this.licenseSettings = licenseSettings;
        this.userManager = userManager;
    }

    public String execute() {
        LOGGER.debug(" ImportExportAction inside Do execute");
        if (this.usermanagementuploadSubmitted == null) {
            this.usermanagementuploadSubmitted = Boolean.FALSE;
        }
        if (!this.UserManagementUtility.isLicenseValid().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return "invalid";
        }
        if (this.usermanagementuploadSubmitted.booleanValue()) {
            LOGGER.debug("Inside usermanagementuploadSubmitted");
            try {
                this.handleUploadedCSVFile();
                this.uploadSuccessful = Boolean.TRUE;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.maxUsersLicense = this.UserManagementUtility.getMaxUsers() == 0;
        if (!this.maxUsersLicense.booleanValue()) {
            this.evaluationLicense = this.UserManagementUtility.isEvaluationLicense() != false && this.UserManagementUtility.isValidEvaluationLicense() != false ? Boolean.TRUE : Boolean.FALSE;
        }
        this.initialization();
        return "success";
    }

    public void initialization() {
        this.isOfflineLicensevalid = this.licenseSettings.isOfflineLicenseValid();
        this.isDatacenter = this.licenseSettings.isDatacenter();
    }

    private void handleUploadedCSVFile() throws IOException, PermissionException, OperationNotPermittedException, UserNotFoundException, DirectoryNotFoundException, OperationFailedException, InvalidUserException, InvalidCredentialException, UserAlreadyExistsException {
        block59: {
            LOGGER.debug("handleUploadedCSVFile called");
            CSVReader csvReader = null;
            try {
                FileUploadUtils.UploadedFile file = FileUploadUtils.getSingleUploadedFile();
                if (file.getFile() == null) {
                    LOGGER.error("Upoaded CSV file is null");
                    this.addActionError("File is Empty");
                    break block59;
                }
                File csvFile = file.getFile();
                LOGGER.debug("Upoaded CSV : " + csvFile.toString());
                csvReader = new CSVReader(new FileReader(csvFile));
                int usernameIndex = -1;
                int userEmailIndex = -1;
                int fullNameIndex = -1;
                int groupsIndex = -1;
                int statusIndex = -1;
                int lastLoginTimeIndex = -1;
                int directoryIndex = -1;
                int passwordIndex = -1;
                String[] nextLine = csvReader.readNext();
                if (nextLine != null) {
                    int colCount = nextLine.length;
                    block28: for (int i = 0; i < colCount; ++i) {
                        if (nextLine[i].contains("Username") || nextLine[i].contains("username")) {
                            nextLine[i] = "Username";
                        }
                        switch (nextLine[i].toString().toLowerCase()) {
                            case "username": {
                                usernameIndex = i;
                                continue block28;
                            }
                            case "email": {
                                userEmailIndex = i;
                                continue block28;
                            }
                            case "fullname": {
                                fullNameIndex = i;
                                continue block28;
                            }
                            case "groups": {
                                groupsIndex = i;
                                continue block28;
                            }
                            case "status": {
                                statusIndex = i;
                                continue block28;
                            }
                            case "directory": {
                                directoryIndex = i;
                                continue block28;
                            }
                            case "lastlogindate": {
                                lastLoginTimeIndex = i;
                                continue block28;
                            }
                            case "password": {
                                passwordIndex = i;
                            }
                        }
                    }
                }
                List<String[]> rows = csvReader.readAll();
                LOGGER.debug("Uploaded CSV file size = " + rows.size());
                if (rows == null) break block59;
                LOGGER.debug("CSV file is not null starting thread");
                String password = "";
                ConfluenceUser user = null;
                int updations = 0;
                int creations = 0;
                this.totalCreations = creations;
                this.totalUpdations = updations;
                for (int i = 0; i < rows.size(); ++i) {
                    String str;
                    String directory;
                    String groups;
                    String userEmail;
                    String userName;
                    if (usernameIndex != -1) {
                        userName = rows.get(i)[usernameIndex].toString();
                        if (userName.isEmpty()) {
                            LOGGER.error(" Username is empty cant create user  ");
                            continue;
                        }
                    } else {
                        LOGGER.error(" Username is empty cant create user  ");
                        continue;
                    }
                    if (userEmailIndex != -1) {
                        userEmail = rows.get(i)[userEmailIndex].toString();
                        if (userEmail.isEmpty()) {
                            LOGGER.error(" Email is empty cant create user  ");
                            continue;
                        }
                    } else {
                        LOGGER.error(" Email is empty cant create user  ");
                        continue;
                    }
                    String fullName = fullNameIndex != -1 ? rows.get(i)[fullNameIndex].toString() : userName;
                    List<Object> defaultGroupList = new ArrayList();
                    if (groupsIndex != -1) {
                        groups = rows.get(i)[groupsIndex].toString().replaceAll(",+\\s+", ",");
                        if (!groups.isEmpty()) {
                            defaultGroupList = Arrays.asList(StringUtils.split(groups, ","));
                        } else {
                            groups = "";
                            defaultGroupList = Collections.singletonList("");
                        }
                    } else {
                        groups = "";
                        defaultGroupList = Collections.singletonList("");
                    }
                    String status = statusIndex != -1 ? rows.get(i)[statusIndex].toString() : "";
                    Long directoryId = null;
                    Directory userDirectory = null;
                    if (directoryIndex != -1) {
                        directory = rows.get(i)[directoryIndex].toString();
                        if (!directory.isEmpty()) {
                            try {
                                userDirectory = this.directoryManager.findDirectoryByName(directory.trim());
                                directoryId = userDirectory.getId();
                            }
                            catch (DirectoryNotFoundException e) {
                                LOGGER.error("Directory of user  Doesn't exist", e);
                                directory = "";
                            }
                        } else {
                            directory = "";
                        }
                    } else {
                        directory = "";
                    }
                    String lastLoginTime = lastLoginTimeIndex != -1 ? rows.get(i)[lastLoginTimeIndex].toString() : "";
                    if (defaultGroupList.size() > 0 && (str = (String)defaultGroupList.get(0)).length() > 0) {
                        str = str.substring(1);
                        defaultGroupList.set(0, str);
                        str = (String)defaultGroupList.get(defaultGroupList.size() - 1);
                        str = str.substring(0, str.length() - 1);
                        defaultGroupList.set(defaultGroupList.size() - 1, str);
                    }
                    if (passwordIndex != -1) {
                        password = rows.get(i)[passwordIndex].toString();
                    }
                    InetAddress ip = InetAddress.getLocalHost();
                    List<Object> groupsKeepAsItIs = defaultGroupList;
                    if (this.userAccessor.exists(userName)) {
                        com.atlassian.crowd.embedded.api.User crowdUser;
                        LOGGER.debug("User " + userName + " Already Exists. Updating user info.");
                        LOGGER.debug("user email = " + userEmail + " full name = " + fullName);
                        Boolean isAdmin = Boolean.FALSE;
                        user = this.userAccessor.getUserByName(userName);
                        isAdmin = this.permissionManager.isSystemAdministrator((User)user);
                        if (isAdmin.booleanValue()) continue;
                        if (!this.userAccessor.isDeactivated((User)user) && (status.equalsIgnoreCase("Inactive") || status.equalsIgnoreCase("false"))) {
                            LOGGER.debug("deactivating user from import action :" + user);
                            this.userAccessor.deactivateUser((User)user);
                            this.pluginHandler.storeAuditLogs(userName, ip.getHostAddress(), "Imported Users", "User Deactivated", "Successful Logs");
                        }
                        if (this.userAccessor.isDeactivated((User)user) && (status.equalsIgnoreCase("Active") || status.equalsIgnoreCase("true"))) {
                            LOGGER.debug("activating user from import action :" + user);
                            this.userAccessor.reactivateUser((User)user);
                            this.pluginHandler.storeAuditLogs(userName, ip.getHostAddress(), "Imported Users", "User Activated", "Successful Logs");
                        }
                        if (this.canGroupsBeUpdated(user) && groupsIndex != -1) {
                            List currentGroups = this.userAccessor.getGroupNames((User)user);
                            LOGGER.debug("Current Groups of the user " + currentGroups.toString());
                            ArrayList<String> groupsToRemove = new ArrayList<String>();
                            for (String groupName : currentGroups) {
                                if (groupsKeepAsItIs.contains(groupName) || groupName.contains("confluence-administrators")) continue;
                                groupsToRemove.add(groupName);
                            }
                            LOGGER.debug("Groups to Remove from " + userName + " are :- " + ((Object)groupsToRemove).toString());
                            this.removeUserFromGroups(userName, groupsToRemove, ip.getHostAddress());
                            ArrayList groupsToAssign = (ArrayList)this.createAndAssignNewGroupsUser(groupsKeepAsItIs);
                            if (!currentGroups.toString().equals(groupsToAssign.toString())) {
                                LOGGER.debug("groupsToAssign := " + groupsToAssign);
                                this.addUserToGroups(userName, groupsToAssign);
                                this.pluginHandler.storeAuditLogs(userName, ip.getHostAddress(), "Imported Users", "User Updated. Added User to Groups:-" + groupsToAssign, "Successful Logs");
                                this.totalUpdations = ++updations;
                            }
                        }
                        if ((crowdUser = this.crowdService.getUser(user.getName())).getDisplayName().equals(fullName) && crowdUser.getEmailAddress().equals(userEmail)) continue;
                        UserTemplate userTemplate = new UserTemplate(crowdUser);
                        Long dirId = userTemplate.getDirectoryId();
                        userTemplate.setEmailAddress(userEmail);
                        userTemplate.setDisplayName(fullName);
                        this.directoryManager.updateUser(dirId.longValue(), userTemplate);
                        this.pluginHandler.storeAuditLogs(userName, ip.getHostAddress(), "Imported Users", "User Updated. Updated User Profile. ", "Successful Logs");
                        this.totalUpdations = ++updations;
                        continue;
                    }
                    LOGGER.debug("User " + userName + " does Not Exist. Creating User ");
                    if (directory.isEmpty()) {
                        Directory internalDir = this.directoryManager.findDirectoryByName("Confluence Internal Directory");
                        directoryId = internalDir.getId();
                    }
                    try {
                        UserTemplate newUser = new UserTemplate(userName, directoryId.longValue());
                        this.pluginHandler.storeAuditLogs(userName, ip.getHostAddress(), "Imported Users", "User Created Successfuly. ", "Successful Logs");
                        newUser.setDisplayName(fullName);
                        newUser.setEmailAddress(userEmail);
                        newUser.setDirectoryId(directoryId.longValue());
                        if (status.equalsIgnoreCase("Inactive") || status.equalsIgnoreCase("false")) {
                            newUser.setActive(Boolean.FALSE.booleanValue());
                        } else {
                            newUser.setActive(Boolean.TRUE.booleanValue());
                        }
                        this.directoryManager.addUser(directoryId.longValue(), newUser, PasswordCredential.NONE);
                        if (!password.isEmpty()) {
                            try {
                                this.userManager.alterPassword(this.userManager.getUser(newUser.getName()), password);
                            }
                            catch (EntityException e) {
                                LOGGER.error("Error while set Password to " + newUser.getName() + " : " + e);
                                throw new RuntimeException(e);
                            }
                        }
                        this.totalCreations = ++creations;
                    }
                    catch (PermissionException e) {
                        e.printStackTrace();
                    }
                    ArrayList groupsToAssignToNewUser = (ArrayList)this.createAndAssignNewGroupsUser(defaultGroupList);
                    this.addUserToGroups(userName, groupsToAssignToNewUser);
                }
                LOGGER.debug("User Imported Successfully");
                this.addActionError("Users Imported Successfully ", new Object[]{"success", true, null});
                LOGGER.debug("Updations = " + this.totalUpdations + " Creations = " + this.totalCreations);
            }
            catch (Exception e) {
                LOGGER.error("error while uploading file " + e);
            }
        }
    }

    private boolean canGroupsBeUpdated(ConfluenceUser confluenceUser) {
        LOGGER.debug("checking if groups of the user can be updated");
        com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(confluenceUser.getName());
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        return directory != null && directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    private void removeUserFromGroups(String username, List<String> groupsToRemove, String ip) throws OperationNotPermittedException {
        LOGGER.debug("Removing user from groups");
        com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(username);
        for (String group : groupsToRemove) {
            LOGGER.debug("Removing user " + username + " from " + group);
            LOGGER.debug("Removing user [" + username + "] from group [" + group + "]");
            Group grp = this.crowdService.getGroup(group);
            this.crowdService.removeUserFromGroup(user, grp);
            this.pluginHandler.storeAuditLogs(username, ip, "Imported Users", "User Updated.. Removed User from Groups:- " + groupsToRemove, "Successful Logs");
        }
    }

    public void addUserToGroups(String username, List<String> groupsToAssign) throws OperationNotPermittedException {
        LOGGER.debug("Adding user to groups");
        try {
            com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(username);
            for (String group : groupsToAssign) {
                if (group.length() <= 0) continue;
                LOGGER.debug("Adding user " + username + " to " + group);
                LOGGER.debug("Adding user [" + username + "] to group [" + group + "]");
                Group grp = this.crowdService.getGroup(group);
                this.crowdService.addUserToGroup(user, grp);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error adding user to groups");
            e.printStackTrace();
        }
    }

    private List<String> createAndAssignNewGroupsUser(List<String> roleValuesList) {
        ArrayList<String> groupsToAssign = new ArrayList<String>();
        try {
            for (String groupsName : roleValuesList) {
                if (groupsName.length() <= 0) continue;
                if (this.crowdService.getGroup(groupsName.trim()) == null) {
                    LOGGER.debug("Creating new Group with name : " + groupsName);
                    this.userAccessor.createGroup(groupsName);
                }
                groupsToAssign.add(groupsName);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return groupsToAssign;
    }

    @StrutsParameter
    public boolean getIsOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    @StrutsParameter
    public void setIsOfflineLicensevalid(boolean isOfflineLicensevalid) {
        this.isOfflineLicensevalid = isOfflineLicensevalid;
    }

    @StrutsParameter
    public boolean getIsDatacenter() {
        return this.isDatacenter;
    }

    @StrutsParameter
    public void setIsDatacenter(boolean datacenter) {
        this.isDatacenter = datacenter;
    }

    @StrutsParameter
    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.UserManagementUtility;
    }

    @StrutsParameter
    public void setUserManagementUtility(ConfluenceUserManagementUtility userManagementUtility) {
        this.UserManagementUtility = userManagementUtility;
    }

    @StrutsParameter
    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    @StrutsParameter
    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    @StrutsParameter
    public Boolean getUsermanagementuploadSubmitted() {
        return this.usermanagementuploadSubmitted;
    }

    @StrutsParameter
    public void setUsermanagementuploadSubmitted(Boolean usermanagementuploadSubmitted) {
        this.usermanagementuploadSubmitted = usermanagementuploadSubmitted;
    }

    @StrutsParameter
    public Integer getTotalUpdations() {
        return this.totalUpdations;
    }

    @StrutsParameter
    public void setTotalUpdations(Integer totalUpdations) {
        this.totalUpdations = totalUpdations;
    }

    @StrutsParameter
    public Integer getTotalCreations() {
        return this.totalCreations;
    }

    @StrutsParameter
    public void setTotalCreations(Integer totalCreations) {
        this.totalCreations = totalCreations;
    }

    @StrutsParameter
    public Boolean getUploadSuccessful() {
        return this.uploadSuccessful;
    }

    @StrutsParameter
    public void setUploadSuccessful(Boolean uploadSuccessful) {
        this.uploadSuccessful = uploadSuccessful;
    }

    @StrutsParameter
    public Boolean getEvaluationLicense() {
        return this.evaluationLicense;
    }

    @StrutsParameter
    public void setEvaluationLicense(Boolean evaluationLicense) {
        this.evaluationLicense = evaluationLicense;
    }
}

