/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.common;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.gson.Gson;
import com.miniorange.usermanagement.common.CommonAuditLogDetails;
import com.miniorange.usermanagement.common.UserManagementPluginCommonConstants;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;

public class UserManagementPluginSettings {
    private static Log LOGGER = LogFactory.getLog(UserManagementPluginSettings.class);
    private ApplicationProperties applicationProperties;
    private PluginSettingsFactory pluginSettingsFactory;
    private PluginSettings pluginSettings;
    private CrowdService crowdService;

    public UserManagementPluginSettings(PluginSettingsFactory pluginSettingsFactory, CrowdService crowdService, ApplicationProperties applicationProperties) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.crowdService = crowdService;
        this.applicationProperties = applicationProperties;
    }

    public String getBaseURL() {
        String baseURL = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        LOGGER.debug("Returning application's base URL : " + baseURL);
        return baseURL;
    }

    public String getOfflineLicenseKey() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get("miniorange.usermanagement.OFFLINE_LICENSE_KEY"), "");
    }

    public void setOfflineLicenseKey(String licenseKey) {
        this.pluginSettings.put("miniorange.usermanagement.OFFLINE_LICENSE_KEY", (Object)StringUtils.defaultIfBlank(licenseKey, ""));
    }

    public long getNumberOfDays() {
        String numberOfDays = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.NUMBER_OF_USER_INACTIVE_DAYS.getKey()), "30");
        return NumberUtils.createInteger(numberOfDays).intValue();
    }

    public void setNumberOfDays(long numberOfDays) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.NUMBER_OF_USER_INACTIVE_DAYS.getKey(), (Object)String.valueOf(numberOfDays));
    }

    public long getNumberofDaysAfterUserCreation() {
        String daysAfterCreation = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.NUMBER_OF_DAYS_AFTER_USER_CREATION.getKey()), "30");
        return NumberUtils.createInteger(daysAfterCreation).intValue();
    }

    public void setNumberofDaysAfterUserCreation(long daysAfterCreation) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.NUMBER_OF_DAYS_AFTER_USER_CREATION.getKey(), (Object)String.valueOf(daysAfterCreation));
    }

    public long getCustomSchedulerTimeHour() {
        String Custom_scheduler_time_hour = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.CUSTOM_SCHEDULER_TIME_HOUR.getKey()), "01");
        return NumberUtils.createInteger(Custom_scheduler_time_hour).intValue();
    }

    public void setCustomSchedulerTimeHour(Long Custom_scheduler_time_hour) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.CUSTOM_SCHEDULER_TIME_HOUR.getKey(), (Object)String.valueOf(Custom_scheduler_time_hour));
    }

    public long getCustomSchedulerTimeMinute() {
        String Custom_scheduler_time_minute = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.CUSTOM_SCHEDULER_TIME_MINUTE.getKey()), "01");
        return NumberUtils.createInteger(Custom_scheduler_time_minute).intValue();
    }

    public void setCustomSchedulerTimeMinute(long Custom_scheduler_time_minute) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.CUSTOM_SCHEDULER_TIME_MINUTE.getKey(), (Object)String.valueOf(Custom_scheduler_time_minute));
    }

    public long getOnlyLoggedinOnceCheckDays() {
        String days = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.NUMBER_OF_DAYS_CHECK_FOR_ONLY_LOGGEDIN_ONCE.getKey()), "30");
        return NumberUtils.createInteger(days).intValue();
    }

    public void setOnlyLoggedinOnceCheckDays(long days) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.NUMBER_OF_DAYS_CHECK_FOR_ONLY_LOGGEDIN_ONCE.getKey(), (Object)String.valueOf(days));
    }

    public Integer getExportUsersFlagEvalLicense() {
        String exportUsersFlagEvalLicense = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.EXPORT_USERS_FLAG_EVAL_LICENSE.getKey()), "3");
        return NumberUtils.createInteger(exportUsersFlagEvalLicense);
    }

    public void setExportUsersFlagEvalLicense(Integer exportUsersFlagEvalLicense) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.EXPORT_USERS_FLAG_EVAL_LICENSE.getKey(), (Object)String.valueOf(exportUsersFlagEvalLicense));
    }

    public long getScheduler_days() {
        String Scheduler_days = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.SCHEDULER_DAYS.getKey()), "1");
        return NumberUtils.createInteger(Scheduler_days).intValue();
    }

    public void setScheduler_days(long scheduler_days) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SCHEDULER_DAYS.getKey(), (Object)String.valueOf(scheduler_days));
    }

    public Date getPrevSchedulerDate() throws ParseException {
        Date prevDate = null;
        String date = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.PREVIOUS_SCHEDULER_DATE.getKey());
        if (date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            prevDate = formatter.parse(date);
        } else {
            Date currentdate;
            prevDate = currentdate = new Date();
        }
        return prevDate;
    }

    public Date getNextSchedulerDate() throws ParseException {
        Date nextDate = null;
        String date = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.NEXT_SCHEDULER_DATE.getKey());
        if (date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            nextDate = formatter.parse(date);
        } else {
            Date currentdate;
            nextDate = currentdate = new Date();
        }
        return nextDate;
    }

    public void setPrevSchedulerDate(String date) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.PREVIOUS_SCHEDULER_DATE.getKey(), (Object)date);
    }

    public void setNextSchedulerDate(String date) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.NEXT_SCHEDULER_DATE.getKey(), (Object)date);
    }

    public String getUserManagementSelectedAction() {
        String groupManagementSelectedAction = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.GROUP_MANAGEMENT_SELECTION.getKey()), "groupCreationAction");
        groupManagementSelectedAction = groupManagementSelectedAction.replaceAll(" ", "");
        return groupManagementSelectedAction;
    }

    public void setUserManagementSelectedAction(String groupManagementSelectedAction) {
        groupManagementSelectedAction = groupManagementSelectedAction.replaceAll(" ", "");
        this.pluginSettings.put(UserManagementPluginCommonConstants.GROUP_MANAGEMENT_SELECTION.getKey(), (Object)StringUtils.trimToEmpty(StringUtils.defaultIfBlank(groupManagementSelectedAction, "groupCreationAction")));
    }

    public String getCreationSelection() {
        String groupCreation = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.GROUP_CREATION_SELECTION.getKey()), "manuallyAdding");
        return groupCreation;
    }

    public void setCreationSelection(String groupCreation) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.GROUP_CREATION_SELECTION.getKey(), (Object)StringUtils.trimToEmpty(StringUtils.defaultIfBlank(groupCreation, "manuallyAdding")));
    }

    public String getGroupsToCreate() {
        String groupToCreate = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.MANUALLY_GROUP_CREATION.getKey()), "");
        return groupToCreate;
    }

    public void setGroupsToCreate(String groupToCreate) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MANUALLY_GROUP_CREATION.getKey(), (Object)StringUtils.trimToEmpty(StringUtils.defaultIfBlank(groupToCreate, "")));
    }

    public Boolean getReActivateUser() {
        String reActivateUser = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_REACTIVATE_USER.getKey());
        if (StringUtils.isBlank(reActivateUser)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean(reActivateUser);
    }

    public void setReActivateUser(Boolean reActivateUser) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_REACTIVATE_USER.getKey(), (Object)BooleanUtils.toString(reActivateUser, "true", "false", "false"));
    }

    public Boolean getAddGroupsToInactive() {
        String addGroupsToInactive = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ADD_GROUP_TO_INACTIVE_USER.getKey());
        if (StringUtils.isBlank(addGroupsToInactive)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean(addGroupsToInactive);
    }

    public void setAddGroupsToInactive(Boolean addGroupsToInactive) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ADD_GROUP_TO_INACTIVE_USER.getKey(), (Object)BooleanUtils.toString(addGroupsToInactive, "true", "false", "false"));
    }

    public void setAddGroups(ArrayList<String> addGroupsList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ADD_GROUP_LIST.getKey(), addGroupsList);
    }

    public Object getAddGroups() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.ADD_GROUP_LIST.getKey());
    }

    public void setAddGroupsToActiveUsers(Boolean addGroupsToActive) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ADD_GROUPS_TO_ACTIVE_USER.getKey(), (Object)BooleanUtils.toString(addGroupsToActive, "true", "false", "false"));
    }

    public Boolean getAddGroupsToActiveUsers() {
        String addGroupsToInactive = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ADD_GROUPS_TO_ACTIVE_USER.getKey());
        if (StringUtils.isBlank(addGroupsToInactive)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean(addGroupsToInactive);
    }

    public void setGroupsAssignToActiveUser(ArrayList<String> groupsListAssignToActiveUser) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.GROUP_ASSIGN_TO_ACTIVE_USER.getKey(), groupsListAssignToActiveUser);
    }

    public Object getGroupsAssignToActiveUser() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.GROUP_ASSIGN_TO_ACTIVE_USER.getKey());
    }

    public Boolean getAutoDeActivateUsers() {
        String autodeactivatecheck = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_DEACTIVATE_USER.getKey());
        if (StringUtils.isBlank(autodeactivatecheck)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean(autodeactivatecheck);
    }

    public void setAutoDeActivateUsers(Boolean autodeactivatecheck) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_DEACTIVATE_USER.getKey(), (Object)BooleanUtils.toString(autodeactivatecheck, "true", "false", "false"));
    }

    public Boolean getAutoDeleteUsers() {
        String autodeletecheck = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_DELETE_USER.getKey());
        if (StringUtils.isBlank(autodeletecheck)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean(autodeletecheck);
    }

    public void setAutoDeleteUsers(Boolean autodeletecheck) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_DELETE_USER.getKey(), (Object)BooleanUtils.toString(autodeletecheck, "true", "false", "false"));
    }

    public Boolean getEnableAutoRemoveFromGroup() {
        String enableAutoRemoveFromGroup = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ENABLE_AUTO_REMOVE_GROUP.getKey());
        return BooleanUtils.toBoolean(StringUtils.defaultIfBlank(enableAutoRemoveFromGroup, "false"));
    }

    public void setEnableAutoRemoveFromGroup(Boolean enableAutoRemoveFromGroup) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ENABLE_AUTO_REMOVE_GROUP.getKey(), (Object)BooleanUtils.toString(enableAutoRemoveFromGroup, "true", "false", "false"));
    }

    public Boolean getEnableCrowdROUser() {
        String enableCrowdROUser = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ENABLE_CROWD_READ_ONLY_USER.getKey());
        return BooleanUtils.toBoolean(StringUtils.defaultIfBlank(enableCrowdROUser, "false"));
    }

    public void setEnableCrowdROUser(Boolean enableCrowdROUser) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ENABLE_CROWD_READ_ONLY_USER.getKey(), (Object)BooleanUtils.toString(enableCrowdROUser, "true", "false", "false"));
    }

    public String getUsernameSuffix() {
        String usernameSuffix = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.USERNAME_SUFFIX.getKey());
        return usernameSuffix == null ? "" : usernameSuffix;
    }

    public void setUsernameSuffix(String usernameSuffix) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.USERNAME_SUFFIX.getKey(), (Object)(usernameSuffix == null ? "" : usernameSuffix));
    }

    public Boolean getPreviousSchedulerFlag() {
        String previousSchedulerFlag = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.PREVIOUS_SCHEDULER_FLAG.getKey());
        if (StringUtils.isBlank(previousSchedulerFlag)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean(previousSchedulerFlag);
    }

    public void setPreviousSchedulerFlag(Boolean previousSchedulerFlag) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.PREVIOUS_SCHEDULER_FLAG.getKey(), (Object)BooleanUtils.toString(previousSchedulerFlag, "true", "false", "false"));
    }

    public void setMailServer(String mailServer) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SERVER.getKey(), (Object)(mailServer != null ? mailServer : ""));
    }

    public String getMailServer() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SERVER.getKey()) != null ? (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SERVER.getKey()) : "";
    }

    public String getMailPeriod() {
        String numberOfDays = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_PERIOD.getKey()), "1");
        return numberOfDays;
    }

    public void setMailPeriod(String numberOfDays) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_PERIOD.getKey(), (Object)String.valueOf(numberOfDays));
    }

    public Boolean getAutoDeactivateNeverLoggedInUser() {
        String neverloggedinusers = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_DEACTIVATE_NEVER_LOGGEDIN_USERS.getKey());
        if (StringUtils.isBlank(neverloggedinusers)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean(neverloggedinusers);
    }

    public void setAutoDeactivateNeverLoggedInUser(Boolean autodeactivatecheck) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_DEACTIVATE_NEVER_LOGGEDIN_USERS.getKey(), (Object)BooleanUtils.toString(autodeactivatecheck, "true", "false", "false"));
    }

    public Boolean getSendMailToNeverLoggedInUsers() {
        String SendMailToNeverLoggedInUsers = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.SEND_MAIL_TO_NEVER_LOGGED_IN_USERS.getKey());
        if (StringUtils.isBlank(SendMailToNeverLoggedInUsers)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean(SendMailToNeverLoggedInUsers);
    }

    public void setSendMailToNeverLoggedInUsers(Boolean sendMailToNeverLoggedInUsers) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SEND_MAIL_TO_NEVER_LOGGED_IN_USERS.getKey(), (Object)BooleanUtils.toString(sendMailToNeverLoggedInUsers, "true", "false", "false"));
    }

    public String getMailServerForNeverLoggedIn() {
        return (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SERVER_FOR_NEVER_LOGGED_IN.getKey());
    }

    public void setMailServerForNeverLoggedIn(String mailServerForNeverLoggedIn) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SERVER_FOR_NEVER_LOGGED_IN.getKey(), (Object)mailServerForNeverLoggedIn);
    }

    public String getMailPeriodForNeverLoggedInUsers() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_PERIOD_FOR_NEVER_LOGGED_IN_USERS.getKey()), "1");
    }

    public void setMailPeriodForNeverLoggedInUsers(String mailPeriodForNeverLoggedInUsers) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_PERIOD_FOR_NEVER_LOGGED_IN_USERS.getKey(), (Object)String.valueOf(mailPeriodForNeverLoggedInUsers));
    }

    public String getMailSubForNeverLoggedInUsers() {
        String mailSubForNeverLoggedInUsers = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SUB_FOR_NEVER_LOGGED_IN_USERS.getKey());
        return mailSubForNeverLoggedInUsers == null || mailSubForNeverLoggedInUsers.isEmpty() ? "Deactivating User" : mailSubForNeverLoggedInUsers;
    }

    public void setMailSubForNeverLoggedInUsers(String mailSubForNeverLoggedInUsers) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SUB_FOR_NEVER_LOGGED_IN_USERS.getKey(), (Object)(mailSubForNeverLoggedInUsers == null || mailSubForNeverLoggedInUsers.isEmpty() ? "Deactivating User" : mailSubForNeverLoggedInUsers));
    }

    public String getMailTextForNeverLoggedInUsers() {
        String mailTextForNeverLoggedInUsers = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_TEXT_FOR_NEVER_LOGGED_IN_USERS.getKey());
        return mailTextForNeverLoggedInUsers == null || mailTextForNeverLoggedInUsers.isEmpty() ? "Hello $$username$$,\n\nWe would like to inform you that your account is scheduled for deactivation due to inactivity in the last $$days$$ days. If you have any questions or require further information, please don't hesitate to contact your Administrator.\n\nThank you." : mailTextForNeverLoggedInUsers;
    }

    public void setMailTextForNeverLoggedInUsers(String mailTextForNeverLoggedInUsers) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_TEXT_FOR_NEVER_LOGGED_IN_USERS.getKey(), (Object)(mailTextForNeverLoggedInUsers != null || !mailTextForNeverLoggedInUsers.isEmpty() ? mailTextForNeverLoggedInUsers : "Hello $$username$$,\n\nWe would like to inform you that your account is scheduled for deactivation due to inactivity in the last $$days$$ days. If you have any questions or require further information, please don't hesitate to contact your Administrator.\n\nThank you."));
    }

    public String getMailSubjectForCreatedUser() {
        String userCreationSubject = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SUBJECT_FOR_CREATED_USER.getKey());
        if (userCreationSubject == null || userCreationSubject.isEmpty()) {
            userCreationSubject = "Welcome to " + this.applicationProperties.getPlatformId() + " - Your Account Details";
        }
        return userCreationSubject;
    }

    public void setMailSubjectForCreatedUser(String userCreationSubject) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SUBJECT_FOR_CREATED_USER.getKey(), (Object)(userCreationSubject == null || userCreationSubject.isEmpty() ? "Welcome to " + this.applicationProperties.getPlatformId() + " - Your Account Details" : userCreationSubject));
    }

    public String getMailTextForCreatedUser() {
        LOGGER.debug("aaplication used : " + this.applicationProperties.getPlatformId());
        String userCreationText = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_TEXT_FOR_CREATED_USER.getKey());
        if (userCreationText == null || userCreationText.isEmpty()) {
            userCreationText = "<html>\n<body> \n\n<h2>Welcome to " + this.applicationProperties.getPlatformId() + "</h2>\n\nHello <b>$$FULLNAME$$</b>,<br>\nYour account has been successfully created. Here are your account details:<br><br>\n\n<b>Username</b>  :- $$USERNAME$$<br>\n<b>Email ID</b> &nbsp;&nbsp;&nbsp;:- $$EMAIL$$<br>\n<b>Full Name</b> :- $$FULLNAME$$<br><br>\n\nIf you have any questions or need further assistance, please don't hesitate to contact your administrator.<br><br>\n\nThank you.<br>\n\n</body>\n</html>";
        }
        return userCreationText;
    }

    public void setMailTextForCreatedUser(String mailText) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_TEXT_FOR_CREATED_USER.getKey(), (Object)(mailText == null || mailText.isEmpty() ? "<html>\n<body> \n\n<h2>Welcome to " + this.applicationProperties.getPlatformId() + "</h2>\n\nHello <b>$$FULLNAME$$</b>,<br>\nYour account has been successfully created. Here are your account details:<br><br>\n\n<b>Username</b>  :- $$USERNAME$$<br>\n<b>Email ID</b> &nbsp;&nbsp;&nbsp;:- $$EMAIL$$<br>\n<b>Full Name</b> :- $$FULLNAME$$<br><br>\n\nIf you have any questions or need further assistance, please don't hesitate to contact your administrator.<br><br>\n\nThank you.<br>\n\n</body>\n</html>" : mailText));
    }

    public Boolean getSendMailToImportUser() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(UserManagementPluginCommonConstants.SEND_MAIL_TO_IMPORT_USERS.getKey())), false);
    }

    public void setSendMailToImportUser(Boolean sendMailNotification) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SEND_MAIL_TO_IMPORT_USERS.getKey(), (Object)BooleanUtils.toString(sendMailNotification, "true", "false", "false"));
    }

    public Boolean getSendPasswordResetMail() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(UserManagementPluginCommonConstants.SEND_PASSWORD_RESET_MAIL.getKey())), false);
    }

    public void setSendPasswordResetMail(Boolean sendPasswordResetMail) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SEND_PASSWORD_RESET_MAIL.getKey(), (Object)BooleanUtils.toString(sendPasswordResetMail, "true", "false", "false"));
    }

    public String getPasswordCreationText() {
        String text = "<html><body><h3><b>Congratulations!</b></h3><b>FULLNAME</b>, your account has been created. <br><br>\n\nTo reset your password, please click the link below:<br><br>\n<a href='PasswordResetURL' style='text-decoration: none;color: #1155cc; font-weight: bold; padding: 6px;font-size: 14px;line-height: 1.429;font-family: Arial, sans-serif;'>Reset Password</a><br><br>\nThis password reset request is valid for the next 24 hours.<br><br>\n\nDon't worry you can always ask for a new password using the following link:<br>\nResendMailURL<br><br>\n\nHere are the details of your account: <br>\n<b>Username</b> : USERNAME<br>\n<b>Email ID</b> &nbsp;&nbsp;&nbsp;: EMAIL<br>\n<b>Full Name</b>: FULLNAME<br><br>\n\nThank you!</body></html>";
        return text;
    }

    public Boolean getOnlyLoggedinOnce() {
        String onlyLoggedinOnce = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ONLY_LOGGEDIN_ONCE.getKey());
        if (StringUtils.isBlank(onlyLoggedinOnce)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean(onlyLoggedinOnce);
    }

    public static String sanitizeText(String text) {
        if (StringUtils.isBlank(text)) {
            return text;
        }
        text = Jsoup.parse(text).text();
        return text;
    }

    public void setOnlyLoggedinOnce(Boolean onlyLoggedinOnce) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ONLY_LOGGEDIN_ONCE.getKey(), (Object)BooleanUtils.toString(onlyLoggedinOnce, "true", "false", "false"));
    }

    public PluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public PluginSettingsFactory getPluginSettingsFactory() {
        return this.pluginSettingsFactory;
    }

    public ArrayList<String> convertSelect2StringToList(String groups) {
        ArrayList<String> groupsList = new ArrayList<String>();
        if (StringUtils.isBlank(groups)) {
            return groupsList;
        }
        Collections.addAll(groupsList, StringUtils.split(groups, ","));
        groupsList.removeAll(Arrays.asList(null, ""));
        return groupsList;
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public Integer getAutoDeleteLogsAfterDays() {
        String autoDeleteLogsAfterDays = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_DELETE_AUDIT_LOGS_AFTER_DAYS.getKey());
        if (NumberUtils.isDigits(autoDeleteLogsAfterDays)) {
            return NumberUtils.createInteger(autoDeleteLogsAfterDays);
        }
        return UserManagementPluginCommonConstants.AUTO_CLEAR_LOG_TIME;
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.IS_DEBUGLOGS_ENABLED.getKey(), (Object)BooleanUtils.toString(enableDebugLogs, "true", "false", "false"));
    }

    public Boolean getEnableDebugLogs() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(UserManagementPluginCommonConstants.IS_DEBUGLOGS_ENABLED.getKey())), false);
    }

    public void setAutoDeleteLogsAfterDays(Integer autoDeleteLogsAfterDays) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_DELETE_AUDIT_LOGS_AFTER_DAYS.getKey(), (Object)String.valueOf(autoDeleteLogsAfterDays));
    }

    public Boolean getSortByLastLogin() {
        LOGGER.debug("inside getSortBYLAst login");
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(UserManagementPluginCommonConstants.SORT_BY_LAST_LOGIN_TIME.getKey())), false);
    }

    public String getStartDateLastLoginTime() {
        String startDatelastLoginTime = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.START_DATE_LASTLOGINTIME.getKey()), "1970-01-01");
        return startDatelastLoginTime;
    }

    public void setStartDateLastLoginTime(String startDatelastLoginTime) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.START_DATE_LASTLOGINTIME.getKey(), (Object)StringUtils.trimToEmpty(StringUtils.defaultIfBlank(startDatelastLoginTime, "1970-01-01")));
    }

    public String getEndDateLastLoginTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
        String[] dateAndTime = expiryDateString.split(" ");
        String currentDate = dateAndTime[0];
        String endDateLastLoginTime = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.END_DATE_LASTLOGINTIME.getKey()), currentDate);
        return endDateLastLoginTime;
    }

    public void setEndDateLastLoginTime(String endDateLastLoginTime) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
        String[] dateAndTime = expiryDateString.split(" ");
        String currentDate = dateAndTime[0];
        this.pluginSettings.put(UserManagementPluginCommonConstants.END_DATE_LASTLOGINTIME.getKey(), (Object)StringUtils.trimToEmpty(StringUtils.defaultIfBlank(endDateLastLoginTime, currentDate)));
    }

    public void setSortByLastLogin(Boolean sortByLastLogin) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SORT_BY_LAST_LOGIN_TIME.getKey(), (Object)String.valueOf(sortByLastLogin));
    }

    public Boolean getAutoDeleteAuditLogs() {
        String autoDeleteAuditLogs = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_DELETE_AUDIT_LOGS.getKey()), "true");
        return BooleanUtils.toBoolean(autoDeleteAuditLogs);
    }

    public void setAutoDeleteAuditLogs(Boolean autoDeleteAuditLogs) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_DELETE_AUDIT_LOGS.getKey(), (Object)BooleanUtils.toString(autoDeleteAuditLogs, "true", "false", "false"));
    }

    public Boolean getEnableDirectoryFilter() {
        String enableDirectoryFilter = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.ENABLE_DIRECTORY_FILTER.getKey()), "false");
        return BooleanUtils.toBoolean(enableDirectoryFilter);
    }

    public void setEnableDirectoryFilter(Boolean enableDirectoryFilter) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ENABLE_DIRECTORY_FILTER.getKey(), (Object)BooleanUtils.toString(enableDirectoryFilter, "true", "false", "false"));
    }

    public void setDirectoryFilterList(ArrayList<String> directoryFilterList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.DIRECTORY_FILTER_LIST.getKey(), directoryFilterList);
    }

    public Object getDirectoryFilterList() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.DIRECTORY_FILTER_LIST.getKey());
    }

    public void setEnableLicenseLimitAlert(Boolean enableLicenseLimitAlert) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ENABLE_LICENSE_LIMIT_ALERT.getKey(), (Object)BooleanUtils.toString(enableLicenseLimitAlert, "true", "false", "false"));
    }

    public Boolean getEnableLicenseLimitAlert() {
        String enableLicenseLimitAlert = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.ENABLE_LICENSE_LIMIT_ALERT.getKey()), "false");
        return BooleanUtils.toBoolean(enableLicenseLimitAlert);
    }

    public void setUserLicenseLimit(String userLicenseLimit) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.LICENSE_LIMIT_ALERT_COUNT.getKey(), (Object)(userLicenseLimit != null ? userLicenseLimit : "0"));
    }

    public String getUserLicenseLimit() {
        String userLicenseLimit = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.LICENSE_LIMIT_ALERT_COUNT.getKey());
        return userLicenseLimit != null ? userLicenseLimit : "0";
    }

    public String getLicenseLimitAlertSubject() {
        return "Action Required: $$APPLICATION$$ License Limit Exceeded";
    }

    public String getLicenseLimitAlertBody() {
        return "<html>\n<head>\n    <style>\n        body { font-family: Arial, sans-serif; }\n        .container { padding: 20px; }\n        .header { font-size: 15px; margin-bottom: 20px; }\n        .details { margin-top: 20px; }\n        .details ul { list-style-type: none; padding: 0; }\n        .details ul li { margin-bottom: 10px; }\n        .footer { margin-top: 20px; }\n    </style>\n</head>\n<body>\n    <div class='container'>\n        <div class='header'>\n            Hi <b>$$Administrator$$</b>,\n        </div>\n        <div class='content'>\n            You are receiving this alert because the current 'licensed user count' has exceeded the threshold set in the Bulk User Management app.\n        </div>\n        <div class='details'>\n            <b>Here is the license information:</b>\n            <ul style='list-style-type: disc; margin-left: 20px;'>\n                <li>User tier for Jira : <b> $$userTier$$ </b></li>\n                <li>Current licensed user count: <b>$$currentCount$$</b></li>\n                <li>License threshold set in app: <b>$$licenseLimit$$</b></li>\n            </ul>\n        </div>\n        <div class='footer'>\n         Please take a moment to review the licensed users and identify any accounts that can be deactivated to avoid upgrading to a higher user tier. To streamline this process, consider enabling the auto-deactivation feature to manage inactive users automatically.<br/>            <br/>\n            Thanks,<br/>\n            <b>miniOrange</b>        </div>\n    </div>\n</body>\n</html>";
    }

    public void setSelectedAdminUserList(ArrayList<String> filteredAdminList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.SELECTED_ADMIN_USER_LIST.getKey(), (Object)(filteredAdminList != null ? filteredAdminList : new ArrayList()));
    }

    public Object getSelectedAdminUserList() {
        Object adminUserList = this.pluginSettings.get(UserManagementPluginCommonConstants.SELECTED_ADMIN_USER_LIST.getKey());
        return adminUserList != null ? adminUserList : new ArrayList();
    }

    public void setMailServerForLicenseAlert(String mailServerForLicenseAlert) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SERVER_FOR_LICENSE_ALERT.getKey(), (Object)(mailServerForLicenseAlert != null ? mailServerForLicenseAlert : ""));
    }

    public String getMailServerForLicenseAlert() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SERVER_FOR_LICENSE_ALERT.getKey()) != null ? (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SERVER_FOR_LICENSE_ALERT.getKey()) : "";
    }

    public Boolean getEnableExcludeGroups() {
        String enableExcludeGroups = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.ENABLE_EXCLUDE_GROUPS.getKey()), "false");
        return BooleanUtils.toBoolean(enableExcludeGroups);
    }

    public void setEnableExcludeGroups(Boolean enableExcludeGroups) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ENABLE_EXCLUDE_GROUPS.getKey(), (Object)BooleanUtils.toString(enableExcludeGroups, "true", "false", "false"));
    }

    public Boolean getMailNotification() {
        String mailNotificationCheck = StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_NOTIFICATIoN_CHECK.getKey()), "false");
        return BooleanUtils.toBoolean(mailNotificationCheck);
    }

    public void setMailNotification(Boolean mailNotificationCheck) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_NOTIFICATIoN_CHECK.getKey(), (Object)BooleanUtils.toString(mailNotificationCheck, "true", "false", "false"));
    }

    public String getMailText() {
        String getAction = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_TEXT.getKey());
        return getAction == null || getAction.isEmpty() ? "Hello $$username$$,\n\nWe noticed that you logged in on $$last_login_date$$, and wanted to inform you that your account is set to be deactivated due to In-Active since $$days$$ days. \n\nIf you have any questions or require further information, please don't hesitate to contact your Administrator.\n\nThank you." : getAction;
    }

    public void setMailText(String mailtext) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_TEXT.getKey(), (Object)(mailtext != null || !mailtext.isEmpty() ? mailtext : "Hello $$username$$,\n\nWe noticed that you logged in on $$last_login_date$$, and wanted to inform you that your account is set to be deactivated due to In-Active since $$days$$ days. \n\nIf you have any questions or require further information, please don't hesitate to contact your Administrator.\n\nThank you."));
    }

    public String getSubText() {
        String getAction = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.MAIL_SUBJECT_TEXT.getKey());
        return getAction == null || getAction.isEmpty() ? "Deactivating User" : getAction;
    }

    public void setSubText(String mailtext) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.MAIL_SUBJECT_TEXT.getKey(), (Object)(mailtext == null || mailtext.isEmpty() ? "Deactivating User" : mailtext));
    }

    public String getSettingOfAssignTikcet() {
        String getAction = (String)this.pluginSettings.get(UserManagementPluginCommonConstants.ASSIGN_TICKET_SETTINGS.getKey());
        return getAction == null || getAction.isEmpty() ? "Action" : getAction;
    }

    public void setSettingOfAssignTikcet(String selectedOption) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ASSIGN_TICKET_SETTINGS.getKey(), (Object)(selectedOption == null || selectedOption.isEmpty() ? "Action" : selectedOption));
    }

    public void setAssignTicketToUser(ArrayList<String> userName) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.ASSIGN_TICKET_TO_USER.getKey(), userName);
    }

    public Object getAssignTicketToUser() {
        ArrayList assigntoUser = (ArrayList)this.pluginSettings.get(UserManagementPluginCommonConstants.ASSIGN_TICKET_TO_USER.getKey());
        if (assigntoUser != null && assigntoUser.isEmpty()) {
            assigntoUser.add("Unassign");
        }
        return assigntoUser;
    }

    public Object getExcludeGroups() {
        if (this.pluginSettings.get(UserManagementPluginCommonConstants.EXCLUDE_GROUPS.getKey()) == null) {
            List<String> defaultGroups = this.getDefaultGroupsForInitialConfiguration();
            return defaultGroups;
        }
        return this.pluginSettings.get(UserManagementPluginCommonConstants.EXCLUDE_GROUPS.getKey());
    }

    public void setExcludeGroups(ArrayList<String> defaultGroups) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.EXCLUDE_GROUPS.getKey(), defaultGroups);
    }

    public Object getAutoRemoveGroups() {
        return this.pluginSettings.get(UserManagementPluginCommonConstants.AUTO_REMOVE_GROUPS.getKey());
    }

    public void setAutoRemoveGroups(ArrayList<String> autoRemoveGroupsList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUTO_REMOVE_GROUPS.getKey(), autoRemoveGroupsList);
    }

    public Object getGroupsToDelete() {
        if (this.pluginSettings.get(UserManagementPluginCommonConstants.GROUPS_TO_DELETE.getKey()) == null) {
            List<String> defaultGroups = this.getDefaultGroupsForInitialConfiguration();
            return defaultGroups;
        }
        return this.pluginSettings.get(UserManagementPluginCommonConstants.GROUPS_TO_DELETE.getKey());
    }

    public void setGroupsToDelete(ArrayList<String> defaultGroups) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.GROUPS_TO_DELETE.getKey(), defaultGroups);
    }

    public List<String> getAuditLogs() {
        if (this.pluginSettings.get(UserManagementPluginCommonConstants.AUDIT_LOGS.getKey()) != null) {
            return (List)this.pluginSettings.get(UserManagementPluginCommonConstants.AUDIT_LOGS.getKey());
        }
        return new ArrayList<String>();
    }

    public void setAuditLogs(List<String> auditLogList) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.AUDIT_LOGS.getKey(), auditLogList);
    }

    public String getNoOfDaysForUsersDashboard() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(UserManagementPluginCommonConstants.USER_DASHBOARD_PERIOD.getKey()), "30");
    }

    public void setNoOfDaysForUsersDashboard(String noOfDays) {
        this.pluginSettings.put(UserManagementPluginCommonConstants.USER_DASHBOARD_PERIOD.getKey(), (Object)noOfDays);
    }

    public List<String> getDefaultGroupsForInitialConfiguration() {
        ArrayList<String> groupList = new ArrayList<String>();
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        LOGGER.debug("Query for Group : " + query);
        Iterable groupsFromSystem = this.crowdService.search((Query)query);
        for (Group group : groupsFromSystem) {
            if (groupList.contains(group.getName())) continue;
            groupList.add(group.getName());
        }
        ArrayList<String> excludeGroup = new ArrayList<String>();
        if (groupList.size() > 0) {
            excludeGroup.add((String)groupList.get(0));
        }
        LOGGER.debug("Exclude Group::" + excludeGroup);
        return excludeGroup;
    }

    public List<String> getLogsToDisplay(List<String> auditLogsList, String username, String ip, String action, String status, String period) throws ParseException {
        ArrayList<String> filteredAuditLogsList = new ArrayList<String>();
        ArrayList<CommonAuditLogDetails> listOfAuditLogsObjects = new ArrayList<CommonAuditLogDetails>();
        Collections.reverse(auditLogsList);
        LOGGER.debug("auditlog size :" + auditLogsList.size());
        Gson gson = new Gson();
        for (int counter = 0; counter < auditLogsList.size(); ++counter) {
            CommonAuditLogDetails backToObject = gson.fromJson(auditLogsList.get(counter), CommonAuditLogDetails.class);
            listOfAuditLogsObjects.add(backToObject);
        }
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        for (int counter = 0; counter < listOfAuditLogsObjects.size(); ++counter) {
            if (!StringUtils.isBlank(username) && !StringUtils.containsIgnoreCase(((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getUsername(), username) || !StringUtils.isBlank(ip) && !StringUtils.equals(((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getIpAddress(), ip) || !StringUtils.equals("All Actions", action) && !StringUtils.equals(((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getAction(), action) || !StringUtils.equals("All Status", status) && !StringUtils.equals(((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getStatus(), status)) continue;
            if (StringUtils.equals("All Days", period)) {
                filteredAuditLogsList.add(auditLogsList.get(counter));
                continue;
            }
            long intervalSelected = NumberUtils.createInteger(String.valueOf(period)).intValue();
            long intervalSelectedInMilliSecs = intervalSelected * 86400000L;
            long timeInPast = timeMilliSecs - intervalSelectedInMilliSecs;
            Date dateBeforeInterval = new Date(timeInPast);
            SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
            Date StringToDateForDatabaseEntry = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z").parse(((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getDateAndTime());
            int isLoginAfterInterval = StringToDateForDatabaseEntry.compareTo(dateBeforeInterval);
            if (isLoginAfterInterval < 0) continue;
            filteredAuditLogsList.add(auditLogsList.get(counter));
        }
        LOGGER.debug("filterauditlog size :" + filteredAuditLogsList.size());
        return filteredAuditLogsList;
    }
}

