/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.servlet;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.user.User;
import com.google.gson.Gson;
import com.miniorange.usermanagement.common.CommonAuditLogDetails;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoAuditLogsExport
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoAuditLogsExport.class);
    private UserManagementPluginSettings settings;
    private UserAccessor userAccessor;
    private DirectoryManager directoryManager;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private PermissionManager permissionManager;
    private CrowdService crowdService;
    private ConfluenceUserManagementUtility confluenceUserManagementUtility;

    public MoAuditLogsExport(UserAccessor userAccessor, DirectoryManager directoryManager, UserDeactivaterScheduler userDeactivaterScheduler, PermissionManager permissionManager, CrowdService crowdService, ConfluenceUserManagementUtility confluenceUserManagementUtility, UserManagementPluginSettings settings) {
        this.userAccessor = userAccessor;
        this.directoryManager = directoryManager;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.permissionManager = permissionManager;
        this.crowdService = crowdService;
        this.confluenceUserManagementUtility = confluenceUserManagementUtility;
        this.settings = settings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Boolean isEvaluationLicensefound;
        if (this.confluenceUserManagementUtility.getMaxUsers() == 0) {
            LOGGER.debug("No license found for app. plugin will not work unless app license is applied.");
            this.sendErrorResponse("Error_User_License", response);
            return;
        }
        if (this.confluenceUserManagementUtility.isEvaluationLicense().booleanValue() && this.confluenceUserManagementUtility.isValidEvaluationLicense().booleanValue()) {
            LOGGER.error("Evaluation license found for app. Operations will be allowed for only 50 users");
            isEvaluationLicensefound = true;
        } else {
            isEvaluationLicensefound = false;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        Boolean isAdmin = Boolean.FALSE;
        if (currentUser != null) {
            isAdmin = this.permissionManager.hasPermission((User)currentUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
        }
        if (isAdmin.booleanValue()) {
            String username = request.getParameter("username");
            String ip = request.getParameter("ip");
            String action = request.getParameter("action");
            String period = request.getParameter("period");
            String status = request.getParameter("status");
            List<Object> filteredAuditLogsList = new ArrayList();
            try {
                filteredAuditLogsList = this.settings.getLogsToDisplay(this.settings.getAuditLogs(), username, ip, action, status, period);
            }
            catch (Exception e) {
                LOGGER.debug("excption in error " + e);
            }
            ArrayList<CommonAuditLogDetails> auditLogsObjects = new ArrayList<CommonAuditLogDetails>();
            Gson gson = new Gson();
            for (int counter = 0; counter < filteredAuditLogsList.size(); ++counter) {
                CommonAuditLogDetails backToObject = gson.fromJson((String)filteredAuditLogsList.get(counter), CommonAuditLogDetails.class);
                auditLogsObjects.add(backToObject);
            }
            StringJoiner stringJoiner = new StringJoiner(",");
            stringJoiner.add("Sr.no");
            stringJoiner.add("Username");
            stringJoiner.add("Date");
            stringJoiner.add("IP Address");
            stringJoiner.add("Action");
            stringJoiner.add("Description");
            stringJoiner.add("Status");
            String str = stringJoiner.toString() + "\n";
            int listCounter = 0;
            for (int counter = 0; counter < auditLogsObjects.size(); ++counter) {
                stringJoiner = new StringJoiner(",");
                stringJoiner.add("" + ++listCounter);
                stringJoiner.add(((CommonAuditLogDetails)auditLogsObjects.get(counter)).getUsername());
                stringJoiner.add(((CommonAuditLogDetails)auditLogsObjects.get(counter)).getDateAndTime());
                stringJoiner.add(((CommonAuditLogDetails)auditLogsObjects.get(counter)).getIpAddress());
                stringJoiner.add(((CommonAuditLogDetails)auditLogsObjects.get(counter)).getAction());
                stringJoiner.add(((CommonAuditLogDetails)auditLogsObjects.get(counter)).getStatus());
                String desc = ((CommonAuditLogDetails)auditLogsObjects.get(counter)).getDescription();
                String finalDescription = desc.replace(',', ';');
                stringJoiner.add(finalDescription);
                str = str + stringJoiner.toString() + "\n";
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"Confluence_BulkUserManagement_Audit_Logs.csv\"");
            response.setHeader("Cache-Control", "max-age=0");
            response.setHeader("Pragma", "");
            response.setContentType("text/csv");
            response.getOutputStream().write(str.getBytes());
            return;
        }
        LOGGER.debug("You do not have administrator privilege to Perform the Operation. ");
        this.sendErrorResponse("Error_Admin_Privilege", response);
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }
}

