/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.OfflineLicenseSettings;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class UserDeactivateAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(UserDeactivateAction.class);
    private Boolean autodeactivatecheck;
    private String usernameSuffix;
    private UserManagementPluginHandler userManagementPluginHandler;
    private UserManagementPluginSettings settings;
    private OfflineLicenseSettings licenseSettings;
    private boolean isDatacenter;
    private boolean isOfflineLicensevalid = false;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private final MailServerManager mailServerManager;
    private final ConfluenceUserManagementUtility userManagementUtility;
    private Boolean enableAutoRemoveFromGroup;
    private long limitDays;
    private Boolean mailNotification;
    private ArrayList<String> emailServers = new ArrayList();
    private String mailPeriod = "1";
    private String mailSubject = "";
    private String emailTemplate = "";
    private Boolean neverLoggedinUsers;
    private long daysAfterUserCreation;
    private Boolean sendMailToNeverLoggedInUsers;
    private Boolean autoDeactivateSubmited;
    private Boolean autoActivateSubmited;
    private Boolean maxUsersLicense;
    private Boolean enableExcludeGroups;
    private String mailServer = "";
    private String mailServerForNeverLoggedIn = "";
    private String mailPeriodForNeverLoggedInUsers = "1";
    private String mailSubForNeverLoggedInUsers = "";
    private String mailTextForNeverLoggedInUsers = "";
    private String excludeGroups;
    private long scheduler_days;
    private Date previousSchedulerDate;
    private Date nextSchedulerDate;
    private ArrayList<String> excludeGroupsList;
    private Boolean reActivateUser;
    private Boolean addGroupsToInactive;
    private String addGroups;
    private ArrayList<String> addGroupsList;
    private Boolean isGroupsEmpty = false;
    private Boolean addGroupsToActiveUser;
    private String groupsAssignToActiveUser = "";
    private ArrayList<String> groupsListAssignToActiveUser;
    private Boolean groupEmptyForActiveUser = false;
    private String autoRemoveGroups;
    private ArrayList<String> autoRemoveGroupsList = new ArrayList();
    private List<SMTPMailServer> smtpServers;
    private long customSchedulerTimeHour;
    private long customSchedulerTimeMinute;
    private Boolean previousSchedulerFlag;
    private Boolean enableLicenseLimitAlert;
    private String mailServerForLicenseAlert;
    private String userLicenseLimit;
    private Integer totalLicensedUsers;
    private UserChecker userChecker;
    private String adminsForAlert = "";
    private ArrayList<String> selectedAdminList;

    public UserDeactivateAction(UserManagementPluginHandler userManagementPluginHandler, UserManagementPluginSettings settings, UserDeactivaterScheduler userDeactivaterScheduler, ConfluenceUserManagementUtility confluenceUserManagement, OfflineLicenseSettings licenseSettings, MailServerManager mailServerManager, UserChecker userChecker) {
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.settings = settings;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.userManagementUtility = confluenceUserManagement;
        this.licenseSettings = licenseSettings;
        this.mailServerManager = mailServerManager;
        this.userChecker = userChecker;
    }

    public Boolean doValidate() throws ParseException {
        LOGGER.debug("Settings Action doValidate");
        LOGGER.debug("value of mail period : " + this.mailPeriod);
        Boolean isError = Boolean.FALSE;
        if (this.enableExcludeGroups == null) {
            this.enableExcludeGroups = false;
        }
        if (this.enableLicenseLimitAlert == null) {
            this.enableLicenseLimitAlert = false;
        }
        if (this.userLicenseLimit == null) {
            this.userLicenseLimit = "0";
        }
        if (BooleanUtils.toBoolean(this.autoDeactivateSubmited)) {
            try {
                long number;
                if (this.limitDays == 0L) {
                    this.limitDays = this.settings.getNumberOfDays();
                }
                if (this.daysAfterUserCreation == 0L) {
                    this.daysAfterUserCreation = this.settings.getNumberofDaysAfterUserCreation();
                }
                if (BooleanUtils.toBoolean(this.enableAutoRemoveFromGroup) && StringUtils.isBlank(this.autoRemoveGroups)) {
                    this.addActionError("Groups field is left blank. Please select at groups to revoke application access from inactive users");
                    isError = Boolean.TRUE;
                }
                if (StringUtils.isBlank(this.excludeGroups)) {
                    this.addActionError("Exclude groups is left blank. Please select at least one group");
                    isError = Boolean.TRUE;
                }
                if (BooleanUtils.toBoolean(this.mailNotification) && StringUtils.isBlank(this.mailPeriod)) {
                    this.addActionError("Please enter valid mail period");
                    isError = Boolean.TRUE;
                }
                if (BooleanUtils.toBoolean(this.sendMailToNeverLoggedInUsers) && StringUtils.isBlank(this.mailPeriodForNeverLoggedInUsers)) {
                    this.addActionError("Please enter valid mail period for Never Logged-In Users.");
                    isError = Boolean.TRUE;
                }
                if (this.scheduler_days == 0L) {
                    this.scheduler_days = this.settings.getScheduler_days();
                }
                if ((number = this.limitDays) < 1L) {
                    isError = Boolean.TRUE;
                    this.addActionError("Invalid Number of Days. The Inactive number of days must be more than 1 day. :" + number);
                    LOGGER.debug("Entered Invalid number :" + number);
                    return isError;
                }
                if (this.daysAfterUserCreation < 1L) {
                    this.addActionError("Invalid Number of Days. The number of days after user creation must be more than 1 day.");
                    isError = Boolean.TRUE;
                }
                if (this.scheduler_days < 1L) {
                    this.addActionError("Invalid Number of Days. The Scheduler time must be more than 1 day.");
                    isError = Boolean.TRUE;
                    LOGGER.error("Entered Invalid number :" + this.scheduler_days);
                }
                if (this.autodeactivatecheck == Boolean.TRUE && (this.mailNotification == Boolean.TRUE || this.sendMailToNeverLoggedInUsers == Boolean.TRUE) && this.mailServerManager.getSmtpMailServers().isEmpty()) {
                    isError = Boolean.TRUE;
                    this.addActionError("Please configure mail server.");
                    LOGGER.debug("Mail server configuration is empty.");
                }
                if (Boolean.valueOf(this.enableLicenseLimitAlert).booleanValue()) {
                    if (Integer.parseInt(this.userLicenseLimit) <= this.totalLicensedUsers && !this.userLicenseLimit.equals("0")) {
                        this.addActionError("User license limit should not be less than the total number of licensed users.");
                        LOGGER.error("User License Limit is less than total licensed users size.");
                        isError = Boolean.TRUE;
                    }
                    if (this.mailServerManager.getSmtpMailServers().isEmpty()) {
                        this.addActionError("Please configure mail server.");
                        LOGGER.debug("Mail server configuration is empty.");
                        isError = Boolean.TRUE;
                    }
                }
            }
            catch (Exception e) {
                isError = Boolean.TRUE;
                this.addActionError("Please enter valid Number. ");
                LOGGER.debug("you have enter negative or zero number ");
                return isError;
            }
        }
        if (isError.booleanValue()) {
            this.initalization();
            return isError;
        }
        return isError;
    }

    public String execute() throws Exception {
        ConfluenceUser loggedInAdmin;
        LOGGER.debug("inside UserDeactivateAction doExecute ");
        this.smtpServers = this.mailServerManager.getSmtpMailServers();
        LOGGER.debug("smtpServer : " + this.smtpServers);
        for (SMTPMailServer smtpServer : this.smtpServers) {
            String name = smtpServer.getName();
            this.emailServers.add(name);
        }
        LOGGER.debug("emailservers in confluence : " + this.emailServers);
        if (!this.userManagementUtility.isLicenseValid().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return "invalid";
        }
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        this.totalLicensedUsers = this.userChecker.getNumberOfRegisteredUsers();
        if (this.adminsForAlert.isEmpty() && (loggedInAdmin = AuthenticatedUserThreadLocal.get()) != null) {
            this.adminsForAlert = loggedInAdmin.getEmail();
            if (((ArrayList)this.settings.getSelectedAdminUserList()).isEmpty()) {
                this.settings.setSelectedAdminUserList(new ArrayList<String>(Collections.singletonList(this.adminsForAlert)));
            }
        }
        if (BooleanUtils.toBoolean(this.autoActivateSubmited)) {
            this.settings.setReActivateUser(this.reActivateUser);
            if (this.addGroupsToInactive == null) {
                this.addGroupsToInactive = false;
            }
            if (this.addGroupsToActiveUser == null) {
                this.addGroupsToActiveUser = false;
            }
            if ((this.addGroups == null || this.addGroups.isEmpty()) && this.addGroupsToInactive.booleanValue()) {
                this.isGroupsEmpty = true;
                LOGGER.debug("Group list are empty...");
            } else {
                this.addGroupsList = this.settings.convertSelect2StringToList(this.addGroups);
                this.settings.setAddGroupsToInactive(this.addGroupsToInactive);
                this.settings.setAddGroups(this.addGroupsList);
            }
            if (this.groupsAssignToActiveUser.isEmpty() && this.addGroupsToActiveUser.booleanValue()) {
                this.groupEmptyForActiveUser = true;
                LOGGER.debug("groups added to active users are empty!");
            } else {
                this.settings.setAddGroupsToActiveUsers(this.addGroupsToActiveUser);
                this.groupsListAssignToActiveUser = this.settings.convertSelect2StringToList(this.groupsAssignToActiveUser);
                this.settings.setGroupsAssignToActiveUser(this.groupsListAssignToActiveUser);
            }
        }
        if (BooleanUtils.toBoolean(this.autoDeactivateSubmited) && !BooleanUtils.toBoolean(this.doValidate())) {
            if (this.enableAutoRemoveFromGroup == null) {
                this.enableAutoRemoveFromGroup = false;
            }
            if (this.autodeactivatecheck == null) {
                this.autodeactivatecheck = false;
            }
            if (this.neverLoggedinUsers == null) {
                this.neverLoggedinUsers = false;
            }
            if (this.sendMailToNeverLoggedInUsers == null) {
                this.sendMailToNeverLoggedInUsers = false;
            }
            if (this.mailNotification == null) {
                this.mailNotification = false;
            }
            if (this.mailPeriod == null) {
                this.mailPeriod = "1";
            }
            if (this.mailPeriodForNeverLoggedInUsers == null) {
                this.mailPeriodForNeverLoggedInUsers = "1";
            }
            if (this.enableExcludeGroups == null) {
                this.enableExcludeGroups = false;
            }
            if (this.enableLicenseLimitAlert == null) {
                this.enableLicenseLimitAlert = false;
            }
            if (this.userLicenseLimit == null) {
                this.userLicenseLimit = "0";
            }
            this.excludeGroupsList = this.settings.convertSelect2StringToList(this.excludeGroups);
            this.autoRemoveGroupsList = this.settings.convertSelect2StringToList(this.autoRemoveGroups);
            this.selectedAdminList = this.settings.convertSelect2StringToList(this.adminsForAlert);
            if (this.autoRemoveGroupsList.isEmpty()) {
                this.enableAutoRemoveFromGroup = false;
            }
            if (this.customSchedulerTimeHour == 0L) {
                this.customSchedulerTimeHour = 1L;
            }
            if (this.customSchedulerTimeMinute == 0L) {
                this.customSchedulerTimeMinute = 1L;
            }
            this.userManagementPluginHandler.saveUserManagementSettings(this.limitDays, this.autodeactivatecheck, this.enableAutoRemoveFromGroup, this.autoRemoveGroupsList, this.neverLoggedinUsers, this.daysAfterUserCreation, this.scheduler_days, this.enableExcludeGroups, this.excludeGroupsList, this.customSchedulerTimeHour, this.customSchedulerTimeMinute, this.previousSchedulerFlag, false, 0L, this.mailNotification, this.mailPeriod, this.mailSubject, this.emailTemplate, this.mailServer, this.usernameSuffix, false, this.sendMailToNeverLoggedInUsers, this.mailServerForNeverLoggedIn, this.mailPeriodForNeverLoggedInUsers, this.mailSubForNeverLoggedInUsers, this.mailTextForNeverLoggedInUsers, false, new ArrayList<String>(), false, this.enableLicenseLimitAlert, this.userLicenseLimit, this.selectedAdminList, this.mailServerForLicenseAlert);
            if (this.autodeactivatecheck.booleanValue() || this.enableAutoRemoveFromGroup.booleanValue()) {
                this.settings.setPreviousSchedulerFlag(true);
                LOGGER.debug(" saveUserManagementSettings : Schedule Task");
                this.userDeactivaterScheduler.schedule();
            } else if (!this.autodeactivatecheck.booleanValue() && !this.enableAutoRemoveFromGroup.booleanValue()) {
                LOGGER.debug(" saveUserManagementSettings : Unschedule Task");
                this.userDeactivaterScheduler.unschedule();
            }
            this.addActionMessage("Configuration saved Successfully", new Object[]{"success", true, null});
        }
        this.initalization();
        return "success";
    }

    public void initalization() throws ParseException {
        LOGGER.debug("calling initialization...");
        this.limitDays = this.settings.getNumberOfDays();
        this.daysAfterUserCreation = this.settings.getNumberofDaysAfterUserCreation();
        this.autodeactivatecheck = this.settings.getAutoDeActivateUsers();
        this.mailNotification = this.settings.getMailNotification();
        this.mailPeriod = String.valueOf(this.settings.getMailPeriod());
        this.mailSubject = this.settings.getSubText();
        this.emailTemplate = this.settings.getMailText();
        this.neverLoggedinUsers = this.settings.getAutoDeactivateNeverLoggedInUser();
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        this.excludeGroupsList = (ArrayList)this.settings.getExcludeGroups();
        this.scheduler_days = this.settings.getScheduler_days();
        this.enableExcludeGroups = this.settings.getEnableExcludeGroups();
        this.enableAutoRemoveFromGroup = this.settings.getEnableAutoRemoveFromGroup();
        this.autoRemoveGroupsList = (ArrayList)this.settings.getAutoRemoveGroups();
        this.previousSchedulerDate = this.settings.getPrevSchedulerDate();
        this.nextSchedulerDate = this.settings.getNextSchedulerDate();
        this.customSchedulerTimeHour = this.settings.getCustomSchedulerTimeHour();
        this.customSchedulerTimeMinute = this.settings.getCustomSchedulerTimeMinute();
        this.previousSchedulerFlag = this.settings.getPreviousSchedulerFlag();
        this.reActivateUser = this.settings.getReActivateUser();
        this.addGroupsToInactive = this.settings.getAddGroupsToInactive();
        this.addGroupsList = (ArrayList)this.settings.getAddGroups();
        this.addGroupsToActiveUser = this.settings.getAddGroupsToActiveUsers();
        this.groupsListAssignToActiveUser = (ArrayList)this.settings.getGroupsAssignToActiveUser();
        this.isOfflineLicensevalid = this.licenseSettings.isOfflineLicenseValid();
        this.isDatacenter = this.licenseSettings.isDatacenter();
        this.mailServer = this.settings.getMailServer();
        this.usernameSuffix = this.settings.getUsernameSuffix();
        this.sendMailToNeverLoggedInUsers = this.settings.getSendMailToNeverLoggedInUsers();
        this.mailServerForNeverLoggedIn = this.settings.getMailServerForNeverLoggedIn();
        this.mailPeriodForNeverLoggedInUsers = this.settings.getMailPeriodForNeverLoggedInUsers();
        this.mailSubForNeverLoggedInUsers = this.settings.getMailSubForNeverLoggedInUsers();
        this.mailTextForNeverLoggedInUsers = this.settings.getMailTextForNeverLoggedInUsers();
        this.enableLicenseLimitAlert = this.settings.getEnableLicenseLimitAlert();
        this.userLicenseLimit = this.settings.getUserLicenseLimit();
        this.adminsForAlert = String.join((CharSequence)",", (ArrayList)this.settings.getSelectedAdminUserList());
        this.mailServerForLicenseAlert = this.settings.getMailServerForLicenseAlert();
    }

    @StrutsParameter
    public Boolean getEnableAutoRemoveFromGroup() {
        return this.enableAutoRemoveFromGroup;
    }

    @StrutsParameter
    public void setEnableAutoRemoveFromGroup(Boolean enableAutoRemoveFromGroup) {
        this.enableAutoRemoveFromGroup = enableAutoRemoveFromGroup;
    }

    @StrutsParameter
    public ArrayList<String> getAutoRemoveGroupsList() {
        return this.autoRemoveGroupsList;
    }

    @StrutsParameter
    public void setAutoRemoveGroupsList(ArrayList<String> autoRemoveGroupsList) {
        this.autoRemoveGroupsList = autoRemoveGroupsList;
    }

    @StrutsParameter
    public String getAutoRemoveGroups() {
        return this.autoRemoveGroups;
    }

    @StrutsParameter
    public void setAutoRemoveGroups(String autoRemoveGroups) {
        this.autoRemoveGroups = autoRemoveGroups;
    }

    @StrutsParameter
    public boolean getIsOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    @StrutsParameter
    public void setIsOfflineLicensevalid(boolean isOfflineLicensevalid) {
        this.isOfflineLicensevalid = isOfflineLicensevalid;
    }

    @StrutsParameter
    public boolean getIsDatacenter() {
        return this.isDatacenter;
    }

    @StrutsParameter
    public void setIsDatacenter(boolean datacenter) {
        this.isDatacenter = datacenter;
    }

    @StrutsParameter
    public Boolean getAutoDeactivateSubmited() {
        return this.autoDeactivateSubmited;
    }

    @StrutsParameter
    public void setAutoDeactivateSubmited(Boolean autoDeactivateSubmited) {
        this.autoDeactivateSubmited = autoDeactivateSubmited;
    }

    @StrutsParameter
    public long getLimitDays() {
        return this.limitDays;
    }

    @StrutsParameter
    public void setLimitDays(long limitDays) {
        this.limitDays = limitDays;
    }

    @StrutsParameter
    public long getDaysAfterUserCreation() {
        return this.daysAfterUserCreation;
    }

    @StrutsParameter
    public void setDaysAfterUserCreation(long daysAfterUserCreation) {
        this.daysAfterUserCreation = daysAfterUserCreation;
    }

    @StrutsParameter
    public UserManagementPluginHandler getUserManagementPluginHandler() {
        return this.userManagementPluginHandler;
    }

    @StrutsParameter
    public void setUserManagementPluginHandler(UserManagementPluginHandler userManagementPluginHandler) {
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    @StrutsParameter
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public Boolean getautodeactivatecheck() {
        return this.autodeactivatecheck;
    }

    @StrutsParameter
    public void setautodeactivatecheck(Boolean autodeactivatecheck) {
        this.autodeactivatecheck = autodeactivatecheck;
    }

    @StrutsParameter
    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    @StrutsParameter
    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    @StrutsParameter
    public Boolean getMailNotification() {
        return this.mailNotification;
    }

    @StrutsParameter
    public void setMailNotification(Boolean mailNotification) {
        this.mailNotification = mailNotification;
    }

    @StrutsParameter
    public ArrayList<String> getEmailServers() {
        return this.emailServers;
    }

    @StrutsParameter
    public void setEmailServers(ArrayList<String> emailServers) {
        this.emailServers = emailServers;
    }

    @StrutsParameter
    public String getMailServer() {
        return this.mailServer;
    }

    @StrutsParameter
    public void setMailServer(String mailServer) {
        this.mailServer = mailServer;
    }

    @StrutsParameter
    public String getMailPeriod() {
        return this.mailPeriod;
    }

    @StrutsParameter
    public void setMailPeriod(String mailPeriod) {
        this.mailPeriod = mailPeriod;
    }

    @StrutsParameter
    public String getMailSubject() {
        return this.mailSubject;
    }

    @StrutsParameter
    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    @StrutsParameter
    public String getEmailTemplate() {
        return this.emailTemplate;
    }

    @StrutsParameter
    public void setEmailTemplate(String emailTemplate) {
        this.emailTemplate = emailTemplate;
    }

    @StrutsParameter
    public Boolean getNeverLoggedinUsers() {
        return this.neverLoggedinUsers;
    }

    @StrutsParameter
    public void setNeverLoggedinUsers(Boolean neverLoggedinUsers) {
        this.neverLoggedinUsers = neverLoggedinUsers;
    }

    @StrutsParameter
    public Boolean getSendMailToNeverLoggedInUsers() {
        return this.sendMailToNeverLoggedInUsers;
    }

    @StrutsParameter
    public void setSendMailToNeverLoggedInUsers(Boolean sendMailToNeverLoggedInUsers) {
        this.sendMailToNeverLoggedInUsers = sendMailToNeverLoggedInUsers;
    }

    @StrutsParameter
    public String getMailServerForNeverLoggedIn() {
        return this.mailServerForNeverLoggedIn;
    }

    @StrutsParameter
    public void setMailServerForNeverLoggedIn(String mailServerForNeverLoggedIn) {
        this.mailServerForNeverLoggedIn = mailServerForNeverLoggedIn;
    }

    @StrutsParameter
    public String getMailPeriodForNeverLoggedInUsers() {
        return this.mailPeriodForNeverLoggedInUsers;
    }

    @StrutsParameter
    public void setMailPeriodForNeverLoggedInUsers(String mailPeriodForNeverLoggedInUsers) {
        this.mailPeriodForNeverLoggedInUsers = mailPeriodForNeverLoggedInUsers;
    }

    @StrutsParameter
    public String getMailSubForNeverLoggedInUsers() {
        return this.mailSubForNeverLoggedInUsers;
    }

    @StrutsParameter
    public void setMailSubForNeverLoggedInUsers(String mailSubForNeverLoggedInUsers) {
        this.mailSubForNeverLoggedInUsers = mailSubForNeverLoggedInUsers;
    }

    @StrutsParameter
    public String getMailTextForNeverLoggedInUsers() {
        return this.mailTextForNeverLoggedInUsers;
    }

    @StrutsParameter
    public void setMailTextForNeverLoggedInUsers(String mailTextForNeverLoggedInUsers) {
        this.mailTextForNeverLoggedInUsers = mailTextForNeverLoggedInUsers;
    }

    @StrutsParameter
    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    @StrutsParameter
    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    @StrutsParameter
    public Boolean getEnableExcludeGroups() {
        return this.enableExcludeGroups;
    }

    @StrutsParameter
    public void setEnableExcludeGroups(Boolean enableExcludeGroups) {
        this.enableExcludeGroups = enableExcludeGroups;
    }

    @StrutsParameter
    public ArrayList<String> getExcludeGroupsList() {
        return this.excludeGroupsList;
    }

    @StrutsParameter
    public void setExcludeGroupsList(ArrayList<String> excludeGroupsList) {
        this.excludeGroupsList = excludeGroupsList;
    }

    @StrutsParameter
    public String getExcludeGroups() {
        return this.excludeGroups;
    }

    @StrutsParameter
    public void setExcludeGroups(String excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    @StrutsParameter
    public long getScheduler_days() {
        return this.scheduler_days;
    }

    @StrutsParameter
    public void setScheduler_days(long scheduler_days) {
        this.scheduler_days = scheduler_days;
    }

    @StrutsParameter
    public Date getPreviousSchedulerDate() {
        return this.previousSchedulerDate;
    }

    @StrutsParameter
    public void setPreviousSchedulerDate(Date previousSchedulerDate) {
        this.previousSchedulerDate = previousSchedulerDate;
    }

    @StrutsParameter
    public Date getNextSchedulerDate() {
        return this.nextSchedulerDate;
    }

    @StrutsParameter
    public void setNextSchedulerDate(Date nextSchedulerDate) {
        this.nextSchedulerDate = nextSchedulerDate;
    }

    @StrutsParameter
    public Boolean getReActivateUser() {
        return this.reActivateUser;
    }

    @StrutsParameter
    public long getCustomSchedulerTimeHour() {
        return this.customSchedulerTimeHour;
    }

    @StrutsParameter
    public void setCustomSchedulerTimeHour(long customSchedulerTimeHour) {
        this.customSchedulerTimeHour = customSchedulerTimeHour;
    }

    @StrutsParameter
    public long getCustomSchedulerTimeMinute() {
        return this.customSchedulerTimeMinute;
    }

    @StrutsParameter
    public void setCustomSchedulerTimeMinute(long customSchedulerTimeMinute) {
        this.customSchedulerTimeMinute = customSchedulerTimeMinute;
    }

    @StrutsParameter
    public Boolean getPreviousSchedulerFlag() {
        return this.previousSchedulerFlag;
    }

    @StrutsParameter
    public void setPreviousSchedulerFlag(Boolean previousSchedulerFlag) {
        this.previousSchedulerFlag = previousSchedulerFlag;
    }

    @StrutsParameter
    public void setReActivateUser(Boolean reActivateUser) {
        this.reActivateUser = reActivateUser;
    }

    @StrutsParameter
    public Boolean getAddGroupsToInactive() {
        return this.addGroupsToInactive;
    }

    @StrutsParameter
    public void setAddGroupsToInactive(Boolean addGroupsToInactive) {
        this.addGroupsToInactive = addGroupsToInactive;
    }

    @StrutsParameter
    public String getAddGroups() {
        return this.addGroups;
    }

    @StrutsParameter
    public void setAddGroups(String addGroups) {
        this.addGroups = addGroups;
    }

    @StrutsParameter
    public ArrayList<String> getAddGroupsList() {
        return this.addGroupsList;
    }

    @StrutsParameter
    public void setAddGroupsList(ArrayList<String> addGroupsList) {
        this.addGroupsList = addGroupsList;
    }

    @StrutsParameter
    public Boolean getIsGroupsEmpty() {
        return this.isGroupsEmpty;
    }

    @StrutsParameter
    public void setIsGroupsEmpty(Boolean isGroupsEmpty) {
        this.isGroupsEmpty = isGroupsEmpty;
    }

    @StrutsParameter
    public Boolean getAddGroupsToActiveUser() {
        return this.addGroupsToActiveUser;
    }

    @StrutsParameter
    public void setAddGroupsToActiveUser(Boolean addGroupsToActiveUser) {
        this.addGroupsToActiveUser = addGroupsToActiveUser;
    }

    @StrutsParameter
    public String getGroupsAssignToActiveUser() {
        return this.groupsAssignToActiveUser;
    }

    @StrutsParameter
    public void setGroupsAssignToActiveUser(String groupsAssignToActiveUser) {
        this.groupsAssignToActiveUser = groupsAssignToActiveUser;
    }

    @StrutsParameter
    public ArrayList<String> getGroupsListAssignToActiveUser() {
        return this.groupsListAssignToActiveUser;
    }

    @StrutsParameter
    public void setGroupsListAssignToActiveUser(ArrayList<String> groupsListAssignToActiveUser) {
        this.groupsListAssignToActiveUser = groupsListAssignToActiveUser;
    }

    @StrutsParameter
    public Boolean getGroupEmptyForActiveUser() {
        return this.groupEmptyForActiveUser;
    }

    @StrutsParameter
    public void setGroupEmptyForActiveUser(Boolean groupEmptyForActiveUser) {
        this.groupEmptyForActiveUser = groupEmptyForActiveUser;
    }

    @StrutsParameter
    public Boolean getAutodeactivatecheck() {
        return this.autodeactivatecheck;
    }

    @StrutsParameter
    public void setAutodeactivatecheck(Boolean autodeactivatecheck) {
        this.autodeactivatecheck = autodeactivatecheck;
    }

    @StrutsParameter
    public Boolean getAutoActivateSubmited() {
        return this.autoActivateSubmited;
    }

    @StrutsParameter
    public void setAutoActivateSubmited(Boolean autoActivateSubmited) {
        this.autoActivateSubmited = autoActivateSubmited;
    }

    @StrutsParameter
    public String getUsernameSuffix() {
        return this.usernameSuffix;
    }

    @StrutsParameter
    public void setUsernameSuffix(String usernameSuffix) {
        this.usernameSuffix = usernameSuffix;
    }

    @StrutsParameter
    public Boolean getEnableLicenseLimitAlert() {
        return this.enableLicenseLimitAlert;
    }

    @StrutsParameter
    public void setEnableLicenseLimitAlert(Boolean enableLicenseLimitAlert) {
        this.enableLicenseLimitAlert = enableLicenseLimitAlert;
    }

    @StrutsParameter
    public String getUserLicenseLimit() {
        return this.userLicenseLimit;
    }

    @StrutsParameter
    public void setUserLicenseLimit(String userLicenseLimit) {
        this.userLicenseLimit = userLicenseLimit;
    }

    @StrutsParameter
    public Integer getTotalLicensedUsers() {
        return this.totalLicensedUsers;
    }

    @StrutsParameter
    public void setTotalLicensedUsers(Integer totalLicensedUsers) {
        this.totalLicensedUsers = totalLicensedUsers;
    }

    @StrutsParameter
    public String getAdminsForAlert() {
        return this.adminsForAlert;
    }

    @StrutsParameter
    public void setAdminsForAlert(String adminsForAlert) {
        this.adminsForAlert = adminsForAlert;
    }

    @StrutsParameter
    public ArrayList<String> getSelectedAdminList() {
        return this.selectedAdminList;
    }

    @StrutsParameter
    public void setSelectedAdminList(ArrayList<String> selectedAdminList) {
        this.selectedAdminList = selectedAdminList;
    }

    @StrutsParameter
    public String getMailServerForLicenseAlert() {
        return this.mailServerForLicenseAlert;
    }

    @StrutsParameter
    public void setMailServerForLicenseAlert(String mailServerForLicenseAlert) {
        this.mailServerForLicenseAlert = mailServerForLicenseAlert;
    }
}

