/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.google.gson.Gson;
import com.miniorange.usermanagement.common.CommonAuditLogDetails;
import com.miniorange.usermanagement.common.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.AuditLogScheduler;
import com.miniorange.usermanagement.confluence.utility.OfflineLicenseSettings;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class AuditLogsAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(AuditLogsAction.class);
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    private OfflineLicenseSettings licenseSettings;
    CommonAuditLogDetails backToObject;
    private Boolean auditLogsUserDetailsSubmitted;
    private AuditLogScheduler auditLogScheduler;
    private String auditLogUsernameSearchKeyword;
    private String auditLogIpSearchKeyword;
    private String filterUsersByPeriod;
    private String filterUsersByAction;
    private String filterByStatus;
    private List<String> auditLogs;
    private List<CommonAuditLogDetails> listOfAuditLogsObjects = new ArrayList<CommonAuditLogDetails>();
    private List<CommonAuditLogDetails> auditLogsToDisplay = new ArrayList<CommonAuditLogDetails>();
    private List<String> auditLogsAfterAllFilters = new ArrayList<String>();
    private Boolean autoDeleteAuditLogs;
    private Boolean autoDeleteAuditLogsDetailsSubmitted;
    private String autoDeleteLogsAfterDays;
    private List<String> numberOfPagesList;
    private Integer numberOfRecordsPerPage;
    private List<String> currentPageUsersList;
    private boolean isDatacenter;
    private boolean isOfflineLicensevalid = false;
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;

    public AuditLogsAction(UserManagementPluginSettings settings, UserManagementPluginHandler pluginHandler, AuditLogScheduler auditLogScheduler, OfflineLicenseSettings licenseSettings) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.auditLogScheduler = auditLogScheduler;
        this.licenseSettings = licenseSettings;
    }

    public String execute() throws Exception {
        LOGGER.debug("AuditLogsAction doExecute called");
        HttpServletRequest request = this.getCurrentRequest();
        String startIndexAsString = "";
        String endIndexAsString = "";
        if (BooleanUtils.toBoolean(this.autoDeleteAuditLogsDetailsSubmitted)) {
            this.settings.setAutoDeleteAuditLogs(BooleanUtils.toBoolean(this.autoDeleteAuditLogs));
            if (BooleanUtils.toBoolean(this.autoDeleteAuditLogs)) {
                int days = Integer.parseInt(this.autoDeleteLogsAfterDays);
                this.settings.setAutoDeleteLogsAfterDays(days);
                LOGGER.debug("Scheduling Task");
                this.auditLogScheduler.schedule();
            } else {
                this.settings.setAutoDeleteAuditLogs(false);
                LOGGER.debug("Un-scheduling Task");
                this.auditLogScheduler.unschedule();
            }
        }
        if (StringUtils.isBlank(this.auditLogUsernameSearchKeyword)) {
            this.auditLogUsernameSearchKeyword = "";
        }
        if (StringUtils.isBlank(this.auditLogIpSearchKeyword)) {
            this.auditLogIpSearchKeyword = "";
        }
        if (BooleanUtils.toBoolean(this.auditLogsUserDetailsSubmitted)) {
            startIndexAsString = "";
            endIndexAsString = "";
        } else {
            String usernameSearchKeyword = request.getParameter("logsUsernameSearchKeywordUrl");
            String ipSearchKeyword = request.getParameter("logsIpSearchKeywordUrl");
            String actionSearchFilter = request.getParameter("actionSearchFilter");
            String periodSearchFilter = request.getParameter("periodSearchFilter");
            String statusSearchFilter = request.getParameter("statusSearchFilter");
            if (StringUtils.isNotBlank(usernameSearchKeyword)) {
                this.auditLogUsernameSearchKeyword = usernameSearchKeyword.trim();
            }
            if (StringUtils.isNotBlank(ipSearchKeyword)) {
                this.auditLogIpSearchKeyword = ipSearchKeyword.trim();
            }
            if (StringUtils.isNotBlank(actionSearchFilter)) {
                this.filterUsersByAction = actionSearchFilter.trim();
            }
            if (StringUtils.isNotBlank(periodSearchFilter)) {
                this.filterUsersByPeriod = periodSearchFilter.trim();
            }
            if (StringUtils.isNotBlank(statusSearchFilter)) {
                this.filterByStatus = statusSearchFilter.trim();
            }
            startIndexAsString = request.getParameter("startIndex");
            endIndexAsString = request.getParameter("endIndex");
        }
        this.auditLogUsernameSearchKeyword = this.auditLogUsernameSearchKeyword.trim();
        this.auditLogIpSearchKeyword = this.auditLogIpSearchKeyword.trim();
        this.numberOfRecordsPerPage = UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE;
        if (StringUtils.isBlank(startIndexAsString) && StringUtils.isBlank(endIndexAsString)) {
            this.selectedPage = 1;
            this.startIndex = 1;
            this.endIndex = this.numberOfRecordsPerPage;
        } else {
            this.startIndex = Integer.parseInt(startIndexAsString);
            this.endIndex = Integer.parseInt(endIndexAsString);
            this.selectedPage = this.endIndex / UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE;
        }
        if (StringUtils.isBlank(this.filterUsersByAction)) {
            this.filterUsersByAction = "All Actions";
        }
        if (StringUtils.isBlank(this.filterUsersByPeriod)) {
            this.filterUsersByPeriod = "All Days";
        }
        if (StringUtils.isBlank(this.filterByStatus)) {
            this.filterByStatus = "All Status";
        }
        this.auditLogs = this.settings.getAuditLogs();
        LOGGER.debug("auditLogs = " + this.auditLogs);
        LOGGER.info("auditLogUsernameSearchKeyword =  " + this.auditLogUsernameSearchKeyword);
        LOGGER.info("auditLogIpSearchKeyword =  " + this.auditLogIpSearchKeyword);
        LOGGER.info("filterUsersByAction=  " + this.filterUsersByAction);
        LOGGER.info("filterUsersByPeriod =  " + this.filterUsersByPeriod);
        LOGGER.info("filterByStatus= " + this.filterByStatus);
        this.auditLogsAfterAllFilters = this.settings.getLogsToDisplay(this.auditLogs, this.auditLogUsernameSearchKeyword, this.auditLogIpSearchKeyword, this.filterUsersByAction, this.filterByStatus, this.filterUsersByPeriod);
        this.currentPageUsersList = this.getSelectedDetailsForPaginationForLogs(this.auditLogsAfterAllFilters, this.startIndex - 1, this.endIndex - 1);
        Gson gson = new Gson();
        for (int counter = 0; counter < this.currentPageUsersList.size(); ++counter) {
            this.backToObject = gson.fromJson(this.currentPageUsersList.get(counter), CommonAuditLogDetails.class);
            this.auditLogsToDisplay.add(this.backToObject);
        }
        LOGGER.debug("auditLogsAfterAllFilters = " + this.auditLogsAfterAllFilters);
        LOGGER.debug("current auditLog list = " + this.currentPageUsersList);
        LOGGER.debug("auditLogsToDisplay = " + this.auditLogsToDisplay);
        this.numberOfPages = this.auditLogsAfterAllFilters.size() / UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE;
        if (this.auditLogsAfterAllFilters.size() > this.numberOfPages * UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE) {
            Integer n = this.numberOfPages;
            this.numberOfPages = this.numberOfPages + 1;
        }
        LOGGER.debug("number of pages = " + this.numberOfPages);
        this.initializeAuditLogs();
        return "success";
    }

    public List<String> getSelectedDetailsForPaginationForLogs(List<String> detailsList, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int counter = startIndex.intValue(); counter <= endIndex && counter < detailsList.size(); ++counter) {
            selectedDetailsPagination.add(detailsList.get(counter));
        }
        LOGGER.debug("Selected Details : " + selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    private void initializeAuditLogs() {
        this.autoDeleteAuditLogs = this.settings.getAutoDeleteAuditLogs();
        this.autoDeleteLogsAfterDays = this.settings.getAutoDeleteLogsAfterDays().toString();
        this.isOfflineLicensevalid = this.licenseSettings.isOfflineLicenseValid();
        this.isDatacenter = this.licenseSettings.isDatacenter();
    }

    @StrutsParameter
    public boolean getIsOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    @StrutsParameter
    public void setIsOfflineLicensevalid(boolean isOfflineLicensevalid) {
        this.isOfflineLicensevalid = isOfflineLicensevalid;
    }

    @StrutsParameter
    public boolean getIsDatacenter() {
        return this.isDatacenter;
    }

    @StrutsParameter
    public void setIsDatacenter(boolean datacenter) {
        this.isDatacenter = datacenter;
    }

    @StrutsParameter
    public Boolean getAuditLogsUserDetailsSubmitted() {
        return this.auditLogsUserDetailsSubmitted;
    }

    @StrutsParameter
    public void setAuditLogsUserDetailsSubmitted(Boolean auditLogsUserDetailsSubmitted) {
        this.auditLogsUserDetailsSubmitted = auditLogsUserDetailsSubmitted;
    }

    @StrutsParameter
    public Boolean getAutoDeleteAuditLogs() {
        return this.autoDeleteAuditLogs;
    }

    @StrutsParameter
    public void setAutoDeleteAuditLogs(Boolean autoDeleteAuditLogs) {
        this.autoDeleteAuditLogs = autoDeleteAuditLogs;
    }

    @StrutsParameter
    public Boolean getAutoDeleteAuditLogsDetailsSubmitted() {
        return this.autoDeleteAuditLogsDetailsSubmitted;
    }

    @StrutsParameter
    public void setAutoDeleteAuditLogsDetailsSubmitted(Boolean autoDeleteAuditLogsDetailsSubmitted) {
        this.autoDeleteAuditLogsDetailsSubmitted = autoDeleteAuditLogsDetailsSubmitted;
    }

    @StrutsParameter
    public String getAutoDeleteLogsAfterDays() {
        return this.autoDeleteLogsAfterDays;
    }

    @StrutsParameter
    public void setAutoDeleteLogsAfterDays(String autoDeleteLogsAfterDays) {
        this.autoDeleteLogsAfterDays = autoDeleteLogsAfterDays;
    }

    @StrutsParameter
    public List<String> getAuditLogs() {
        return this.auditLogs;
    }

    @StrutsParameter
    public void setAuditLogs(List<String> auditLogs) {
        this.auditLogs = auditLogs;
    }

    @StrutsParameter
    public String getAuditLogUsernameSearchKeyword() {
        return this.auditLogUsernameSearchKeyword;
    }

    @StrutsParameter
    public void setAuditLogUsernameSearchKeyword(String auditLogUsernameSearchKeyword) {
        this.auditLogUsernameSearchKeyword = auditLogUsernameSearchKeyword;
    }

    @StrutsParameter
    public String getAuditLogIpSearchKeyword() {
        return this.auditLogIpSearchKeyword;
    }

    @StrutsParameter
    public void setAuditLogIpSearchKeyword(String auditLogIpSearchKeyword) {
        this.auditLogIpSearchKeyword = auditLogIpSearchKeyword;
    }

    @StrutsParameter
    public String getFilterUsersByPeriod() {
        return this.filterUsersByPeriod;
    }

    @StrutsParameter
    public void setFilterUsersByPeriod(String filterUsersByPeriod) {
        this.filterUsersByPeriod = filterUsersByPeriod;
    }

    @StrutsParameter
    public String getFilterUsersByAction() {
        return this.filterUsersByAction;
    }

    @StrutsParameter
    public void setFilterUsersByAction(String filterUsersByAction) {
        this.filterUsersByAction = filterUsersByAction;
    }

    @StrutsParameter
    public String getFilterByStatus() {
        return this.filterByStatus;
    }

    @StrutsParameter
    public void setFilterByStatus(String filterByStatus) {
        this.filterByStatus = filterByStatus;
    }

    @StrutsParameter
    public List<String> getAuditLogsAfterAllFilters() {
        return this.auditLogsAfterAllFilters;
    }

    @StrutsParameter
    public void setAuditLogsAfterAllFilters(List<String> auditLogsAfterAllFilters) {
        this.auditLogsAfterAllFilters = auditLogsAfterAllFilters;
    }

    @StrutsParameter
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @StrutsParameter
    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    @StrutsParameter
    public Integer getEndIndex() {
        return this.endIndex;
    }

    @StrutsParameter
    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    @StrutsParameter
    public Integer getSelectedPage() {
        return this.selectedPage;
    }

    @StrutsParameter
    public void setSelectedPage(Integer selectedPage) {
        this.selectedPage = selectedPage;
    }

    @StrutsParameter
    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    @StrutsParameter
    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    @StrutsParameter
    public List<String> getNumberOfPagesList() {
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
        return this.numberOfPagesList;
    }

    @StrutsParameter
    public void setNumberOfPagesList(List<String> numberOfPagesList) {
        this.numberOfPagesList = numberOfPagesList;
    }

    @StrutsParameter
    public List<String> getCurrentPageUsersList() {
        return this.currentPageUsersList;
    }

    @StrutsParameter
    public void setCurrentPageUsersList(List<String> currentPageUsersList) {
        this.currentPageUsersList = currentPageUsersList;
    }

    @StrutsParameter
    public Integer getNumberOfRecordsPerPage() {
        return this.numberOfRecordsPerPage;
    }

    @StrutsParameter
    public void setNumberOfRecordsPerPage(Integer numberOfRecordsPerPage) {
        this.numberOfRecordsPerPage = numberOfRecordsPerPage;
    }

    @StrutsParameter
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @StrutsParameter
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @StrutsParameter
    public CommonAuditLogDetails getBackToObject() {
        return this.backToObject;
    }

    @StrutsParameter
    public void setBackToObject(CommonAuditLogDetails backToObject) {
        this.backToObject = backToObject;
    }

    @StrutsParameter
    public List<CommonAuditLogDetails> getListOfAuditLogsObjects() {
        return this.listOfAuditLogsObjects;
    }

    @StrutsParameter
    public void setListOfAuditLogsObjects(List<CommonAuditLogDetails> listOfAuditLogsObjects) {
        this.listOfAuditLogsObjects = listOfAuditLogsObjects;
    }

    @StrutsParameter
    public List<CommonAuditLogDetails> getAuditLogsToDisplay() {
        return this.auditLogsToDisplay;
    }

    @StrutsParameter
    public void setAuditLogsToDisplay(List<CommonAuditLogDetails> auditLogsToDisplay) {
        this.auditLogsToDisplay = auditLogsToDisplay;
    }
}

