/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.OfflineLicenseSettings;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserDeactivateAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(UserDeactivateAction.class);
    private Boolean autodeactivatecheck;
    private String usernameSuffix;
    private UserManagementPluginHandler userManagementPluginHandler;
    private UserManagementPluginSettings settings;
    private OfflineLicenseSettings licenseSettings;
    private boolean isDatacenter;
    private boolean isOfflineLicensevalid = false;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private final MailServerManager mailServerManager;
    private final ConfluenceUserManagementUtility userManagementUtility;
    private Boolean enableAutoRemoveFromGroup;
    private long limitDays;
    private Boolean mailNotification;
    private ArrayList<String> emailServers = new ArrayList();
    private String mailPeriod = "1";
    private String mailSubject = "";
    private String emailTemplate = "";
    private Boolean neverLoggedinUsers;
    private Boolean autoDeactivateSubmited;
    private Boolean autoActivateSubmited;
    private Boolean maxUsersLicense;
    private Boolean enableExcludeGroups;
    private String mailServer = "";
    private String excludeGroups;
    private long scheduler_days;
    private Date previousSchedulerDate;
    private Date nextSchedulerDate;
    private ArrayList<String> excludeGroupsList;
    private Boolean reActivateUser;
    private Boolean addGroupsToInactive;
    private String addGroups;
    private ArrayList<String> addGroupsList;
    private Boolean isGroupsEmpty = false;
    private Boolean addGroupsToActiveUser;
    private String groupsAssignToActiveUser = "";
    private ArrayList<String> groupsListAssignToActiveUser;
    private Boolean groupEmptyForActiveUser = false;
    private String autoRemoveGroups;
    private ArrayList<String> autoRemoveGroupsList = new ArrayList();
    private List<SMTPMailServer> smtpServers;
    private long customSchedulerTimeHour;
    private long customSchedulerTimeMinute;
    private Boolean previousSchedulerFlag;

    public UserDeactivateAction(UserManagementPluginHandler userManagementPluginHandler, UserManagementPluginSettings settings, UserDeactivaterScheduler userDeactivaterScheduler, ConfluenceUserManagementUtility confluenceUserManagement, OfflineLicenseSettings licenseSettings, MailServerManager mailServerManager) {
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.settings = settings;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.userManagementUtility = confluenceUserManagement;
        this.licenseSettings = licenseSettings;
        this.mailServerManager = mailServerManager;
    }

    public Boolean doValidate() throws ParseException {
        LOGGER.debug("Settings Action doValidate");
        LOGGER.debug("value of mail period : " + this.mailPeriod);
        Boolean isError = Boolean.FALSE;
        if (this.enableExcludeGroups == null) {
            this.enableExcludeGroups = false;
        }
        if (BooleanUtils.toBoolean(this.autoDeactivateSubmited)) {
            try {
                long number;
                if (this.limitDays == 0L) {
                    this.limitDays = this.settings.getNumberOfDays();
                }
                if (BooleanUtils.toBoolean(this.enableAutoRemoveFromGroup) && StringUtils.isBlank(this.autoRemoveGroups)) {
                    this.addActionError("Groups field is left blank. Please select at groups to revoke application access from inactive users");
                    isError = Boolean.TRUE;
                }
                if (StringUtils.isBlank(this.excludeGroups)) {
                    this.addActionError("Exclude groups is left blank. Please select at least one group");
                    isError = Boolean.TRUE;
                }
                if (StringUtils.isBlank(this.mailPeriod)) {
                    this.addActionError("Please enter valid mail period");
                    isError = Boolean.TRUE;
                }
                if (this.scheduler_days == 0L) {
                    this.scheduler_days = this.settings.getScheduler_days();
                }
                if ((number = this.limitDays) < 1L) {
                    isError = Boolean.TRUE;
                    this.addActionError("Invalid Number of Days. The Inactive number of days must be more than 1 day. :" + number);
                    LOGGER.debug("Entered Invalid number :" + number);
                    return isError;
                }
                if (this.scheduler_days < 1L) {
                    this.addActionError("Invalid Number of Days. The Scheduler time must be more than 1 day.");
                    isError = Boolean.TRUE;
                    LOGGER.error("Entered Invalid number :" + this.scheduler_days);
                }
                if (this.autodeactivatecheck == Boolean.TRUE && this.mailNotification == Boolean.TRUE && this.mailServerManager.getSmtpMailServers().isEmpty()) {
                    isError = Boolean.TRUE;
                    this.addActionError("Please configure mail server.");
                    LOGGER.debug("Mail server configuration is empty.");
                }
            }
            catch (Exception e) {
                isError = Boolean.TRUE;
                this.addActionError("Please enter valid Number. ");
                LOGGER.debug("you have enter negative or zero number ");
                return isError;
            }
        }
        if (isError.booleanValue()) {
            this.initalization();
            return isError;
        }
        return isError;
    }

    public String execute() throws Exception {
        LOGGER.debug("inside UserDeactivateAction doExecute ");
        this.smtpServers = this.mailServerManager.getSmtpMailServers();
        LOGGER.debug("smtpServer : " + this.smtpServers);
        for (SMTPMailServer smtpServer : this.smtpServers) {
            String name = smtpServer.getName();
            this.emailServers.add(name);
        }
        LOGGER.debug("emailservers in confluence : " + this.emailServers);
        if (!this.userManagementUtility.isLicenseValid().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return "invalid";
        }
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        if (BooleanUtils.toBoolean(this.autoActivateSubmited)) {
            this.settings.setReActivateUser(this.reActivateUser);
            if (this.addGroupsToInactive == null) {
                this.addGroupsToInactive = false;
            }
            if (this.addGroupsToActiveUser == null) {
                this.addGroupsToActiveUser = false;
            }
            if ((this.addGroups == null || this.addGroups.isEmpty()) && this.addGroupsToInactive.booleanValue()) {
                this.isGroupsEmpty = true;
                LOGGER.debug("Group list are empty...");
            } else {
                this.addGroupsList = this.settings.convertSelect2StringToList(this.addGroups);
                this.settings.setAddGroupsToInactive(this.addGroupsToInactive);
                this.settings.setAddGroups(this.addGroupsList);
            }
            if (this.groupsAssignToActiveUser.isEmpty() && this.addGroupsToActiveUser.booleanValue()) {
                this.groupEmptyForActiveUser = true;
                LOGGER.debug("groups added to active users are empty!");
            } else {
                this.settings.setAddGroupsToActiveUsers(this.addGroupsToActiveUser);
                this.groupsListAssignToActiveUser = this.settings.convertSelect2StringToList(this.groupsAssignToActiveUser);
                this.settings.setGroupsAssignToActiveUser(this.groupsListAssignToActiveUser);
            }
        }
        if (BooleanUtils.toBoolean(this.autoDeactivateSubmited) && !BooleanUtils.toBoolean(this.doValidate())) {
            if (this.enableAutoRemoveFromGroup == null) {
                this.enableAutoRemoveFromGroup = false;
            }
            if (this.autodeactivatecheck == null) {
                this.autodeactivatecheck = false;
            }
            if (this.neverLoggedinUsers == null) {
                this.neverLoggedinUsers = false;
            }
            if (this.mailNotification == null) {
                this.mailNotification = false;
            }
            if (this.mailPeriod == null) {
                this.mailPeriod = "1";
            }
            if (this.enableExcludeGroups == null) {
                this.enableExcludeGroups = false;
            }
            this.excludeGroupsList = this.settings.convertSelect2StringToList(this.excludeGroups);
            this.autoRemoveGroupsList = this.settings.convertSelect2StringToList(this.autoRemoveGroups);
            if (this.autoRemoveGroupsList.isEmpty()) {
                this.enableAutoRemoveFromGroup = false;
            }
            if (this.customSchedulerTimeHour == 0L) {
                this.customSchedulerTimeHour = 1L;
            }
            if (this.customSchedulerTimeMinute == 0L) {
                this.customSchedulerTimeMinute = 1L;
            }
            this.userManagementPluginHandler.saveUserManagementSettings(this.limitDays, this.autodeactivatecheck, this.enableAutoRemoveFromGroup, this.autoRemoveGroupsList, this.neverLoggedinUsers, 0L, this.scheduler_days, this.enableExcludeGroups, this.excludeGroupsList, this.customSchedulerTimeHour, this.customSchedulerTimeMinute, this.previousSchedulerFlag, false, 0L, this.mailNotification, this.mailPeriod, this.mailSubject, this.emailTemplate, this.mailServer, this.usernameSuffix, false);
            if (this.autodeactivatecheck.booleanValue() || this.enableAutoRemoveFromGroup.booleanValue()) {
                this.settings.setPreviousSchedulerFlag(true);
                LOGGER.debug(" saveUserManagementSettings : Schedule Task");
                this.userDeactivaterScheduler.schedule();
            } else if (!this.autodeactivatecheck.booleanValue() && !this.enableAutoRemoveFromGroup.booleanValue()) {
                LOGGER.debug(" saveUserManagementSettings : Unschedule Task");
                this.userDeactivaterScheduler.unschedule();
            }
            this.addActionMessage("Configuration saved Successfully", new Object[]{"success", true, null});
        }
        this.initalization();
        return "success";
    }

    public void initalization() throws ParseException {
        LOGGER.debug("calling initialization...");
        this.limitDays = this.settings.getNumberOfDays();
        this.autodeactivatecheck = this.settings.getAutoDeActivateUsers();
        this.mailNotification = this.settings.getMailNotification();
        this.mailPeriod = String.valueOf(this.settings.getMailPeriod());
        this.mailSubject = this.settings.getSubText();
        this.emailTemplate = this.settings.getMailText();
        this.neverLoggedinUsers = this.settings.getAutoDeactivateNeverLoggedInUser();
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        this.excludeGroupsList = (ArrayList)this.settings.getExcludeGroups();
        this.scheduler_days = this.settings.getScheduler_days();
        this.enableExcludeGroups = this.settings.getEnableExcludeGroups();
        this.enableAutoRemoveFromGroup = this.settings.getEnableAutoRemoveFromGroup();
        this.autoRemoveGroupsList = (ArrayList)this.settings.getAutoRemoveGroups();
        this.previousSchedulerDate = this.settings.getPrevSchedulerDate();
        this.nextSchedulerDate = this.settings.getNextSchedulerDate();
        this.customSchedulerTimeHour = this.settings.getCustomSchedulerTimeHour();
        this.customSchedulerTimeMinute = this.settings.getCustomSchedulerTimeMinute();
        this.previousSchedulerFlag = this.settings.getPreviousSchedulerFlag();
        this.reActivateUser = this.settings.getReActivateUser();
        this.addGroupsToInactive = this.settings.getAddGroupsToInactive();
        this.addGroupsList = (ArrayList)this.settings.getAddGroups();
        this.addGroupsToActiveUser = this.settings.getAddGroupsToActiveUsers();
        this.groupsListAssignToActiveUser = (ArrayList)this.settings.getGroupsAssignToActiveUser();
        this.isOfflineLicensevalid = this.licenseSettings.isOfflineLicenseValid();
        this.isDatacenter = this.licenseSettings.isDatacenter();
        this.mailServer = this.settings.getMailServer();
        this.usernameSuffix = this.settings.getUsernameSuffix();
    }

    public Boolean getEnableAutoRemoveFromGroup() {
        return this.enableAutoRemoveFromGroup;
    }

    public void setEnableAutoRemoveFromGroup(Boolean enableAutoRemoveFromGroup) {
        this.enableAutoRemoveFromGroup = enableAutoRemoveFromGroup;
    }

    public ArrayList<String> getAutoRemoveGroupsList() {
        return this.autoRemoveGroupsList;
    }

    public void setAutoRemoveGroupsList(ArrayList<String> autoRemoveGroupsList) {
        this.autoRemoveGroupsList = autoRemoveGroupsList;
    }

    public String getAutoRemoveGroups() {
        return this.autoRemoveGroups;
    }

    public void setAutoRemoveGroups(String autoRemoveGroups) {
        this.autoRemoveGroups = autoRemoveGroups;
    }

    public boolean getIsOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    public void setIsOfflineLicensevalid(boolean isOfflineLicensevalid) {
        this.isOfflineLicensevalid = isOfflineLicensevalid;
    }

    public boolean getIsDatacenter() {
        return this.isDatacenter;
    }

    public void setIsDatacenter(boolean datacenter) {
        this.isDatacenter = datacenter;
    }

    public Boolean getAutoDeactivateSubmited() {
        return this.autoDeactivateSubmited;
    }

    public void setAutoDeactivateSubmited(Boolean autoDeactivateSubmited) {
        this.autoDeactivateSubmited = autoDeactivateSubmited;
    }

    public long getLimitDays() {
        return this.limitDays;
    }

    public void setLimitDays(long limitDays) {
        this.limitDays = limitDays;
    }

    public UserManagementPluginHandler getUserManagementPluginHandler() {
        return this.userManagementPluginHandler;
    }

    public void setUserManagementPluginHandler(UserManagementPluginHandler userManagementPluginHandler) {
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    public Boolean getautodeactivatecheck() {
        return this.autodeactivatecheck;
    }

    public void setautodeactivatecheck(Boolean autodeactivatecheck) {
        this.autodeactivatecheck = autodeactivatecheck;
    }

    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    public Boolean getMailNotification() {
        return this.mailNotification;
    }

    public void setMailNotification(Boolean mailNotification) {
        this.mailNotification = mailNotification;
    }

    public ArrayList<String> getEmailServers() {
        return this.emailServers;
    }

    public void setEmailServers(ArrayList<String> emailServers) {
        this.emailServers = emailServers;
    }

    public String getMailServer() {
        return this.mailServer;
    }

    public void setMailServer(String mailServer) {
        this.mailServer = mailServer;
    }

    public String getMailPeriod() {
        return this.mailPeriod;
    }

    public void setMailPeriod(String mailPeriod) {
        this.mailPeriod = mailPeriod;
    }

    public String getMailSubject() {
        return this.mailSubject;
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public String getEmailTemplate() {
        return this.emailTemplate;
    }

    public void setEmailTemplate(String emailTemplate) {
        this.emailTemplate = emailTemplate;
    }

    public Boolean getNeverLoggedinUsers() {
        return this.neverLoggedinUsers;
    }

    public void setNeverLoggedinUsers(Boolean neverLoggedinUsers) {
        this.neverLoggedinUsers = neverLoggedinUsers;
    }

    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    public Boolean getEnableExcludeGroups() {
        return this.enableExcludeGroups;
    }

    public void setEnableExcludeGroups(Boolean enableExcludeGroups) {
        this.enableExcludeGroups = enableExcludeGroups;
    }

    public ArrayList<String> getExcludeGroupsList() {
        return this.excludeGroupsList;
    }

    public void setExcludeGroupsList(ArrayList<String> excludeGroupsList) {
        this.excludeGroupsList = excludeGroupsList;
    }

    public String getExcludeGroups() {
        return this.excludeGroups;
    }

    public void setExcludeGroups(String excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    public long getScheduler_days() {
        return this.scheduler_days;
    }

    public void setScheduler_days(long scheduler_days) {
        this.scheduler_days = scheduler_days;
    }

    public Date getPreviousSchedulerDate() {
        return this.previousSchedulerDate;
    }

    public void setPreviousSchedulerDate(Date previousSchedulerDate) {
        this.previousSchedulerDate = previousSchedulerDate;
    }

    public Date getNextSchedulerDate() {
        return this.nextSchedulerDate;
    }

    public void setNextSchedulerDate(Date nextSchedulerDate) {
        this.nextSchedulerDate = nextSchedulerDate;
    }

    public Boolean getReActivateUser() {
        return this.reActivateUser;
    }

    public long getCustomSchedulerTimeHour() {
        return this.customSchedulerTimeHour;
    }

    public void setCustomSchedulerTimeHour(long customSchedulerTimeHour) {
        this.customSchedulerTimeHour = customSchedulerTimeHour;
    }

    public long getCustomSchedulerTimeMinute() {
        return this.customSchedulerTimeMinute;
    }

    public void setCustomSchedulerTimeMinute(long customSchedulerTimeMinute) {
        this.customSchedulerTimeMinute = customSchedulerTimeMinute;
    }

    public Boolean getPreviousSchedulerFlag() {
        return this.previousSchedulerFlag;
    }

    public void setPreviousSchedulerFlag(Boolean previousSchedulerFlag) {
        this.previousSchedulerFlag = previousSchedulerFlag;
    }

    public void setReActivateUser(Boolean reActivateUser) {
        this.reActivateUser = reActivateUser;
    }

    public Boolean getAddGroupsToInactive() {
        return this.addGroupsToInactive;
    }

    public void setAddGroupsToInactive(Boolean addGroupsToInactive) {
        this.addGroupsToInactive = addGroupsToInactive;
    }

    public String getAddGroups() {
        return this.addGroups;
    }

    public void setAddGroups(String addGroups) {
        this.addGroups = addGroups;
    }

    public ArrayList<String> getAddGroupsList() {
        return this.addGroupsList;
    }

    public void setAddGroupsList(ArrayList<String> addGroupsList) {
        this.addGroupsList = addGroupsList;
    }

    public Boolean getIsGroupsEmpty() {
        return this.isGroupsEmpty;
    }

    public void setIsGroupsEmpty(Boolean isGroupsEmpty) {
        this.isGroupsEmpty = isGroupsEmpty;
    }

    public Boolean getAddGroupsToActiveUser() {
        return this.addGroupsToActiveUser;
    }

    public void setAddGroupsToActiveUser(Boolean addGroupsToActiveUser) {
        this.addGroupsToActiveUser = addGroupsToActiveUser;
    }

    public String getGroupsAssignToActiveUser() {
        return this.groupsAssignToActiveUser;
    }

    public void setGroupsAssignToActiveUser(String groupsAssignToActiveUser) {
        this.groupsAssignToActiveUser = groupsAssignToActiveUser;
    }

    public ArrayList<String> getGroupsListAssignToActiveUser() {
        return this.groupsListAssignToActiveUser;
    }

    public void setGroupsListAssignToActiveUser(ArrayList<String> groupsListAssignToActiveUser) {
        this.groupsListAssignToActiveUser = groupsListAssignToActiveUser;
    }

    public Boolean getGroupEmptyForActiveUser() {
        return this.groupEmptyForActiveUser;
    }

    public void setGroupEmptyForActiveUser(Boolean groupEmptyForActiveUser) {
        this.groupEmptyForActiveUser = groupEmptyForActiveUser;
    }

    public Boolean getAutodeactivatecheck() {
        return this.autodeactivatecheck;
    }

    public void setAutodeactivatecheck(Boolean autodeactivatecheck) {
        this.autodeactivatecheck = autodeactivatecheck;
    }

    public Boolean getAutoActivateSubmited() {
        return this.autoActivateSubmited;
    }

    public void setAutoActivateSubmited(Boolean autoActivateSubmited) {
        this.autoActivateSubmited = autoActivateSubmited;
    }

    public String getUsernameSuffix() {
        return this.usernameSuffix;
    }

    public void setUsernameSuffix(String usernameSuffix) {
        this.usernameSuffix = usernameSuffix;
    }
}

