/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.user.User;
import com.atlassian.xwork.FileUploadUtils;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.OfflineLicenseSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OfflineLicensingAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(OfflineLicensingAction.class);
    private UserManagementPluginHandler pluginHandler;
    private OfflineLicenseSettings licenseSettings;
    private String platform;
    private UserManagementPluginSettings settings;
    private File licenseFile;
    private boolean error = false;
    private boolean isOfflineLicensevalid = false;
    private boolean isDatacenter;
    private String expiryDate = "Fetching";
    private String serverId = "Fetching";
    private String domainName = "Fetching";
    private String userTier = "Fetching";
    private Boolean licenseFileSubmitted;
    private Boolean maxUsersLicense;
    private ConfluenceUserManagementUtility userManagementUtility;

    public OfflineLicensingAction(UserManagementPluginSettings settings, UserManagementPluginHandler pluginHandler, OfflineLicenseSettings licenseSettings, ConfluenceUserManagementUtility userManagementUtility) {
        this.pluginHandler = pluginHandler;
        this.settings = settings;
        this.licenseSettings = licenseSettings;
        this.userManagementUtility = userManagementUtility;
    }

    public String execute() throws Exception {
        LOGGER.debug("OfflineLicensingAction called");
        HttpServletRequest request = this.getCurrentRequest();
        HttpServletResponse response = ServletContextThreadLocal.getResponse();
        this.pluginHandler.enforceWebsudoProtection(request, response);
        if (this.licenseSettings.isDatacenter()) {
            response.sendRedirect("/plugins/servlet/usermanagement/bulkusermanagementaction");
            return "input";
        }
        ConfluenceUser confluenceUser = null;
        confluenceUser = AuthenticatedUserThreadLocal.get();
        Boolean isAdmin = Boolean.FALSE;
        if (confluenceUser != null) {
            isAdmin = this.permissionManager.hasPermission((User)confluenceUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
        }
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        LOGGER.debug("BooleanUtils.toBoolean(this.licenseFileSubmitted : " + BooleanUtils.toBoolean(this.licenseFileSubmitted));
        if (isAdmin.booleanValue()) {
            if (BooleanUtils.toBoolean(this.licenseFileSubmitted)) {
                String licenseKey = this.handleUpload();
                if (licenseKey != null && this.licenseSettings.isOfflineLicenseValid(licenseKey)) {
                    this.settings.setOfflineLicenseKey(licenseKey);
                    LOGGER.debug("Uploaded License is valid and license applied");
                    this.addActionMessage(this.getText("user-management.license.success"), new Object[]{"success", true, null});
                    this.isOfflineLicensevalid = true;
                } else {
                    this.addActionError("Invalid/Expired License");
                    LOGGER.debug("Invalid License file uploaded");
                    this.isOfflineLicensevalid = false;
                    this.error = true;
                }
            }
            if (this.licenseSettings.isOfflineLicenseValid()) {
                this.userTier = Integer.toString(this.licenseSettings.getLicensedUserTier());
                if (this.licenseSettings.getLicenseDetails() != null) {
                    this.serverId = this.licenseSettings.getLicenseDetails().get(0);
                    this.expiryDate = this.licenseSettings.getLicenseDetails().get(1);
                }
            }
            this.initialize();
            return "input";
        }
        LOGGER.debug("Not an administrator, returning");
        return "input";
    }

    public void initialize() {
        this.isOfflineLicensevalid = this.licenseSettings.isOfflineLicenseValid();
        this.isDatacenter = this.licenseSettings.isDatacenter();
        LOGGER.debug(" is data center =  " + this.isDatacenter);
    }

    private String handleUpload() throws IOException {
        try {
            FileUploadUtils.UploadedFile file = FileUploadUtils.getSingleUploadedFile();
            this.licenseFile = file.getFile();
            if (file != null) {
                String licenseKey = IOUtils.toString(new FileInputStream(this.licenseFile));
                LOGGER.debug("License Key : " + licenseKey);
                return licenseKey;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred := ", e);
        }
        return null;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public UserManagementPluginSettings getuserManagementPluginSettings() {
        return this.settings;
    }

    public void setuserManagementPluginSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    public UserManagementPluginHandler getuserManagementPluginHandler() {
        return this.pluginHandler;
    }

    public void setuserManagementPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public Boolean getLicenseFileSubmitted() {
        return this.licenseFileSubmitted;
    }

    public void setLicenseFileSubmitted(Boolean licenseFileSubmitted) {
        this.licenseFileSubmitted = licenseFileSubmitted;
    }

    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.userManagementUtility;
    }

    public void setUserManagementUtility(ConfluenceUserManagementUtility userManagementUtility) {
    }

    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    public File getLicenseFile() {
        return this.licenseFile;
    }

    public void setLicenseFile(File licenseFile) {
        this.licenseFile = licenseFile;
    }

    public boolean getIsOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    public void setIsOfflineLicensevalid(boolean isOfflineLicensevalid) {
    }

    public boolean getIsDatacenter() {
        return this.isDatacenter;
    }

    public void setIsDatacenter(boolean datacenter) {
        this.isDatacenter = datacenter;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getUserTier() {
        return this.userTier;
    }

    public void setUserTier(String userTier) {
        this.userTier = userTier;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }
}

