/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.common;

import com.atlassian.sal.api.websudo.WebSudoManager;
import com.google.gson.Gson;
import com.miniorange.usermanagement.common.CommonAuditLogDetails;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserManagementPluginHandler {
    private static Log LOGGER = LogFactory.getLog(UserManagementPluginHandler.class);
    private UserManagementPluginSettings settings;
    private static WebSudoManager webSudoManager;

    public UserManagementPluginHandler(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    public void saveUserManagementSettings(long days, boolean autodeactivatecheck, boolean enableAutoRemoveFromGroup, ArrayList<String> autoRemoveGroupsList, boolean neverloggedinusers, long numberOfDaysAfterUserCreation, long scheduler_days, Boolean enableExcludeGroups, ArrayList<String> excludeGroupsList, long customSchedulerTimeHour, long customSchedulerTimeMinute, Boolean previousSchedulerFlag, boolean onlyLoggedinOnce, long onlyLoggedinOnceCheckDays, Boolean mailNotification, String mailPeriod, String mailsubject, String mailtext, String mailServer, String usernameSuffix, Boolean autodeletecheck) {
        try {
            this.settings.setNumberOfDays(days);
            LOGGER.debug("daysAfterUserCreation = " + numberOfDaysAfterUserCreation);
            this.settings.setNumberofDaysAfterUserCreation(numberOfDaysAfterUserCreation);
            this.settings.setExcludeGroups(excludeGroupsList);
            this.settings.setEnableExcludeGroups(enableExcludeGroups);
            this.settings.setScheduler_days(scheduler_days);
            this.settings.setAutoDeActivateUsers(autodeactivatecheck);
            this.settings.setAutoDeleteUsers(autodeletecheck);
            this.settings.setEnableAutoRemoveFromGroup(enableAutoRemoveFromGroup);
            this.settings.setAutoRemoveGroups(autoRemoveGroupsList);
            this.settings.setMailNotification(mailNotification);
            this.settings.setMailServer(mailServer);
            this.settings.setMailPeriod(mailPeriod);
            this.settings.setSubText(mailsubject);
            this.settings.setMailText(mailtext);
            this.settings.setAutoDeactivateNeverLoggedInUser(neverloggedinusers);
            this.settings.setCustomSchedulerTimeHour(customSchedulerTimeHour);
            this.settings.setCustomSchedulerTimeMinute(customSchedulerTimeMinute);
            this.settings.setPreviousSchedulerFlag(previousSchedulerFlag);
            this.settings.setOnlyLoggedinOnce(onlyLoggedinOnce);
            this.settings.setOnlyLoggedinOnceCheckDays(onlyLoggedinOnceCheckDays);
            this.settings.setMailNotification(mailNotification);
            this.settings.setSubText(mailsubject);
            this.settings.setMailText(mailtext);
            this.settings.setUsernameSuffix(usernameSuffix);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while scheduling job.", e);
        }
    }

    public List<String> autoDeleteAuditLogs(List<String> auditLogsList, Integer daysForAutoDeleteLogs) throws ParseException {
        LOGGER.debug("initiating Auto Delete Audit Logs");
        ArrayList<CommonAuditLogDetails> listOfAuditLogsObjects = new ArrayList<CommonAuditLogDetails>();
        ArrayList<String> updatedListAfterRemoval = new ArrayList<String>();
        Gson gson = new Gson();
        for (int counter = 0; counter < auditLogsList.size(); ++counter) {
            CommonAuditLogDetails backToObject = gson.fromJson(auditLogsList.get(counter), CommonAuditLogDetails.class);
            listOfAuditLogsObjects.add(backToObject);
        }
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        for (int counter = 0; counter < listOfAuditLogsObjects.size(); ++counter) {
            long daysForAutoDeleteLogsInLong = NumberUtils.createInteger(daysForAutoDeleteLogs.toString()).intValue();
            long givenDaysInMilliSecs = daysForAutoDeleteLogsInLong * 86400000L;
            long timeInPast = timeMilliSecs - givenDaysInMilliSecs;
            Date dateBeforeInterval = new Date(timeInPast);
            SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
            Date StringToDateForDatabaseEntry = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z").parse(((CommonAuditLogDetails)listOfAuditLogsObjects.get(counter)).getDateAndTime());
            int isLoginAfterInterval = StringToDateForDatabaseEntry.compareTo(dateBeforeInterval);
            if (isLoginAfterInterval < 0) continue;
            updatedListAfterRemoval.add(gson.toJson(listOfAuditLogsObjects.get(counter)));
        }
        return updatedListAfterRemoval;
    }

    public void storeAuditLogs(String username, String ip, String action, String description) {
        CommonAuditLogDetails commonAuditLogDetails = new CommonAuditLogDetails();
        commonAuditLogDetails.setUsername(username.trim());
        commonAuditLogDetails.setAction(action.trim());
        commonAuditLogDetails.setDescription(description.trim());
        commonAuditLogDetails.setIpAddress(ip.trim());
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        Date newdate = new Date(timeMilliSecs);
        SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z");
        commonAuditLogDetails.setDateAndTime(formatter.format(newdate));
        List<String> updateAuditList = this.settings.getAuditLogs();
        Gson gson = new Gson();
        String jsonString = gson.toJson(commonAuditLogDetails);
        updateAuditList.add(jsonString);
        this.settings.setAuditLogs(updateAuditList);
    }

    public void enforceWebsudoProtection(HttpServletRequest request, HttpServletResponse response) {
        try {
            webSudoManager.willExecuteWebSudoRequest(request);
        }
        catch (Exception e) {
            LOGGER.debug("Enforcing Websudo Protection");
            try {
                webSudoManager.enforceWebSudoProtection(request, response);
            }
            catch (Exception t) {
                LOGGER.debug("Error in Enforcing Websudo Protection");
            }
        }
    }

    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }
}

