/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.OfflineLicenseSettings;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TroubleshootingAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(TroubleshootingAction.class);
    private Boolean enableDebugLogs;
    private UserManagementPluginSettings settings;
    private ConfluenceUserManagementUtility usermanagementutils;
    private OfflineLicenseSettings licenseSettings;
    private boolean isDatacenter;
    private boolean isOfflineLicensevalid = false;

    public TroubleshootingAction(UserManagementPluginSettings settings, ConfluenceUserManagementUtility usermanagementutils, OfflineLicenseSettings licenseSettings) {
        this.settings = settings;
        this.usermanagementutils = usermanagementutils;
        this.licenseSettings = licenseSettings;
    }

    public String execute() throws Exception {
        if (!this.usermanagementutils.isLicenseValid().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return "invalid";
        }
        this.enableDebugLogs = this.settings.getEnableDebugLogs();
        if (this.enableDebugLogs.booleanValue()) {
            Logger logger = Logger.getLogger((String)"com.miniorange.usermanagement");
            logger.setLevel(Level.DEBUG);
            LOGGER.debug("Debug Logs are enabled");
        } else {
            Logger logger = Logger.getLogger((String)"com.miniorange.usermanagement");
            logger.setLevel(Level.INFO);
            LOGGER.debug("Debug Logs are  disabled");
        }
        this.initialization();
        return "success";
    }

    public void initialization() throws ParseException {
        this.isOfflineLicensevalid = this.licenseSettings.isOfflineLicenseValid();
        this.isDatacenter = this.licenseSettings.isDatacenter();
    }

    public boolean getIsOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    public void setIsOfflineLicensevalid(boolean isOfflineLicensevalid) {
        this.isOfflineLicensevalid = isOfflineLicensevalid;
    }

    public boolean getIsDatacenter() {
        return this.isDatacenter;
    }

    public void setIsDatacenter(boolean isDatacenter) {
        this.isDatacenter = isDatacenter;
    }
}

