/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.common.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.OfflineLicenseSettings;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BulkUserManagementAction
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(BulkUserManagementAction.class);
    private static final String BULK_USER_MANAGEMENT_VM_PATH = "/template/BulkUserManagement.vm";
    private ConfluenceUserManagementUtility userManagementUtility;
    private UserManagementPluginSettings settings;
    private UserAccessor userAccessor;
    private final TemplateRenderer renderer;
    private LoginManager loginManager;
    private PermissionManager permissionManager;
    private DirectoryManager directoryManager;
    private String usernameSearchKeyword;
    private Integer numberOfRecordsPerPage;
    private List<User> currentPageUsersList;
    private List<String> numberOfPagesList;
    private Boolean maxUsersLicense;
    private Boolean evaluationLicense;
    private List<User> usernameList;
    private Integer userPerPage;
    private String groupSearchKey;
    private List<String> groupSearchList;
    private Boolean userDetailsSubmitted;
    private String userSearchFilter;
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;
    private String startIndexOfPage = "";
    private String endIndexOfPage = "";
    private ContextPathHolder contextPathHolder;
    private String currentDate;
    private OfflineLicenseSettings licenseSettings;
    private boolean isDatacenter;
    private boolean isOfflineLicensevalid = false;
    private List<String> directories;
    private String selectedDirectory = "ALL";

    public BulkUserManagementAction(ConfluenceUserManagementUtility userManagementUtility, UserAccessor userAccessor, LoginManager loginManager, DirectoryManager directoryManager, TemplateRenderer renderer, ContextPathHolder contextPathHolder, PermissionManager permissionManager, UserManagementPluginSettings settings, OfflineLicenseSettings licenseSettings) {
        this.userManagementUtility = userManagementUtility;
        this.userAccessor = userAccessor;
        this.loginManager = loginManager;
        this.directoryManager = directoryManager;
        this.renderer = renderer;
        this.contextPathHolder = contextPathHolder;
        this.permissionManager = permissionManager;
        this.settings = settings;
        this.licenseSettings = licenseSettings;
        this.directories = new ArrayList<String>();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("inside do post");
        ConfluenceUser confluenceUser = null;
        confluenceUser = AuthenticatedUserThreadLocal.get();
        Boolean isAdmin = Boolean.FALSE;
        if (confluenceUser != null) {
            isAdmin = this.permissionManager.hasPermission((com.atlassian.user.User)confluenceUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
        }
        try {
            List list = this.directoryManager.findAllDirectories();
            ArrayList<String> listNames = new ArrayList<String>();
            listNames.add("All");
            for (Directory x : list) {
                if (!x.isActive()) continue;
                listNames.add(x.getName());
            }
            this.directories = listNames;
        }
        catch (Exception e) {
            LOGGER.error("Directories were not found:" + e.getMessage());
        }
        if (isAdmin.booleanValue()) {
            this.userPerPage = req.getParameter("userPerPage") == null ? UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE : Integer.valueOf(Integer.parseInt(req.getParameter("userPerPage")));
            String searchKeyword = req.getParameter("usernameSearchKeyword");
            this.usernameSearchKeyword = StringUtils.isNotBlank(searchKeyword) ? searchKeyword.trim() : "";
            this.groupSearchKey = req.getParameter("groupSearchKey");
            this.groupSearchList = Arrays.asList(StringUtils.split(this.groupSearchKey, ","));
            this.startIndexOfPage = req.getParameter("startIndex");
            this.endIndexOfPage = req.getParameter("endIndex");
            this.userSearchFilter = req.getParameter("userSearchFilter");
            this.selectedDirectory = req.getParameter("selectedDirectory");
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
            String[] dateAndTime = expiryDateString.split(" ");
            this.currentDate = dateAndTime[0];
            LOGGER.error("current date :" + this.currentDate);
            if (this.userPerPage == null) {
                this.userPerPage = UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE;
            }
            this.UserDetails(req, resp);
            HashMap<String, Object> context = this.initializeSAMLConfig();
            resp.setContentType("text/html;charset=utf-8");
            this.renderer.render(BULK_USER_MANAGEMENT_VM_PATH, context, (Writer)resp.getWriter());
        } else {
            LOGGER.debug("You do not have administrator privilege to perform the Operation. ");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("inside do get");
        ConfluenceUser confluenceUser = null;
        confluenceUser = AuthenticatedUserThreadLocal.get();
        Boolean isAdmin = Boolean.FALSE;
        if (confluenceUser != null) {
            isAdmin = this.permissionManager.hasPermission((com.atlassian.user.User)confluenceUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
        }
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        if (!this.maxUsersLicense.booleanValue()) {
            this.evaluationLicense = this.userManagementUtility.isEvaluationLicense() != false && this.userManagementUtility.isValidEvaluationLicense() != false ? Boolean.TRUE : Boolean.FALSE;
        }
        LOGGER.debug("evaluationLicense :" + this.evaluationLicense);
        try {
            List list = this.directoryManager.findAllDirectories();
            ArrayList<String> listNames = new ArrayList<String>();
            listNames.add("All");
            for (Directory x : list) {
                if (!x.isActive()) continue;
                listNames.add(x.getName());
            }
            this.directories = listNames;
        }
        catch (Exception e) {
            LOGGER.error("Directories were not found:" + e.getMessage());
        }
        if (isAdmin.booleanValue()) {
            this.userPerPage = req.getParameter("userPerPageGet") == null ? UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE : Integer.valueOf(Integer.parseInt(req.getParameter("userPerPageGet")));
            String searchKeyword = req.getParameter("usernameSearchKeywordGet");
            this.groupSearchKey = req.getParameter("groupSearchKey");
            this.groupSearchList = this.groupSearchKey == null ? new ArrayList<String>() : Arrays.asList(StringUtils.split(this.groupSearchKey, ","));
            this.usernameSearchKeyword = StringUtils.isNotBlank(searchKeyword) ? searchKeyword.trim() : "";
            this.startIndexOfPage = req.getParameter("startIndexGet");
            this.endIndexOfPage = req.getParameter("endIndexGet");
            this.userSearchFilter = req.getParameter("userSearchFilterGet");
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
            String[] dateAndTime = expiryDateString.split(" ");
            this.currentDate = dateAndTime[0];
            LOGGER.error("current date :" + this.currentDate);
            this.UserDetails(req, resp);
            resp.setContentType("text/html;charset=utf-8");
            this.renderer.render(BULK_USER_MANAGEMENT_VM_PATH, this.initializeSAMLConfig(), (Writer)resp.getWriter());
        } else {
            LOGGER.debug("You do not have administrator privilege to perform the Operation. ");
        }
    }

    private HashMap<String, Object> initializeSAMLConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("userPerPage", this.userPerPage);
        context.put("usernameSearchKeyword", this.usernameSearchKeyword);
        context.put("startIndex", this.startIndex);
        context.put("endIndex", this.endIndex);
        context.put("userSearchFilter", this.userSearchFilter);
        context.put("currentPageUsersList", this.currentPageUsersList);
        context.put("userAccessor", this.userAccessor);
        context.put("directoryManager", this.directoryManager);
        context.put("usernameList", this.usernameList);
        context.put("numberOfRecordsPerPage", this.numberOfRecordsPerPage);
        context.put("selectedPage", this.selectedPage);
        context.put("numberOfPagesList", this.numberOfPagesList);
        context.put("maxUsersLicense", this.maxUsersLicense);
        context.put("groupSearchList", this.groupSearchList);
        context.put("contextPath", this.contextPathHolder.getContextPath());
        context.put("loginManager", this.loginManager);
        context.put("userLoginMap", this.getUserLoginMap());
        context.put("evaluationLicense", this.evaluationLicense);
        context.put("currentDate", this.currentDate);
        context.put("isOfflineLicensevalid", this.licenseSettings.isOfflineLicenseValid());
        context.put("isDatacenter", this.licenseSettings.isDatacenter());
        context.put("directories", this.directories);
        context.put("selectedDirectory", this.selectedDirectory);
        return context;
    }

    private Map<String, String> getUserLoginMap() {
        HashMap<String, String> userMapLogin = new HashMap<String, String>();
        for (User user : this.currentPageUsersList) {
            if (Objects.requireNonNull(this.loginManager.getLoginInfo(user.getName())).getLastSuccessfulLoginDate() != null) {
                userMapLogin.put(user.getName(), new SimpleDateFormat("E, dd/MMM/yyyy hh:mm aaa").format(this.loginManager.getLoginInfo(user.getName()).getLastSuccessfulLoginDate()));
                continue;
            }
            userMapLogin.put(user.getName(), "Never Logged In");
        }
        return userMapLogin;
    }

    public void UserDetails(HttpServletRequest req, HttpServletResponse resp) {
        this.numberOfRecordsPerPage = this.userPerPage;
        if (StringUtils.isBlank(this.startIndexOfPage) && StringUtils.isBlank(this.endIndexOfPage)) {
            this.selectedPage = 1;
            this.startIndex = 1;
            this.endIndex = this.numberOfRecordsPerPage;
        } else {
            this.startIndex = Integer.parseInt(this.startIndexOfPage);
            this.endIndex = Integer.parseInt(this.endIndexOfPage);
            this.selectedPage = this.endIndex / this.userPerPage;
        }
        if (StringUtils.isBlank(this.userSearchFilter)) {
            this.userSearchFilter = "AllUsers";
        }
        if (StringUtils.isBlank(this.usernameSearchKeyword)) {
            this.usernameSearchKeyword = "";
        }
        if (StringUtils.equalsIgnoreCase(this.userSearchFilter, "ActiveUsers")) {
            this.userSearchFilter = "ActiveUsers";
            LOGGER.debug("usernameSearchKeyword :- " + this.usernameSearchKeyword.trim());
            this.usernameList = this.userManagementUtility.getUserFromConfluenceUsingUsername(this.usernameSearchKeyword.trim(), this.userSearchFilter, this.groupSearchList, this.selectedDirectory);
        } else if (StringUtils.equalsIgnoreCase(this.userSearchFilter, "InactiveUsers")) {
            this.userSearchFilter = "InactiveUsers";
            this.usernameList = this.userManagementUtility.getUserFromConfluenceUsingUsername(this.usernameSearchKeyword.trim(), this.userSearchFilter, this.groupSearchList, this.selectedDirectory);
        } else {
            this.userSearchFilter = "AllUsers";
            this.usernameList = this.userManagementUtility.getUserFromConfluenceUsingUsername(this.usernameSearchKeyword.trim(), this.userSearchFilter, this.groupSearchList, this.selectedDirectory);
        }
        this.currentPageUsersList = this.getSelectedUsersForPagination(this.usernameList, this.startIndex - 1, this.endIndex - 1);
        this.numberOfPages = this.usernameList.size() / this.userPerPage;
        if (this.usernameList.size() > this.numberOfPages * this.userPerPage) {
            Integer n = this.numberOfPages;
            this.numberOfPages = this.numberOfPages + 1;
        }
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
    }

    public List<User> getSelectedUsersForPagination(List<User> selectedUsers, Integer startIndex, Integer endIndex) {
        ArrayList<User> selectedUserPagination = new ArrayList<User>();
        for (int i = startIndex.intValue(); i <= endIndex && i < selectedUsers.size(); ++i) {
            selectedUserPagination.add(selectedUsers.get(i));
        }
        return selectedUserPagination;
    }

    public boolean getIsOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    public void setIsOfflineLicensevalid(boolean isOfflineLicensevalid) {
        this.isOfflineLicensevalid = isOfflineLicensevalid;
    }

    public boolean getIsDatacenter() {
        return this.isDatacenter;
    }

    public void setIsDatacenter(boolean datacenter) {
        this.isDatacenter = datacenter;
    }

    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    public Boolean getEvaluationLicense() {
        return this.evaluationLicense;
    }

    public void setEvaluationLicense(Boolean evaluationLicense) {
        this.evaluationLicense = evaluationLicense;
    }
}

