/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.utility;

import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.utility.OfflineLicenseSettings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfluenceUserManagementUtility {
    private static Log LOGGER = LogFactory.getLog(ConfluenceUserManagementUtility.class);
    private CrowdService crowdService;
    private PluginLicenseManager pluginLicenseManager;
    private LoginManager loginManager;
    private UserAccessor userAccessor;
    private UserManagementPluginSettings settting;
    private OfflineLicenseSettings offlineLicenseSettings;
    private UserManagementPluginHandler userManagementPluginHandler;
    private DirectoryManager directoryManager;

    public ConfluenceUserManagementUtility(CrowdService crowdService, PluginLicenseManager pluginLicenseManager, LoginManager loginManager, UserAccessor userAccessor, UserManagementPluginHandler userManagementPluginHandler, UserManagementPluginSettings settting, OfflineLicenseSettings offlineLicenseSettings, DirectoryManager directoryManager) {
        this.crowdService = crowdService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.loginManager = loginManager;
        this.userAccessor = userAccessor;
        this.settting = settting;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.offlineLicenseSettings = offlineLicenseSettings;
        this.directoryManager = directoryManager;
    }

    public List<User> getUserFromConfluenceUsingUsername(String usernameSearchKeyword, String userSearchFilter, List<String> groupSearchList, String directory) {
        LOGGER.debug("getUserFromConfluenceUsingUsername");
        ArrayList availableUser = new ArrayList();
        Object activeUser = null;
        Object inactiveUser = null;
        ArrayList<List> userLists = new ArrayList<List>();
        ArrayList usersList = new ArrayList();
        List<Object> finalUserList = new ArrayList<User>();
        String groupSearchKey = "";
        MembershipQuery queryForGroup = null;
        EntityQuery query = null;
        if (groupSearchList.size() > 0) {
            for (int i = 0; i < groupSearchList.size(); ++i) {
                groupSearchKey = groupSearchList.get(i);
                if (!StringUtils.isNotBlank(groupSearchKey)) continue;
                if (StringUtils.equalsIgnoreCase(userSearchFilter, "AllUsers") || userSearchFilter.isEmpty()) {
                    LOGGER.debug("Get all Users using Group Filter");
                    queryForGroup = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(new String[]{groupSearchKey}).returningAtMost(-1);
                } else if (StringUtils.equalsIgnoreCase(userSearchFilter, "ActiveUsers")) {
                    LOGGER.debug("Get active users using Group Filter");
                    queryForGroup = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(new String[]{groupSearchKey}).returningAtMost(-1);
                } else if (StringUtils.equalsIgnoreCase(userSearchFilter, "InactiveUsers")) {
                    LOGGER.debug("Get inactive users using Group Filter");
                    queryForGroup = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(new String[]{groupSearchKey}).returningAtMost(-1);
                }
                userLists.add((List)this.crowdService.search(queryForGroup));
            }
            if (userLists.size() > 0) {
                usersList.addAll((Collection)userLists.get(0));
                ListIterator iter = userLists.listIterator(0);
                while (iter.hasNext()) {
                    usersList.retainAll((Collection)iter.next());
                }
            }
            finalUserList = usersList;
        } else {
            if (StringUtils.equalsIgnoreCase(userSearchFilter, "AllUsers") || userSearchFilter.isEmpty()) {
                LOGGER.debug("Get all User");
                query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)).returningAtMost(-1);
            } else if (StringUtils.equalsIgnoreCase(userSearchFilter, "ActiveUsers")) {
                LOGGER.debug("Get active users");
                query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)true), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)})).returningAtMost(-1);
            } else if (StringUtils.equalsIgnoreCase(userSearchFilter, "InactiveUsers")) {
                LOGGER.debug("Get inactive users");
                query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)false), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)})).returningAtMost(-1);
            }
            finalUserList = (List)this.crowdService.search((Query)query);
        }
        if (!StringUtils.equalsIgnoreCase("All", directory)) {
            try {
                List directoryUsers = new ArrayList();
                DirectoryInstanceLoader directoryLoader = (DirectoryInstanceLoader)ContainerManager.getComponent((String)"directoryInstanceLoader");
                List allDirectories = this.directoryManager.findAllDirectories();
                for (int i = 0; i < allDirectories.size(); ++i) {
                    String dirName = ((Directory)allDirectories.get(i)).getName();
                    if (!StringUtils.equalsIgnoreCase(dirName, directory)) continue;
                    RemoteDirectory dir = directoryLoader.getDirectory(this.directoryManager.findDirectoryByName(dirName));
                    EntityQuery query1 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
                    directoryUsers = dir.searchUsers(query1);
                }
                finalUserList.retainAll(directoryUsers);
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while querying based on directory" + e);
            }
        }
        Collections.sort(finalUserList);
        return finalUserList;
    }

    public String getCurrentIpAddress(HttpServletRequest request) {
        String remoteAddr = "";
        if (request != null && (StringUtils.isBlank(remoteAddr = request.getHeader("X-FORWARDED-FOR")) || StringUtils.isEmpty(remoteAddr))) {
            remoteAddr = request.getRemoteAddr();
        }
        return remoteAddr;
    }

    public void removeUserFromGroups(String username, Boolean autoRemove, List<String> groupsToRemove, HttpServletResponse response, String ip) throws IOException {
        block4: {
            LOGGER.debug("Removing user from groups");
            try {
                for (String groupToRemove : groupsToRemove) {
                    LOGGER.debug("Removing User from " + groupToRemove + " group ");
                    this.userAccessor.removeMembership(groupToRemove, username);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (autoRemove.booleanValue()) break block4;
                this.sendErrorResponse("Error", 500, response);
            }
        }
        if (!groupsToRemove.isEmpty()) {
            String UserInGroup = groupsToRemove.toString();
            this.userManagementPluginHandler.storeAuditLogs(username, ip, "Removed from Group", "Removed User from Groups: \n" + UserInGroup.replaceAll("[\\[\\]]", ""));
        }
    }

    public void sendErrorResponse(String errorMessages, int statusCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(statusCode);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }

    public void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }

    public List<String> getAllGroups(String groupRegexPattern) {
        String startWith = "";
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)startWith)).returningAtMost(-1);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        for (Group groupObject : groups) {
            if (!StringUtils.containsIgnoreCase(groupObject.getName(), groupRegexPattern.trim())) continue;
            existingGroups.add(groupObject.getName().trim());
        }
        return existingGroups;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer groupsPerPage, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i < startIndex + groupsPerPage && i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public int getMaxUsers() {
        if (!this.offlineLicenseSettings.isDatacenter() && this.offlineLicenseSettings.isOfflineLicenseValid()) {
            return 1;
        }
        int t = 0;
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                t = (Integer)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().get();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return t;
    }

    public Boolean isValidEvaluationLicense() {
        return ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid();
    }

    public Boolean isEvaluationLicense() {
        if (this.isLicenseDefined().booleanValue()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            LOGGER.debug("pluginLicense.isEvaluation() :- " + pluginLicense.isEvaluation());
            return pluginLicense.isEvaluation();
        }
        return Boolean.FALSE;
    }

    public Boolean isSubscriptionLicense() {
        if (this.isLicenseDefined().booleanValue()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            LOGGER.debug("pluginLicense.isSubscription() :- " + pluginLicense.isSubscription());
            if (pluginLicense.isSubscription()) {
                return pluginLicense.isSubscription();
            }
            if (!pluginLicense.isEvaluation() || this.isLicenseValid().booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseDefined() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseValid() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            if (!((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() || ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (!this.offlineLicenseSettings.isDatacenter() && this.offlineLicenseSettings.isOfflineLicenseValid()) {
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }
}

