/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.directory.ssl.LdapHostnameVerificationSSLSocketFactory;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.user.User;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoLoginFilter
implements Filter {
    private static Log LOGGER = LogFactory.getLog(MoLoginFilter.class);
    private UserManagementPluginSettings settings;
    private UserAccessor userAccessor;
    private ConfluenceUserManagementUtility usermanagementutils;
    private UserManagementPluginHandler pluginHandler;
    private CrowdService crowdService;
    private UserDeactivaterScheduler userDeactivaterScheduler;

    public MoLoginFilter(ConfluenceUserManagementUtility usermanagementutils, UserManagementPluginSettings settings, UserAccessor userAccessor, UserManagementPluginHandler pluginHandler, CrowdService crowdService, UserDeactivaterScheduler userDeactivaterScheduler) {
        this.settings = settings;
        this.userAccessor = userAccessor;
        this.usermanagementutils = usermanagementutils;
        this.pluginHandler = pluginHandler;
        this.crowdService = crowdService;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            LOGGER.debug("request url :" + req.getRequestURL());
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            String username = req.getParameter("os_username");
            String pwd = req.getParameter("os_password");
            InetAddress ip = InetAddress.getLocalHost();
            if (this.settings.getReActivateUser().booleanValue() && this.userAccessor.isDeactivated(username)) {
                Thread currentThread = Thread.currentThread();
                currentThread.setContextClassLoader(LdapHostnameVerificationSSLSocketFactory.class.getClassLoader());
                AuthenticatedUserThreadLocal.set((ConfluenceUser)this.userDeactivaterScheduler.getConfluenceAdministrator());
                this.userAccessor.reactivateUser((User)this.userAccessor.getUserByName(username));
                LOGGER.debug("activating user for credentials check :" + username);
                try {
                    if (StringUtils.isNotBlank(username) && StringUtils.isNotBlank(pwd)) {
                        this.crowdService.authenticate(username, pwd);
                        LOGGER.debug("correct credentials");
                        this.pluginHandler.storeAuditLogs(username, ip.getHostAddress(), "User Reactivated", "Deactivated user activated on successful authentication");
                        if (this.settings.getAddGroupsToInactive().booleanValue()) {
                            List groupsToAdd = (List)this.settings.getAddGroups();
                            for (String group : groupsToAdd) {
                                LOGGER.debug("group add to user : " + username + " : " + group);
                                this.userAccessor.addMembership(group, username);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.userAccessor.deactivateUser((User)this.userAccessor.getUserByName(username));
                    LOGGER.debug("Authentication Failed! Deactivating user in credential check scope :" + username);
                }
            }
            chain.doFilter(request, response);
            return;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while reactivating user", e);
            chain.doFilter(request, response);
            return;
        }
    }

    public void destroy() {
    }
}

