/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.utility;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.miniorange.license.MoLicenseDetails;
import com.miniorange.license.MoLicenseManager;
import com.miniorange.license.constants.MoPluginKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Named
@JiraComponent
@ConfluenceComponent
public class OfflineLicenseSettings {
    private static Log LOGGER = LogFactory.getLog(OfflineLicenseSettings.class);
    private PluginSettings pluginSettings;
    private PluginLicenseManager pluginLicenseManager;
    private MoLicenseManager licenseManager;
    @ComponentImport
    private LicenseHandler licenseHandler;
    private LicenseService licenseService;

    public OfflineLicenseSettings(PluginLicenseManager pluginLicenseManager, PluginSettingsFactory pluginSettingsFactory, LicenseHandler licenseHandler, MoLicenseManager licenseManager, LicenseService licenseService) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseManager = licenseManager;
        this.licenseHandler = licenseHandler;
        this.licenseService = licenseService;
    }

    public boolean isOfflineLicenseValid(String licenseKey) {
        if (this.isDatacenter()) {
            return true;
        }
        MoPluginKey pluginKey = MoPluginKey.CONFLUENCE_BUM;
        String serverId = this.licenseHandler.getServerId();
        LOGGER.debug("serverID = " + serverId);
        if (licenseKey == "") {
            LOGGER.debug("license key is empty");
            return false;
        }
        MoLicenseDetails licenseDetails = this.licenseManager.verifyAndFetchDetails(licenseKey, serverId, pluginKey);
        if (licenseDetails == null) {
            LOGGER.error("Unable to fetch license details object");
            return false;
        }
        int userTier = this.getLicensedUserTier();
        LOGGER.debug(" user tier = " + userTier);
        if (userTier != licenseDetails.getUserTier()) {
            LOGGER.error("User tier does not match with Licensed User Tier");
            return false;
        }
        String licenseExpireDate = licenseDetails.getExpiryDate();
        if (this.getDaysLeftToExpire(licenseExpireDate) < 0) {
            LOGGER.error("License has expired");
            return false;
        }
        return true;
    }

    public boolean isOfflineLicenseValid() {
        String licenseKey = this.getOfflineLicenseKey();
        return this.isOfflineLicenseValid(licenseKey);
    }

    public int getLicensedUserTier() {
        try {
            ConfluenceLicense license = this.licenseService.retrieve();
            int userTier = license.getMaximumNumberOfUsers();
            LOGGER.debug("userTier is :- " + userTier);
            return userTier;
        }
        catch (Exception e) {
            LOGGER.error("Error occured", e);
            return 0;
        }
    }

    public boolean isDatacenter() {
        Collection allProductLicenses = this.licenseHandler.getAllProductLicenses();
        Iterator iterator = allProductLicenses.iterator();
        if (iterator.hasNext()) {
            MultiProductLicenseDetails productLicenseDetails = (MultiProductLicenseDetails)iterator.next();
            return productLicenseDetails.isDataCenter();
        }
        return false;
    }

    public ArrayList<String> getLicenseDetails() {
        ArrayList<String> details = new ArrayList<String>();
        try {
            String licenseKey = this.getOfflineLicenseKey();
            if (licenseKey == "") {
                LOGGER.debug("license key is empty");
                return null;
            }
            MoPluginKey pluginKey = MoPluginKey.CONFLUENCE_BUM;
            String serverId = this.licenseHandler.getServerId();
            details.add(serverId);
            LOGGER.debug("serverID = " + serverId);
            MoLicenseDetails licenseDetails = this.licenseManager.verifyAndFetchDetails(licenseKey, serverId, pluginKey);
            if (licenseDetails == null) {
                LOGGER.error("Unable to fetch license details object");
                return null;
            }
            String expiryDate = licenseDetails.getExpiryDate();
            Date licenseExpireDate = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS").parse(expiryDate);
            details.add(licenseExpireDate.toString());
            return details;
        }
        catch (Exception e) {
            LOGGER.error("An exception occured why fetching expiry date", e);
            return null;
        }
    }

    public Integer getDaysLeftToExpire(String licenseExpireDateString) {
        try {
            Date licenseExpireDate = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS").parse(licenseExpireDateString);
            LOGGER.debug("licenseExpireDate = " + licenseExpireDate.toString());
            Date currentDate = new Date();
            LOGGER.debug("currentDate = " + currentDate);
            Integer daysLeft = (int)((licenseExpireDate.getTime() - currentDate.getTime()) / 86400000L);
            if (daysLeft >= 0) {
                LOGGER.debug("Days Left to Expire : " + daysLeft);
                return daysLeft;
            }
            LOGGER.debug("License Expired.");
            return -2;
        }
        catch (Exception e) {
            LOGGER.error("An exception occurs while calculating days left to expire", e);
            return -1;
        }
    }

    public String getOfflineLicenseKey() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get("miniorange.usermanagement.OFFLINE_LICENSE_KEY"), "");
    }
}

