/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.OfflineLicenseSettings;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserDeactivateAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(UserDeactivateAction.class);
    private Boolean autodeactivatecheck;
    private UserManagementPluginHandler userManagementPluginHandler;
    private UserManagementPluginSettings settings;
    private OfflineLicenseSettings licenseSettings;
    private boolean isDatacenter;
    private boolean isOfflineLicensevalid = false;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private ConfluenceUserManagementUtility userManagementUtility;
    private Boolean enableAutoRemoveFromGroup;
    private long limitDays;
    private Boolean neverLoggedinUsers;
    private Boolean autoDeactivateSubmited;
    private Boolean autoActivateSubmited;
    private Boolean maxUsersLicense;
    private Boolean enableExcludeGroups;
    private String excludeGroups;
    private long scheduler_days;
    private Date previousSchedulerDate;
    private Date nextSchedulerDate;
    private ArrayList<String> excludeGroupsList;
    private Boolean reActivateUser;
    private String autoRemoveGroups;
    private ArrayList<String> autoRemoveGroupsList = new ArrayList();
    private long customSchedulerTimeHour;
    private long customSchedulerTimeMinute;
    private Boolean previousSchedulerFlag;

    public UserDeactivateAction(UserManagementPluginHandler userManagementPluginHandler, UserManagementPluginSettings settings, UserDeactivaterScheduler userDeactivaterScheduler, ConfluenceUserManagementUtility confluenceUserManagement, OfflineLicenseSettings licenseSettings) {
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.settings = settings;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.userManagementUtility = confluenceUserManagement;
        this.licenseSettings = licenseSettings;
    }

    public Boolean doValidate() throws ParseException {
        LOGGER.debug("Settings Action doValidate");
        Boolean isError = Boolean.FALSE;
        if (this.enableExcludeGroups == null) {
            this.enableExcludeGroups = false;
        }
        if (BooleanUtils.toBoolean(this.autoDeactivateSubmited)) {
            try {
                long number;
                if (this.limitDays == 0L) {
                    this.limitDays = this.settings.getNumberOfDays();
                }
                if (BooleanUtils.toBoolean(this.enableAutoRemoveFromGroup) && StringUtils.isBlank(this.autoRemoveGroups)) {
                    this.addActionError("Groups field is left blank. Please select at groups to revoke application access from inactive users");
                    isError = Boolean.TRUE;
                }
                if (StringUtils.isBlank(this.excludeGroups)) {
                    this.addActionError("Exclude groups is left blank. Please select at least one group");
                    isError = Boolean.TRUE;
                }
                if (this.scheduler_days == 0L) {
                    this.scheduler_days = this.settings.getScheduler_days();
                }
                if ((number = this.limitDays) < 1L) {
                    isError = Boolean.TRUE;
                    this.addActionError("Invalid Number of Days. The Inactive number of days must be more than 1 day. :" + number);
                    LOGGER.debug("Entered Invalid number :" + number);
                    return isError;
                }
                if (this.scheduler_days < 1L) {
                    this.addActionError("Invalid Number of Days. The Scheduler time must be more than 1 day.");
                    isError = Boolean.TRUE;
                    LOGGER.error("Entered Invalid number :" + this.scheduler_days);
                }
            }
            catch (Exception e) {
                isError = Boolean.TRUE;
                this.addActionError("Please enter valid Number. ");
                LOGGER.debug("you have enter negative or zero number ");
                return isError;
            }
        }
        if (isError.booleanValue()) {
            this.initalization();
            return isError;
        }
        return isError;
    }

    public String execute() throws Exception {
        LOGGER.debug("inside UserDeactivateAction doExecute ");
        if (!this.userManagementUtility.isLicenseValid().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return "invalid";
        }
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        if (BooleanUtils.toBoolean(this.autoActivateSubmited)) {
            this.settings.setReActivateUser(this.reActivateUser);
        }
        if (BooleanUtils.toBoolean(this.autoDeactivateSubmited) && !BooleanUtils.toBoolean(this.doValidate())) {
            if (this.enableAutoRemoveFromGroup == null) {
                this.enableAutoRemoveFromGroup = false;
            }
            if (this.autodeactivatecheck == null) {
                this.autodeactivatecheck = false;
            }
            if (this.neverLoggedinUsers == null) {
                this.neverLoggedinUsers = false;
            }
            if (this.enableExcludeGroups == null) {
                this.enableExcludeGroups = false;
            }
            this.excludeGroupsList = this.settings.convertSelect2StringToList(this.excludeGroups);
            this.autoRemoveGroupsList = this.settings.convertSelect2StringToList(this.autoRemoveGroups);
            if (this.autoRemoveGroupsList.isEmpty()) {
                this.enableAutoRemoveFromGroup = false;
            }
            if (this.customSchedulerTimeHour == 0L) {
                this.customSchedulerTimeHour = 1L;
            }
            if (this.customSchedulerTimeMinute == 0L) {
                this.customSchedulerTimeMinute = 1L;
            }
            this.userManagementPluginHandler.saveUserManagementSettings(this.limitDays, this.autodeactivatecheck, this.enableAutoRemoveFromGroup, this.autoRemoveGroupsList, this.neverLoggedinUsers, 0L, this.scheduler_days, this.enableExcludeGroups, this.excludeGroupsList, this.customSchedulerTimeHour, this.customSchedulerTimeMinute, this.previousSchedulerFlag, false, 0L);
            if (this.autodeactivatecheck.booleanValue() || this.enableAutoRemoveFromGroup.booleanValue()) {
                this.settings.setPreviousSchedulerFlag(true);
                LOGGER.debug(" saveUserManagementSettings : Schedule Task");
                this.userDeactivaterScheduler.schedule();
            } else if (!this.autodeactivatecheck.booleanValue() && !this.enableAutoRemoveFromGroup.booleanValue()) {
                LOGGER.debug(" saveUserManagementSettings : Unschedule Task");
                this.userDeactivaterScheduler.unschedule();
            }
            this.addActionMessage("Configuration saved Successfully", new Object[]{"success", true, null});
        }
        this.initalization();
        return "success";
    }

    public void initalization() throws ParseException {
        this.limitDays = this.settings.getNumberOfDays();
        this.autodeactivatecheck = this.settings.getAutoDeActivateUsers();
        this.neverLoggedinUsers = this.settings.getAutoDeactivateNeverLoggedInUser();
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        this.excludeGroupsList = (ArrayList)this.settings.getExcludeGroups();
        this.scheduler_days = this.settings.getScheduler_days();
        this.enableExcludeGroups = this.settings.getEnableExcludeGroups();
        this.enableAutoRemoveFromGroup = this.settings.getEnableAutoRemoveFromGroup();
        this.autoRemoveGroupsList = (ArrayList)this.settings.getAutoRemoveGroups();
        this.previousSchedulerDate = this.settings.getPrevSchedulerDate();
        this.nextSchedulerDate = this.settings.getNextSchedulerDate();
        this.customSchedulerTimeHour = this.settings.getCustomSchedulerTimeHour();
        this.customSchedulerTimeMinute = this.settings.getCustomSchedulerTimeMinute();
        this.previousSchedulerFlag = this.settings.getPreviousSchedulerFlag();
        this.reActivateUser = this.settings.getReActivateUser();
        this.isOfflineLicensevalid = this.licenseSettings.isOfflineLicenseValid();
        this.isDatacenter = this.licenseSettings.isDatacenter();
    }

    public Boolean getEnableAutoRemoveFromGroup() {
        return this.enableAutoRemoveFromGroup;
    }

    public void setEnableAutoRemoveFromGroup(Boolean enableAutoRemoveFromGroup) {
        this.enableAutoRemoveFromGroup = enableAutoRemoveFromGroup;
    }

    public ArrayList<String> getAutoRemoveGroupsList() {
        return this.autoRemoveGroupsList;
    }

    public void setAutoRemoveGroupsList(ArrayList<String> autoRemoveGroupsList) {
        this.autoRemoveGroupsList = autoRemoveGroupsList;
    }

    public String getAutoRemoveGroups() {
        return this.autoRemoveGroups;
    }

    public void setAutoRemoveGroups(String autoRemoveGroups) {
        this.autoRemoveGroups = autoRemoveGroups;
    }

    public boolean getIsOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    public void setIsOfflineLicensevalid(boolean isOfflineLicensevalid) {
        this.isOfflineLicensevalid = isOfflineLicensevalid;
    }

    public boolean getIsDatacenter() {
        return this.isDatacenter;
    }

    public void setIsDatacenter(boolean datacenter) {
        this.isDatacenter = datacenter;
    }

    public Boolean getAutoDeactivateSubmited() {
        return this.autoDeactivateSubmited;
    }

    public void setAutoDeactivateSubmited(Boolean autoDeactivateSubmited) {
        this.autoDeactivateSubmited = autoDeactivateSubmited;
    }

    public long getLimitDays() {
        return this.limitDays;
    }

    public void setLimitDays(long limitDays) {
        this.limitDays = limitDays;
    }

    public UserManagementPluginHandler getUserManagementPluginHandler() {
        return this.userManagementPluginHandler;
    }

    public void setUserManagementPluginHandler(UserManagementPluginHandler userManagementPluginHandler) {
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    public Boolean getautodeactivatecheck() {
        return this.autodeactivatecheck;
    }

    public void setautodeactivatecheck(Boolean autodeactivatecheck) {
        this.autodeactivatecheck = autodeactivatecheck;
    }

    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    public Boolean getNeverLoggedinUsers() {
        return this.neverLoggedinUsers;
    }

    public void setNeverLoggedinUsers(Boolean neverLoggedinUsers) {
        this.neverLoggedinUsers = neverLoggedinUsers;
    }

    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    public Boolean getEnableExcludeGroups() {
        return this.enableExcludeGroups;
    }

    public void setEnableExcludeGroups(Boolean enableExcludeGroups) {
        this.enableExcludeGroups = enableExcludeGroups;
    }

    public ArrayList<String> getExcludeGroupsList() {
        return this.excludeGroupsList;
    }

    public void setExcludeGroupsList(ArrayList<String> excludeGroupsList) {
        this.excludeGroupsList = excludeGroupsList;
    }

    public String getExcludeGroups() {
        return this.excludeGroups;
    }

    public void setExcludeGroups(String excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    public long getScheduler_days() {
        return this.scheduler_days;
    }

    public void setScheduler_days(long scheduler_days) {
        this.scheduler_days = scheduler_days;
    }

    public Date getPreviousSchedulerDate() {
        return this.previousSchedulerDate;
    }

    public void setPreviousSchedulerDate(Date previousSchedulerDate) {
        this.previousSchedulerDate = previousSchedulerDate;
    }

    public Date getNextSchedulerDate() {
        return this.nextSchedulerDate;
    }

    public void setNextSchedulerDate(Date nextSchedulerDate) {
        this.nextSchedulerDate = nextSchedulerDate;
    }

    public Boolean getReActivateUser() {
        return this.reActivateUser;
    }

    public long getCustomSchedulerTimeHour() {
        return this.customSchedulerTimeHour;
    }

    public void setCustomSchedulerTimeHour(long customSchedulerTimeHour) {
        this.customSchedulerTimeHour = customSchedulerTimeHour;
    }

    public long getCustomSchedulerTimeMinute() {
        return this.customSchedulerTimeMinute;
    }

    public void setCustomSchedulerTimeMinute(long customSchedulerTimeMinute) {
        this.customSchedulerTimeMinute = customSchedulerTimeMinute;
    }

    public Boolean getPreviousSchedulerFlag() {
        return this.previousSchedulerFlag;
    }

    public void setPreviousSchedulerFlag(Boolean previousSchedulerFlag) {
        this.previousSchedulerFlag = previousSchedulerFlag;
    }

    public void setReActivateUser(Boolean reActivateUser) {
        this.reActivateUser = reActivateUser;
    }

    public Boolean getAutodeactivatecheck() {
        return this.autodeactivatecheck;
    }

    public void setAutodeactivatecheck(Boolean autodeactivatecheck) {
        this.autodeactivatecheck = autodeactivatecheck;
    }

    public Boolean getAutoActivateSubmited() {
        return this.autoActivateSubmited;
    }

    public void setAutoActivateSubmited(Boolean autoActivateSubmited) {
        this.autoActivateSubmited = autoActivateSubmited;
    }
}

