/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.license;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.miniorange.license.MoLicenseDetails;
import com.miniorange.license.constants.MoPluginKey;
import com.miniorange.license.utils.EncryptionUtils;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoLicenseManager {
    private static final String PUBLIC_CERT_PATH = "/certificates/publicKey.crt";
    private static final Logger LOGGER = LoggerFactory.getLogger(MoLicenseManager.class);

    public MoLicenseDetails verifyAndFetchDetails(String licenseKey, String senId, MoPluginKey pluginKey) {
        try {
            String storedKey = IOUtils.toString(MoLicenseManager.class.getResourceAsStream(PUBLIC_CERT_PATH), "UTF-8");
            licenseKey = EncryptionUtils.decrypt("u4JpSz2dti6u5kRB", licenseKey);
            LOGGER.debug("Token value after decoding = " + licenseKey);
            RSAPublicKey publicKey = this.getPublicKey(storedKey);
            Algorithm algorithm = Algorithm.RSA256(publicKey, null);
            JWTVerifier verifier = JWT.require(algorithm).withIssuer("miniOrange").build();
            DecodedJWT jwt = verifier.verify(licenseKey);
            String licenseSenId = jwt.getClaims().get("serverID").asString();
            String licensePluginKey = jwt.getClaims().get("pluginName").asString();
            if (senId.equalsIgnoreCase(licenseSenId) && licensePluginKey.equals(pluginKey.getKey())) {
                return this.saveLicenseDetails(jwt.getClaims());
            }
        }
        catch (Exception exception) {
            LOGGER.debug("An error occurred while verifying license:" + exception);
        }
        return null;
    }

    private MoLicenseDetails saveLicenseDetails(Map<String, Claim> claims) {
        try {
            LOGGER.debug("Saving license details");
            MoLicenseDetails moLicenseDetails = new MoLicenseDetails();
            moLicenseDetails.setCustomerKey(claims.get("customerKey").asString());
            moLicenseDetails.setCustomerEmail(claims.get("customerEmail").asString());
            moLicenseDetails.setCustomerId(claims.get("customerId").asString());
            moLicenseDetails.setCustomerToken(claims.get("customerToken").asString());
            moLicenseDetails.setLicenseType(claims.get("licenseType").asString());
            moLicenseDetails.setUserTier(Integer.parseInt(claims.get("userTier").asString()));
            moLicenseDetails.setExpiryDate(claims.get("ExpiryDate").asString());
            return moLicenseDetails;
        }
        catch (Exception e) {
            LOGGER.error("Invalid License Details", e);
            return null;
        }
    }

    private RSAPublicKey getPublicKey(String storedKey) {
        String publicKey = storedKey.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
        byte[] publicBytes = Base64.decodeBase64(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("An error occurred while getting public key", e);
            return null;
        }
    }
}

