/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.servlet;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.user.User;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AjaxCallsServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(AjaxCallsServlet.class);
    private UserAccessor userAccessor;
    private LoginManager loginManager;
    private ConfluenceUserManagementUtility userManagementUtility;
    private UserManagementPluginSettings settings;
    private CrowdService crowdService;
    private UserManagementPluginHandler userManagementPluginHandler;
    private PermissionManager permissionManager;
    private BootstrapManager bootstrapManager;

    public AjaxCallsServlet(UserAccessor userAccessor, LoginManager loginManager, UserManagementPluginSettings settings, ConfluenceUserManagementUtility confluenceUserManagement, CrowdService crowdService, UserManagementPluginHandler userManagementPluginHandler, PermissionManager permissionManager, BootstrapManager bootstrapManager) {
        this.userAccessor = userAccessor;
        this.loginManager = loginManager;
        this.settings = settings;
        this.userManagementUtility = confluenceUserManagement;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.crowdService = crowdService;
        this.permissionManager = permissionManager;
        this.bootstrapManager = bootstrapManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block37: {
            block36: {
                String action = req.getParameter("action");
                ConfluenceUser confluenceUser = null;
                LOGGER.debug("inside Ajax Call Servlet ");
                if (this.userManagementUtility.getMaxUsers() == 0) {
                    LOGGER.debug("No license found for app. Bulk Delete Users will not work unless app license is applied.");
                    this.userManagementUtility.sendErrorResponse("Error_User_License", 403, resp);
                    return;
                }
                confluenceUser = AuthenticatedUserThreadLocal.get();
                Boolean isAdmin = Boolean.FALSE;
                if (confluenceUser != null) {
                    isAdmin = this.permissionManager.hasPermission((User)confluenceUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
                }
                LOGGER.debug("AjaxCallsServlet confluence user = " + confluenceUser.getName() + " has admin permission  = " + isAdmin);
                if (confluenceUser == null || !isAdmin.booleanValue()) break block36;
                switch (action) {
                    case "CheckEvalLicense": {
                        if (this.userManagementUtility.isEvaluationLicense().booleanValue() && this.userManagementUtility.isValidEvaluationLicense().booleanValue()) {
                            LOGGER.error("Evaluation license found for app. Operations will be allowed for only 10 users");
                            this.userManagementUtility.sendErrorResponse("Error_User_eval_License", 403, resp);
                            return;
                        }
                        if (!this.userManagementUtility.isValidEvaluationLicense().booleanValue()) {
                            LOGGER.error("Evaluation license Expired.");
                            this.userManagementUtility.sendErrorResponse("Evaluation_license_Expired", 403, resp);
                            return;
                        }
                        break block37;
                    }
                    case "BulkDeleteSelectedUser": {
                        this.deleteSelectedUsers(req, resp);
                        break;
                    }
                    case "BulkActivateSelectedUser": {
                        this.activateSelectedUsers(req, resp);
                        break;
                    }
                    case "BulkDeactivateSelectedUser": {
                        this.deactivateSelectedUsers(req, resp);
                        break;
                    }
                    case "fetchGroups": {
                        this.fetchGroups(req, resp);
                        break;
                    }
                    case "removeUserFromGroups": {
                        String username = req.getParameter("username").trim();
                        String GroupsList = req.getParameter("groupsToRemove").trim();
                        ArrayList<String> groupsToRemove = new ArrayList<String>(Arrays.asList(GroupsList.split(",")));
                        this.userManagementUtility.removeUserFromGroups(username, false, groupsToRemove, resp, this.userManagementUtility.getCurrentIpAddress(req));
                        break;
                    }
                    case "assignGroupsToUser": {
                        this.assignGroupsToUser(req, resp);
                        break;
                    }
                    case "ChangeGroupManagementSelectedAction": {
                        this.changeGroupManagementSelectedAction(req, resp);
                        break;
                    }
                    case "ChangeGroupManagementCreationSelectedAction": {
                        this.ChangeGroupManagementCreationSelectedAction(req, resp);
                        break;
                    }
                    case "BulkCreationGroup": {
                        this.BulkCreationGroup(req, resp);
                        break;
                    }
                    case "BulkDeletionGroup": {
                        this.BulkDeletionGroup(req, resp);
                        break;
                    }
                    case "clearAuditLogs": {
                        this.clearAuditLogs(req, resp);
                        break;
                    }
                    case "enableDebugLogs": {
                        this.enableDebugLogs(req, resp);
                        break;
                    }
                    case "downloadJiraLogs": {
                        this.downloadConfluenceLogs(req, resp);
                        break;
                    }
                    default: {
                        resp.setContentType("application/json");
                        resp.sendError(405, "The requested method is not allowed. Choose valid Method");
                        return;
                    }
                }
                break block37;
            }
            LOGGER.debug("You do not have administrator privilege to perform the Operation. ");
            this.userManagementUtility.sendErrorResponse("Error_Admin_Privilege", 401, resp);
        }
    }

    private void enableDebugLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Boolean enableDebugLogs = BooleanUtils.toBoolean(req.getParameter("enableDebugLogs"));
        this.settings.setEnableDebugLogs(enableDebugLogs);
        this.userManagementUtility.sendSuccessFullResponse("Change Successful", resp);
        if (enableDebugLogs.booleanValue()) {
            Logger logger = Logger.getLogger((String)"com.miniorange.usermanagement");
            logger.setLevel(Level.DEBUG);
            LOGGER.debug("Debug Logs are enabled");
        } else {
            Logger logger = Logger.getLogger((String)"com.miniorange.usermanagement");
            logger.setLevel(Level.INFO);
            LOGGER.debug("Debug Logs are  disabled");
        }
    }

    private void downloadConfluenceLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            File confluenceHomeFolder = this.bootstrapManager.getLocalHome();
            File confluenceLogFolder = null;
            File confluenceLogFile = null;
            for (File f : confluenceHomeFolder.listFiles()) {
                if (!f.isDirectory() || !StringUtils.equals(f.getName(), "logs")) continue;
                confluenceLogFolder = f;
                break;
            }
            for (File f : confluenceLogFolder.listFiles()) {
                if (!f.isFile() || !StringUtils.equals(f.getName(), "atlassian-confluence.log")) continue;
                confluenceLogFile = f;
                break;
            }
            resp.setHeader("Content-Disposition", "attachment; filename=\"atlassian-confluence.log\"");
            resp.setHeader("Cache-Control", "max-age=0");
            resp.setHeader("Pragma", "");
            resp.setContentType("text/plain");
            FileUtils.copyFile(confluenceLogFile, (OutputStream)resp.getOutputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearAuditLogs(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            ArrayList<String> updateAuditList = new ArrayList<String>();
            this.settings.setAuditLogs(updateAuditList);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void BulkDeletionGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String groupsToDelete = request.getParameter("groupsToDelete");
            ArrayList<String> groupToDeleteList = this.settings.convertSelect2StringToList(groupsToDelete);
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            InetAddress ip = InetAddress.getLocalHost();
            for (String groupsName : groupToDeleteList) {
                if (groupsName.equals("confluence-administrators")) {
                    LOGGER.debug("Cant Delete Group with admistrator access : ");
                    this.userManagementPluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Group Deleted", " Can not delete group with administrator access :" + groupsName);
                    this.userManagementUtility.sendErrorResponse("Error_User_Is_Admin", 405, response);
                    continue;
                }
                LOGGER.debug("Deleting Group :" + groupsName);
                this.userAccessor.removeGroup(this.userAccessor.getGroup(groupsName));
                this.userManagementPluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Group Deleted", "Deleting group :" + groupsName);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void BulkCreationGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String groupsToAdd = request.getParameter("groupsToAdd");
            String[] roleValuesList = StringUtils.split(groupsToAdd.trim(), ";");
            String groupsAlreadyExist = "";
            String groupsCreated = "";
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            InetAddress ip = InetAddress.getLocalHost();
            for (String groupsName : roleValuesList) {
                if (groupsName.length() <= 0) continue;
                if (this.crowdService.getGroup(groupsName.trim()) == null) {
                    LOGGER.debug("Creating new Group with name : " + groupsName);
                    this.userAccessor.createGroup(groupsName);
                    groupsCreated = groupsCreated + groupsName.toString() + ",";
                    this.userManagementPluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Group Created", "Creating group :" + groupsName);
                    continue;
                }
                groupsAlreadyExist = groupsAlreadyExist + this.crowdService.getGroup(groupsName.trim()).getName() + ",";
            }
            JSONObject data = new JSONObject();
            data.put("groupsAlreadyExist", (Object)groupsAlreadyExist);
            data.put("groupsCreated", (Object)groupsCreated);
            this.userManagementUtility.sendSuccessFullResponse(data.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void ChangeGroupManagementCreationSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String CreationSelectedAction = request.getParameter("CreationSelectedAction");
            this.settings.setCreationSelection(CreationSelectedAction);
            this.userManagementUtility.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    private void changeGroupManagementSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String selectedAction = request.getParameter("selectedAction");
            this.settings.setUserManagementSelectedAction(selectedAction);
            this.userManagementUtility.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    private void assignGroupsToUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String username = request.getParameter("username").trim();
            String GroupsList = request.getParameter("groupsToAdd").trim();
            if (!GroupsList.isEmpty()) {
                this.AddUserInGroup(GroupsList, username, request);
            }
            LOGGER.debug("Added User in Groups Successfully : " + username);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    private void fetchGroups(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String search = StringUtils.trim(req.getParameter("search"));
            List<String> groups = this.retrieveGroups(search, 10);
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            for (String groupName : groups) {
                HashMap<String, String> groupResultsMap = new HashMap<String, String>();
                groupResultsMap.put("id", groupName);
                groupResultsMap.put("text", groupName);
                resultArray.put(groupResultsMap);
            }
            data.put("results", (Object)resultArray);
            this.userManagementUtility.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (JSONException | IOException e) {
            LOGGER.error("An error occurred while fetching groups ", e);
        }
    }

    public List<String> retrieveGroups(String groupRegexPattern, int i) {
        String startWith = groupRegexPattern;
        if (StringUtils.equalsIgnoreCase(groupRegexPattern, "*")) {
            startWith = "";
        }
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)startWith)).returningAtMost(i);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        for (Group groupObject : groups) {
            LOGGER.debug("groups from Confluence Server = " + groupObject.getName());
            existingGroups.add(groupObject.getName().trim());
        }
        return existingGroups;
    }

    private void deleteSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String referer = request.getHeader("referer");
        try {
            String username = request.getParameter("username").trim();
            if (!this.userAccessor.hasMembership("confluence-administrators", username)) {
                ConfluenceUser currentUser = this.userAccessor.getUserByName(username);
                LOGGER.debug(" Remove User Successfully :- " + username);
                this.userAccessor.removeUser((User)currentUser);
                this.userManagementPluginHandler.storeAuditLogs(username, this.userManagementUtility.getCurrentIpAddress(request), "User Deleted", "User Deleted Manualy");
            } else {
                LOGGER.debug("Cant delete Admin User : " + username);
                this.userManagementUtility.sendErrorResponse("Error_User_Is_Admin", 405, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    private void activateSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String username = request.getParameter("username").trim();
            String GroupsList = request.getParameter("groupsToAdd").trim();
            if (this.userAccessor.isDeactivated(username)) {
                ConfluenceUser currentUser = this.userAccessor.getUserByName(username);
                LOGGER.debug("Activated User Successfully  = " + username);
                this.userAccessor.reactivateUser((User)currentUser);
                this.userManagementPluginHandler.storeAuditLogs(username, this.userManagementUtility.getCurrentIpAddress(request), "User Activated", "User Activated Manualy");
            }
            if (!GroupsList.isEmpty()) {
                this.AddUserInGroup(GroupsList, username, request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.debug("Error in Activating user = " + e.toString());
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    public void AddUserInGroup(String GroupsList, String username, HttpServletRequest request) {
        ArrayList<String> groupsToAdd = new ArrayList<String>(Arrays.asList(GroupsList.split(",")));
        for (String group : groupsToAdd) {
            this.userAccessor.addMembership(group, username);
        }
        this.userManagementPluginHandler.storeAuditLogs(username, this.userManagementUtility.getCurrentIpAddress(request), "Added to Group", "Added User to Groups : " + GroupsList);
        LOGGER.debug("Added User to Groups : " + GroupsList);
    }

    private void deactivateSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            LOGGER.debug("inside deactivateSelectedUser : ");
            String username = request.getParameter("username").trim();
            String GroupsList = request.getParameter("groupsToRemove").trim();
            if (!this.userAccessor.hasMembership("confluence-administrators", username)) {
                if (!GroupsList.isEmpty()) {
                    ArrayList<String> groupsToRemove = new ArrayList<String>(Arrays.asList(GroupsList.split(",")));
                    this.userManagementUtility.removeUserFromGroups(username, false, groupsToRemove, response, this.userManagementUtility.getCurrentIpAddress(request));
                }
                if (!this.userAccessor.isDeactivated(username)) {
                    ConfluenceUser currentUser = this.userAccessor.getUserByName(username);
                    LOGGER.debug("Deactivated User Successfully  = " + username);
                    this.userAccessor.deactivateUser((User)currentUser);
                    this.userManagementPluginHandler.storeAuditLogs(username, this.userManagementUtility.getCurrentIpAddress(request), "User Deactivated", "User Deactivated Manualy");
                } else {
                    LOGGER.debug("User is already inactive : " + username);
                    this.userManagementUtility.sendErrorResponse("Error_User_Is_Inactive", 400, response);
                }
            } else {
                LOGGER.debug("Cant Deactivate Admin User : " + username);
                this.userManagementUtility.sendErrorResponse("Error_User_Is_Admin", 405, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.userManagementUtility.sendErrorResponse("Error", 500, response);
        }
    }

    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }
}

